/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.Category;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/geoserviceregistry/")
@StrictBinding
public class GeoServiceRegistryActionBean
implements ActionBean {
    private ActionBeanContext context;
    @Validate
    private String nodeId;
    @Validate
    private String q;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    @DefaultHandler
    public Resolution load() throws JSONException {
        JSONArray children;
        block7: {
            Layer layer;
            int id;
            String type;
            EntityManager em;
            block8: {
                block6: {
                    JSONObject j;
                    em = Stripersist.getEntityManager();
                    children = new JSONArray();
                    type = this.nodeId.substring(0, 1);
                    id = Integer.parseInt(this.nodeId.substring(1));
                    if (!type.equals("c")) break block6;
                    Category c = (Category)em.find(Category.class, (Object)new Long(id));
                    for (Category sub : c.getChildren()) {
                        j = new JSONObject();
                        j.put("id", (Object)("c" + sub.getId()));
                        j.put("name", (Object)sub.getName());
                        j.put("type", (Object)"category");
                        j.put("isLeaf", sub.getChildren().isEmpty() && sub.getServices().isEmpty());
                        if (sub.getParent() != null) {
                            j.put("parentid", (Object)sub.getParent().getId());
                        }
                        children.put((Object)j);
                    }
                    for (GeoService service : c.getServices()) {
                        j = new JSONObject();
                        j.put("id", (Object)("s" + service.getId()));
                        j.put("service", (Object)service.toJSONObject(false, em));
                        j.put("name", (Object)service.getName());
                        j.put("type", (Object)"service");
                        j.put("isLeaf", service.getTopLayer() == null);
                        j.put("status", (Object)(service.isMonitoringStatusOK() ? "ok" : "error"));
                        j.put("parentid", (Object)this.nodeId);
                        children.put((Object)j);
                    }
                    break block7;
                }
                if (!type.equals("s")) break block8;
                GeoService gs = (GeoService)em.find(GeoService.class, (Object)new Long(id));
                if (gs.getTopLayer() == null || !Authorizations.isLayerReadAuthorized((Layer)gs.getTopLayer(), (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) break block7;
                for (Layer sublayer : gs.getTopLayer().getChildren()) {
                    if (!Authorizations.isLayerReadAuthorized((Layer)sublayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) continue;
                    JSONObject j = GeoServiceRegistryActionBean.layerJSON(sublayer);
                    j.put("parentid", (Object)this.nodeId);
                    children.put((Object)j);
                }
                break block7;
            }
            if (type.equals("l") && Authorizations.isLayerReadAuthorized((Layer)(layer = (Layer)em.find(Layer.class, (Object)new Long(id))), (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
                for (Layer sublayer : layer.getChildren()) {
                    if (!Authorizations.isLayerReadAuthorized((Layer)sublayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) continue;
                    JSONObject j = GeoServiceRegistryActionBean.layerJSON(sublayer);
                    j.put("parentid", (Object)this.nodeId);
                    children.put((Object)j);
                }
            }
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(children.toString()));
    }

    private static JSONObject layerJSON(Layer l) throws JSONException {
        JSONObject j = new JSONObject();
        j.put("id", (Object)("l" + l.getId()));
        j.put("layerName", (Object)l.getName());
        String alias = l.getName();
        if (l.getTitleAlias() != null) {
            alias = l.getTitleAlias();
        } else if (l.getTitle() != null) {
            alias = l.getTitle();
        }
        j.put("name", (Object)alias);
        j.put("type", (Object)"layer");
        j.put("isLeaf", l.getChildren().isEmpty());
        j.put("isVirtual", l.isVirtual());
        return j;
    }

    public Resolution search() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        this.q = "%" + this.q.toLowerCase() + "%";
        List results = em.createQuery("select distinct gs from GeoService gs left join gs.keywords kw where lower(gs.name) like :q or lower(kw) like :q2").setParameter("q", (Object)this.q).setParameter("q2", (Object)this.q).setMaxResults(10).getResultList();
        JSONArray jresults = new JSONArray();
        for (GeoService service : results) {
            JSONObject j = new JSONObject();
            j.put("id", (Object)("s" + service.getId()));
            j.put("service", (Object)service.toJSONObject(false, em));
            j.put("name", (Object)service.getName());
            j.put("type", (Object)"service");
            j.put("isLeaf", service.getTopLayer() == null);
            j.put("status", (Object)(service.isMonitoringStatusOK() ? "ok" : "error"));
            jresults.put((Object)j);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(jresults.toString(4)));
    }
}

