/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.services.ArcGISService;
import nl.b3p.viewer.config.services.ArcIMSService;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.WMSService;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/service/info")
@StrictBinding
public class ServiceActionBean
implements ActionBean {
    private ActionBeanContext context;
    @Validate
    private String protocol;
    @Validate
    private String url;
    @Validate
    private String serviceName;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Resolution info() throws JSONException {
        EntityManager em;
        GeoService service;
        String error;
        JSONObject json;
        block12: {
            json = new JSONObject();
            json.put("success", (Object)Boolean.FALSE);
            error = null;
            service = null;
            em = Stripersist.getEntityManager();
            if (this.protocol == null || this.url == null) {
                error = "Invalid parameters";
            } else {
                HashMap<String, String> params = new HashMap<String, String>();
                try {
                    if (this.protocol.equals("wms")) {
                        service = new WMSService().loadFromUrl(this.url, params, em);
                    } else if (this.protocol.equals("arcgis")) {
                        service = new ArcGISService().loadFromUrl(this.url, params, em);
                    } else if (this.protocol.equals("arcims")) {
                        params.put("ServiceName", this.serviceName);
                        service = new ArcIMSService().loadFromUrl(this.url, params, em);
                    } else {
                        error = "Invalid protocol";
                    }
                }
                catch (Exception e) {
                    error = "Fout bij laden service " + e.toString();
                    if (e.getCause() == null) break block12;
                    error = error + "; oorzaak: " + e.getCause().toString();
                }
            }
        }
        if (service != null) {
            json.put("success", (Object)Boolean.TRUE);
            json.put("service", (Object)service.toJSONObject(true, em));
        } else {
            json.put("success", (Object)Boolean.FALSE);
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }
}

