/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.image;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.viewer.image.CombineImageSettings;
import nl.b3p.viewer.image.ImageBbox;
import nl.b3p.viewer.image.ImageManager;
import nl.b3p.viewer.image.ImageTool;
import nl.b3p.viewer.image.ReferencedImage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CombineImagesHandler {
    private static final Log log = LogFactory.getLog(CombineImagesHandler.class);
    private static String defaultReturnMime = "image/png";
    private static int defaultMaxResponseTime = 30000;

    public static void combineImage(OutputStream out, CombineImageSettings settings, HttpServletRequest req) throws Exception {
        CombineImagesHandler.combineImage((OutputStream)out, (CombineImageSettings)settings, (String)defaultReturnMime, (int)defaultMaxResponseTime, (HttpServletRequest)req);
    }

    public static void combineImage(OutputStream out, CombineImageSettings settings, String returnMime, int maxResponseTime, HttpServletRequest req) throws Exception {
        CombineImagesHandler.combineImage((OutputStream)out, (CombineImageSettings)settings, (String)returnMime, (int)maxResponseTime, null, null, (HttpServletRequest)req);
    }

    public static void combineImage(OutputStream out, CombineImageSettings settings, String returnMime, int maxResponseTime, String uname, String pw, HttpServletRequest req) throws Exception {
        List urls = settings.getCalculatedUrls();
        List<Object> refImages = null;
        if (urls != null && urls.size() > 0) {
            ImageManager im = new ImageManager(urls, maxResponseTime, uname, pw, req);
            im.process();
            im.shutdown();
            refImages = im.getCombinedImages();
        } else {
            refImages = new ArrayList<ReferencedImage>();
            refImages.add(new ReferencedImage(new BufferedImage(settings.getWidth(), settings.getHeight(), 3)));
        }
        BufferedImage returnImage = null;
        ImageBbox bb = settings.getRequestBbox();
        BufferedImage combinedImages = ImageTool.combineImages(refImages, (String)returnMime, (Integer)bb.getWidth(), (Integer)bb.getHeight());
        try {
            returnImage = settings.getWktGeoms() != null ? ImageTool.drawGeometries((BufferedImage)combinedImages, (CombineImageSettings)settings) : combinedImages;
        }
        catch (Exception e) {
            log.error((Object)"Kan geometrien niet tekenen. Return image zonder alle geometrien: ", (Throwable)e);
            returnImage = combinedImages;
        }
        if (settings.getAngle() != null && settings.getAngle() != 0 && settings.getAngle() != 360) {
            BufferedImage rot = new BufferedImage(settings.getWidth(), settings.getHeight(), 3);
            Graphics2D gr = (Graphics2D)rot.getGraphics();
            int h = returnImage.getHeight();
            int w = returnImage.getWidth();
            AffineTransform xform = new AffineTransform();
            xform.setToTranslation((settings.getWidth() - w) / 2, (settings.getHeight() - h) / 2);
            xform.rotate(Math.toRadians(360 - settings.getAngle()), w / 2, h / 2);
            gr.drawImage(returnImage, xform, null);
            gr.dispose();
            returnImage = rot;
        }
        try {
            ImageTool.writeImage((BufferedImage)returnImage, (String)returnMime, (OutputStream)out);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }
}

