/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.image;

import java.util.ArrayList;
import java.util.List;
import nl.b3p.viewer.image.Bbox;
import nl.b3p.viewer.image.CombineImageUrl;
import nl.b3p.viewer.image.CombineStaticImageUrl;
import nl.b3p.viewer.image.ImageBbox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CombineWmsUrl
extends CombineImageUrl {
    private static final Log log = LogFactory.getLog(CombineWmsUrl.class);
    private Integer maxTileWidth = 2048;
    private Integer maxTileHeight = 2048;

    private CombineWmsUrl(CombineWmsUrl cwu) {
        super((CombineImageUrl)cwu);
    }

    public CombineWmsUrl() {
    }

    public List<CombineImageUrl> calculateNewUrl(ImageBbox bbox) {
        CombineWmsUrl ciu = new CombineWmsUrl(this);
        Integer width = bbox.getWidth();
        Integer height = bbox.getHeight();
        ArrayList<CombineImageUrl> list = new ArrayList<CombineImageUrl>();
        if (width > this.maxTileWidth || height > this.maxTileHeight) {
            Bbox newBbox = bbox.getBbox();
            Double resolutionWidth = bbox.getUnitsPixelX();
            Double resolutionHeight = bbox.getUnitsPixelY();
            for (int beginX = 0; beginX < width; beginX += this.maxTileWidth.intValue()) {
                for (int endY = height.intValue(); endY >= 0; endY -= this.maxTileHeight.intValue()) {
                    Integer beginY;
                    Integer endX = beginX + this.maxTileWidth;
                    if (endX > width) {
                        endX = width;
                    }
                    if ((beginY = Integer.valueOf(endY - this.maxTileHeight)) < 0) {
                        beginY = 0;
                    }
                    Bbox curBbox = new Bbox(newBbox.getMinx() + (double)beginX * resolutionWidth, newBbox.getMiny() + (double)(height - endY) * resolutionHeight, newBbox.getMinx() + (double)endX.intValue() * resolutionWidth, newBbox.getMiny() + (double)(height - beginY) * resolutionHeight);
                    CombineWmsUrl newCiu = new CombineWmsUrl(this);
                    newCiu.changeParameter("bbox", curBbox.toString());
                    newCiu.changeParameter("width", "" + (endX - beginX));
                    newCiu.changeParameter("height", "" + (endY - beginY));
                    CombineStaticImageUrl csiu = new CombineStaticImageUrl();
                    csiu.setX(Integer.valueOf(beginX));
                    csiu.setY(beginY);
                    csiu.setBbox(curBbox);
                    csiu.setUrl(newCiu.getUrl());
                    csiu.setHeight(Integer.valueOf(endY - beginY));
                    csiu.setWidth(Integer.valueOf(endX - beginX));
                    list.add((CombineImageUrl)csiu);
                }
            }
        } else {
            ciu.changeParameter("bbox", bbox.getBbox().toString());
            ciu.changeParameter("width", bbox.getWidth().toString());
            ciu.changeParameter("height", bbox.getHeight().toString());
            list.add((CombineImageUrl)ciu);
        }
        return list;
    }

    public Integer[] getWidthAndHeightFromUrl() {
        if (this.getUrl() == null) {
            return null;
        }
        String url = this.getUrl();
        String heightString = this.getParameter("height");
        String widthString = this.getParameter("width");
        Integer[] result = null;
        if (heightString != null && widthString != null) {
            try {
                result = new Integer[]{new Integer(widthString), new Integer(heightString)};
            }
            catch (NumberFormatException nfe) {
                result = null;
                log.debug((Object)("Height en/of Width zijn geen integers: Heigth: " + heightString + "Width: " + widthString));
            }
        }
        return result;
    }

    public Bbox getBboxFromUrl() {
        if (this.getUrl() == null) {
            return null;
        }
        double[] bb = null;
        String url = this.getUrl();
        String stringBbox = this.getParameter("bbox");
        if (stringBbox != null) {
            if (stringBbox.split(",").length != 4) {
                stringBbox = null;
            } else {
                bb = new double[4];
                try {
                    bb[0] = Double.parseDouble(stringBbox.split(",")[0]);
                    bb[1] = Double.parseDouble(stringBbox.split(",")[1]);
                    bb[2] = Double.parseDouble(stringBbox.split(",")[2]);
                    bb[3] = Double.parseDouble(stringBbox.split(",")[3]);
                }
                catch (NumberFormatException nfe) {
                    bb = null;
                    log.debug((Object)("Geen geldige double waarden in de bbox: " + stringBbox));
                }
            }
        }
        if (bb != null) {
            return new Bbox(bb);
        }
        return null;
    }

    private void changeParameter(String key, String newValue) {
        String lowerUrl = this.url.toLowerCase();
        if (lowerUrl.indexOf("?" + key + "=") >= 0 || lowerUrl.indexOf("&" + key + "=") >= 0) {
            int beginIndex = 0;
            int endIndex = lowerUrl.length();
            beginIndex = lowerUrl.indexOf("?" + key + "=") >= 0 ? lowerUrl.indexOf("?" + key + "=") + key.length() + 2 : lowerUrl.indexOf("&" + key + "") + key.length() + 2;
            if (lowerUrl.indexOf("&", beginIndex) > 0) {
                endIndex = lowerUrl.indexOf("&", beginIndex);
            }
            if (beginIndex < endIndex) {
                String newUrl = "";
                if (beginIndex > 0) {
                    newUrl = newUrl + this.url.substring(0, beginIndex);
                }
                newUrl = newUrl + newValue;
                if (endIndex < this.url.length()) {
                    newUrl = newUrl + this.url.substring(endIndex, this.url.length());
                }
                this.url = newUrl;
            }
        }
    }

    public String getParameter(String key) {
        String lowerUrl = this.url.toLowerCase();
        if (lowerUrl.indexOf("?" + key + "=") >= 0 || lowerUrl.indexOf("&" + key + "=") >= 0) {
            int beginIndex = 0;
            int endIndex = lowerUrl.length();
            beginIndex = lowerUrl.indexOf("?" + key + "=") >= 0 ? lowerUrl.indexOf("?" + key + "=") + key.length() + 2 : lowerUrl.indexOf("&" + key + "") + key.length() + 2;
            if (lowerUrl.indexOf("&", beginIndex) > 0) {
                endIndex = lowerUrl.indexOf("&", beginIndex);
            }
            if (beginIndex < endIndex) {
                return this.url.substring(beginIndex, endIndex);
            }
        }
        return null;
    }
}

