/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.search;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.viewer.search.SearchClient;
import nl.b3p.viewer.search.SearchResult;
import nl.b3p.viewer.search.SolrSearchClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.geotools.geometry.jts.WKTReader2;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PDOKSearchClient
extends SearchClient {
    private static final Log log = LogFactory.getLog(SolrSearchClient.class);
    private SolrServer server = new HttpSolrServer("http://geodata.nationaalgeoregister.nl/locatieserver");
    private WKTReader2 wkt = new WKTReader2();
    private String filter;

    public PDOKSearchClient(String filter) {
        this.filter = filter;
    }

    public SearchResult search(String term) {
        SearchResult result = new SearchResult();
        try {
            JSONArray respDocs = new JSONArray();
            SolrQuery query = new SolrQuery();
            if (this.filter != null) {
                term = term + " " + this.filter;
            }
            query.setQuery(term);
            query.setRequestHandler("/free");
            QueryResponse rsp = this.server.query((SolrParams)query);
            SolrDocumentList list = rsp.getResults();
            for (SolrDocument solrDocument : list) {
                JSONObject doc = this.solrDocumentToResult(solrDocument);
                if (doc == null) continue;
                respDocs.put((Object)doc);
            }
            result.setResults(respDocs);
            result.setLimitReached(Boolean.valueOf(list.getNumFound() > (long)list.size()));
        }
        catch (SolrServerException ex) {
            log.error((Object)"Cannot search:", (Throwable)ex);
        }
        return result;
    }

    public JSONArray autosuggest(String term) throws JSONException {
        SearchResult r = this.search(term);
        return r.getResults();
    }

    private JSONObject solrDocumentToResult(SolrDocument doc) {
        JSONObject result = null;
        try {
            String centroide;
            Map values = doc.getFieldValueMap();
            result = new JSONObject();
            for (String key : values.keySet()) {
                result.put(key, values.get(key));
            }
            String geom = centroide = (String)doc.getFieldValue("centroide_rd");
            if (values.containsKey("geometrie_rd")) {
                geom = (String)values.get("geometrie_rd");
            }
            Geometry g = this.wkt.read(geom);
            Envelope env = g.getEnvelopeInternal();
            if (centroide != null) {
                HashMap<String, Double> bbox = new HashMap<String, Double>();
                bbox.put("minx", env.getMinX());
                bbox.put("miny", env.getMinY());
                bbox.put("maxx", env.getMaxX());
                bbox.put("maxy", env.getMaxY());
                result.put("location", bbox);
            }
            result.put("label", values.get("weergavenaam"));
        }
        catch (ParseException | JSONException ex) {
            log.error((Object)ex);
        }
        return result;
    }
}

