/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.image;

import java.awt.Color;
import nl.b3p.viewer.image.FeatureStyle;

public class CombineImageWkt {
    private String wktGeom = "";
    private Color color = null;
    private String label = null;
    private Float strokeWidth = null;
    private FeatureStyle style = new FeatureStyle();

    public CombineImageWkt(String wktGeomString) {
        int colorIndex = wktGeomString.indexOf("#");
        int labelIndex = wktGeomString.indexOf("|");
        int wktEnd = wktGeomString.length();
        if (colorIndex > 0) {
            wktEnd = colorIndex;
        }
        if (labelIndex > 0 && labelIndex < wktEnd) {
            wktEnd = labelIndex;
        }
        this.setWktGeom(wktGeomString.substring(0, wktEnd));
        if (colorIndex > 0) {
            int colorEnd = labelIndex != -1 && labelIndex > colorIndex ? labelIndex : wktGeomString.length();
            this.setColor(wktGeomString.substring(colorIndex + 1, colorEnd));
        }
        if (labelIndex > 0) {
            int labelEnd = colorIndex != -1 && colorIndex > labelIndex ? colorIndex : wktGeomString.length();
            this.setLabel(wktGeomString.substring(labelIndex + 1, labelEnd));
        }
    }

    public CombineImageWkt(String wktGeomString, String color) {
        this.setWktGeom(wktGeomString);
        this.setColor(color);
    }

    public CombineImageWkt(String wktGeomString, String color, Float strokeWidth) {
        this.setWktGeom(wktGeomString);
        this.setColor(color);
        this.setStrokeWidth(strokeWidth);
    }

    public String getWktGeom() {
        return this.wktGeom;
    }

    public void setWktGeom(String wktGeom) {
        this.wktGeom = wktGeom;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(String hexrgb) {
        if (hexrgb == null || hexrgb.equals("transparent")) {
            return;
        }
        if (hexrgb.length() > 0) {
            this.color = new Color(Integer.parseInt(hexrgb, 16));
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(Float strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public FeatureStyle getStyle() {
        return this.style;
    }

    public void setStyle(FeatureStyle style) {
        this.style = style;
    }
}

