/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import javax.persistence.EntityManager;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.geotools.filter.visitor.RemoveDistanceUnit;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.WFSFeatureSource;
import nl.b3p.viewer.features.CSVDownloader;
import nl.b3p.viewer.features.ExcelDownloader;
import nl.b3p.viewer.features.FeatureDownloader;
import nl.b3p.viewer.features.GeoJSONDownloader;
import nl.b3p.viewer.features.ShapeDownloader;
import nl.b3p.viewer.util.ChangeMatchCase;
import nl.b3p.viewer.util.FeatureToJson;
import nl.b3p.web.stripes.ErrorMessageResolution;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.jdbc.JDBCFeatureSource;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/downloadfeatures")
@StrictBinding
public class DownloadFeaturesActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(DownloadFeaturesActionBean.class);
    private ActionBeanContext context;
    private boolean unauthorized;
    @Validate
    private Application application;
    @Validate
    private ApplicationLayer appLayer;
    @Validate
    private SimpleFeatureType featureType;
    private Layer layer = null;
    @Validate
    private int limit;
    @Validate
    private String filter;
    @Validate
    private boolean debug;
    @Validate
    private String type;
    @Validate
    private String params;

    public void setContext(ActionBeanContext abc) {
        this.context = abc;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public boolean isUnauthorized() {
        return this.unauthorized;
    }

    public void setUnauthorized(boolean unauthorized) {
        this.unauthorized = unauthorized;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void loadLayer() {
        this.layer = this.appLayer.getService().getSingleLayer(this.appLayer.getLayerName(), Stripersist.getEntityManager());
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        if (this.application == null || this.appLayer == null || !Authorizations.isAppLayerReadAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)Stripersist.getEntityManager())) {
            this.unauthorized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution download() throws JSONException, FileNotFoundException {
        JSONObject json = new JSONObject();
        if (this.unauthorized) {
            json.put("success", false);
            json.put("message", (Object)"Not authorized");
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        File output = null;
        try {
            if (this.featureType != null || this.layer != null && this.layer.getFeatureType() != null) {
                FeatureSource fs;
                SimpleFeatureType ft = this.featureType;
                if (ft == null) {
                    ft = this.layer.getFeatureType();
                }
                if (this.isDebug() && ft.getFeatureSource() instanceof WFSFeatureSource) {
                    HashMap<String, Boolean> extraDataStoreParams = new HashMap<String, Boolean>();
                    extraDataStoreParams.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.FALSE);
                    fs = ((WFSFeatureSource)ft.getFeatureSource()).openGeoToolsFeatureSource(this.layer.getFeatureType(), extraDataStoreParams);
                } else {
                    fs = ft.openGeoToolsFeatureSource();
                }
                Query q = new Query(fs.getName().toString());
                this.setFilter(q, ft);
                HashMap<String, AttributeDescriptor> featureTypeAttributes = new HashMap();
                featureTypeAttributes = this.makeAttributeDescriptorList(ft);
                List attributes = this.appLayer.getAttributes();
                output = this.convert(ft, fs, q, this.type, attributes, featureTypeAttributes);
                json.put("success", true);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading features", (Throwable)e);
            json.put("success", false);
            String message = "Fout bij ophalen features: " + e.toString();
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                message = message + "; " + cause.toString();
            }
            json.put("message", (Object)message);
        }
        if (json.getBoolean("success")) {
            final FileInputStream fis = new FileInputStream(output);
            try {
                StreamingResolution res = new StreamingResolution(MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(output)){

                    public void stream(HttpServletResponse response) throws Exception {
                        ServletOutputStream out = response.getOutputStream();
                        IOUtils.copy((InputStream)fis, (OutputStream)out);
                        fis.close();
                    }
                };
                String name = output.getName();
                String extension = name.substring(name.lastIndexOf("."));
                String newName = "Download-" + this.appLayer.getDisplayName(Stripersist.getEntityManager()) + "-" + this.type + extension;
                res.setFilename(newName);
                res.setAttachment(true);
                StreamingResolution streamingResolution = res;
                return streamingResolution;
            }
            finally {
                output.delete();
            }
        }
        return new ErrorMessageResolution(json.getString("message"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File convert(SimpleFeatureType ft, FeatureSource fs, Query q, String type, List<ConfiguredAttribute> attributes, Map<String, AttributeDescriptor> featureTypeAttributes) throws IOException {
        HashMap<String, String> attributeAliases = new HashMap<String, String>();
        for (Object ad : ft.getAttributes()) {
            if (ad.getAlias() != null) {
                attributeAliases.put(ad.getName(), ad.getAlias());
                continue;
            }
            attributeAliases.put(ad.getName(), ad.getName());
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (AttributeDescriptor ad : ft.getAttributes()) {
            propertyNames.add(ad.getName());
        }
        if (fs instanceof JDBCFeatureSource && !propertyNames.isEmpty()) {
            this.setSortBy(q, (String)propertyNames.get(0));
        }
        SimpleFeatureCollection fc = (SimpleFeatureCollection)fs.getFeatures(q);
        File f = null;
        FeatureDownloader downloader = null;
        if (type.equalsIgnoreCase("SHP")) {
            downloader = new ShapeDownloader(attributes, (SimpleFeatureSource)fs, featureTypeAttributes, attributeAliases, this.params);
        } else if (type.equalsIgnoreCase("XLS")) {
            downloader = new ExcelDownloader(attributes, (SimpleFeatureSource)fs, featureTypeAttributes, attributeAliases, this.params);
        } else if (type.equals("CSV")) {
            downloader = new CSVDownloader(attributes, (SimpleFeatureSource)fs, featureTypeAttributes, attributeAliases, this.params);
        } else if (type.equals("GEOJSON")) {
            downloader = new GeoJSONDownloader(attributes, (SimpleFeatureSource)fs, featureTypeAttributes, attributeAliases, this.params);
        } else {
            throw new IllegalArgumentException("No suitable type given: " + type);
        }
        try {
            downloader.init();
            try (SimpleFeatureIterator it = fc.features();){
                while (it.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)it.next();
                    downloader.processFeature(feature);
                }
            }
            f = downloader.write();
        }
        catch (IOException ex) {
            log.error((Object)"Cannot create outputfile: ", (Throwable)ex);
            throw ex;
        }
        finally {
            fs.getDataStore().dispose();
        }
        return f;
    }

    private Map<String, AttributeDescriptor> makeAttributeDescriptorList(SimpleFeatureType ft) {
        HashMap<String, AttributeDescriptor> featureTypeAttributes = new HashMap<String, AttributeDescriptor>();
        for (AttributeDescriptor ad : ft.getAttributes()) {
            String name = ft.getId() + ":" + ad.getName();
            if (featureTypeAttributes.containsKey(name)) {
                return featureTypeAttributes;
            }
            featureTypeAttributes.put(name, ad);
        }
        if (ft.getRelations() != null) {
            for (FeatureTypeRelation rel : ft.getRelations()) {
                featureTypeAttributes.putAll(this.makeAttributeDescriptorList(rel.getForeignFeatureType()));
            }
        }
        return featureTypeAttributes;
    }

    private void setFilter(Query q, SimpleFeatureType ft) throws Exception {
        if (this.filter != null && this.filter.trim().length() > 0) {
            Filter f = CQL.toFilter((String)this.filter);
            f = (Filter)f.accept((FilterVisitor)new RemoveDistanceUnit(), null);
            f = (Filter)f.accept((FilterVisitor)new ChangeMatchCase(false), null);
            f = FeatureToJson.reformatFilter(f, ft);
            q.setFilter(f);
        }
    }

    private void setSortBy(Query q, String sort) {
        FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        if (sort != null) {
            q.setSortBy(new SortBy[]{ff2.sort(sort, SortOrder.ASCENDING)});
        }
    }
}

