/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.search;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.SolrConf;
import nl.b3p.viewer.search.SearchClient;
import nl.b3p.viewer.search.SearchResult;
import nl.b3p.viewer.util.FeatureToJson;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.geometry.jts.WKTReader2;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.stripesstuff.stripersist.Stripersist;

public class AttributeSourceSearchClient
extends SearchClient {
    private static final Log log = LogFactory.getLog(AttributeSourceSearchClient.class);
    private JSONObject config;
    private WKTReader2 wkt;

    public AttributeSourceSearchClient(JSONObject config) {
        this.config = config;
        this.wkt = new WKTReader2();
    }

    public SearchResult search(String query) {
        JSONObject asConfig = this.config.getJSONObject("asConfig");
        JSONArray processedResults = new JSONArray();
        Iterator iterator = asConfig.keys();
        while (iterator.hasNext()) {
            String configId = (String)iterator.next();
            Integer id = Integer.parseInt(configId);
            this.getResults(query, id, processedResults);
        }
        SearchResult sr = new SearchResult();
        sr.setResults(processedResults);
        return sr;
    }

    private void getResults(String query, Integer solrConfigId, JSONArray processedResults) {
        try {
            EntityManager em = Stripersist.getEntityManager();
            SolrConf conf = (SolrConf)em.find(SolrConf.class, (Object)solrConfigId.longValue());
            List queryAttributes = conf.getIndexAttributes();
            List resultAttributes = conf.getResultAttributes();
            SimpleFeatureType ft = conf.getSimpleFeatureType();
            FeatureSource gtFS = ft.openGeoToolsFeatureSource();
            FeatureToJson ftoj = new FeatureToJson(false, false, false, true, null);
            Query q = this.createQuery(queryAttributes, gtFS, query);
            q.setMaxFeatures(1000);
            JSONArray features = ftoj.getJSONFeatures(null, ft, gtFS, q, null, null);
            for (Object feature : features) {
                JSONObject newFeature = new JSONObject();
                JSONObject oldFeature = (JSONObject)feature;
                String label = "";
                for (String name : resultAttributes) {
                    String value = oldFeature.optString(name, "");
                    newFeature.put(name, (Object)value);
                    label = label + " " + value;
                }
                Geometry g = (Geometry)oldFeature.get(ft.getGeometryAttribute());
                Envelope env = g.getEnvelopeInternal();
                HashMap<String, Double> bbox = new HashMap<String, Double>();
                bbox.put("minx", env.getMinX());
                bbox.put("miny", env.getMinY());
                bbox.put("maxx", env.getMaxX());
                bbox.put("maxy", env.getMaxY());
                newFeature.put("location", bbox);
                newFeature.put("type", (Object)conf.getName());
                newFeature.put("label", (Object)label);
                processedResults.put((Object)newFeature);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error searching", (Throwable)ex);
        }
    }

    private Query createQuery(List<String> queryAttrs, FeatureSource gtFS, String term) throws CQLException {
        Query q = new Query(gtFS.getName().toString());
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        ArrayList<PropertyIsLike> filters = new ArrayList<PropertyIsLike>();
        for (String queryAttr : queryAttrs) {
            PropertyIsLike filter = ff.like((Expression)ff.property(queryAttr), "%" + term + "%", "%", "_", "\\", false);
            filters.add(filter);
        }
        Or or = ff.or(filters);
        q.setFilter((Filter)or);
        return q;
    }

    public JSONArray autosuggest(String query) throws JSONException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

