/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.components.ViewerComponent;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ConfiguredComponent;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.stripes.ApplicationActionBean;
import nl.b3p.viewer.stripes.ComponentActionBean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
@UrlBinding(value="/app/component/{className}/{$event}/{file}")
@StrictBinding
public class ComponentActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(ComponentActionBean.class);
    @Validate
    private String app;
    @Validate
    private String version;
    @Validate
    private String className;
    @Validate
    private String file;
    @Validate
    private boolean minified;
    private Application application;
    private ViewerComponent component;
    private ActionBeanContext context;
    private static final Map<String, Object[]> minifiedSourceCache = new HashMap();

    public void setContext(ActionBeanContext abc) {
        this.context = abc;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public boolean isMinified() {
        return this.minified;
    }

    public void setMinified(boolean minified) {
        this.minified = minified;
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void load() {
        this.application = ApplicationActionBean.findApplication((String)this.app, (String)this.version);
        EntityManager em = Stripersist.getEntityManager();
        if (this.application != null && this.className != null) {
            for (ConfiguredComponent cc : this.application.getComponents()) {
                if (!cc.getClassName().equals(this.className) || !Authorizations.isConfiguredComponentAuthorized((ConfiguredComponent)cc, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) continue;
                this.component = cc.getViewerComponent();
                break;
            }
        }
    }

    @DefaultHandler
    public Resolution source() throws IOException {
        long ifModifiedSince;
        File[] files = null;
        if (this.className != null && this.component == null) {
            return new ErrorResolution(403, "User not authorized for this components' source");
        }
        if (this.component == null) {
            File[] comps = new ArrayList(this.application.getComponents());
            Collections.sort(comps);
            HashSet<String> classNamesDone = new HashSet<String>();
            ArrayList fileList = new ArrayList();
            EntityManager em = Stripersist.getEntityManager();
            for (ConfiguredComponent configuredComponent : comps) {
                if (!Authorizations.isConfiguredComponentAuthorized((ConfiguredComponent)configuredComponent, (HttpServletRequest)this.context.getRequest(), (EntityManager)em) || classNamesDone.contains(configuredComponent.getClassName())) continue;
                classNamesDone.add(configuredComponent.getClassName());
                if (configuredComponent.getViewerComponent() == null || configuredComponent.getViewerComponent().getSources() == null) continue;
                fileList.addAll(Arrays.asList(configuredComponent.getViewerComponent().getSources()));
            }
            files = fileList.toArray(new File[0]);
        } else if (this.file != null) {
            for (File f : this.component.getSources()) {
                if (!f.getName().equals(this.file)) continue;
                files = new File[]{f};
                break;
            }
            if (files == null) {
                return new ErrorResolution(404, this.file);
            }
        } else {
            files = this.component.getSources();
        }
        long lastModified = -1L;
        for (File file : files) {
            lastModified = Math.max(lastModified, file.lastModified());
        }
        if (lastModified != -1L && (ifModifiedSince = this.context.getRequest().getDateHeader("If-Modified-Since")) != -1L && ifModifiedSince >= lastModified) {
            return new ErrorResolution(304);
        }
        File[] theFiles = files;
        1 res = new /* Unavailable Anonymous Inner Class!! */;
        if (lastModified != -1L) {
            res.setLastModified(lastModified);
        }
        return res;
    }

    public Resolution resource() throws IOException {
        this.getContext().getResponse().sendError(404);
        return null;
    }

    private static synchronized String getMinifiedSource(File f) throws IOException {
        Long lastModified;
        String key = f.getCanonicalPath();
        Object[] cache = (Object[])minifiedSourceCache.get(key);
        if (cache != null && !(lastModified = (Long)cache[0]).equals(f.lastModified())) {
            minifiedSourceCache.remove(key);
            cache = null;
        }
        if (cache != null) {
            return (String)cache[1];
        }
        String minified = null;
        try {
            Compiler compiler = new Compiler();
            CompilerOptions options = new CompilerOptions();
            CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
            options.setOutputCharset(Charset.forName("UTF-8"));
            compiler.compile(SourceFile.fromCode((String)"dummy.js", (String)""), SourceFile.fromFile((File)f), options);
            if (compiler.hasErrors()) {
                log.warn((Object)(compiler.getErrorCount() + " error(s) minifying source file " + f.getCanonicalPath() + "; using original source"));
                minified = IOUtils.toString((InputStream)new FileInputStream(f));
                for (int i = 0; i < compiler.getErrorCount(); ++i) {
                    JSError error = compiler.getErrors()[i];
                    log.warn((Object)String.format("#%d line %d,%d: %s: %s", i + 1, error.lineNumber, error.getCharno(), error.getDefaultLevel(), error.description));
                }
            } else {
                minified = compiler.toSource();
            }
        }
        catch (Exception e) {
            log.warn((Object)String.format("Error minifying file \"%s\" using closure compiler, sending original source\n", f.getCanonicalPath()), (Throwable)e);
        }
        Object[] entry = new Object[]{f.lastModified(), minified};
        minifiedSourceCache.put(key, entry);
        return minified;
    }

    static /* synthetic */ String access$000(File x0) throws IOException {
        return ComponentActionBean.getMinifiedSource((File)x0);
    }
}

