/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.geotools.filter.visitor.RemoveDistanceUnit;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.util.ChangeMatchCase;
import nl.b3p.viewer.util.FeatureToJson;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQL;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.DWithin;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/featureinfo")
@StrictBinding
public class FeatureInfoActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(FeatureInfoActionBean.class);
    public static final String FID = "__fid";
    private ActionBeanContext context;
    private static final int TIMEOUT = 5000;
    @Validate
    private Application application;
    @Validate
    private int limit = 10;
    @Validate
    private String x;
    @Validate
    private String y;
    @Validate
    private String requestId;
    @Validate
    private String distance;
    @Validate
    private String queryJSON;
    @Validate
    private boolean edit = false;
    @Validate
    private boolean arrays = false;
    @Validate
    private List<Long> attributesToInclude = new ArrayList<Long>();
    @Validate
    private boolean graph = false;
    private Layer layer;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getDistance() {
        return this.distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }

    public String getQueryJSON() {
        return this.queryJSON;
    }

    public void setQueryJSON(String queryJSON) {
        this.queryJSON = queryJSON;
    }

    public String getX() {
        return this.x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public String getY() {
        return this.y;
    }

    public void setY(String y) {
        this.y = y;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public boolean isArrays() {
        return this.arrays;
    }

    public void setArrays(boolean arrays) {
        this.arrays = arrays;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public List<Long> getAttributesToInclude() {
        return this.attributesToInclude;
    }

    public void setAttributesToInclude(List<Long> attributesToInclude) {
        this.attributesToInclude = attributesToInclude;
    }

    public boolean isGraph() {
        return this.graph;
    }

    public void setGraph(boolean graph) {
        this.graph = graph;
    }

    public Layer getLayer() {
        return this.layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution info() throws JSONException {
        JSONArray queries = new JSONArray(this.queryJSON);
        JSONArray responses = new JSONArray();
        FeatureSource fs = null;
        EntityManager em = Stripersist.getEntityManager();
        for (int i = 0; i < queries.length(); ++i) {
            block25: {
                JSONObject query = queries.getJSONObject(i);
                JSONObject response = new JSONObject();
                responses.put((Object)response);
                response.put("request", (Object)query);
                if (this.requestId != null) {
                    response.put("requestId", (Object)this.requestId);
                }
                String error = null;
                String exceptionMsg = query.toString();
                try {
                    ApplicationLayer al = null;
                    GeoService gs = null;
                    if (query.has("appLayer")) {
                        al = (ApplicationLayer)em.find(ApplicationLayer.class, (Object)query.getLong("appLayer"));
                    } else {
                        gs = (GeoService)em.find(GeoService.class, (Object)query.getLong("service"));
                    }
                    if (al == null && gs == null) {
                        error = "App layer or service not found";
                    } else if (!Authorizations.isAppLayerReadAuthorized((Application)this.application, (ApplicationLayer)al, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
                        error = "Not authorized";
                    } else {
                        this.layer = al != null ? al.getService().getLayer(al.getLayerName(), em) : gs.getLayer(query.getString("layer"), em);
                        if (this.layer == null) {
                            error = "Layer not found";
                        } else if (this.layer.getFeatureType() == null) {
                            response.put("noFeatureType", true);
                        } else {
                            DWithin f;
                            Filter currentFilter;
                            response.put("featureType", (Object)this.layer.getFeatureType().getId());
                            String filter = query.optString("filter", null);
                            fs = this.layer.getFeatureType().openGeoToolsFeatureSource(5000);
                            Query q = new Query(fs.getName().toString());
                            String geomAttribute = fs.getSchema().getGeometryDescriptor().getLocalName();
                            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
                            DWithin spatialFilter = null;
                            boolean useIntersect = false;
                            if (this.layer.getService().getDetails().containsKey("useIntersect")) {
                                ClobElement ce = (ClobElement)this.layer.getService().getDetails().get("useIntersect");
                                useIntersect = Boolean.parseBoolean(ce.getValue());
                            }
                            if (!useIntersect) {
                                Point point = new GeometryFactory().createPoint(new Coordinate(Double.parseDouble(this.x), Double.parseDouble(this.y)));
                                spatialFilter = ff.dwithin((Expression)ff.property(geomAttribute), (Expression)ff.literal((Object)point), Double.parseDouble(this.distance), "meters");
                            } else {
                                GeometricShapeFactory shapeFact = new GeometricShapeFactory();
                                shapeFact.setNumPoints(32);
                                shapeFact.setCentre(new Coordinate(Double.parseDouble(this.x), Double.parseDouble(this.y)));
                                shapeFact.setSize(Double.parseDouble(this.distance) * 2.0);
                                Polygon p = shapeFact.createCircle();
                                spatialFilter = ff.intersects((Expression)ff.property(geomAttribute), (Expression)ff.literal((Object)p));
                            }
                            Filter filter2 = currentFilter = filter != null && filter.trim().length() > 0 ? CQL.toFilter((String)filter) : null;
                            if (currentFilter != null) {
                                currentFilter = (Filter)currentFilter.accept((FilterVisitor)new ChangeMatchCase(false), null);
                            }
                            Object object = f = currentFilter != null ? ff.and((Filter)spatialFilter, currentFilter) : spatialFilter;
                            if ("jdbc".equals(this.layer.getService().getProtocol())) {
                                f = (Filter)f.accept((FilterVisitor)new RemoveDistanceUnit(), null);
                            }
                            f = FeatureToJson.reformatFilter((Filter)f, this.layer.getFeatureType());
                            q.setFilter((Filter)f);
                            q.setMaxFeatures(this.limit + 1);
                            JSONArray features = this.executeQuery(al, this.layer.getFeatureType(), fs, q);
                            if (features.length() > this.limit) {
                                JSONArray newArray = new JSONArray();
                                for (int j = 0; j < features.length(); ++j) {
                                    if (j >= this.limit) continue;
                                    newArray.put(features.get(j));
                                }
                                features = newArray;
                                response.put("moreFeaturesAvailable", true);
                            }
                            response.put("features", (Object)features);
                        }
                    }
                    if (error == null) break block25;
                }
                catch (Exception e) {
                    block26: {
                        try {
                            log.error((Object)("Exception loading feature info for " + exceptionMsg), (Throwable)e);
                            error = "Exception: " + e.toString();
                            if (error == null) break block26;
                        }
                        catch (Throwable throwable) {
                            if (error != null) {
                                response.put("error", error);
                            }
                            if (fs != null) {
                                fs.getDataStore().dispose();
                            }
                            throw throwable;
                        }
                        response.put("error", (Object)error);
                    }
                    if (fs == null) continue;
                    fs.getDataStore().dispose();
                    continue;
                }
                response.put("error", (Object)error);
            }
            if (fs == null) continue;
            fs.getDataStore().dispose();
            continue;
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(responses.toString(4)));
    }

    protected JSONArray executeQuery(ApplicationLayer al, SimpleFeatureType ft, FeatureSource fs, Query q) throws IOException, JSONException, Exception {
        FeatureToJson ftjson = new FeatureToJson(this.arrays, this.edit, this.graph, this.attributesToInclude);
        JSONArray features = ftjson.getJSONFeatures(al, ft, fs, q, null, null);
        return features;
    }
}

