/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.util;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.FeatureTypeRelationKey;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.util.ValidFilterExtractor;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.jdbc.JDBCFeatureSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class FeatureToJson {
    public static final int MAX_FEATURES = 1000;
    private boolean arrays = false;
    private boolean edit = false;
    private boolean graph = false;
    private boolean aliases = true;
    private List<Long> attributesToInclude = new ArrayList<Long>();
    private static final int TIMEOUT = 5000;
    private FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    HashMap<Long, List<String>> propertyNamesQueryCache = new HashMap();
    HashMap<Long, Boolean> haveInvisiblePropertiesCache = new HashMap();
    HashMap<Long, List<String>> propertyNamesReturnCache = new HashMap();
    private DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");

    public FeatureToJson(boolean arrays, boolean edit) {
        this.arrays = arrays;
        this.edit = edit;
    }

    public FeatureToJson(boolean arrays, boolean edit, boolean graph, List<Long> attributesToInclude) {
        this.arrays = arrays;
        this.edit = edit;
        this.graph = graph;
        this.attributesToInclude = attributesToInclude;
    }

    public FeatureToJson(boolean arrays, boolean edit, boolean graph, boolean aliases, List<Long> attributesToInclude) {
        this.arrays = arrays;
        this.edit = edit;
        this.graph = graph;
        this.attributesToInclude = attributesToInclude;
        this.aliases = aliases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getJSONFeatures(ApplicationLayer al, SimpleFeatureType ft, FeatureSource fs, Query q, String sort, String dir) throws IOException, JSONException, Exception {
        boolean offsetSupported;
        List<Object> propertyNames;
        HashMap<String, String> attributeAliases = new HashMap<String, String>();
        if (!this.edit) {
            for (AttributeDescriptor ad : ft.getAttributes()) {
                if (ad.getAlias() == null) continue;
                attributeAliases.put(ad.getName(), ad.getAlias());
            }
        }
        if (al != null) {
            propertyNames = this.setPropertyNames(al, q, ft, this.edit);
        } else {
            propertyNames = new ArrayList();
            for (AttributeDescriptor ad : ft.getAttributes()) {
                propertyNames.add(ad.getName());
            }
        }
        if (sort != null) {
            this.setSortBy(q, propertyNames, sort, dir);
        } else if ((fs instanceof JDBCFeatureSource || fs.getDataStore() instanceof WFSDataStore) && !propertyNames.isEmpty()) {
            this.setSortBy(q, (String)propertyNames.get(0), dir);
        }
        Integer start = q.getStartIndex();
        if (start == null) {
            start = 0;
        }
        if (!(offsetSupported = fs.getQueryCapabilities().isOffsetSupported()) && q.getMaxFeatures() < 1000 || fs.getDataStore() instanceof WFSDataStore) {
            q.setMaxFeatures(q.getMaxFeatures() + start);
        }
        FeatureIterator it = null;
        JSONArray features = new JSONArray();
        try {
            it = fs.getFeatures(q).features();
            int featureIndex = 0;
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                if (offsetSupported || featureIndex >= start) {
                    JSONObject j = this.toJSONFeature(new JSONObject(), feature, ft, al, propertyNames, attributeAliases, 0);
                    features.put((Object)j);
                }
                ++featureIndex;
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
            fs.getDataStore().dispose();
        }
        return features;
    }

    private JSONObject toJSONFeature(JSONObject j, SimpleFeature f, SimpleFeatureType ft, ApplicationLayer al, List<String> propertyNames, Map<String, String> attributeAliases, int index) throws JSONException, Exception {
        if (this.arrays) {
            for (String name : propertyNames) {
                Object value = f.getAttribute(name);
                j.put("c" + index++, this.formatValue(value));
            }
        } else {
            for (String name : propertyNames) {
                if (!this.aliases) {
                    j.put(name, this.formatValue(f.getAttribute(name)));
                    continue;
                }
                String alias = null;
                if (attributeAliases != null) {
                    alias = attributeAliases.get(name);
                }
                j.put(alias != null ? alias : name, this.formatValue(f.getAttribute(name)));
            }
        }
        if (j.optString("__fid", null) == null) {
            String id = f.getID();
            j.put("__fid", (Object)id);
        }
        if (ft.hasRelations()) {
            j = this.populateWithRelatedFeatures(j, f, ft, al, index);
        }
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject populateWithRelatedFeatures(JSONObject j, SimpleFeature feature, SimpleFeatureType ft, ApplicationLayer al, int index) throws Exception {
        if (ft.hasRelations()) {
            JSONArray related_featuretypes = new JSONArray();
            for (FeatureTypeRelation rel : ft.getRelations()) {
                boolean isJoin = rel.getType().equals("join");
                if (isJoin) {
                    FeatureSource foreignFs = rel.getForeignFeatureType().openGeoToolsFeatureSource(5000);
                    FeatureIterator foreignIt = null;
                    try {
                        List<Object> propertyNames;
                        Query foreignQ = new Query(foreignFs.getName().toString());
                        Filter filter = this.createFilter(feature, rel);
                        if (filter == null) continue;
                        foreignQ.setMaxFeatures(1);
                        foreignQ.setFilter(filter);
                        if (al != null) {
                            propertyNames = this.setPropertyNames(al, foreignQ, rel.getForeignFeatureType(), this.edit);
                        } else {
                            propertyNames = new ArrayList();
                            for (Object ad : rel.getForeignFeatureType().getAttributes()) {
                                propertyNames.add(ad.getName());
                            }
                        }
                        if (propertyNames.isEmpty()) continue;
                        HashMap<String, String> attributeAliases = new HashMap<String, String>();
                        if (!this.edit) {
                            Object ad;
                            ad = rel.getForeignFeatureType().getAttributes().iterator();
                            while (ad.hasNext()) {
                                AttributeDescriptor ad2 = (AttributeDescriptor)ad.next();
                                if (ad2.getAlias() == null) continue;
                                attributeAliases.put(ad2.getName(), ad2.getAlias());
                            }
                        }
                        foreignIt = foreignFs.getFeatures(foreignQ).features();
                        while (foreignIt.hasNext()) {
                            SimpleFeature foreignFeature = (SimpleFeature)foreignIt.next();
                            j = this.toJSONFeature(j, foreignFeature, rel.getForeignFeatureType(), al, propertyNames, attributeAliases, index);
                        }
                        continue;
                    }
                    finally {
                        if (foreignIt != null) {
                            foreignIt.close();
                        }
                        foreignFs.getDataStore().dispose();
                        continue;
                    }
                }
                Filter filter = this.createFilter(feature, rel);
                if (filter == null) continue;
                JSONObject related_ft = new JSONObject();
                related_ft.put("filter", (Object)CQL.toCQL((Filter)filter));
                related_ft.put("id", (Object)rel.getForeignFeatureType().getId());
                related_ft.put("foreignFeatureTypeName", (Object)rel.getForeignFeatureType().getTypeName());
                related_featuretypes.put((Object)related_ft);
            }
            if (related_featuretypes.length() > 0) {
                j.put("related_featuretypes", (Object)related_featuretypes);
            }
        }
        return j;
    }

    private List<String> setPropertyNames(ApplicationLayer appLayer, Query q, SimpleFeatureType sft, boolean edit) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        boolean haveInvisibleProperties = false;
        if (this.propertyNamesQueryCache.containsKey(sft.getId())) {
            haveInvisibleProperties = this.haveInvisiblePropertiesCache.get(sft.getId());
            if (haveInvisibleProperties) {
                q.setPropertyNames(this.propertyNamesQueryCache.get(sft.getId()));
            }
            return this.propertyNamesReturnCache.get(sft.getId());
        }
        for (ConfiguredAttribute ca : appLayer.getAttributes(sft)) {
            if (!edit && !this.graph && ca.isVisible() || edit && ca.isEditable() || this.graph && this.attributesToInclude.contains(ca.getId())) {
                propertyNames.add(ca.getAttributeName());
                continue;
            }
            haveInvisibleProperties = true;
        }
        this.haveInvisiblePropertiesCache.put(sft.getId(), haveInvisibleProperties);
        this.propertyNamesReturnCache.put(sft.getId(), propertyNames);
        this.propertyNamesQueryCache.put(sft.getId(), propertyNames);
        if (haveInvisibleProperties) {
            q.setPropertyNames(propertyNames);
            if (sft.getRelations() != null) {
                ArrayList<String> withRelations = new ArrayList<String>();
                withRelations.addAll(propertyNames);
                for (FeatureTypeRelation ftr : sft.getRelations()) {
                    if (ftr.getRelationKeys() == null) continue;
                    for (FeatureTypeRelationKey key : ftr.getRelationKeys()) {
                        if (withRelations.contains(key.getLeftSide().getName())) continue;
                        withRelations.add(key.getLeftSide().getName());
                    }
                }
                this.propertyNamesQueryCache.put(sft.getId(), withRelations);
                q.setPropertyNames(withRelations);
            }
        }
        this.propertyNamesReturnCache.put(sft.getId(), propertyNames);
        return propertyNames;
    }

    private void setSortBy(Query q, List<String> propertyNames, String sort, String dir) {
        if (sort != null) {
            String sortAttribute = null;
            if (this.arrays) {
                int i = Integer.parseInt(sort.substring(1));
                int j = 0;
                for (String name : propertyNames) {
                    if (j == i) {
                        sortAttribute = name;
                        break;
                    }
                    ++j;
                }
            } else {
                sortAttribute = sort;
            }
            this.setSortBy(q, sortAttribute, dir);
        }
    }

    private void setSortBy(Query q, String sort, String dir) {
        if (sort != null) {
            q.setSortBy(new SortBy[]{this.ff2.sort(sort, "DESC".equals(dir) ? SortOrder.DESCENDING : SortOrder.ASCENDING)});
        }
    }

    private Object formatValue(Object value) {
        if (value instanceof Date) {
            return this.dateFormat.format((Date)value);
        }
        return value;
    }

    private Filter createFilter(SimpleFeature feature, FeatureTypeRelation rel) {
        ArrayList<Object> filters = new ArrayList<Object>();
        for (FeatureTypeRelationKey key : rel.getRelationKeys()) {
            AttributeDescriptor rightSide = key.getRightSide();
            AttributeDescriptor leftSide = key.getLeftSide();
            Object value = feature.getAttribute(leftSide.getName());
            if (value == null) continue;
            if (AttributeDescriptor.GEOMETRY_TYPES.contains(rightSide.getType()) && AttributeDescriptor.GEOMETRY_TYPES.contains(leftSide.getType())) {
                filters.add(this.ff2.not((Filter)this.ff2.isNull((Expression)this.ff2.property(rightSide.getName()))));
                filters.add(this.ff2.intersects((Expression)this.ff2.property(rightSide.getName()), (Expression)this.ff2.literal(value)));
                continue;
            }
            filters.add(this.ff2.equals((Expression)this.ff2.property(rightSide.getName()), (Expression)this.ff2.literal(value)));
        }
        if (filters.size() > 1) {
            return this.ff2.and(filters);
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return null;
    }

    public static Filter reformatFilter(Filter filter, SimpleFeatureType ft) throws Exception {
        if (Filter.INCLUDE.equals(filter) || Filter.EXCLUDE.equals(filter)) {
            return filter;
        }
        for (FeatureTypeRelation rel : ft.getRelations()) {
            if (!"join".equals(rel.getType())) continue;
            filter = FeatureToJson.reformatFilter(filter, rel.getForeignFeatureType());
            filter = (Filter)filter.accept((FilterVisitor)new ValidFilterExtractor(rel), (Object)filter);
        }
        filter = (Filter)filter.accept((FilterVisitor)new SimplifyingFilterVisitor(), null);
        return filter;
    }
}

