/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.util.ChangeMatchCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class FlamingoCQL {
    private static final Log LOG = LogFactory.getLog(FlamingoCQL.class);
    private static final String BEGIN_PART = "APPLAYER(";

    public static Filter toFilter(String filter, EntityManager em) throws CQLException {
        filter = FlamingoCQL.processFilter(filter, em);
        return ECQL.toFilter((String)filter);
    }

    public static String processFilter(String filter, EntityManager em) throws CQLException {
        if (filter.contains(BEGIN_PART)) {
            filter = FlamingoCQL.replaceApplayerFilter(filter, em);
        }
        return filter;
    }

    private static String replaceApplayerFilter(String filter, EntityManager em) throws CQLException {
        int begin = filter.indexOf(BEGIN_PART);
        int startIndex = begin + BEGIN_PART.length();
        int closingBrackets = 0;
        int openBrackets = 1;
        int endIndex = 0;
        for (int i = startIndex; i < filter.length(); ++i) {
            char c = filter.charAt(i);
            if (c == '(') {
                ++openBrackets;
            }
            if (c == ')') {
                ++closingBrackets;
            }
            if (openBrackets != closingBrackets) continue;
            endIndex = i;
            break;
        }
        String appLayerPart = filter.substring(startIndex, endIndex);
        appLayerPart = FlamingoCQL.processFilter(appLayerPart, em);
        String geometryFilter = FlamingoCQL.rewriteAppLayerFilter(appLayerPart, em);
        String beginpart = filter.substring(0, begin);
        String endpart = filter.substring(endIndex + 1);
        String result = beginpart + geometryFilter + endpart;
        return result;
    }

    private static String rewriteAppLayerFilter(String applayerfilter, EntityManager em) throws CQLException {
        int firstIndex = applayerfilter.indexOf(", ");
        int secondIndex = applayerfilter.indexOf(",", firstIndex + 1);
        String attribute = applayerfilter.substring(0, firstIndex);
        String appLayerId = applayerfilter.substring(firstIndex + 1, secondIndex);
        String filter = applayerfilter.substring(secondIndex + 1);
        filter = filter.trim();
        appLayerId = appLayerId.trim();
        Long id = Long.parseLong(appLayerId);
        String geom = FlamingoCQL.getUnionedFeatures(filter, id, em);
        String nieuwFilter = "intersects (" + attribute + ", " + geom + ")";
        return nieuwFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUnionedFeatures(String filter, Long appLayerId, EntityManager em) throws CQLException {
        String string;
        ApplicationLayer al = (ApplicationLayer)em.find(ApplicationLayer.class, (Object)appLayerId);
        GeoService gs = al.getService();
        Layer l = gs.getLayer(al.getLayerName(), em);
        if (l.getFeatureType() == null) {
            throw new Exception("Layer has no feature type");
        }
        FeatureSource fs = l.getFeatureType().openGeoToolsFeatureSource();
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 28992);
        Query q = new Query(fs.getName().toString());
        if (filter != null && !filter.isEmpty()) {
            Filter attributeFilter = ECQL.toFilter((String)filter);
            attributeFilter = (Filter)attributeFilter.accept((FilterVisitor)new ChangeMatchCase(false), null);
            q.setFilter(attributeFilter);
        }
        q.setMaxFeatures(1000);
        FeatureIterator it = fs.getFeatures(q).features();
        try {
            GeometryCollection gc = new GeometryCollection(null, gf);
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Geometry g = (Geometry)f.getDefaultGeometry();
                if (g == null) continue;
                gc = gc.union(g);
            }
            string = gc.union().toText();
        }
        catch (Throwable throwable) {
            try {
                it.close();
                fs.getDataStore().dispose();
                throw throwable;
            }
            catch (Exception ex) {
                LOG.error((Object)("retrieving geometry for intersects filter in flamingoCQL failed: " + ex));
                return null;
            }
        }
        it.close();
        fs.getDataStore().dispose();
        return string;
    }
}

