/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.image;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import nl.b3p.viewer.config.services.TileMatrix;
import nl.b3p.viewer.config.services.TileMatrixSet;
import nl.b3p.viewer.config.services.TileService;
import nl.b3p.viewer.image.Bbox;
import nl.b3p.viewer.image.CombineImageUrl;
import nl.b3p.viewer.image.CombineStaticImageUrl;
import nl.b3p.viewer.image.CombineTileImageUrl;
import nl.b3p.viewer.image.ImageBbox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class CombineWMTSUrl
extends CombineTileImageUrl {
    private static final Log log = LogFactory.getLog(CombineTileImageUrl.class);
    private String layername;
    private TileMatrixSet set;
    private double ratio = 1.0;

    public CombineWMTSUrl(CombineTileImageUrl ctiu) {
        super(ctiu);
    }

    public CombineWMTSUrl() {
    }

    @Override
    protected String createUrl(ImageBbox imageBbox, Bbox tileBbox, int indexX, int indexY, int zoomlevel) {
        try {
            TileMatrix tm = (TileMatrix)this.set.getMatrices().get(zoomlevel);
            return this.url + "request=GetTile&version=1.0.0&format=image/png&SERVICE=WMTS&layer=" + this.getLayername() + "&TileMatrixSet=" + URLEncoder.encode(this.set.getIdentifier(), "UTF-8") + "&TileRow=" + indexY + "&TileCol=" + indexX + "&TileMatrix=" + URLEncoder.encode(tm.getIdentifier(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"Cannot encode url");
            return null;
        }
    }

    public void setMatrixSet(JSONObject matrixSet) {
        this.set = TileMatrixSet.fromJSONObject((JSONObject)matrixSet);
    }

    @Override
    public Integer getClosestZoomlevel(ImageBbox requestBbox) {
        double res = requestBbox.getUnitsPixelX();
        int dpi = 72;
        double dpm = 0.0254;
        double scale = res * ((double)dpi / dpm);
        List matrices = this.set.getMatrices();
        int index = -1;
        for (int i = 0; i < matrices.size(); ++i) {
            TileMatrix tm = (TileMatrix)matrices.get(i);
            if (i == matrices.size() - 1) {
                return i;
            }
            TileMatrix next = (TileMatrix)matrices.get(i + 1);
            double scCur = Double.valueOf(tm.getScaleDenominator());
            double scNext = Double.valueOf(next.getScaleDenominator());
            if (!(scale < scCur) || !(scale > scNext)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public List<CombineImageUrl> calculateNewUrl(ImageBbox imbbox) {
        ArrayList<CombineImageUrl> tileImages = new ArrayList<CombineImageUrl>();
        Integer indexOfMatrix = this.getClosestZoomlevel(imbbox);
        TileMatrix tm = (TileMatrix)this.set.getMatrices().get(indexOfMatrix);
        String topleft = tm.getTopLeftCorner();
        double tileMatrixMinX = Double.valueOf(topleft.substring(0, topleft.indexOf(" ")));
        double tileMatrixMaxY = Double.valueOf(topleft.substring(topleft.indexOf(" ") + 1));
        int matrixHeight = tm.getMatrixHeight();
        int matrixWidth = tm.getMatrixWidth();
        double bBoxMinX = imbbox.getBbox().getMinx();
        double bBoxMinY = imbbox.getBbox().getMiny();
        double bBoxMaxX = imbbox.getBbox().getMaxx();
        double bBoxMaxY = imbbox.getBbox().getMaxy();
        double pixelSpan = Double.valueOf(tm.getScaleDenominator()) * 2.8E-4 / TileService.metersPerUnit((String)tm.getMatrixSet().getCrs());
        double tileSpanX = (double)tm.getTileWidth() * pixelSpan;
        double tileSpanY = (double)tm.getTileHeight() * pixelSpan;
        int minTileIndexX = (int)Math.floor((bBoxMinX - tileMatrixMinX) / tileSpanX + epsilon);
        int maxTileIndexX = (int)Math.floor((bBoxMaxX - tileMatrixMinX) / tileSpanX + epsilon);
        int minTileIndexY = (int)Math.floor((tileMatrixMaxY - bBoxMaxY) / tileSpanY + epsilon);
        int maxTileIndexY = (int)Math.floor((tileMatrixMaxY - bBoxMinY) / tileSpanY - epsilon);
        double requestResolution = imbbox.getUnitsPixelX();
        this.ratio = requestResolution / pixelSpan;
        if (minTileIndexX < 0) {
            minTileIndexX = 0;
        }
        if (maxTileIndexX >= matrixWidth) {
            maxTileIndexX = matrixWidth - 1;
        }
        if (minTileIndexY < 0) {
            minTileIndexY = 0;
        }
        if (maxTileIndexY >= matrixHeight) {
            maxTileIndexY = matrixHeight - 1;
        }
        int xOffset = (int)Math.floor((bBoxMinX - tileMatrixMinX) / tileSpanX % 1.0 * ((double)tm.getTileWidth() / this.ratio));
        int yOffset = (int)Math.floor((tileMatrixMaxY - bBoxMaxY) / tileSpanY % 1.0 * ((double)tm.getTileHeight() / this.ratio));
        double tileWidthMapUnits = imbbox.getUnitsPixelX() * (double)tm.getTileWidth();
        double tileHeightMapUnits = imbbox.getUnitsPixelY() * (double)tm.getTileHeight();
        int numX = 0;
        int numY = 0;
        for (int ix = minTileIndexX; ix <= maxTileIndexX; ++ix) {
            for (int iy = minTileIndexY; iy <= maxTileIndexY; ++iy) {
                double[] tempBbox;
                tempBbox = new double[]{this.serviceBbox.getMinx() + (double)ix * tileWidthMapUnits, this.serviceBbox.getMiny() + (double)iy * tileHeightMapUnits, tempBbox[0] + tileWidthMapUnits, tempBbox[1] + tileHeightMapUnits};
                Bbox tileBbox = new Bbox(tempBbox);
                CombineStaticImageUrl tile = this.createTile(imbbox, tileBbox, ix, iy, (int)indexOfMatrix, (double)numX * ((double)tm.getTileWidth() / this.ratio) - (double)xOffset, (double)numY * ((double)tm.getTileHeight() / this.ratio) - (double)yOffset);
                tileImages.add(tile);
                ++numY;
            }
            ++numX;
            numY = 0;
        }
        return tileImages;
    }

    public CombineStaticImageUrl createTile(ImageBbox imageBbox, Bbox tileBbox, int tileX, int tileY, int matrixId, Double imgPosX, Double imgPosY) {
        CombineStaticImageUrl img = new CombineStaticImageUrl();
        TileMatrix tm = (TileMatrix)this.set.getMatrices().get(matrixId);
        String tileUrl = this.createUrl(imageBbox, tileBbox, tileX, tileY, matrixId);
        img.setUrl(tileUrl);
        img.setHeight((int)((double)tm.getTileHeight() / this.ratio));
        img.setWidth((int)((double)tm.getTileWidth() / this.ratio));
        img.setBbox(tileBbox);
        img.setX(imgPosX.intValue());
        img.setY(imgPosY.intValue());
        img.setAlpha(this.getAlpha());
        return img;
    }

    public String getLayername() {
        return this.layername;
    }

    public void setLayername(String layername) {
        this.layername = layername;
    }
}

