/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.OneToManyTypeConverter;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ConfiguredComponent;
import nl.b3p.viewer.search.ArcGisRestSearchClient;
import nl.b3p.viewer.search.AttributeSourceSearchClient;
import nl.b3p.viewer.search.OpenLSSearchClient;
import nl.b3p.viewer.search.PDOKSearchClient;
import nl.b3p.viewer.search.SearchClient;
import nl.b3p.viewer.search.SearchResult;
import nl.b3p.viewer.search.SolrSearchClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/search")
@StrictBinding
public class SearchActionBean
implements ActionBean {
    private ActionBeanContext context;
    @Validate
    private String searchText;
    @Validate
    private String searchName;
    @Validate
    private Long appId;
    @Validate
    private String componentName;
    @Validate
    private String searchRequestId;
    @Validate(converter=OneToManyTypeConverter.class)
    private List<String> visibleLayers = new ArrayList();

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public String getSearchRequestId() {
        return this.searchRequestId;
    }

    public void setSearchRequestId(String searchRequestId) {
        this.searchRequestId = searchRequestId;
    }

    public List<String> getVisibleLayers() {
        return this.visibleLayers;
    }

    public void setVisibleLayers(List<String> visibleLayers) {
        this.visibleLayers = visibleLayers;
    }

    @DefaultHandler
    public Resolution source() throws Exception {
        JSONObject result = new JSONObject();
        JSONObject request = new JSONObject();
        request.put("appId", (Object)this.appId);
        request.put("componentName", (Object)this.componentName);
        request.put("searchName", (Object)this.searchName);
        request.put("searchText", (Object)this.searchText);
        request.put("searchRequestId", (Object)this.searchRequestId);
        result.put("request", (Object)request);
        String error = "";
        JSONObject search = this.getSearchConfig();
        if (search == null) {
            error = error + "No searchconfig found";
        } else {
            JSONArray resultsArray = new JSONArray();
            SearchClient client = this.getSearchClient(search);
            SearchResult response = new SearchResult();
            if (client != null) {
                response = client.search(this.searchText);
                resultsArray = response.getResults();
            }
            result.put("limitReached", (Object)response.getLimitReached());
            result.put("results", (Object)resultsArray);
            result.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(result.toString()));
    }

    public Resolution autosuggest() throws JSONException {
        JSONObject result = new JSONObject();
        JSONObject request = new JSONObject();
        request.put("appId", (Object)this.appId);
        request.put("componentName", (Object)this.componentName);
        request.put("searchName", (Object)this.searchName);
        request.put("searchText", (Object)this.searchText);
        request.put("searchRequestId", (Object)this.searchRequestId);
        result.put("request", (Object)request);
        String error = "";
        JSONObject search = this.getSearchConfig();
        if (search == null) {
            error = error + "No suggestions found";
        } else {
            JSONArray results = new JSONArray();
            SearchClient client = this.getSearchClient(search);
            if (client != null) {
                results = client.autosuggest(this.searchText);
            }
            result.put("results", (Object)results);
            result.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(result.toString()));
    }

    private JSONObject getSearchConfig() throws JSONException {
        JSONObject obj = new JSONObject();
        if (this.appId != null) {
            EntityManager em = Stripersist.getEntityManager();
            Application app = (Application)em.find(Application.class, (Object)this.appId);
            Set components = app.getComponents();
            for (ConfiguredComponent comp : components) {
                if (!comp.getName().equals(this.componentName)) continue;
                JSONObject config = new JSONObject(comp.getConfig());
                if (config.has("searchconfigs")) {
                    JSONArray searchConfig = config.getJSONArray("searchconfigs");
                    for (int i = 0; i < searchConfig.length(); ++i) {
                        JSONObject search = (JSONObject)searchConfig.get(i);
                        if (!search.get("id").equals(this.searchName)) continue;
                        obj = search;
                    }
                    continue;
                }
                if (!config.has("searchUrl")) continue;
                obj.put("url", config.get("searchUrl"));
            }
        } else {
            return null;
        }
        return obj;
    }

    private SearchClient getSearchClient(JSONObject config) throws JSONException {
        Object client;
        if (config == null) {
            client = null;
        } else {
            String url;
            String type = config.getString("type");
            String string = url = config.has("searchUrl") ? config.getString("searchUrl") : config.getString("url");
            if (type == null || "arcgisrest".equalsIgnoreCase(type)) {
                client = new ArcGisRestSearchClient(url);
            } else if (type.equalsIgnoreCase("openls")) {
                client = new OpenLSSearchClient(url);
            } else if (type.equalsIgnoreCase("solr")) {
                client = new SolrSearchClient();
                ((SolrSearchClient)client).setConfig(config);
                ArrayList<Long> visLayers = new ArrayList<Long>();
                for (String visibleLayer : this.visibleLayers) {
                    try {
                        visLayers.add(new Long(visibleLayer));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ((SolrSearchClient)client).setVisibleLayers(visLayers);
            } else if (type.equalsIgnoreCase("pdok")) {
                String filter = config.optString("filter");
                client = new PDOKSearchClient(filter);
            } else {
                client = type.equalsIgnoreCase("attributesource") ? new AttributeSourceSearchClient(config) : null;
            }
        }
        return client;
    }
}

