Ext.define("viewer.AppLoader", {config:{appId:"", app:{}, debugMode:!1, user:null, viewerType:"openlayers", loginUrl:"", logoutUrl:"", viewerController:null, contextPath:"", absoluteURIPrefix:"", actionbeanUrl:null}, constructor:function(a) {
  this.initConfig(a);
  this.exposeGlobalVariables();
}, reloadApplication:function(a) {
}, loadApplication:function() {
  var a = function() {
    alert("Cannot retrieve config");
  };
  Ext.Ajax.request({url:Ext.String.urlAppend(this.config.actionbeanUrl, "t\x3d" + (new Date).getTime()), scope:this, params:{application:this.config.appId}, success:function(b) {
    b = Ext.JSON.decode(b.responseText);
    b.success ? this.processAppConfig(Ext.JSON.decode(b.config)) : void 0 !== a && a(b.error);
  }, failure:function(b) {
    void 0 !== a && a("Ajax request failed with status " + b.status + " " + b.statusText + ": " + b.responseText);
  }});
}, processAppConfig:function(a) {
  a.name && (document.title = a.name);
  this.createApplicationStyle(a);
  Ext.onReady(function() {
    this.loadViewerController(a);
  }, this);
}, get:function(a) {
  var b = ["viewerController", "appId", "user", "contextPath", "absoluteURIPrefix"];
  this.config.debugMode && b.push("app");
  if (-1 !== Ext.Array.indexOf(b, a)) {
    return this.config[a];
  }
}, exposeGlobalVariables:function() {
  this.exposeVariable(this.config.appId, "appId", !this.config.debugMode);
  this.exposeVariable(this.config.user, "user", !this.config.debugMode);
  this.exposeVariable(this.config.contextPath, "contextPath", !this.config.debugMode);
  this.exposeVariable(this.config.absoluteURIPrefix, "absoluteURIPrefix", !this.config.debugMode);
  this.exposeVariable(this.login.bind(this), "login", !0);
  this.exposeVariable(this.logout.bind(this), "logout", !0);
}, exposeVariable:function(a, b, c) {
  Object.defineProperty(window, b, {get:function() {
    console.warn && !c && console.warn("Warning! You are using global variable [var], please use FlamingoAppLoader.get('[var]').".replace(/\[var\]/ig, b));
    return a;
  }});
}, login:function() {
  window.location.href = this.config.loginUrl;
}, logout:function() {
  var a = this.config.viewerController.app.details;
  window.location.href = a.returnAfterLogout && "true" === a.returnAfterLogout ? this.config.logoutAndReturnUrl : this.config.logoutUrl;
}, viewerControllerLoaded:function() {
  document.getElementById("appLoader").className += " hide";
  this.updateLoginInfo();
}, updateLoginInfo:function() {
  if (this.config.user) {
    var a = document.getElementById("loginLink");
    a && (a.innerHTML = "Uitloggen", a.onclick = this.logout.bind(this));
    if (a = document.getElementById("loginInfo")) {
      a.innerHTML = "Ingelogd als \x3cb\x3e" + this.config.user.name + "\x3c/b\x3e";
    }
  }
}, loadViewerController:function(a) {
  var b = {ON_COMPONENTS_FINISHED_LOADING:this.viewerControllerLoaded.bind(this)}, c = {};
  "flamingo" === this.config.viewerType && (c.swfPath = this.config.contextPath + "/flamingo/flamingo.swf");
  this.config.viewerController = new viewer.viewercontroller.ViewerController(this.config.viewerType, null, a, b, c);
  this.exposeVariable(this.config.viewerController, "viewerController", !this.config.debugMode);
  document.getElementById(this.config.viewerController.getWrapperId()).addEventListener("touchstart", function() {
  });
}, createApplicationStyle:function(a) {
  if (a.details) {
    var b = a.details.globalLayout ? Ext.JSON.decode(a.details.globalLayout) : {};
    Ext.create("viewer.AppStyle", {steunkleur1:a.details.steunkleur1, steunkleur2:a.details.steunkleur2, font:a.details.font, globalLayout:b});
  }
}});
Ext.define("viewer.AppStyle", {config:{steunkleur1:"", steunkleur2:"", font:"", globalLayout:""}, CSS_STYLESHEET_ID:"app_layout_stylesheet", constructor:function(a) {
  this.initConfig(a);
  a = this.generateApplicationStyle();
  this.addStylesheet(a);
}, addStylesheet:function(a) {
  Ext.util.CSS.removeStyleSheet(this.CSS_STYLESHEET_ID);
  Ext.util.CSS.createStyleSheet(a, this.CSS_STYLESHEET_ID);
}, generateApplicationStyle:function() {
  var a = [];
  this.config.steunkleur1 && this.config.steunkleur2 && (a.push(this.generateStyleDeclaration(".x-window-default", ["border-color: [steunkleur1]", "box-shadow: 0 1px 0 0 [steunkleur1] inset, 0 -1px 0 0 [steunkleur1] inset, -1px 0 0 0 [steunkleur1] inset, 1px 0 0 0 [steunkleur1] inset", "background-color: [steunkleur1]"])), a.push(this.generateStyleDeclaration(".x-window-header-default-top", ["background-color: [steunkleur1]", "box-shadow: 0 1px 0 0 [steunkleur1] inset, -1px 0 0 0 [steunkleur1] inset, 1px 0 0 0 [steunkleur1] inset"])), 
  a.push(this.generateStyleDeclaration(".x-window-header-default", ["border-color: [steunkleur1]"])), a.push(this.generateStyleDeclaration(".x-window-body-default", ["background-color: [steunkleur1]", "border-color: [steunkleur1]"])), a.push(this.generateStyleDeclaration(".x-window.floating-window", ["border-color: #FFFFFF", "box-shadow: 0 1px 0 0 #FFFFFF inset, 0 -1px 0 0 #FFFFFF inset, -1px 0 0 0 #FFFFFF inset, 1px 0 0 0 #FFFFFF inset", "background-color: #FFFFFF"])), a.push(this.generateStyleDeclaration(".x-window.floating-left_menu", 
  ["border-color: transparent", "box-shadow: none", "background-color: transparent"])), a.push(this.generateStyleDeclaration(".x-window.floating-window .x-window-header-default-top", ["background-color: #FFFFFF", "box-shadow: 0 1px 0 0 #FFFFFF inset, -1px 0 0 0 #FFFFFF inset, 1px 0 0 0 #FFFFFF inset"])), a.push(this.generateStyleDeclaration(".x-window.floating-window .x-window-body-default", ["background-color: #FFFFFF", "border-color: #FFFFFF"])), a.push(this.generateStyleDeclaration(".x-window.floating-left_menu .x-window-body-default", 
  ["border-color: transparent", "background-color: transparent"])), a.push(this.generateStyleDeclaration(".x-panel-header-default", "background-color: [steunkleur1];background-image: -moz-linear-gradient(center top, [steunkleur1], [steunkleur1]);background-image: -webkit-gradient(linear, 50% 0%, 50% 100%, color-stop(0%, [steunkleur1]), color-stop(100%, [steunkleur1]));background-image: -webkit-linear-gradient(top, [steunkleur1], [steunkleur1]);background-image: -o-linear-gradient(top, [steunkleur1], [steunkleur1]);background-image: -ms-linear-gradient(top, [steunkleur1], [steunkleur1]);background-image: linear-gradient(top, [steunkleur1], [steunkleur1]);border-color: [steunkleur1]".split(";"))), 
  a.push(this.generateStyleDeclaration(".x-panel-header-default-top", ["box-shadow: 0 1px 0 0 [steunkleur1] inset"])), a.push(this.generateStyleDeclaration(".x-tool-img", ["background-color: [steunkleur1] !important", "color: [steunkleur2]"])), a.push(this.generateStyleDeclaration(".x-nlg .x-panel-header-default-top;.x-nlg .x-window-default-tl;.x-nlg .x-window-default-tc;.x-nlg .x-window-default-tr;.x-nlg .x-window-default-ml;.x-nlg .x-window-default-mc;.x-nlg .x-window-default-mr;.x-nlg .x-window-default-bl;.x-nlg .x-window-default-bc;.x-nlg .x-window-default-br;.x-nlg .x-window-header-default-top-tl;.x-nlg .x-window-header-default-top-tc;.x-nlg .x-window-header-default-top-tr;.x-nlg .x-window-header-default-top-ml;.x-nlg .x-window-header-default-top-mc;.x-nlg .x-window-header-default-top-mr;.x-nlg .x-window-header-default-top-bl;.x-nlg .x-window-header-default-top-bc;.x-nlg .x-window-header-default-top-br".split(";"), 
  ["background-image: none", "background-color: [steunkleur1]"])), a.push(this.generateStyleDeclaration(".x-nlg .x-window.floating-left_menu .x-window-default-tl;.x-nlg .x-window.floating-left_menu .x-window-default-tc;.x-nlg .x-window.floating-left_menu .x-window-default-tr;.x-nlg .x-window.floating-left_menu .x-window-default-ml;.x-nlg .x-window.floating-left_menu .x-window-default-mc;.x-nlg .x-window.floating-left_menu .x-window-default-mr;.x-nlg .x-window.floating-left_menu .x-window-default-bl;.x-nlg .x-window.floating-left_menu .x-window-default-bc;.x-nlg .x-window.floating-left_menu .x-window-default-br;.x-nlg .x-window.floating-left_menu .x-window-header-default-top-tl;.x-nlg .x-window.floating-left_menu .x-window-header-default-top-tc;.x-nlg .x-window.floating-left_menu .x-window-header-default-top-tr;.x-nlg .x-window.floating-left_menu .x-window-header-default-top-ml;.x-nlg .x-window.floating-left_menu .x-window-header-default-top-mc;.x-nlg .x-window.floating-left_menu .x-window-header-default-top-mr;.x-nlg .x-window.floating-left_menu .x-window-header-default-top-bl;.x-nlg .x-window.floating-left_menu .x-window-header-default-top-bc;.x-nlg .x-window.floating-left_menu .x-window-header-default-top-br".split(";"), 
  ["border-color: transparent", "background-color: transparent"])), a.push(this.generateStyleDeclaration(".x-panel-default", ["border-color: [steunkleur1]"])), a.push(this.generateStyleDeclaration([".x-panel-header-text-default", ".x-window-header-text-default", ".x-panel-header-title-default", ".x-window-header-title-default"], ["color: [steunkleur2]"])), a.push(this.generateStyleDeclaration(".x-panel-header svg text", ["fill: [steunkleur2]"])), a.push(this.generateStyleDeclaration(".olControlOverviewMapElement", 
  ["background-color: [steunkleur1] !important"])), a.push(this.generateStyleDeclaration(".olControlOverviewMapExtentRectangle", ["border: 2px dotted [steunkleur2] !important"])), a.push(this.generateStyleDeclaration(".steunkleur1", ["background-color: [steunkleur1]"])), a.push(this.generateStyleDeclaration(".steunkleur2", ["color: [steunkleur2]"])));
  this.config.font && a.push(this.generateStyleDeclaration(".x-grid-row .x-grid-cell;.x-grid-cell;.x-panel-body-default;.x-panel-header-text-default, .x-panel-header-title-default;.x-window-body-default;.x-border-layout-ct;.x-body;.x-btn, .x-btn-inner, .x-btn .x-btn-inner;.x-field;.x-tab;.x-tab-button, .x-tab-inner-default;.x-form-field:not(.x-form-checkbox):not(.x-form-radio);.x-form-item;.x-boundlist-item;.x-menu-item-text-default, .x-menu-item-text;.x-form-cb-label;.x-form-item-label-text;.x-column-header;.x-toolbar-text-default, .x-toolbar-text;.x-window-header-text-default, .x-window-header-title-default;body div.olControlMousePosition".split(";"), 
  ["font-family: [font]"]));
  this.config.globalLayout.extraCss && a.push(this.config.globalLayout.extraCss);
  a.push(this.createWrapperStyle());
  return a.join(" ");
}, createWrapperStyle:function() {
  var a = {"max-width":this.config.globalLayout.maxWidth, "max-height":this.config.globalLayout.maxHeight, padding:this.config.globalLayout.margin, "background-color":this.config.globalLayout.backgroundColor, "background-image":this.config.globalLayout.backgroundImage, "background-repeat":this.config.globalLayout.backgroundRepeat, "background-position":this.config.globalLayout.backgroundPosition}, b = [], c;
  for (c in a) {
    a.hasOwnProperty(c) && a[c] && b.push([c, ": ", a[c], "max-width" === c || "max-height" === c ? "px" : ""].join(""));
  }
  return b.length ? this.generateStyleDeclaration("#wrapper", b) : "";
}, generateStyleDeclaration:function(a, b) {
  Ext.isArray(a) && (a = a.join(", "));
  var c = b.join(";"), c = c.replace(/\[steunkleur1\]/ig, this.config.steunkleur1), c = c.replace(/\[steunkleur2\]/ig, this.config.steunkleur2), c = c.replace(/\[font\]/ig, this.config.font);
  return [a, " { ", c, "; }"].join("");
}});
Ext.define("viewer.components.MobileManager", {singleton:!0, qs:Ext.Object.fromQueryString(location.search), constructor:function() {
  Ext.onReady(function() {
    var a = Ext.getBody();
    this.hasTouch() || a.addCls("no-touch");
    this.isMobile() && a.addCls("flamingo-mobile");
  }, this);
}, isMobile:function() {
  return this.qs.hasOwnProperty("mobile") && "true" === this.qs.mobile ? !0 : "Desktop" !== Ext.os.deviceType;
}, hasTouch:function() {
  return Ext.supports.Touch;
}, getOrientation:function() {
  return window.orientation && (90 == window.orientation || -90 == window.orientation) || screen.width > screen.height ? "landscape" : "portrait";
}});
Ext.define("viewer.viewercontroller.ViewerController", {extend:"Ext.util.Observable", queryParams:null, components:{}, mapComponent:null, app:null, layoutManager:null, layers:null, logger:null, singlePopup:!1, previousPopup:null, dataSelectionChecker:null, layersInitialized:!1, registeredSnappingLayers:[], spriteUrl:null, savedCheckedState:{}, resizeDebounce:null, filterDebounce:{}, anchors:[], constructor:function(a, b, c, d, e) {
  this.callParent([{listeners:d}]);
  this.dataSelectionChecker = Ext.create("viewer.components.DataSelectionChecker", {viewerController:this});
  this.app = c;
  this.queryParams = Ext.urlDecode(window.location.search.substring(1));
  this.savedCheckedState = this.restoreSavedCheckedState();
  d = viewer.components.Logger.LEVEL_ERROR;
  this.isDebug() && (d = viewer.components.Logger.LEVEL_DEBUG);
  this.logger = Ext.create("viewer.components.Logger", {logLevel:d});
  c.layout && (d = null, c.details && c.details.maxHeight && 0 !== parseInt(c.details.maxHeight, 10) && (d = parseInt(c.details.maxHeight, 10)), d = {layout:c.layout, configuredComponents:c.components, maxHeight:d}, b && (d.wrapperId = b), this.layoutManager = Ext.create("viewer.LayoutManager", d, c.components));
  this.layers = {};
  try {
    if (c.details && c.details.globalLayout) {
      var f = Ext.JSON.decode(c.details.globalLayout);
      f.hasOwnProperty("singlePopup") && f.singlePopup && (this.singlePopup = f.singlePopup);
    }
  } catch (h) {
  }
  b = this.layoutManager.getMapId();
  c = this.app.components;
  var f = {}, g;
  for (g in c) {
    if (c.hasOwnProperty(g) && (d = c[g], "viewer.mapcomponents.FlamingoMap" == d.className || "viewer.mapcomponents.OpenLayersMap" == d.className)) {
      f = d.config;
      break;
    }
  }
  Ext.apply(f, e || {});
  "flamingo" == a ? this.mapComponent = new viewer.viewercontroller.FlamingoMapComponent(this, b, f) : "openlayers" == a ? this.mapComponent = new viewer.viewercontroller.OpenLayersMapComponent(this, b, f) : this.logger.error("No correct viewerType defined. This might be a problem. ViewerType: " + a);
  this.addListener(viewer.viewercontroller.controller.Event.ON_LAYERS_INITIALIZED, this.spinupDataStores, this);
  this.mapComponent.addListener(viewer.viewercontroller.controller.Event.ON_CONFIG_COMPLETE, this.onMapContainerLoaded, this);
  this.addListener(viewer.viewercontroller.controller.Event.ON_SELECTEDCONTENT_CHANGE, this.onSelectedContentChanged, this);
  "openlayers" == a && this.mapComponent.fireEvent(viewer.viewercontroller.controller.Event.ON_CONFIG_COMPLETE);
  window.onorientationchange && window.addEventListener && window.addEventListener("orientationchange", function() {
    this.resizeComponents(!0);
  }.bind(this), !1);
  Ext.on("resize", function() {
    this.resizeComponents(!0);
  }, this);
}, showLoading:function(a) {
  var b = "Loading...";
  a && (b += " " + a);
  document.getElementById("loader").innerHTML = b;
  document.getElementById("loader").style.display = "block";
  document.getElementById("loadwrapper").style.zIndex = "900000";
}, hideLoading:function() {
  document.getElementById("loadwrapper").style.zIndex = "0";
  document.getElementById("loader").style.display = "none";
}, isDebug:function() {
  return this.queryParams.hasOwnProperty("debug") && "true" == this.queryParams.debug;
}, spinupDataStores:function() {
  if (!this.app.details.dataStoreSpinupDisabled) {
    var a = this.app.details.lastSpinupTime;
    a && (a = Ext.Date.parse(a, "c", !0));
    var b = this;
    (!a || 18E5 < Ext.Date.getElapsed(a)) && Ext.Ajax.request({url:actionBeans.datastorespinup, params:{application:this.app.id}, success:function(a) {
      a = Ext.JSON.decode(a.responseText);
      a.success ? b.logger.debug("DataStore spinup result success: " + a.message) : b.logger.debug("DataStore spinup result error: " + a.error);
    }, failure:function(a) {
      b.logger.error("DataStore spinup Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
    }});
  }
}, mapContainerLoaded:!1, onMapContainerLoaded:function() {
  if (!this.configCompleted) {
    this.configCompleted = !0;
    try {
      var a = this.getLayout("top_menu"), b = a.height && 0 <= a.height ? a.height : 0;
      a.heightmeasure && (b += "px" == a.heightmeasure ? "" : a.heightmeasure);
      var c = this.getLayout("content_bottom"), d = c.height && 0 <= c.height ? c.height : 0;
      c.heightmeasure && (d += "px" == c.heightmeasure ? "" : c.heightmeasure);
      var e = this.app.maxExtent, f;
      f = void 0 != e ? Ext.create("viewer.viewercontroller.controller.Extent", e.minx, e.miny, e.maxx, e.maxy) : Ext.create("viewer.viewercontroller.controller.Extent", "12000,304000,280000,620000");
      var g, h = this.app.startExtent;
      g = h ? Ext.create("viewer.viewercontroller.controller.Extent", h.minx, h.miny, h.maxx, h.maxy) : Ext.create("viewer.viewercontroller.controller.Extent", "12000,304000,280000,620000");
      var k = this.mapComponent.createMap("map", {viewerController:this, options:{left:0, top:b, width:"100%", bottom:d, visible:"true", maxExtent:f, startExtent:g, extenthistory:"10"}});
      this.mapComponent.addMap(k);
      this.initializeConfiguredComponents();
      this.valuesFromURL(this.queryParams) || (this.initLayers(), this.fireEvent(viewer.viewercontroller.controller.Event.ON_LAYERS_INITIALIZED));
    } catch (l) {
      this.logger.error(l);
    }
  }
}, initializeConfiguredComponents:function() {
  for (var a = this.layoutManager.getComponentList(), b = 0;b < a.length;b++) {
    var c = a[b], d = this.app.components[c.componentName];
    d && (d.config.div = c.htmlId, d.config.containerId = c.containerId, d.config.isPopup = c.isPopup, d.config.hasSharedPopup = c.hasSharedPopup, d.config.showOnStartup = c.showOnStartup, d.config.regionName = c.regionName, this.createComponent(d.name, d.className, d.config, d.details));
  }
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_COMPONENTS_FINISHED_LOADING);
}, createComponent:function(a, b, c, d) {
  if (void 0 != this.components[a]) {
    throw "Component with name " + a + " (class " + b + ") already added, cannot add component of class " + b + " with the same name";
  }
  if ("viewer.mapcomponents.FlamingoMap" == b || "viewer.mapcomponents.OpenLayersMap" == b) {
    return null;
  }
  c.viewerController = this;
  c.name = a;
  c.details = d;
  try {
    var e = Ext.create(b, c);
    e.config.hasSharedPopup && (e.popup = this.layoutManager.popupWin);
    this.components[a] = {className:b, instance:e};
  } catch (f) {
    this.logger.error("Error creating component with className " + b + ": error " + f + " with config" + c), this.isDebug() && f instanceof Error && (console.log(f), void 0 != f.stack && console.log(f.stack));
  }
  return e;
}, addService:function(a) {
  void 0 == this.app.services[a.id] && (this.app.services[a.id] = a);
}, addOrReplaceService:function(a) {
  this.app.services[a.id] = a;
}, getService:function(a) {
  return this.app.services[a] ? this.app.services[a] : null;
}, addAppLayer:function(a) {
  void 0 == this.app.appLayers[a.id] && (this.app.appLayers[a.id] = a);
}, addOrReplaceAppLayer:function(a) {
  this.app.appLayers[a.id] = a;
}, counter:0, max:0, setSelectedContent:function(a) {
  this.counter = 0;
  this.max = this.mapComponent.getMap().layers.length;
  var b = this, c = function(d, e) {
    this.counter++;
    this.counter >= this.max && setTimeout(function() {
      b.app.selectedContent = a;
      b.uncheckUnselectedContent();
      b.initLayers();
      b.mapComponent.getMap().removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED, c, b);
      b.fireEvent(viewer.viewercontroller.controller.Event.ON_SELECTEDCONTENT_CHANGE);
    }, 1);
  };
  0 == this.max && c.call(this);
  this.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED, c, this);
  this.clearLayers();
}, onSelectedContentChanged:function() {
  var a = this.app.appLayers, b;
  for (b in a) {
    if (a.hasOwnProperty(b)) {
      var c = a[b];
      if (c.filter) {
        var d = this.getLayer(c);
        d && (d.setQuery(c.filter), this.fireEvent(viewer.viewercontroller.controller.Event.ON_FILTER_ACTIVATED, c.filter, c));
      }
    }
  }
}, uncheckUnselectedContent:function() {
  for (var a = [], b = 0;b < this.app.selectedContent.length;b++) {
    var c = this.app.selectedContent[b];
    "appLayer" == c.type ? a.push(c.id) : a = a.concat(this.getLevelAppLayerIds(this.app.levels[c.id]));
  }
  for (b in this.app.appLayers) {
    this.app.appLayers.hasOwnProperty(b) && (c = this.app.appLayers[b], c.checked && -1 == Ext.Array.indexOf(a, c.id + "") && (c.checked = !1));
  }
}, traverseSelectedContent:function(a, b) {
  for (var c = this.app, d = function(e) {
    if (e && !e.removed) {
      a(e);
      if (e.children) {
        for (var f = 0;f < e.children.length;f++) {
          d(c.levels[e.children[f]]);
        }
      }
      if (e.layers) {
        for (f = 0;f < e.layers.length;f++) {
          var k = c.appLayers[e.layers[f]];
          k.removed || b(k);
        }
      }
    }
  }, e = 0;e < c.selectedContent.length;e++) {
    var f = c.selectedContent[e];
    "level" == f.type ? d(c.levels[f.id]) : "appLayer" == f.type && b(c.appLayers[f.id]);
  }
}, doesLevelExist:function(a) {
  var b = this;
  b.found = !1;
  this.traverseSelectedContent(function(c) {
    b.found = c.id == a.id || b.found;
  }, Ext.emptyFn);
  return b.found;
}, getLevelAppLayerIds:function(a) {
  var b = [];
  if (a) {
    if (a.layers) {
      for (var c = 0;c < a.layers.length;c++) {
        b.push(a.layers[c]);
      }
    }
    if (a.children) {
      for (c = 0;c < a.children.length;c++) {
        var d = this.getLevelAppLayerIds(this.app.levels[a.children[c]]), b = b.concat(d)
      }
    }
  }
  return b;
}, getAppLayerParent:function(a) {
  a = "" + a;
  for (var b in this.app.levels) {
    if (this.app.levels.hasOwnProperty(b)) {
      var c = this.app.levels[b];
      if (c.layers && Ext.Array.contains(c.layers, a)) {
        return c;
      }
    }
  }
  return null;
}, getLevelParent:function(a) {
  a = "" + a;
  for (var b in this.app.levels) {
    if (this.app.levels.hasOwnProperty(b)) {
      var c = this.app.levels[b];
      if (c.children && Ext.Array.contains(c.children, a)) {
        return c;
      }
    }
  }
  return null;
}, getDocumentsInLevel:function(a) {
  var b = {};
  if (a.documents) {
    for (var c = 0;c < a.documents.length;c++) {
      var d = a.documents[c];
      b[d.id] = d;
    }
  }
  a = this.getLevelParent(a.id);
  null != a && (a = this.getDocumentsInLevel(a), Ext.apply(b, a));
  return b;
}, clearLayers:function() {
  this.layers = {};
  this.mapComponent.getMap().removeAllLayers();
}, initLayers:function(a) {
  this.layersInitialized = !1;
  if (void 0 == a) {
    this.initLayers(!0), this.initLayers(!1);
  } else {
    for (var b = this.app.selectedContent.length - 1;0 <= b;b--) {
      var c = this.app.selectedContent[b];
      "appLayer" == c.type ? this.initAppLayer(c.id, a) : this.initLevel(c.id, a);
    }
  }
  this.layersInitialized = !0;
}, initAppLayer:function(a, b) {
  var c = this.app.appLayers[a];
  if (void 0 !== c && c.background == b) {
    var d = this.getOrCreateLayer(c);
    d && this.mapComponent.getMap().setLayerVisible(d, this.getLayerChecked(c));
  }
}, getStorageKey:function() {
  return ["checkedlayers", this.getApplicationName(), "v", this.getApplicationVersion()].join("_");
}, getLayerChecked:function(a) {
  var b = "" + a.id;
  return this.savedCheckedState.hasOwnProperty(b) ? this.savedCheckedState[b] : a.checked;
}, saveCheckedState:function(a, b) {
  this.savedCheckedState["" + a.id] = b;
  this._persistTimer && window.clearTimeout(this._persistTimer);
  this._persistTimer = window.setTimeout(function() {
    viewer.components.LocalStorage.setItem(this.getStorageKey(), this.savedCheckedState);
  }.bind(this), 150);
}, restoreSavedCheckedState:function() {
  var a = viewer.components.LocalStorage.getItem(this.getStorageKey()), b = {};
  if (null === a) {
    return b;
  }
  var c = Ext.Object.getKeys(this.app.appLayers), d;
  for (d in a) {
    a.hasOwnProperty(d) && -1 !== Ext.Array.indexOf(c, d) && (b[d] = a[d]);
  }
  return b;
}, removeSavedCheckedState:function() {
  this.savedCheckedState = {};
  viewer.components.LocalStorage.removeItem(this.getStorageKey());
}, initLevel:function(a, b) {
  var c = this.app.levels[a];
  if (c && c.background == b) {
    if (c.layers) {
      for (var d = c.layers.length - 1;0 <= d;d--) {
        this.initAppLayer(c.layers[d], b);
      }
    }
    if (c.children) {
      for (d = c.children.length - 1;0 <= d;d--) {
        this.initLevel(c.children[d], b);
      }
    }
  }
}, setLayerVisible:function(a, b) {
  var c = this.getLayer(a);
  c && (c.visible = b, this.mapComponent.getMap().setLayerVisible(c, b));
}, getLayer:function(a, b) {
  b && this.isDebug() && this.logger.warning("getLayer() old method call is used!");
  return void 0 == this.layers[a.id] ? (this.layersInitialized ? this.logger.warning("The layer #" + a.id + " can't be found!") : this.logger.warning("Layers not initialized! getLayer() caller should wait for the layers to be added!"), null) : this.layers[a.id];
}, getOrCreateLayer:function(a) {
  var b = a.id;
  void 0 == this.layers[b] && this.createLayer(a);
  return this.layers[b];
}, getAppLayerById:function(a) {
  return this.app.appLayers[a];
}, getAppLayer:function(a, b) {
  this.logger.warning("viewerController.getAppLayer() with serviceId and LayerName is not unique");
  var c = 0, d = null, e;
  for (e in this.app.appLayers) {
    if (this.app.appLayers.hasOwnProperty(e)) {
      var f = this.app.appLayers[e];
      f.layerName == b && f.serviceId == a && (c++, null == d && (d = f));
    }
  }
  1 < c && this.logger.warning("viewerController.getAppLayer() with serviceId and LayerName found " + c + " application layers with serviceId: '" + a + "' and layerName: '" + b + "' returning the first");
  return d;
}, getAppLayerFeatureService:function(a) {
  if (void 0 == a.featureService) {
    if (a.added) {
      var b = this.app.services[a.serviceId];
      a.featureService = Ext.create("viewer.DirectFeatureService", {appLayer:a, protocol:b.protocol, url:b.url});
    } else {
      a.featureService = Ext.create("viewer.AppLayerService", {appId:this.app.id, appLayer:a, debug:this.isDebug()});
    }
  }
  return a.featureService;
}, createLayer:function(a) {
  var b = a.id, c = this.app.services[a.serviceId], d = c.layers[a.layerName];
  if (void 0 === d) {
    return null;
  }
  var e = {id:b, ratio:1, visible:a.checked, serviceId:c.id};
  a.details && void 0 != a.details.transparency && (e.alpha = 100 - a.details.transparency);
  e.attribution = d.details && d.details.attribution ? d.details.attribution : null;
  var f = null;
  try {
    if ("wms" == c.protocol) {
      var g = c.url, h = {exceptions:c.exception_type ? c.exception_type : "application/vnd.ogc.se_inimage", srs:"EPSG:28992", version:"1.1.1", layers:d.name, styles:"", format:"image/png", transparent:!0, noCache:!0}, k = this.calculateScaleCorrection(c, d.minScale, d.maxScale);
      Ext.isDefined(d.minScale) && (h.minResulution = d.minScale / k);
      Ext.isDefined(d.maxScale) && (h.maxResolution = d.maxScale / k);
      d.queryable && (h.query_layers = d.name);
      void 0 == d.name && d.details && d.details.all_children && (e.layers = d.details.all_children);
      var l = {}, m = "registry_default";
      void 0 != a.details && void 0 != a.details.style && (m = a.details.style);
      l.style = m;
      var n = null;
      if ("registry_default" == m) {
        void 0 != c.defaultStyleLibrary && (n = c.defaultStyleLibrary);
      } else {
        if (/^sld:/.test(m)) {
          if (n = (void 0 != c.styleLibraries ? c.styleLibraries : {})[m], -1 != c.url.toLowerCase().indexOf("/arcgis/") && n.userStylesPerNamedLayer && n.userStylesPerNamedLayer[d.name] && 0 < n.userStylesPerNamedLayer[d.name].styles.length && (h.styles = n.userStylesPerNamedLayer[d.name].styles[0].name, l.sldLegendStyle = h.styles), n.extraLegendParameters) {
            try {
              l.extraLegendParameters = Ext.Object.fromQueryString(n.extraLegendParameters);
            } catch (p) {
              this.logger.error("Invalid extra legend parameters for SLD '" + n.title + "': " + n.extraLegendParameters + "; error: " + p);
            }
          }
        } else {
          /^wms:/.test(m) && (h.styles = m.substring(4), l.wmsStyle = h.styles);
        }
      }
      if (null != n) {
        l.sld = n;
        var q;
        q = n.hasBody ? Ext.create(viewer.SLD).createURL(null, null, null, null, n.id) : n.externalUrl;
        h.sld = q;
        l.originalSldUrl = q;
      }
      f = this.mapComponent.createWMSLayer(d.name, g, h, e, this);
      Ext.apply(f.config, l);
    } else {
      if ("arcims" == c.protocol || "arcgis" == c.protocol) {
        e.layers = d.name, d.details && d.details.all_children && (e.layers = d.details.all_children), "arcims" == c.protocol ? (e.type = "ArcIMS", e.mapservice = c.serviceName, f = this.mapComponent.createArcIMSLayer(a.layerName, c.url, e, this)) : (e.type = "ArcGIS", f = this.mapComponent.createArcServerLayer(a.layerName, c.url, e, this));
      } else {
        if ("tiled" == c.protocol) {
          if (d.resolutions) {
            for (var r = d.resolutions.split(","), l = 0;r.length > l;l++) {
              r[l] = Number(r[l]);
            }
            e.resolutions = r;
          }
          d.bbox && (e.serviceEnvelope = d.bbox.minx + "," + d.bbox.miny + "," + d.bbox.maxx + "," + d.bbox.maxy);
          e.tileHeight = d.tileHeight;
          e.tileWidth = d.tileWidth;
          e.protocol = c.tilingProtocol;
          e.title = d.title;
          e.viewerController = this;
          d.details && d.details.image_extension && (e.extension = d.details.image_extension);
          if (d.details && d.details["wms.styles"]) {
            n = Ext.JSON.decode(d.details["wms.styles"]);
            e.style = "";
            g = !1;
            for (l = 0;l < n.length;l++) {
              m = n[l], m.isDefault && (e.style = m.identifier, g = !0);
            }
            !g && 0 < n.length && (e.style = n[0].identifier);
          }
          if (d.matrixSets) {
            for (var t = d.matrixSets[0], l = 0;l < d.matrixSets.length;l++) {
              if (-1 !== d.matrixSets[l].crs.indexOf("28992")) {
                t = d.matrixSets[l];
                break;
              }
            }
            e.matrixSet = t;
          }
          f = this.mapComponent.createTilingLayer(a.layerName, c.url, e);
        }
      }
    }
  } catch (p) {
    return a = Ext.String.format("Error creating layer object for appLayer #{0} ({1} {2} layer {3}: {4}", b, c.protocol, c.url, a.layerName, p), this.logger.error(a), this.isDebug() && p instanceof Error && (console.log(p), void 0 != p.stack && console.log(p.stack)), null;
  }
  f.serviceId = a.serviceId;
  f.appLayerId = a.id;
  this.layers[b] = f;
  this.mapComponent.getMap().addLayer(f);
  return f;
}, getAppLayerGeometryAttributes:function(a) {
  return a.attributes.filter(function(a) {
    if ("polygon" === a.type || "multipolygon" === a.type || "point" === a.type || "multipoint" === a.type || "multilinestring" === a.type || "linestring" === a.type || "geometry" === a.type) {
      return a.alias || a.name;
    }
  });
}, getLayerByLayerId:function(a) {
  this.logger.warning("viewerController.getLayerByLayerId() is not returning a unique layer!");
  for (var b in this.app.services) {
    if (this.app.services.hasOwnProperty(b)) {
      var c = this.app.services[b], d;
      for (d in c.layers) {
        if (c.layers.hasOwnProperty(d)) {
          var e = c.layers[d];
          if (a == e.id) {
            return this.getLayer(c.id, e.name);
          }
        }
      }
    }
  }
  return null;
}, getServiceLayerById:function(a) {
  for (var b in this.app.services) {
    if (this.app.services.hasOwnProperty(b)) {
      var c = this.app.services[b], d;
      for (d in c.layers) {
        if (c.layers.hasOwnProperty(d)) {
          var e = c.layers[d];
          if (a == e.id) {
            return e;
          }
        }
      }
    }
  }
  return null;
}, getServiceLayer:function(a) {
  return this.app.services[a.serviceId].layers[a.layerName];
}, getVisibleLayers:function(a) {
  var b = this.layers, c = [], d;
  for (d in b) {
    b.hasOwnProperty(d) && b[d].getVisible() && c.push(a ? "" + d : d);
  }
  return c;
}, getVisibleAppLayers:function(a) {
  a = this.getVisibleLayers(a);
  for (var b = {}, c = 0;c < a.length;c++) {
    var d = this.getAppLayerById(a[c]);
    null != d && (b[d.id] = !0);
  }
  return b;
}, isSummaryLayer:function(a) {
  a = a.getDetails();
  return this.isSummaryDetails(a);
}, isSummaryDetails:function(a) {
  return !a || Ext.isEmpty(a["summary.description"]) && Ext.isEmpty(a["summary.image"]) && Ext.isEmpty(a["summary.link"]) && Ext.isEmpty(a["summary.title"]) ? !1 : !0;
}, setLayersVisible:function(a, b) {
  for (var c = 0;c < a.length;c++) {
    this.setLayerVisible(a[c], b);
  }
}, compareToScale:function(a, b, c) {
  void 0 === c && (c = !0);
  var d = this.getServiceLayer(a), e = d.minScale, f = d.maxScale;
  this.isMinMaxSwitched(e, f) && (e = d.maxScale, f = d.minScale);
  if (!e && !f) {
    return 0;
  }
  if (void 0 == b || null == b) {
    b = this.mapComponent.getMap().getScale();
  }
  a = this.app.services[a.serviceId];
  c && (c = this.calculateScaleCorrection(a, e, f), b *= c);
  return e && b < e ? 1 : f && b > f ? -1 : 0;
}, isMinMaxSwitched:function(a, b) {
  return void 0 !== a && void 0 !== b && a > b ? !0 : !1;
}, isWithinScale:function(a, b) {
  return 0 == this.compareToScale(a, b);
}, zoomToLayer:function(a) {
  var b = this.compareToScale(a), c = this.getServiceLayer(a), d;
  d = 1 / this.calculateScaleCorrection(this.app.services[a.serviceId], c.minScale, c.maxScale);
  a = this.mapComponent.getMap().getResolutions();
  if (-1 === b) {
    var e = c.maxScale * d;
    this.isMinMaxSwitched(c.minScale, c.maxScale) && (e = c.minScale * d);
    if (null !== a) {
      for (b = 0;b < a.length;b++) {
        if (e > a[b]) {
          e = a[b];
          break;
        }
      }
    }
    this.mapComponent.getMap().zoomToResolution(e);
  } else {
    if (1 == b) {
      e = c.minScale * d;
      if (null != a) {
        for (b = 0;b < a.length;b++) {
          if (e > a[b]) {
            e = 0 == b ? a[b] : a[b - 1];
            break;
          }
        }
      }
      this.mapComponent.getMap().zoomToResolution(e);
    }
  }
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_ZOOM_END, e);
}, calculateScaleCorrection:function(a, b, c) {
  var d = 1;
  if (a && "arcgis" === a.protocol) {
    return 96 / .0254;
  }
  if (750 < b || (void 0 === b || 0 === b) && 5E3 < c) {
    d = 1 / 2.8E-4;
  }
  return d = 0 < a.url.toLowerCase().indexOf("geoserver") ? 90.7 * d / 72 : 0 < a.url.toLowerCase().indexOf("mapserver/wmsserver") ? 96 * d / 72 : 96 * d / 90.7;
}, getLayerLegendImage:function(a) {
  var b = this.app.services[a.serviceId].layers[a.layerName];
  return void 0 != b.legendImageUrl ? b.legendImageUrl : this.getLayer(a).getLegendGraphic();
}, getLayerLegendInfo:function(a, b, c) {
  try {
    if (void 0 != a.details && void 0 != a.details.legendImageUrl) {
      b(a, {parts:[{url:a.details.legendImageUrl}]});
    } else {
      var d = this.getLayer(a);
      if (d) {
        var e = this.getServiceLayer(a);
        if (d.config.wmsStyle) {
          var f = d.config.wmsStyle;
          if (void 0 != e.details && e.details["wms.styles"]) {
            var g = Ext.JSON.decode(e.details["wms.styles"]), h = null;
            Ext.Array.each(g, function(a) {
              a.name == f && a.legendURLs && 0 < a.legendURLs.length && (h = {parts:[]}, Ext.Array.each(a.legendURLs, function(a) {
                h.parts.push({url:a});
              }));
            });
            if (null != h) {
              b(a, h);
              return;
            }
          }
        }
        d.config.sld && d.getLegendGraphic ? b(a, {parts:[{url:d.getLegendGraphic()}]}) : void 0 != e.details && e.details.alternateLegendImageUrl ? b(a, {parts:[{url:e.details.alternateLegendImageUrl}]}) : e.legendImageUrl ? b(a, {parts:[{url:e.legendImageUrl, label:a.alias}], name:a.alias}) : d.getLayerLegendInfo ? d.getLayerLegendInfo(function(c) {
          b(a, c);
        }, function() {
          c(a);
        }) : (this.logger.error("Layer class " + d.$className + " does not support getLayerLegendInfo"), c(a));
      } else {
        c(a);
      }
    }
  } catch (k) {
    this.logger.error("Error creating legend info for appLayerId " + a.id + ": " + k), c(a);
  }
}, getLayerMetadata:function(a, b) {
  return this.app.services[a].layers[b].details["metadata.stylesheet"];
}, setFilter:function(a, b) {
  b && (b.filter || (b.filter = Ext.create("viewer.components.CQLFilterWrapper", {id:"", cql:"", operator:""})), b.filter.addOrReplace(a), this.applyFilter(b));
}, applyFilter:function(a) {
  var b = this.getLayer(a);
  b && (a.relations && 0 < a.relations.length && a.filter && a.filter.getCQL() ? (this.filterDebounce[a.id] && window.clearTimeout(this.filterDebounce[a.id]), this.filterDebounce[a.id] = window.setTimeout(function() {
    this._doApplyFilter(a, b);
  }.bind(this), 250)) : this._doApplyFilter(a, b));
}, _doApplyFilter:function(a, b) {
  var c = this;
  a.filter || (a.filter = Ext.create("viewer.components.CQLFilterWrapper", {id:"", cql:"", operator:""}));
  if (a.filter.getCQL() && "" !== a.filter.getCQL()) {
    var d = Ext.urlAppend(actionBeans.sld, "transformFilter\x3dt");
    Ext.create("viewer.SLD", {actionbeanUrl:d}).transformFilter(a.filter.getCQL(), a.id, function(d, f, g) {
      d = Ext.create("viewer.components.CQLFilterWrapper", {id:"", cql:d, operator:""});
      b.setQuery(d, f, g);
      c.fireEvent(viewer.viewercontroller.controller.Event.ON_FILTER_ACTIVATED, null, a);
    }, function(a) {
      c.logger.error("Error while transforming SLD for joined/related featuretypes: " + a);
    });
  } else {
    b.setQuery(a.filter), this.fireEvent(viewer.viewercontroller.controller.Event.ON_FILTER_ACTIVATED, a.filter, a);
  }
}, removeFilter:function(a, b) {
  b.filter && (b.filter = b.filter.removeFilterById(a), 0 == b.filter.filters.length && (b.filter = null), this.applyFilter(b));
}, layerClicked:function(a) {
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_LAYER_CLICKED, a);
}, showHelp:function(a) {
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_HELP, a);
}, getComponents:function() {
  var a = [], b;
  for (b in this.components) {
    this.components.hasOwnProperty(b) && a.push(this.components[b].instance);
  }
  return a;
}, getComponentsByClassName:function(a) {
  var b = [], c;
  for (c in this.components) {
    if (this.components.hasOwnProperty(c)) {
      var d = this.components[c];
      d.className == a && b.push(d.instance);
    }
  }
  return b;
}, getComponentsByClassNames:function(a) {
  var b = [], c;
  for (c in this.components) {
    if (this.components.hasOwnProperty(c)) {
      var d = this.components[c];
      -1 !== Ext.Array.indexOf(a, d.className) && b.push(d.instance);
    }
  }
  return b;
}, getComponentByName:function(a) {
  a = this.components[a];
  return void 0 != a ? a.instance : null;
}, deactivateControls:function(a) {
  for (var b = this.getComponents(), c = 0;c < b.length;c++) {
    for (var d = 0;d < a.length;d++) {
      if (b[c].self.getName() === a[d] || b[c].superclass.self.getName() === a[d]) {
        "function" === typeof b[c].cancel ? b[c].cancel() : Ext.Error.raise({msg:"cancel() Not implemented for component: " + b[c].self.getName()});
      }
    }
  }
}, getAttributesFromAppLayer:function(a, b, c) {
  if (void 0 != a.attributes) {
    if (void 0 == b || null == b) {
      b = this.getServiceLayer(a).featureTypeId;
    }
    if (void 0 == c || null == c) {
      c = !0;
    }
    var d = [];
    d.push(b);
    c && a.relations && (d = d.concat(this.getJoinedFeatureTypes(a.relations, b)));
    b = [];
    for (c = 0;c < a.attributes.length;c++) {
      var e = a.attributes[c];
      void 0 != e.featureType && -1 == d.indexOf(e.featureType) || b.push(e);
    }
    return b;
  }
}, getJoinedFeatureTypes:function(a, b) {
  for (var c = [], d = 0;d < a.length;d++) {
    var e = a[d], f = [];
    e.featureType == b && "join" == e.type ? (f.push(e.foreignFeatureType), e.relations && (f = f.concat(this.getJoinedFeatureTypes(e.relations, e.foreignFeatureType)))) : e.relations && (f = f.concat(this.getJoinedFeatureTypes(e.relations, b)));
    for (e = 0;e < f.length;e++) {
      if (0 <= c.indexOf(f[e])) {
        return c;
      }
      c.push(f[e]);
    }
  }
  return c;
}, valuesFromURL:function(a) {
  var b = !1, c = !1, d = this.app.appLayers, e = this.app.selectedContent, f;
  for (f in a) {
    if (a.hasOwnProperty(f)) {
      var g = a[f];
      if ("bookmark" === f) {
        var h = this;
        Ext.create("viewer.Bookmark").getBookmarkParams(g, function(a) {
          h.succesReadUrl(a);
        }, function(a) {
          h.failureReadUrl(a);
        });
        c = b = !0;
      } else {
        if ("layers" === f) {
          Ext.isArray(g) || (g = g.split(",")), d = this.loadBookmarkLayers(g), b = !0;
        } else {
          if ("selectedContent" === f) {
            e = g;
          } else {
            if ("extent" === f) {
              var k = g, l = {};
              Ext.isObject(g) ? l = k : (k = g.split(","), l.minx = k[0], l.miny = k[1], l.maxx = k[2], l.maxy = k[3]);
              h = this;
              h.newExtent = l;
              var m = function() {
                h.mapComponent.getMap().zoomToExtent(h.newExtent);
                h.mapComponent.getMap().removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, m, m);
              };
              this.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, m, m);
            } else {
              if ("levelOrder" === f) {
                for (e = [], Ext.isArray(g) || (g = g.split(",")), k = 0;k < g.length;k++) {
                  "L" === g[k][0] ? (l = g[k].slice(1, g[k].length), e.push({type:"level", id:l})) : "A" === g[k][0] ? (l = g[k].slice(1, g[k].length), e.push({type:"appLayer", id:l})) : e.push({type:"level", id:g[k]});
                }
              } else {
                "levels" === f ? this.app.levels = g : "forceLoadLayers" === f ? b = !0 : (k = this.getComponentByName(f)) && !Ext.isEmpty(g) && k.loadVariables(g);
              }
            }
          }
        }
      }
    }
  }
  b && !c && (this.app.appLayers = d, this.setSelectedContent(e), this.addListener(viewer.viewercontroller.controller.Event.ON_SELECTEDCONTENT_CHANGE, function() {
    this.fireEvent(viewer.viewercontroller.controller.Event.ON_LAYERS_INITIALIZED);
  }, this, {single:!0}));
  return b;
}, loadBookmarkLayers:function(a) {
  var b = this.app.appLayers, c;
  for (c in b) {
    if (b.hasOwnProperty(c)) {
      for (var d = b[c], e = !1, f = 0;f < a.length;f++) {
        if (d.id == a[f]) {
          e = !0;
          break;
        }
      }
      e ? (d.checked = !0, d.removed = !1) : d.checked = !1;
    }
  }
  return b;
}, succesReadUrl:function(a) {
  a = Ext.JSON.decode(a);
  for (var b = {}, c = 0;c < a.params.length;c++) {
    var d = a.params[c];
    b[d.name] = d.value;
  }
  this.valuesFromURL(b);
}, failureReadUrl:function(a) {
}, getBookmarkUrl:function() {
  var a = {params:[]}, b = window.location.origin + actionBeans.app, b = b + ("/" + this.app.name);
  "undefined" !== typeof this.app.version && (b += "/v" + this.app.version);
  a.params.push({name:"url", value:b + "?"});
  var b = Ext.urlDecode(window.location.search), c;
  for (c in b) {
    "layers" != c && "extent" != c && "bookmark" != c && "levelOrder" != c && a.params.push({name:c, value:b[c]});
  }
  b = this.getVisibleLayers();
  for (c = b.length - 1;0 <= c;c--) {
    "added" == this.getAppLayerById(b[c]).status && b.splice(c, 1);
  }
  0 != b.length && a.params.push({name:"layers", value:b});
  c = this.mapComponent.getMap().getExtent();
  a.params.push({name:"extent", value:c});
  b = [];
  for (c = 0;c < this.app.selectedContent.length;c++) {
    var d = this.app.selectedContent[c], e = this.app.selectedContent[c].id;
    "level" === d.type ? e = "L" + e : "appLayer" === d.type && (e = "A" + e);
    b.push(e);
  }
  a.params.push({name:"levelOrder", value:b});
  a.params.push({name:"selectedContent", value:this.app.selectedContent});
  a.params.push({name:"levels", value:this.app.levels});
  return a;
}, getApplicationSprite:function() {
  return Ext.isDefined(this.app.details) && Ext.isDefined(this.app.details.iconSprite) ? this.hasSvgSprite() ? this.checkSvgSupport(this.app.details.iconSprite) : this.app.details.iconSprite : null;
}, hasSvgSprite:function() {
  var a = this.app.details.iconSprite || "";
  return ".svg" === a.substring(a.length - 4, a.length);
}, checkSvgSupport:function(a) {
  if (null !== this.spriteUrl) {
    return this.spriteUrl;
  }
  if (!(/\bEdge\/12\b|\bTrident\/[567]\b|\bVersion\/7.0 Safari\b/.test(navigator.userAgent) || 537 > (navigator.userAgent.match(/AppleWebKit\/(\d+)/) || [])[1])) {
    return this.spriteUrl = a;
  }
  Ext.Ajax.request({url:a, success:function(a) {
    a = a.responseText;
    var c = document.querySelector("body"), d = document.createElement("div");
    d.style.display = "none";
    d.innerHTML = a;
    c.insertBefore(d, c.firstChild);
  }});
  return this.spriteUrl = "";
}, getLayoutHeight:function(a) {
  var b = -1;
  (a = this.getLayout(a)) && a.height && (b = a.height);
  return b;
}, getLayout:function(a) {
  return (a = this.app.layout[a]) && a.layout ? a.layout : null;
}, getMapId:function() {
  return this.layoutManager.getMapId();
}, getWrapperId:function() {
  return this.layoutManager.getWrapperId();
}, anchorTo:function(a, b, c, d) {
  this.anchors.push({element:a, container:b, position:c, offsets:d});
}, doAlignAnchors:function() {
  for (var a = 0;a < this.anchors.length;a++) {
    this.anchors[a].element.alignTo(this.anchors[a].container, this.anchors[a].position, this.anchors[a].offsets);
  }
}, getApplicationName:function() {
  return this.app.name;
}, getApplicationVersion:function() {
  return this.app.version;
}, registerPopupShow:function(a) {
  this.singlePopup && this.previousPopup && this.previousPopup !== a && this.previousPopup.hide();
  this.previousPopup = a;
}, registerSnappingLayer:function(a) {
  Ext.Array.contains(this.registeredSnappingLayers, a) || this.registeredSnappingLayers.push(a);
}, getTopMenuHeightInPixels:function() {
  var a = this.getLayout("top_menu"), b = Number(a.height && 0 <= a.height ? a.height : 0);
  a.heightmeasure && "%" == a.heightmeasure && (a = Ext.get(this.layoutManager.mapId).getHeight(), b = Math.round(a / 100 * b));
  return b;
}, resizeComponents:function(a) {
  var b = this;
  null !== this.resizeDebounce && window.clearTimeout(this.resizeDebounce);
  this.resizeDebounce = window.setTimeout(function() {
    if (a) {
      b.layoutManager.resizeLayout(function() {
        b.doAlignAnchors();
        return b.resizeComponentsImpl();
      });
    } else {
      return b.doAlignAnchors(), b.resizeComponentsImpl();
    }
  }, 50);
}, resizeComponentsImpl:function() {
  this.mapComponent.doResize && this.mapComponent.doResize();
  this.mapComponent.getMap().updateSize();
  for (var a in this.components) {
    this.components.hasOwnProperty(a) && this.components[a].instance.resizeScreenComponent();
  }
  return !0;
}, isEmptyObject:function(a) {
  for (var b in a) {
    if (a.hasOwnProperty(b)) {
      return !1;
    }
  }
  return !0;
}, destroyComponents:function() {
  for (var a in this.components) {
    this.components.hasOwnProperty(a) && this.components[a].instance.destroy();
  }
  delete this.components;
}});
Ext.define("viewer.viewercontroller.MapComponent", {extend:"Ext.util.Observable", eventList:null, maps:null, tools:null, events:null, components:null, panel:null, viewerController:null, config:{resolutions:null, id:null}, constructor:function(a, b, c) {
  viewer.viewercontroller.MapComponent.superclass.constructor.call(this, c);
  this.eventList = {};
  this.maps = [];
  this.tools = [];
  this.events = [];
  this.components = [];
  this.initConfig(c);
  this.initEvents();
  this.viewerController = a;
  return this;
}, createMap:function(a, b) {
  Ext.Error.raise({msg:"MapComponent.createMap(...) not implemented! Must be implemented in sub-class"});
}, createWMSLayer:function(a, b, c, d) {
  Ext.Error.raise({msg:"MapComponent.createWMSLayer() Not implemented! Must be implemented in sub-class"});
}, createTilingLayer:function(a, b, c, d) {
  Ext.Error.raise({msg:"MapComponent.createTMSLayer() Not implemented! Must be implemented in sub-class"});
}, createArcIMSLayer:function() {
  Ext.Error.raise({msg:"MapComponent.createArcIMSLayer needs te be implemented in the sub-class"});
}, createArcServerLayer:function(a, b, c, d) {
  Ext.Error.raise({msg:"MapComponent.createArcServerLayer needs te be implemented in the sub-class"});
}, createImageLayer:function(a, b, c, d, e) {
  Ext.Error.raise({msg:"MapComponent.createImageLayer() Not implemented! Must be implemented in sub-class"});
}, createVectorLayer:function(a) {
  Ext.Error.raise({msg:"MapComponent.createVectorLayer() Not implemented! Must be implemented in sub-class"});
}, createTool:function(a) {
  Ext.Error.raise({msg:"MapComponent.createTool(...) not implemented! Must be implemented in sub-class"});
}, createComponent:function() {
  Ext.Error.raise({msg:"MapComponent.createComponent() not implemented! Must be implemented in the sub-class"});
}, addTools:function(a) {
  for (var b = 0;b < a.length;b++) {
    addTool(a[b]);
  }
}, addTool:function(a) {
  a instanceof viewer.viewercontroller.controller.Tool || (Ext.Error.raise({msg:"Given tool not of type 'Tool'", options:{tool:a}}), Ext.err());
  a.mapComponent = this;
  this.tools.push(a);
}, removeTool:function(a) {
  a instanceof viewer.viewercontroller.controller.Tool || Ext.Error.raise({msg:"Given tool not of type 'Tool'"});
  for (var b = 0;b < this.tools;b++) {
    if (this.tools[b] == a) {
      this.tools.splice(b, 1);
      break;
    }
  }
}, getTool:function(a) {
  for (var b = 0;b < this.tools.length;b++) {
    var c = this.tools[b];
    if (c.getId() == a) {
      return c;
    }
  }
  return null;
}, getTools:function() {
  return this.tools;
}, getToolsByType:function(a) {
  for (var b = [], c = 0;c < this.tools.length;c++) {
    this.tools[c].getType() == a && b.push(this.tools[c]);
  }
  return b;
}, removeToolById:function(a) {
  Ext.Error.raise({msg:"MapComponent.removeToolById() Not implemented! Must be implemented in sub-class"});
}, addComponent:function(a) {
  a instanceof viewer.viewercontroller.controller.Component || (Ext.Error.raise({msg:"Given tool not of type 'Component'", options:{tool:a}}), Ext.err());
  this.components.push(a);
}, addMap:function(a) {
  Ext.Error.raise({msg:"MapComponent.addMap() Not implemented! Must be implemented in sub-class"});
}, getMap:function(a) {
  Ext.Error.raise({msg:"MapComponent.getMap() Not implemented! Must be implemented in sub-class"});
}, removeMap:function(a) {
  Ext.Error.raise({msg:"MapComponent.removeMap() Not implemented! Must be implemented in sub-class"});
}, handleEvents:function(a) {
  Ext.Error.raise({msg:"MapComponent.handleEvents() Not implemented! Must be implemented in sub-class"});
}, initEvents:function() {
  Ext.Error.raise({msg:"MapComponent.initEvent() Not implemented! Must be implemented in sub-class"});
}, getGenericEventName:function(a) {
  if (void 0 == a || null == a) {
    return null;
  }
  0 == this.eventList.length && this.initEvents();
  for (var b in this.eventList) {
    if (this.eventList.hasOwnProperty(b) && this.eventList[b] == a) {
      return b;
    }
  }
  return null;
}, getSpecificEventName:function(a) {
  return this.eventList[a];
}, activateTool:function(a, b) {
  Ext.Error.raise({msg:"MapComponent.activateTool() Not implemented! Must be implemented in sub-class"});
}, deactivateTools:function() {
  for (var a = [], b = 0;b < this.tools.length;b++) {
    this.tools[b].isActive() && a.push(this.tools[b]), this.tools[b].deactivate();
  }
  return a;
}, getWidth:function() {
  Ext.Error.raise({msg:"MapComponent.getWidth() Not implemented! Must be implemented in sub-class"});
}, getHeight:function() {
  Ext.Error.raise({msg:"MapComponent.getHeight() Not implemented! Must be implemented in sub-class"});
}, setCursor:function(a, b) {
  Ext.Error.raise({msg:"MapComponent.setCursor() Not implemented! Must be implemented in sub-class"});
}});
Ext.define("viewer.components.Component", {extend:"Ext.util.Observable", events:null, popup:null, config:{name:"naam", div:{}, viewerController:null, isPopup:!1, hasSharedPopup:!1, regionName:"", containerId:""}, defaultButtonWidth:46, defaultButtonHeight:46, forceState:!1, haveSprite:!1, constructor:function(a) {
  var b = this;
  viewer.components.Component.superclass.constructor.call(this, a);
  b.initConfig(a);
  b.createIconStylesheet();
  var c = "header leftmargin_top leftmargin_bottom rightmargin_top rightmargin_bottom footer".split(" ");
  b.config.hasOwnProperty("isPopup") || (b.config.isPopup = !0);
  a.hasOwnProperty("regionName") && -1 !== Ext.Array.indexOf(c, a.regionName) && (b.config.isPopup = !1);
  b.config.isPopup && (this.viewerController.hasSvgSprite() && !this.config.iconUrl ? a.popupIcon = this.getSvgIcon() : a.iconCls = this.getPopupIcon(), b.popup = Ext.create("viewer.components.ScreenPopup", a), b.popup.setComponent(b), b.popup.popupWin.addListener("resize", function() {
    b.doResize();
  }));
  b.config.name && b.title && b.config.viewerController.layoutManager.setTabTitle(b.config.name, b.title);
  b.events = [];
  b.addContainerClass();
  return b;
}, addContainerClass:function() {
  var a = [(this.$className || "").toLowerCase().replace(/\./ig, "").replace(/viewercomponents/ig, ""), "-component-container"].join(""), b = this.getContentContainer();
  b && b.addCls(a);
}, getContentDiv:function() {
  return this.config.isPopup ? this.popup.getContentId() : this.config.div;
}, getContentContainer:function() {
  return this.config.isPopup ? this.popup.getContentContainer() : Ext.getCmp(this.config.containerId);
}, renderButton:function(a) {
  var b = this, c = null, d = "", e = "", f = b.defaultButtonWidth, g = this.getBaseClass(), h = !1;
  buttonHtml = "";
  if (b.config.isPopup) {
    var k = a.icon && "#" === a.icon.charAt(0);
    b.options = a;
    a.icon && !k ? (c = a.icon, e = "customIconButton") : b.haveSprite ? (e = "applicationSpriteClass buttonDefaultClass_normal " + g + "_normal", this.config.viewerController.hasSvgSprite() && (buttonHtml = this.getSvgIcon(k ? a.icon : null), e += " svg-button")) : (d = a.text || b.config.name || "", f = "autoWidth");
    (a.icon || b.haveSprite) && a.label && (h = !0);
    g = {click:function(a) {
      b.setButtonState("click");
    }};
    viewer.components.MobileManager.hasTouch() || (g.mouseover = function(a) {
      b.setButtonState("hover");
    }, g.mouseout = function(a) {
      b.setButtonState("normal");
    });
    b.button = Ext.create("Ext.button.Button", {text:d, cls:e, html:buttonHtml, renderTo:h ? null : b.config.div, scale:"large", icon:c, tooltip:a.tooltip || null, maskElement:"el", handler:function() {
      b.button.isMasked() || (b.popup && b.popup.isVisible() ? b.popup.hide() : (b.button.setLoading(!0), setTimeout(function() {
        var c = a.handler();
        b.isPromise(c) ? c.always(function() {
          b.button.setLoading(!1);
        }) : setTimeout(function() {
          b.button.setLoading(!1);
        }, 0);
      }, 0)));
    }, width:f, height:b.defaultButtonHeight, enableToggle:!0, style:{height:b.defaultButtonHeight + "px"}, listeners:g, preventDefault:!viewer.components.MobileManager.hasTouch()});
    h && (c = Ext.util.TextMetrics.measure(b.config.div, a.label, f), Ext.create("Ext.container.Container", {renderTo:b.config.div, height:b.defaultButtonHeight + c.height + 3, margin:3, layout:{type:"vbox", align:"center", shrinkToFit:!1}, style:{display:"inline-block", "vertical-align":"top"}, items:[b.button, {xtype:"container", html:a.label, style:{"padding-top":"3px", "text-align":"center"}}]}));
  }
}, getSvgIcon:function(a) {
  var b = this.config.viewerController.getApplicationSprite(), c = "#icon-" + this.getBaseClass().replace("viewercomponents", "").toLowerCase();
  a && (c = a);
  return ['\x3cdiv class\x3d"svg-click-area"\x3e\x3c/div\x3e\x3csvg role\x3d"img" title\x3d""\x3e\x3cuse xlink:href\x3d"', b, c, '"/\x3e\x3c/svg\x3e'].join("");
}, setButtonState:function(a, b) {
  var c = this.button, d = this.getBaseClass();
  this.options && this.button && (this.options.icon || !this.haveSprite || this.forceState && !b || ("hover" == a ? (c.removeCls(d + "_normal"), c.removeCls(d + "_click"), c.removeCls("buttonDefaultClass_click"), c.removeCls("buttonDefaultClass_normal"), c.addCls("buttonDefaultClass_hover"), c.addCls(d + "_hover")) : "click" == a ? (c.removeCls(d + "_normal"), c.removeCls(d + "_hover"), c.removeCls("buttonDefaultClass_normal"), c.removeCls("buttonDefaultClass_hover"), c.addCls("buttonDefaultClass_click"), 
  c.addCls(d + "_click")) : (c.removeCls(d + "_click"), c.removeCls(d + "_hover"), c.removeCls("buttonDefaultClass_click"), c.removeCls("buttonDefaultClass_hover"), c.addCls("buttonDefaultClass_normal"), c.addCls(d + "_normal"))), "click" != a || this.forceState && !b || c.pressed ? this.forceState && !b || !c.pressed || c.toggle() : c.toggle(), b && this.forceState ? this.forceState = !1 : b && !this.forceState && (this.forceState = b));
}, getBaseClass:function() {
  return this.$className.replace(/\./g, "");
}, getPopupIcon:function() {
  var a = this.getBaseClass();
  if (this.config.iconUrl) {
    var b = a + "_popupicon";
    Ext.util.CSS.createStyleSheet("." + b + " { background-image: url('" + this.config.iconUrl + "') !important; }", a + "iconStyle");
    return b;
  }
  return "applicationSpriteClassPopup " + a + "_popup";
}, createIconStylesheet:function() {
  if (this.viewerController.hasSvgSprite()) {
    this.haveSprite = !0;
  } else {
    if (null != document.getElementById("appSpriteStyle")) {
      this.haveSprite = !0;
    } else {
      var a = this.config.viewerController.getApplicationSprite();
      if (Ext.isEmpty(a)) {
        this.haveSprite = !1;
      } else {
        this.haveSprite = !0;
        -1 == a.indexOf("://") && (0 == a.indexOf("/viewer/") && (a = a.substring(7)), "/" == !a.charAt(0) && (a = "/" + a), a = FlamingoAppLoader.get("contextPath") + a);
        var b = {normal:3, hover:2, click:1}, c = ".applicationSpriteClass .x-btn-button { background-image: url('" + a + "') !important; position: absolute; left: 2px; top: 2px; bottom: 2px; right: 2px; } ", c = c + (".applicationSpriteClassPopup { background-image: url('" + a + "') !important; } "), c = c + (" .buttonDefaultClass_normal .x-btn-button { background-position: -" + 55 * (b.normal - 1) + "px 0px; } "), c = c + (" .buttonDefaultClass_hover .x-btn-button { background-position: -" + 55 * 
        (b.hover - 1) + "px 0px; } "), c = c + (" .buttonDefaultClass_click .x-btn-button { background-position: -" + 55 * (b.click - 1) + "px 0px; } ");
        Ext.Object.each({viewercomponentsSelectionModule:2, viewercomponentsLegend:3, viewercomponentsBuffer:4, viewercomponentsDataSelection:5, viewercomponentsSearch:6, viewercomponentsEdit:7, viewercomponentsDrawing:8, viewercomponentsBookmark:9, viewercomponentsTransparencySlider:10, viewercomponentsInfluenceImage:11, viewercomponentsRelatedDocuments:12, viewercomponentsAttributeList:13, viewercomponentsPrint:15, viewercomponentstoolsDownloadMap:16, viewercomponentsSpatialFilter:17, viewercomponentsGraph:18, 
        viewercomponentsTOC:19, viewercomponentsSnapping:20, viewercomponentsSplit:21, viewercomponentsMerge:22}, function(a, e) {
          Ext.Object.each(b, function(b, g) {
            c += " ." + a + "_" + b + " .x-btn-button { background-position: -" + (55 * (g - 1) + 357) + "px -" + (55 * (e - 1) + 3) + "px !important; }";
          });
          c += " ." + a + "_popup { background-position: -539px -" + (55 * (e - 1) + 14) + "px !important; }";
        });
        Ext.util.CSS.createStyleSheet(c, "appSpriteStyle");
      }
    }
  }
}, bind:function(a, b, c, d) {
  this.addListener(a, b, d);
}, isTool:function() {
  return this.superclass && this.superclass.$className && ("viewer.viewercontroller.controller.Tool" == this.superclass.$className || "viewer.components.tools.JSButton" == this.superclass.$className);
}, resizeScreenComponent:function() {
  this.isTool() || this.config.isPopup || this.doResize();
  viewer.components.MobileManager.isMobile() && this.config.isPopup && (this.popup.resizePopup(), this.doResize());
}, doResize:function() {
  if (this.getExtComponents) {
    for (var a = this.getExtComponents(), b = 0;b < a.length;b++) {
      var c = Ext.getCmp(a[b]);
      void 0 !== c && null !== c && c.updateLayout && c.updateLayout();
    }
  }
}, getBookmarkState:function(a) {
  return null;
}, loadVariables:function(a) {
}, currentDeferred:null, createDeferred:function() {
  this.currentDeferred = new Ext.Deferred;
  window.setTimeout(function() {
    this.cleanupDeferred();
  }.bind(this), 3E4);
  return this.currentDeferred;
}, resolveDeferred:function() {
  this.isPromise(this.currentDeferred) && this.currentDeferred.resolve.apply(this.currentDeferred, ["success"].concat(arguments));
}, rejectDeferred:function() {
  this.isPromise(this.currentDeferred) && this.currentDeferred.reject.apply(this.currentDeferred, ["error"].concat(arguments));
}, isPromise:function(a) {
  return a && (a instanceof Ext.promise.Promise || a instanceof Ext.Deferred);
}, cleanupDeferred:function() {
  this.isPromise(this.currentDeferred) && this.currentDeferred.reject("timeout");
}});
Ext.define("viewer.components.LogMessage", {statics:{ERROR:"error", WARNING:"warning", INFO:"info", DEBUG:"debug"}, config:{type:"", message:""}, date:null, constructor:function(a) {
  this.initConfig(a);
  this.date = new Date;
}, toHtmlElement:function() {
  var a = new Ext.Element(document.createElement("div"));
  a.addCls("logger_" + this.getType());
  a.insertHtml("beforeEnd", this.date.toString() + ": \x3cbr/\x3e" + this.getMessage());
  return a;
}});
Ext.define("viewer.components.Logger", {config:{title:"Logger", logLevel:0, details:{minWidth:400, minHeight:250}}, statics:{LEVEL_ERROR:2, LEVEL_WARNING:1, LEVEL_INFO:0, LEVEL_DEBUG:-1}, popup:null, messageDiv:null, messages:null, iconDiv:null, iconSize:16, constructor:function(a) {
  this.initConfig(a);
  this.messages = [];
  var b = this;
  Ext.on("resize", function() {
    b.onResize();
  }, this);
}, error:function(a) {
  this.config.logLevel <= viewer.components.Logger.LEVEL_ERROR && (FlamingoErrorLogger(a), this.message(a, viewer.components.LogMessage.ERROR), console.log(a));
}, warning:function(a) {
  this.config.logLevel <= viewer.components.Logger.LEVEL_WARNING && this.message(a, viewer.components.LogMessage.WARNING);
}, warn:function(a) {
  this.warning.call(this, a);
}, info:function(a) {
  this.config.logLevel <= viewer.components.Logger.LEVEL_INFO && this.message(a, viewer.components.LogMessage.INFO);
}, debug:function(a) {
  this.config.logLevel <= viewer.components.Logger.LEVEL_DEBUG && this.message(a, viewer.components.LogMessage.DEBUG);
}, message:function(a, b) {
  var c = Ext.create("viewer.components.LogMessage", {message:a, type:b});
  this.messages.push(c);
  null != this.popup && this.messageDiv.appendChild(c.toHtmlElement());
  b != viewer.components.LogMessage.DEBUG && this.setIconVisible(!0);
}, show:function() {
  if (null == this.popup) {
    this.popup = Ext.create("viewer.components.ScreenPopup", this.config);
    var a = Ext.get(this.popup.getContentId());
    Ext.create("Ext.container.Container", {renderTo:this.popup.getContentId(), width:"100%", items:{xtype:"button", text:"Clear", style:{"float":"right", marginLeft:"5px"}, listeners:{click:{scope:this, fn:function() {
      this.clear();
    }}}}});
    this.messageDiv = new Ext.Element(document.createElement("div"));
    this.messageDiv.addCls("logger_messages");
    a.appendChild(this.messageDiv);
    for (a = 0;a < this.messages.length;a++) {
      this.messageDiv.appendChild(this.messages[a].toHtmlElement());
    }
  }
  this.popup.show();
}, clear:function() {
  this.messageDiv.update("");
  this.messages = [];
  this.setIconVisible(!1);
}, setIconVisible:function(a) {
  a && null == this.iconDiv && (this.iconDiv = new Ext.Element(document.createElement("div")), this.iconDiv.addCls("logger_icon"), this.iconDiv.applyStyles({left:"0px", top:Ext.getBody().getHeight() - this.iconSize + "px", width:this.iconSize + "px", height:this.iconSize + "px"}), this.iconDiv.on("click", function() {
    this.show();
    this.setIconVisible(!1);
  }, this), Ext.getBody().appendChild(this.iconDiv));
  null != this.iconDiv && this.iconDiv.setVisible(a);
}, onResize:function() {
  null != this.iconDiv && this.iconDiv.applyStyles({top:Ext.getBody().getHeight() - this.iconSize + "px"});
}});
Ext.define("viewer.components.RequestManager", {previousRequests:null, featureInfo:null, viewerController:null, constructor:function(a, b) {
  this.previousRequests = {};
  this.featureInfo = a;
  this.config.viewerController = b;
}, request:function(a, b, c, d, e, f, g, h) {
  var k = this;
  g || (g = k);
  void 0 === this.previousRequests[a] && (this.previousRequests[a] = {}, this.previousRequests[a].requests = [], this.previousRequests[a].total = 0, this.previousRequests[a].done = 0, this.cancelPrevious(a));
  h = Ext.merge({}, h, {requestId:a});
  for (var l = 0;l < d.length;l++) {
    var m = this.featureInfo.layersFeatureInfo(b.coord.x, b.coord.y, c, [d[l]], h, function(a) {
      k.responseReceived(a[0].requestId);
      e(a);
    }, f, g);
    m && (this.previousRequests[a].requests.push(m), b.useCursorForWaiting && this.config.viewerController.mapComponent.setCursor(!0, "wait"), this.previousRequests[a].total++);
  }
}, requestsFinished:function(a) {
  return this.previousRequests[a].done === this.previousRequests[a].total;
}, responseReceived:function(a) {
  this.previousRequests[a].done++;
  this.requestsFinished(a) && this.config.viewerController.mapComponent.setCursor(!1);
}, cancelPrevious:function(a) {
  for (var b in this.previousRequests) {
    this.previousRequests.hasOwnProperty(b) && b !== a && (this.cancel(b), delete this.previousRequests[b]);
  }
}, cancel:function(a) {
  a = this.previousRequests[a].requests;
  for (var b = 0;b < a.length;b++) {
    Ext.Ajax.abort(a[b]);
  }
}});
Ext.define("viewer.components.DataSelectionChecker", {config:{viewerController:null}, constructor:function(a) {
  this.initConfig(a);
  this.config.viewerController.addListener(viewer.viewercontroller.controller.Event.ON_COMPONENTS_FINISHED_LOADING, this.init, this);
}, init:function() {
  this.config.viewerController.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED, this.layerVisibilityChanged, this);
  this.config.viewerController.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, this.layerVisibilityChanged, this);
}, layerVisibilityChanged:function(a, b) {
  var c = this, d = this.config.viewerController.getAppLayerById(b.layer.appLayerId);
  d && d.checked && this.hasLayerDataSelectionAttributes(d, function(a) {
    a || setTimeout(function() {
      c.config.viewerController.setLayerVisible(d, !1);
    }, 100);
  });
}, hasLayerDataSelectionAttributes:function(a, b) {
  if (a) {
    var c = this.config.viewerController.getAppLayerFeatureService(a);
    if (null != a) {
      var d = this;
      void 0 == a.attributes ? c.loadAttributes(a, function(c) {
        b(d.checkAppLayerForDataselection(a), d);
      }) : b(this.checkAppLayerForDataselection(a), d);
    } else {
      return b(!0, d);
    }
  } else {
    return b(!0, d);
  }
}, checkAppLayerForDataselection:function(a) {
  var b = this.hasSelectableAttributes(a);
  if (0 <= b && (void 0 == a.filter || null == a.filter)) {
    var c = a.alias || a.layerName, d = this.config.viewerController.getComponentsByClassName("viewer.components.DataSelection");
    if (0 == d.length) {
      this.config.viewerController.logger.warning('Dataselectiemodule niet beschikbaar, kaartlaag "' + c + '" kan niet weergegeven worden.');
    } else {
      for (var e = !1, f = 0;f < d.length;f++) {
        var g = d[f], h = a;
        if (g.allLayers || g.hasAppLayerConfigured(a)) {
          e = !0;
          this.config.viewerController.addListener(viewer.viewercontroller.controller.Event.ON_FILTER_ACTIVATED, function(b, c) {
            h.serviceId == c.serviceId && h.layerName == c.layerName && (this.config.viewerController.setLayerVisible(h, !0), g.removeForcedLayer(a));
          }, this);
          if (1 == b) {
            return g.applyFilterWithDefaults(), !0;
          }
          g.showAndForceLayer(a);
          g.selectAppLayer(a);
        }
      }
      e || this.config.viewerController.logger.warning('Kaartlaag "' + c + '" niet geconfigureerd bij een dataselectiecomponent.');
    }
    return !1;
  }
  return !0;
}, hasSelectableAttributes:function(a) {
  for (var b = -1, c = 0;c < a.attributes.length;c++) {
    if (a.attributes[c].selectable) {
      if (a.attributes[c].defaultValue) {
        b = 1;
      } else {
        b = 0;
        break;
      }
    }
  }
  return b;
}});
Ext.define("viewer.overrides.dom.TouchAction", {override:"Ext.dom.TouchAction", fixEvent:function(a) {
  a.touches || (a.touches = []);
  return a;
}, onTouchStart:function(a) {
  this.callParent([this.fixEvent(a)]);
}, onTouchMove:function(a) {
  this.callParent([this.fixEvent(a)]);
}, onTouchEnd:function(a) {
  this.callParent([this.fixEvent(a)]);
}});
(Ext.browser.is.Chrome || Ext.browser.is.ChromeMobile) && Ext.define("Ext.overrides.event.publisher.Dom", {override:"Ext.event.publisher.Dom"}, function(a) {
  var b = !1;
  try {
    window.addEventListener("options-test", null, Object.defineProperty({}, "capture", {get:function() {
      b = !0;
    }}));
  } catch (c) {
  }
  a.override({addDelegatedListener:function(a) {
    b && /^touch(start|end|move)$/.test(a) && this.target instanceof Window ? (this.delegatedListeners[a] = 1, this.target.addEventListener(a, this.onDelegatedEvent, {passive:!1, capture:!!this.captureEvents[a]})) : this.callParent([a]);
  }});
});
"Desktop" !== Ext.os.deviceType && Ext.form.field.ComboBox && Ext.form.field.ComboBox.prototype && Ext.form.field.ComboBox.prototype.defaultConfig && (Ext.form.field.ComboBox.prototype.defaultConfig.editable = !1);
OpenLayers.Renderer.SVG.prototype.drawText = function(a, b, c) {
  var d = !!b.labelOutlineWidth;
  if (d) {
    var e = OpenLayers.Util.extend({}, b);
    e.fontColor = e.labelOutlineColor;
    e.fontStrokeColor = e.labelOutlineColor;
    e.fontStrokeWidth = b.labelOutlineWidth;
    delete e.labelOutlineWidth;
    this.drawText(a, e, c);
  }
  var f = this.getResolution(), e = (c.x - this.featureDx) / f + this.left, g = c.y / f - this.top, d = d ? this.LABEL_OUTLINE_SUFFIX : this.LABEL_ID_SUFFIX, f = this.nodeFactory(a + d, "text");
  f.setAttributeNS(null, "x", e);
  f.setAttributeNS(null, "y", -g);
  b.fontColor && f.setAttributeNS(null, "fill", b.fontColor);
  b.fontStrokeColor && f.setAttributeNS(null, "stroke", b.fontStrokeColor);
  b.fontStrokeWidth && f.setAttributeNS(null, "stroke-width", b.fontStrokeWidth);
  b.fontOpacity && f.setAttributeNS(null, "opacity", b.fontOpacity);
  b.fontFamily && f.setAttributeNS(null, "font-family", b.fontFamily);
  b.fontSize && f.setAttributeNS(null, "font-size", b.fontSize);
  b.fontWeight && f.setAttributeNS(null, "font-weight", b.fontWeight);
  b.fontStyle && f.setAttributeNS(null, "font-style", b.fontStyle);
  !0 === b.labelSelect ? (f.setAttributeNS(null, "pointer-events", "visible"), f._featureId = a) : f.setAttributeNS(null, "pointer-events", "none");
  b.rotation && f.setAttributeNS(null, "transform", "rotate(" + b.rotation + "," + e + "," + -g + ")");
  g = b.labelAlign || OpenLayers.Renderer.defaultSymbolizer.labelAlign;
  f.setAttributeNS(null, "text-anchor", OpenLayers.Renderer.SVG.LABEL_ALIGN[g[0]] || "middle");
  !0 === OpenLayers.IS_GECKO && f.setAttributeNS(null, "dominant-baseline", OpenLayers.Renderer.SVG.LABEL_ALIGN[g[1]] || "central");
  for (var h = b.label.split("\n"), k = h.length;f.childNodes.length > k;) {
    f.removeChild(f.lastChild);
  }
  for (var l = 0;l < k;l++) {
    var m = this.nodeFactory(a + d + "_tspan_" + l, "tspan");
    !0 === b.labelSelect && (m._featureId = a, m._geometry = c, m._geometryClass = c.CLASS_NAME);
    !1 === OpenLayers.IS_GECKO && m.setAttributeNS(null, "baseline-shift", OpenLayers.Renderer.SVG.LABEL_VSHIFT[g[1]] || "-35%");
    m.setAttribute("x", e);
    if (0 == l) {
      var n = OpenLayers.Renderer.SVG.LABEL_VFACTOR[g[1]];
      null == n && (n = -.5);
      m.setAttribute("dy", n * (k - 1) + "em");
    } else {
      m.setAttribute("dy", "1em");
    }
    m.textContent = "" === h[l] ? " " : h[l];
    m.parentNode || f.appendChild(m);
  }
  f.parentNode || this.textRoot.appendChild(f);
};
Ext.define("viewer.components.SvgHeader", {extend:"Ext.panel.Header", xtype:"svgpanelheader", constructor:function(a) {
  a.iconCls = "svg-icon-header";
  viewer.components.SvgHeader.superclass.constructor.call(this, a);
  this.initConfig(a);
  this.addListener("afterrender", function(b, c) {
    b.el.dom.querySelector(".svg-icon-header").innerHTML = a.svgIcon;
  });
}});
Ext.define("viewer.components.ScreenPopup", {extend:"Ext.util.Observable", popupWin:null, config:{title:"", showOnStartup:null, details:{x:100, y:100, width:400, height:600, minWidth:null, minHeight:null, changeablePosition:!0, changeableSize:!0, items:null, position:"center", useExtLayout:!1}}, component:null, currentOrientation:null, constructor:function(a) {
  viewer.components.ScreenPopup.superclass.constructor.call(this, a);
  this.initConfig(a);
  var b = {title:this.config.title || "Titel", closable:!0, closeAction:"hide", hideMode:"offsets", width:-1 !== ("" + this.config.details.width).indexOf("%") ? this.config.details.width : parseInt(this.config.details.width), height:-1 !== ("" + this.config.details.height).indexOf("%") ? this.config.details.height : parseInt(this.config.details.height), resizable:this.parseBooleanValue(this.config.details.changeableSize), draggable:this.parseBooleanValue(this.config.details.changeablePosition), layout:"fit", 
  modal:!1, renderTo:Ext.getBody(), scrollable:!0, constrainHeader:!0, iconCls:this.config.iconCls || "", bodyStyle:{}, cls:"screen-popup"};
  this.config.popupIcon && (b.header = {xtype:"svgpanelheader", svgIcon:this.config.popupIcon});
  var c = viewer.components.MobileManager.isMobile();
  c && (b.modal = !0, b.width = "100%", b.height = "100%", b.draggable = !1, b.resizable = !1, this.config.details.minWidth && (b.bodyStyle.minWidth = this.config.details.minWidth + "px"), this.config.details.minHeight && (b.bodyStyle.minHeight = this.config.details.minHeight + "px"), this.currentOrientation = viewer.components.MobileManager.getOrientation());
  this.config.details.minWidth && !c && (b.minWidth = this.config.details.minWidth, a.details.width || (b.width = this.config.details.minWidth));
  this.config.details.minHeight && !c && (b.minHeight = this.config.details.minHeight, a.details.height || (b.height = this.config.details.minHeight));
  this.config.details && this.config.details.items ? (b.items = this.config.details.items, b.bodyStyle.background = "#fff") : this.config.details && this.config.details.useExtLayout ? b.bodyStyle.background = "#fff" : (c = document.createElement("div"), c.style.height = "100%", c.style.position = "absolute", c.style.background = "#FFFFFF", c.style.width = "100%", b.contentEl = c);
  this.config && this.config.hasOwnProperty("showHelpButton") && "false" !== this.config.showHelpButton && !1 !== this.config.showHelpButton && (b.tools = [{type:"help", tooltip:"Help", margin:"0 28 0 0", handler:function(b, c, d) {
    a.viewerController.showHelp(a);
  }}]);
  b.resizable && (b.resizable = {listeners:{beforeresize:{fn:function() {
    this.disableBody();
  }, scope:this}, resize:{fn:function() {
    this.enableBody();
  }, scope:this}}});
  this.popupWin = Ext.create("Ext.window.Window", b);
  this.config.showOnStartup && this.popupWin.show();
  var d = !1;
  b.draggable && (this.popupWin.addListener("dragstart", function() {
    this.disableBody();
  }, this), this.popupWin.addListener("dragend", function() {
    this.enableBody();
    d = !0;
  }, this));
  this.popupWin.addListener("hide", function() {
    this.component && this.component.setButtonState("normal", !0);
    this.enableBody();
    this.fireEvent("hide", this);
  }, this);
  this.popupWin.addListener("show", function() {
    a.viewerController && a.viewerController.registerPopupShow(this.popupWin);
    this.component && this.component.setButtonState("click", !0);
    if (viewer.components.MobileManager.isMobile()) {
      viewer.components.MobileManager.getOrientation() !== this.currentOrientation && (this.currentOrientation = viewer.components.MobileManager.getOrientation(), setTimeout(function() {
        this.component.resizeScreenComponent();
      }, 0));
    } else {
      if ("fixed" === this.config.details.position && !d) {
        var b = [parseInt(this.config.details.x), parseInt(this.config.details.y)], c = "tl";
        this.config.details.alignposition && (c = this.config.details.alignposition);
        "b" === c.substr(0, 1) && (b[1] *= -1);
        "r" === c.substr(1) && (b[0] *= -1);
        this.popupWin.alignTo(Ext.get("wrapper"), [c, c].join("-"), b);
      }
    }
  }, this);
  this.popupWin.getEl().dom.addEventListener("touchstart", function() {
  });
  return this;
}, parseBooleanValue:function(a) {
  return !0 === a || !1 === a ? a : "true" === a;
}, setComponent:function(a) {
  this.component = a;
}, getContentId:function() {
  return this.popupWin.contentEl.id;
}, getContentContainer:function() {
  return this.popupWin;
}, show:function() {
  this.popupWin.show();
  this.popupWin.zIndexManager.bringToFront(this.popupWin);
}, hide:function() {
  this.popupWin.hide();
}, disableBody:function() {
  var a = Ext.getBody().mask();
  a.on("click", this.enableBody, this);
  a.setZIndex(this.popupWin.getEl().getZIndex() - 1);
}, enableBody:function() {
  Ext.getBody().unmask();
}, setIconClass:function(a) {
  this.popupWin.setIconCls(a);
}, isVisible:function() {
  return this.popupWin.isVisible();
}, resizePopup:function() {
  viewer.components.MobileManager.isMobile() && this.isVisible() && (this.popupWin.setSize(Ext.Element.getViewportWidth(), Ext.Element.getViewportHeight()), this.popupWin.setPosition(0, 0), this.popupWin.updateLayout(), this.currentOrientation = viewer.components.MobileManager.getOrientation());
}, setWindowTitle:function(a) {
  this.popupWin.setTitle(a);
}});
Ext.define("viewer.components.CQLFilterWrapper", {filters:null, logicOperators:null, config:{id:null, cql:null, operator:null, type:null}, constructor:function(a) {
  this.initConfig(a);
  this.filters = [];
  this.logicOperators = ["AND", "OR"];
  this.config.type || (this.config.type = "ATTRIBUTE");
}, getCQL:function() {
  for (var a = this.getInternalCQL(), b = 0;b < this.logicOperators.length;b++) {
    var a = Ext.String.trim(a), c = this.logicOperators[b];
    0 === a.indexOf(c) && (a = a.substr(c.length));
  }
  return a;
}, getCQLWithoutType:function(a) {
  a = this.getInternalCQLWithoutType(a);
  for (var b = 0;b < this.logicOperators.length;b++) {
    a = Ext.String.trim(a);
    var c = this.logicOperators[b];
    0 === a.indexOf(c) && (a = a.substr(c.length));
  }
  return a;
}, getInternalCQLWithoutType:function(a) {
  var b = "";
  this.config.type !== a && "" !== this.config.cql && (b = " " + this.config.operator + " " + this.config.cql);
  for (var c = 0;c < this.filters.length;c++) {
    var d = this.filters[c];
    d.type !== a && (b += d.getInternalCQLWithoutType(a));
  }
  return b;
}, getInternalCQL:function() {
  var a = "";
  "" !== this.config.cql && (a = " " + this.config.operator + " " + this.config.cql);
  for (var b = 0;b < this.filters.length;b++) {
    a += this.filters[b].getInternalCQL();
  }
  return a;
}, addFilter:function(a) {
  this.filters.push(a);
}, removeFilter:function(a) {
  this.removeFilterById(a.config.id);
}, removeFilterById:function(a) {
  for (var b = 0;b < this.filters.length;b++) {
    if (this.filters[b].config.id === a) {
      this.filters.splice(b, 1);
      break;
    }
  }
  return this;
}, addOrReplace:function(a) {
  this.removeFilter(a);
  this.addFilter(a);
}});
Ext.define("viewer.FeatureInfoWrapper", {feature:null, indexedAttributes:null, constructor:function(a) {
  this.feature = a;
}, getAttributes:function() {
  return this.feature.attributes ? this.feature.attributes : this.feature;
}, forEachAttribute:function(a, b, c) {
  for (var d = this.getAttributes(), e = {}, f = 0;f < c.length;f++) {
    e[c[f]] = !0;
  }
  if (Ext.isArray(d)) {
    for (c = 0;c < d.length;c++) {
      this._executeLoop(d[c], a, b, e);
    }
  } else {
    this._executeLoop(d, a, b, e);
  }
}, _executeLoop:function(a, b, c, d) {
  for (var e in a) {
    a.hasOwnProperty(e) && !d.hasOwnProperty(e) && b.call(c || this, e, a[e]);
  }
}, getIndexedAttributes:function() {
  if (null !== this.indexedAttributes) {
    return this.indexedAttributes;
  }
  var a = this.getAttributes();
  Ext.isArray(a) && (a = this.attributeArrayToObject(a));
  return this.indexedAttributes = a;
}, getAttribute:function(a) {
  return this.getIndexedAttributes()[a] || null;
}, getRelatedFeatureTypes:function() {
  return this.getAttribute("related_featuretypes");
}, attributeArrayToObject:function(a) {
  for (var b = {}, c, d = 0;d < a.length;d++) {
    c = a[d];
    for (var e in c) {
      c.hasOwnProperty(e) && (b[e] = c[e]);
    }
  }
  return b;
}});
/*
 Ext.ux.form.trigger.Clear is released under the <a target="_blank"
          href="http://www.apache.org/licenses/LICENSE-2.0.txt">Apache License, Version
          2.0</a>.
*/
Ext.define("Ext.ux.form.trigger.Clear", {extend:"Ext.form.trigger.Trigger", alias:"trigger.clear", cls:Ext.baseCSSPrefix + "form-clear-trigger", mixins:{observable:"Ext.util.Observable"}, hideWhenEmpty:!0, hideWhenMouseOut:!1, clearOnEscape:!1, destroy:function() {
  this.clearListeners();
  this.callParent();
}, initEvents:function() {
  this.updateTriggerVisibility();
  this.callParent();
  var a = this.field;
  a.addCls(Ext.baseCSSPrefix + "form-has-clear-trigger");
  this.hideWhenEmpty && this.addManagedListener(a, "change", this.updateTriggerVisibility, this);
  if (this.hideWhenMouseOut) {
    var b = a.bodyEl;
    this.addManagedListener(b, "mouseover", function() {
      this.mouseover = !0;
      this.updateTriggerVisibility();
    }, this);
    this.addManagedListener(b, "mouseout", function() {
      this.mouseover = !1;
      this.updateTriggerVisibility();
    }, this);
  }
  this.clearOnEscape && this.addManagedListener(a.inputEl, "keydown", function(b) {
    b.getKey() !== Ext.event.Event.ESC || a.isExpanded || (this.handler(a), b.stopEvent());
  }, this);
}, updateTriggerVisibility:function() {
  this.isTriggerVisible() ? this.isVisible() || this.show() : this.isVisible() && this.hide();
}, handler:function(a) {
  Ext.isFunction(a.clearValue) ? a.clearValue() : a.setValue("");
  a.fireEvent("clear", a);
}, isTriggerVisible:function() {
  return !this.field || !this.rendered || this.isDestroyed || this.hideWhenEmpty && Ext.isEmpty(this.field.getValue()) || this.hideWhenMouseOut && !this.mouseover ? !1 : !0;
}});
Ext.define("viewer.components.LocalStorage", {singleton:!0, itemprefix:"flamingo4_", itemskey:"flamingo4items", items:[], maxage:30, localStorageSupported:!1, constructor:function() {
  if (this.localStorageSupported = this._isLocalStorageSupported()) {
    var a = this._getItem(this.itemskey);
    null !== a && (this.items = a);
    this._clearOldItems();
  }
}, setItem:function(a, b) {
  this.localStorageSupported && (a = this._getKey(a), this._setItem(a, {created:new Date, value:b}));
}, getItem:function(a) {
  if (!this.localStorageSupported) {
    return null;
  }
  a = this._getItem(this._getKey(a));
  return null === a ? null : a.value;
}, removeItem:function(a) {
  this.localStorageSupported && this._removeItem(this._getKey(a));
}, _setItem:function(a, b) {
  this._itemAdded(a);
  this._getStorage().setItem(a, Ext.JSON.encode(b));
}, _getItem:function(a) {
  a = this._getStorage().getItem(a);
  return null === a ? null : Ext.JSON.decode(a);
}, _removeItem:function(a) {
  this._getStorage().removeItem(a);
  a = Ext.Array.indexOf(this.items, a);
  -1 !== a && (this.items.splice(a, 1), this._saveItems());
}, _itemAdded:function(a) {
  -1 === Ext.Array.indexOf(this.items, a) && (this.items.push(a), this._saveItems());
}, _clearOldItems:function() {
  var a, b = new Date;
  b.setDate(b.getDate() - this.maxage);
  for (var c = 0;c < this.items.length;c++) {
    if (a = this._getItem(this.items[c]), null === a || a && a.created && new Date(a.created) < b) {
      return this._removeItem(this.items[c]), this.items.splice(c, 1), this._clearOldItems();
    }
  }
  this._saveItems();
}, _saveItems:function() {
  this._getStorage().setItem(this.itemskey, Ext.JSON.encode(this.items));
}, _getStorage:function() {
  try {
    return window.localStorage;
  } catch (a) {
    return {};
  }
}, _getKey:function(a) {
  return this.itemprefix + a;
}, _isLocalStorageSupported:function() {
  try {
    return this._getStorage().setItem("test", "1"), this._getStorage().removeItem("test"), !0;
  } catch (a) {
    return !1;
  }
}});
Ext.define("viewer.ServiceInfo", {config:{actionbeanUrl:null, protocol:"wms", url:null}, url:null, constructor:function(a) {
  this.initConfig(a);
  null == this.config.actionbeanUrl && (this.config.actionbeanUrl = actionBeans.service);
}, loadInfo:function(a, b) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:this.config, success:function(c) {
    c = Ext.JSON.decode(c.responseText);
    c.success ? a(c.service) : void 0 != b && b(c.error);
  }, failure:function(a) {
    void 0 != b && b("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}});
Ext.define("viewer.CSWClient", {config:{actionbeanUrl:null, url:null}, url:null, constructor:function(a) {
  null == this.config.actionbeanUrl && (this.config.actionbeanUrl = actionBeans.csw);
  this.initConfig(a);
}, loadInfo:function(a, b) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:this.config, timeout:12E4, success:function(c) {
    c = Ext.JSON.decode(c.responseText);
    c.success ? a(c.results) : void 0 != b && b(c.error);
  }, failure:function(a) {
    void 0 != b && b("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}});
Ext.define("viewer.DirectFeatureService", {config:{actionbeanUrl:null, appLayer:null, protocol:null, url:null}, constructor:function(a) {
  this.initConfig(a);
  null == this.config.actionbeanUrl && (this.config.actionbeanUrl = actionBeans.feature);
}, loadAttributes:function(a, b) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{getLayerFeatureType:!0, protocol:this.config.protocol, layer:this.config.appLayer.layerName}, success:function(c) {
    c = Ext.JSON.decode(c.responseText);
    c.success ? a(c.attributes) : void 0 != b && b(c.error);
  }, failure:function(a) {
    void 0 != b && b("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}, getCount:function(a, b, c, d, e) {
  b(16);
}});
Ext.define("viewer.AppLayerService", {config:{actionbeanUrl:null, appId:null, appLayer:null, debug:!1}, constructor:function(a) {
  null == a.actionbeanUrl && (a.actionbeanUrl = actionBeans.attributes);
  this.initConfig(a);
}, loadAttributes:function(a, b, c) {
  !isNaN(a.id) && this.config.actionbeanUrl ? Ext.Ajax.request({url:this.config.actionbeanUrl, timeout:12E4, params:{attributes:!0, application:this.config.appId, appLayer:this.config.appLayer.id}, success:function(d) {
    d = Ext.JSON.decode(d.responseText);
    d.success ? (a.attributes = d.attributes, a.relations = d.relations, a.geometryAttributeIndex = d.geometryAttributeIndex, a.geometryAttribute = d.geometryAttribute, b(d.attributes)) : void 0 != c && c(d.error);
  }, failure:function(a) {
    void 0 != c && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }}) : void 0 != c && c("Ajax request failed with status " + result.status + " " + result.statusText + ": " + result.responseText);
}, getStoreUrl:function() {
  var a = this.getActionbeanUrl();
  return Ext.urlAppend(a, "store\x3d1\x26application\x3d" + this.config.appId + "\x26appLayer\x3d" + this.config.appLayer.id + (this.config.debug ? "\x26debug\x3dtrue" : ""));
}, loadFeatures:function(a, b, c, d, e) {
  var f = a.id;
  if (isNaN(f)) {
    void 0 != c && c("Ajax request failed with status " + result.status + " " + result.statusText + ": " + result.responseText);
  } else {
    var g = null;
    a && a.filter && (g = a.filter.getCQL());
    if (void 0 === d || null === d) {
      d = {};
    }
    d.application = this.config.appId;
    d.appLayer = f;
    d.filter = void 0 === d.filter ? g : d.filter;
    Ext.Ajax.request({url:this.getStoreUrl(), timeout:12E4, params:d, scope:e, success:function(a) {
      a = Ext.JSON.decode(a.responseText);
      a.success ? b.call(this, a.features) : void 0 != c && c.call(this, a.error || a.message);
    }, failure:function(a) {
      void 0 != c && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
    }});
  }
}, getCount:function(a, b, c, d, e) {
  b(16);
}});
Ext.define("viewer.SLD", {config:{actionbeanUrl:null}, constructor:function(a) {
  this.initConfig(a);
  null == this.config.actionbeanUrl && (this.config.actionbeanUrl = actionBeans.sld);
}, create:function(a, b, c, d, e, f, g) {
  a = {layer:a, format:"json"};
  null !== b && (a.style = b);
  null !== c && (a.filter = c);
  null !== d && (a.featureTypeName = d);
  null !== e && (a.id = e);
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:a, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? f(a.sld) : void 0 != g && g(a.error);
  }, failure:function(a) {
    void 0 != g && g("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}, createURL:function(a, b, c, d, e, f, g, h) {
  var k = FlamingoAppLoader.get("absoluteURIPrefix") + this.config.actionbeanUrl, k = a instanceof Array ? Ext.String.urlAppend(k, "layer\x3d" + a.join(",")) : Ext.String.urlAppend(k, "layer\x3d" + a);
  null !== b && (k = b instanceof Array ? Ext.String.urlAppend(k, "style\x3d" + b.join(",")) : Ext.String.urlAppend(k, "style\x3d" + b));
  null !== c && (k = c instanceof Array ? Ext.String.urlAppend(k, "filter\x3d" + encodeURIComponent(JSON.stringify(c))) : Ext.String.urlAppend(k, "filter\x3d" + encodeURIComponent(c)));
  null !== d && (k = Ext.String.urlAppend(k, "featureTypeName\x3d" + d));
  null !== e && (k = Ext.String.urlAppend(k, "id\x3d" + e));
  f && (k = Ext.String.urlAppend(k, "commonAndFilter\x3d" + encodeURIComponent(f)));
  g && (g instanceof Array && (g = g.join(",")), k = Ext.String.urlAppend(k, "color\x3d" + encodeURIComponent(g)));
  h && (k = Ext.String.urlAppend(k, "useRuleFilter\x3dtrue"));
  return k = Ext.String.urlAppend(k, "format\x3dxml");
}, createURLWithHash:function(a, b, c, d) {
  var e = FlamingoAppLoader.get("absoluteURIPrefix") + this.config.actionbeanUrl, e = Ext.String.urlAppend(e, "sldId\x3d" + a), e = Ext.String.urlAppend(e, "sessId\x3d" + b), e = Ext.String.urlAppend(e, "findSLD\x3dt"), e = Ext.String.urlAppend(e, "layer\x3d" + c);
  return e = Ext.String.urlAppend(e, "style\x3d" + d);
}, transformFilter:function(a, b, c, d) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{filter:a, applicationLayer:b}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? c(a.filter, a.sldId, a.sessId) : void 0 != d && d(a.error);
  }, failure:function(a) {
    void 0 != d && d("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}});
Ext.define("viewer.Bookmark", {config:{actionbeanUrl:null}, constructor:function(a) {
  this.initConfig(a);
  null == this.config.actionbeanUrl && (this.config.actionbeanUrl = actionBeans.bookmark);
}, createBookmark:function(a, b, c) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{create:!0, application:FlamingoAppLoader.get("appId"), "bookmark.params":a}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? b(a.bookmark) : void 0 != c && c(a.error);
  }, failure:function(a) {
    void 0 != c && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}, getBookmarkParams:function(a, b, c) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{load:!0, application:FlamingoAppLoader.get("appId"), "bookmark.code":a}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? b(a.params) : void 0 != c && c(a.error);
  }, failure:function(a) {
    void 0 != c && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}});
Ext.define("viewer.components.LayerSelector", {extend:"viewer.components.Component", popupWin:null, layersInitialized:!1, layerList:null, layerArray:null, layerselector:null, layerstore:null, div:null, forcedLayers:null, config:{viewerController:{}, restriction:null, layers:null, useTabs:!1, label:null, rememberSelection:!1}, constructor:function(a) {
  a.label || (a.label = "Kies kaartlaag");
  this.initConfig(a);
  viewer.components.LayerSelector.superclass.constructor.call(this, this.config);
  this.forcedLayers = [];
  this.layerstore = Ext.create("Ext.data.Store", {fields:["layerId", "title", "layer"], data:[]});
  this.config.useTabs ? this.createTabs() : this.createCombobox();
  a = actionBeans.layerlist;
  var b = {};
  b[this.config.restriction] = !0;
  b.appId = FlamingoAppLoader.get("appId");
  var c = this;
  null != this.config.layers && 0 < this.config.layers.length && (b.layers = this.config.layers, b.hasConfiguredLayers = !0);
  Ext.Ajax.request({url:a, timeout:12E4, params:b, success:function(a, b) {
    c.layersInitialized = !0;
    c.layerList = Ext.JSON.decode(a.responseText);
    c.initLayers();
  }, failure:function(a, b, c) {
    Ext.MessageBox.alert("Foutmelding", "Er is een onbekende fout opgetreden waardoor de lijst met kaartlagen niet kan worden weergegeven");
  }});
  this.config.viewerController.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED, this.layerVisibilityChanged, this);
  return this;
}, createCombobox:function() {
  var a = {fieldLabel:this.config.label, emptyText:"Maak uw keuze", store:this.layerstore, queryMode:"local", displayField:"title", valueField:"layer", listeners:{change:{fn:this.changed, scope:this}}};
  this.config.div && (a.renderTo = this.config.div);
  this.config.padding && (a.padding = this.config.padding);
  this.layerselector = Ext.create("Ext.form.ComboBox", a);
}, createTabs:function() {
  var a = {bodyStyle:{width:0, height:0, display:"none"}, listeners:{tabchange:{fn:this.tabChanged, scope:this}}};
  this.config.div && (a.renderTo = this.config.div);
  this.config.padding && (a.padding = this.config.padding);
  this.layerselector = Ext.create("Ext.tab.Panel", a);
}, getLayerSelector:function() {
  return this.layerselector;
}, addForcedLayer:function(a) {
  for (var b = !1, c = 0;c < this.forcedLayers.length;c++) {
    if (this.forcedLayers[c] == a) {
      b = !0;
      break;
    }
  }
  b || this.forcedLayers.push(a);
}, removeForcedLayer:function(a) {
  for (var b = this.forcedLayers.length - 1;0 <= b;b--) {
    this.forcedLayers[b] == a && this.forcedLayers.splice(b, 1);
  }
}, initLayers:function(a) {
  if (this.layersInitialized) {
    var b = this.getValue(), c = this.config.rememberSelection && a && b;
    this.layerArray = [];
    for (var d = this.config.viewerController.getVisibleLayers(), e = 0;e < this.forcedLayers.length;e++) {
      d.push(this.forcedLayers[e].id);
    }
    this.layerstore.removeAll();
    this.config.useTabs && this.layerselector.removeAll();
    var f = 0;
    if (null != this.layerList) {
      for (e = 0;e < this.layerList.length;e++) {
        for (var g = this.layerList[e], h = 0;h < d.length;h++) {
          if (d[h] == g.id || d[h] == "" + g.id) {
            this.layerstore.add({layerId:g.id, title:g.alias || g.layerName, layer:g});
            f++;
            break;
          }
        }
      }
    }
    0 === f ? this.layerselector.setDisabled(!0) : (this.layerselector.setDisabled(!1), this.config.useTabs && this.initTabs(c));
    c && !this.updateValueById(b.id) && (this.clearSelection(), this.selectFirstLayer());
    this.fireEvent(viewer.viewercontroller.controller.Event.ON_LAYERSELECTOR_INITLAYERS, {store:this.layerstore, layers:this.layerList, hasBeenInitialized:a}, this);
  }
}, initTabs:function(a) {
  var b = [];
  this.layerstore.each(function(a) {
    b.push({title:a.get("title"), itemId:"tab-" + a.get("layerId")});
  });
  this.layerselector.add(b);
  a || this.layerselector.setActiveTab(0);
}, getLayerIdFromTab:function(a) {
  return a ? a.getItemId().replace("tab-", "") : null;
}, tabChanged:function(a, b, c) {
  b = this.getLayerIdFromTab(b);
  c = this.getLayerIdFromTab(c);
  b = this.findLayerInStore(b);
  c = this.findLayerInStore(c);
  this.changed(a, b, c);
}, changed:function(a, b, c) {
  a = null;
  (b = this._validateAppLayer(b)) && (a = this.config.viewerController.getAppLayerById(b.id));
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_LAYERSELECTOR_CHANGE, a, c, this);
}, getValue:function() {
  var a;
  a = this.config.useTabs ? this.findLayerInStore(this.getLayerIdFromTab(this.layerselector.getActiveTab())) : this.layerselector.getValue();
  return (a = this._validateAppLayer(a)) ? this.config.viewerController.getAppLayerById(a.id) : null;
}, _validateAppLayer:function(a) {
  if ("string" === typeof a) {
    try {
      var b = this.layerstore.findBy(function(b) {
        return b.get("title") === a ? !0 : !1;
      });
      a = -1 !== b ? this.layerstore.getAt(b).data.layer : null;
    } catch (c) {
    }
  }
  return a;
}, setValue:function(a) {
  this.config.useTabs ? this.layerselector.setActiveTab(this.layerselector.getComponent("tab-" + a.get("layerId"))) : this.layerselector.setValue(a);
}, updateValueById:function(a) {
  if (this.config.useTabs) {
    a = this.layerselector.getComponent("tab-" + a);
    if (!a) {
      return !1;
    }
    this.layerselector.setActiveTab(a);
    return !0;
  }
  a = this.layerstore.findRecord("layerId", a);
  if (!a) {
    return !1;
  }
  this.layerselector.setValue(a);
  return !0;
}, hasValue:function(a) {
  return null !== this.findLayerInStore(a.id);
}, findLayerInStore:function(a) {
  var b = null;
  this.layerstore.each(function(c) {
    "" + c.get("layerId") === "" + a && (b = c.get("layer"));
  });
  return b;
}, getStore:function() {
  return this.layerstore;
}, getVisibleLayerCount:function() {
  return this.layerstore.getCount();
}, selectFirstLayer:function() {
  0 !== this.getVisibleLayerCount() && this.setValue(this.layerstore.getAt(0));
}, clearSelection:function() {
  this.config.useTabs || this.layerselector.clearValue();
}, getSelectedAppLayer:function() {
  return this.getValue();
}, getExtComponents:function() {
  return [this.layerselector.getId()];
}, layerVisibilityChanged:function(a, b) {
  this.initLayers(!0);
}});
Ext.define("viewer.CombineImage", {config:{actionbeanUrl:null}, constructor:function(a) {
  this.initConfig(a);
  null == this.config.actionbeanUrl && (this.config.actionbeanUrl = actionBeans.combineimage);
}, getImageUrl:function(a, b, c) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{create:!0, params:a}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? b(a.imageUrl) : void 0 != c && c(a.error);
  }, failure:function(a) {
    void 0 != c && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}});
Ext.define("viewer.FeatureInfo", {config:{actionBeanUrl:null, viewerController:null}, constructor:function(a) {
  this.initConfig(a);
  null == this.config.actionbeanUrl && (this.config.actionbeanUrl = actionBeans.featureinfo);
}, featureInfoInternal:function(a, b, c, d) {
  var e = this;
  a = Ext.apply(a, {application:this.config.viewerController.app.id});
  return Ext.Ajax.request({url:this.config.actionbeanUrl, params:a, scope:d, timeout:6E4, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    for (var c = 0;c < a.length;c++) {
      var d = a[c];
      d.request.appLayer ? d.appLayer = e.config.viewerController.app.appLayers[d.request.appLayer] : d.request.service && (d.service = e.config.viewerController.app.services[d.request.service]);
    }
    b(a);
  }, failure:function(a) {
    void 0 !== c && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText, d);
  }});
}, featureInfo:function(a, b, c, d, e) {
  for (var f = this.config.viewerController.getVisibleAppLayers(), g = [], h = 0;h < f.length;h++) {
    var k = this.config.viewerController.app.appLayers[h], l = {appLayer:k.id};
    k.filter && (l.filter = k.filter.getCQL());
    g.push(l);
  }
  a = {featureInfo:!0, x:a, y:b, distance:c, queryJSON:Ext.JSON.encode(g)};
  this.featureInfoInternal(a, d, e);
}, layersFeatureInfo:function(a, b, c, d, e, f, g, h) {
  for (var k = this.config.viewerController.getVisibleAppLayers(), l = [], m = 0;m < d.length;m++) {
    var n = d[m];
    if (!0 === k[n.id]) {
      var q = {appLayer:n.id};
      n.filter && (q.filter = n.filter.getCQLWithoutType("GEOMETRY"));
      l.push(q);
    }
  }
  a = {featureInfo:!0, x:a, y:b, distance:c, queryJSON:Ext.JSON.encode(l)};
  Ext.merge(a, e);
  if (0 < l.length) {
    return this.featureInfoInternal(a, f, g, h);
  }
}, relatedFeatureInfo:function(a, b, c, d, e) {
  var f = "\x26filter\x3d" + encodeURIComponent(b.filter);
  b = "\x26featureType\x3d" + b.id;
  var g = {application:this.config.viewerController.app.id, appLayer:a.id, limit:1E3, filter:f};
  Ext.Object.merge(g, e || {});
  Ext.Ajax.request({url:a.featureService.getStoreUrl() + b + f, params:g, scope:this, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    c(a);
  }, failure:function(a) {
    "undefined" !== typeof d ? d("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText) : this.config.viewerController.logger.error(a);
  }});
}, editFeatureInfo:function(a, b, c, d, e, f, g) {
  a = {application:this.config.viewerController.app.id, featureInfo:!0, edit:!0, arrays:!0, x:a, y:b, distance:c, queryJSON:Ext.JSON.encode([{appLayer:d.id}])};
  g && Ext.merge(a, g);
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:a, timeout:4E4, success:function(a) {
    a = Ext.JSON.decode(a.responseText)[0];
    a.error ? f("Error finding feature to edit: " + a.error) : e(a.features);
  }, failure:function(a) {
    void 0 != f && f("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}});
Ext.define("viewer.EditFeature", {config:{actionbeanUrl:null, viewerController:null}, constructor:function(a) {
  this.initConfig(a);
  null == this.config.actionbeanUrl && (this.config.actionbeanUrl = actionBeans.editfeature);
}, edit:function(a, b, c, d) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{application:this.config.viewerController.app.id, appLayer:a.id, feature:Ext.JSON.encode(b)}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? a.hasOwnProperty("__fid") ? c(a.__fid) : c(null) : void 0 != d && d(a.error);
  }, failure:function(a) {
    void 0 != d && d("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}, remove:function(a, b, c, d) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{application:this.config.viewerController.app.id, appLayer:a.id, feature:Ext.JSON.encode(b), "delete":"d"}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? c() : void 0 != d && d(a.error);
  }, failure:function(a) {
    void 0 != d && d("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}});
Ext.define("viewer.ArcQueryUtil", {config:{actionbeanUrl:null}, constructor:function(a) {
  this.initConfig(a);
  null == this.config.actionbeanUrl && (this.config.actionbeanUrl = actionBeans.arcqueryutil);
}, cqlToArcXMLSpatialQuery:function(a, b, c) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{cql:a}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? b(a.SPATIALQUERY) : void 0 != c && c(a.error);
  }, failure:function(a) {
    void 0 != c && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}, cqlToArcXMLWhere:function(a, b, c) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{cql:a, whereOnly:!0}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? b(a.where) : void 0 != c && c(a.error);
  }, failure:function(a) {
    void 0 != c && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}, cqlToArcFIDS:function(a, b, c, d) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{cql:a, getObjectIds:!0, appLayer:b, application:appId}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? c(a.objectIds, a.objectIdFieldName) : void 0 != d && d(a.message);
  }, failure:function(a) {
    void 0 != d && d("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}});
Ext.define("viewer.FeatureExtent", {config:{actionbeanUrl:null}, constructor:function(a) {
  this.initConfig(a);
  null === this.config.actionbeanUrl && (this.config.actionbeanUrl = actionBeans.featureExtent);
}, getExtentForFeatures:function(a, b, c, d, e) {
  Ext.isArray(a) || (a = [a]);
  a = ["IN ('", a.join("','"), "')"].join("");
  this._doRequest(a, b, c, d, e);
}, getExtentForFilter:function(a, b, c, d, e) {
  "" === a && (a = "include");
  this._doRequest(a, b, c, d, e);
}, _doRequest:function(a, b, c, d, e) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{buffer:c, filter:a, appLayer:b.id}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? d(a.extent) : "undefined" !== typeof e && e(a.error);
  }, failure:function(a) {
    "undefined" !== typeof e && e("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText);
  }});
}});
Ext.define("viewer.viewercontroller.controller.Map", {extend:"Ext.util.Observable", events:[], layers:[], frameworkMap:null, enabledEvents:{}, config:{id:null, mapComponent:null, viewerController:null, options:null}, constructor:function(a) {
  viewer.viewercontroller.controller.Map.superclass.constructor.call(this, a);
  this.initConfig(a);
  return this;
}, fire:function(a, b) {
  this.fireEvent(a, this, b);
}, getFrameworkMap:function() {
  return this.frameworkMap;
}, addLayers:function(a) {
  for (var b = 0;b < a.length;b++) {
    this.addLayer(a[b]);
  }
}, getLayers:function() {
  void 0 == this.layers && (this.layers = []);
  return this.layers;
}, getLayer:function(a) {
  for (var b = 0;b < this.layers.length;b++) {
    if (a == this.layers[b].getId()) {
      return this.layers[b];
    }
  }
  return null;
}, removeLayerById:function(a) {
  this.removeLayer(this.getLayer(a));
}, removeAllLayers:function() {
  for (var a = this.layers.length - 1;0 <= a;a--) {
    this.removeLayer(this.layers[a]);
  }
}, getLayerIndex:function(a) {
  for (var b = 0;b < this.getLayers().length;b++) {
    if (this.getLayers()[b] == a) {
      return b;
    }
  }
  return -1;
}, addLayer:function(a) {
  this.layers.push(a);
  a.setMap(this);
}, removeLayer:function(a) {
  a = this.getLayerIndex(a);
  -1 == a ? this.config.viewerController.logger.warning("Map.removeLayer(): Layer not available in map!") : this.layers.splice(a, 1);
}, setLayerIndex:function(a, b) {
  a instanceof viewer.viewercontroller.controller.Layer || Ext.Error.raise({msg:"Given layer not of type Layer"});
  var c = this.getLayerIndex(a), d = [], e = this.getLayers(), f = e.length, g = 0;
  e.splice(c, 1);
  for (var h = 0;h < f;h++) {
    b == h ? d.push(a) : (d.push(e[g]), g++);
  }
  this.layers = d;
  return c;
}, setLayerVisible:function(a, b) {
  this.config.viewerController.app.appLayers[a.appLayerId].checked = b;
}, getId:function() {
  Ext.Error.raise({msg:"Map.getId() Not implemented! Must be implemented in sub-class"});
}, getAllWMSLayers:function() {
  Ext.Error.raise({msg:"Map.getAllWMSLayers() Not implemented! Must be implemented in sub-class"});
}, getAllVectorLayers:function() {
  Ext.Error.raise({msg:"Map.getAllVectorLayers() Not implemented! Must be implemented in sub-class"});
}, remove:function() {
  Ext.Error.raise({msg:"Map.remove() Not implemented! Must be implemented in sub-class"});
}, zoomToExtent:function(a) {
  Ext.Error.raise({msg:"Map.moveToExtent() Not implemented! Must be implemented in sub-class"});
}, zoomToMaxExtent:function() {
  Ext.Error.raise({msg:"Map.zoomToMaxExtent() Not implemented! Must be implemented in sub-class"});
}, zoomToScale:function(a) {
  Ext.Error.raise({msg:"Map.zoomToScale() Not implemented! Must be implemented in sub-class"});
}, zoomToResolution:function(a) {
  Ext.Error.raise({msg:"Map.zoomToResolution() Not implemented! Must be implemented in sub-class"});
}, moveTo:function(a, b) {
  Ext.Error.raise({msg:"Map.moveTo() Not implemented! Must be implemented in sub-class"});
}, getExtent:function() {
  Ext.Error.raise({msg:"Map.getExtent() Not implemented! Must be implemented in sub-class"});
}, setMaxExtent:function(a) {
  Ext.Error.raise({msg:"Map.setMaxExtent() Not implemented! Must be implemented in sub-class"});
}, getMaxExtent:function() {
  Ext.Error.raise({msg:"Map.getFullExtent() Not implemented! Must be implemented in sub-class"});
}, doIdentify:function(a, b) {
  Ext.Error.raise({msg:"Map.doIdentify() Not implemented! Must be implemented in sub-class"});
}, update:function() {
  Ext.Error.raise({msg:"Map.update() Not implemented! Must be implemented in sub-class"});
}, setMarker:function(a, b, c, d) {
  Ext.Error.raise({msg:"Map.setMarker() Not implemented! Must be implemented in sub-class"});
}, removeMarker:function(a) {
  Ext.Error.raise({msg:"Map.removeMarker() Not implemented! Must be implemented in sub-class"});
}, getScale:function() {
  Ext.Error.raise({msg:"Map.getScale() Not implemented! Must be implemented in sub-class"});
}, getResolution:function() {
  Ext.Error.raise({msg:"Map.getResolution() Not implemented! Must be implemented in sub-class"});
}, getResolutions:function() {
  Ext.Error.raise({msg:"Map.getResolutions() Not implemented! Must be implemented in sub-class"});
}, coordinateToPixel:function(a, b) {
  Ext.Error.raise({msg:"Map.coordinateToPixel() Not implemented! Must be implemented in sub-class"});
}, getCenter:function() {
  Ext.Error.raise({msg:"Map.getCenter() Not implemented! Must be implemented in sub-class"});
}, getWidth:function() {
  Ext.Error.raise({msg:"Map.getWidth() Not implemented! Must be implemented in sub-class"});
}, getHeight:function() {
  Ext.Error.raise({msg:"Map.getHeight() Not implemented! Must be implemented in sub-class"});
}, updateSize:function() {
  Ext.Error.raise({msg:"Map.updateSize() Not implemented! Must be implemented in sub-class"});
}});
Ext.define("viewer.viewercontroller.controller.Layer", {extend:"Ext.util.Observable", statics:{WMS_TYPE:"WMS", ARCSERVER_TYPE:"ARCSERVER", ARCSERVERREST_TYPE:"ARCSERVERREST", ARCIMS_TYPE:"ARCIMS", VECTOR_TYPE:"VECTOR", IMAGE_TYPE:"IMAGE", TILING_TYPE:"TILING"}, maptips:[], map:null, visible:!0, serviceId:null, config:{id:null, options:null, viewerController:null, url:null, appLayerId:null, frameworkLayer:null, details:null}, constructor:function(a) {
  this.initConfig(a);
  this.callParent(arguments);
}, getOption:function(a) {
  for (var b in this.options) {
    if (this.options.hasOwnProperty(b) && b.toLowerCase() === a.toLowerCase()) {
      return this.options[b];
    }
  }
  return null;
}, getFrameworkLayer:function() {
  return this.frameworkLayer || this.config.frameworkLayer;
}, getAppLayerName:function() {
  return this.config.viewerController.app.appLayers[this.appLayerId].layerName;
}, addMapTip:function(a) {
  this.maptips.push(a);
}, setMaptips:function(a) {
  this.maptips = a;
}, getMaptips:function() {
  return this.maptips;
}, getMapTipByFeatureType:function(a) {
  for (var b = 0;b < this.maptips.length;b++) {
    if (this.maptips[b].layer == a || this.maptips[b].aka == a) {
      return this.maptips[b];
    }
  }
  return null;
}, getMap:function() {
  return this.map;
}, setMap:function(a) {
  this.map = a;
}, getDetails:function() {
  return this.appLayerId ? this.config.viewerController.app.appLayers[this.appLayerId].details : this.details;
}, getType:function() {
  Ext.Error.raise({msg:"Layer.getType() Not implemented! Must be implemented in sub-class"});
}, setOption:function(a, b) {
  Ext.Error.raise({msg:"Layer.getOption() Not implemented! Must be implemented in sub-class"});
}, getLayers:function() {
  Ext.Error.raise({msg:"Get layers must be implemented by implementation"});
}, setAlpha:function(a) {
  Ext.Error.raise({msg:"Layer.setAlpha() Not implemented! Must be implemented in sub-class"});
}, setVisible:function(a) {
  Ext.Error.raise({msg:"Layer.setVisible() Not implemented! Must be implemented in sub-class"});
}, getVisible:function() {
  Ext.Error.raise({msg:"Layer.getVisible() Not implemented! Must be implemented in sub-class"});
}, setQuery:function(a) {
  Ext.Error.raise({msg:"Layer.setQuery() Not implemented! Must be implemented in sub-class"});
}, getLayerLegendInfo:function() {
  Ext.Error.raise({msg:"Layer.getLayerLegendInfo() Not implemented! Must be implemented in sub-class"});
}, getLastMapRequest:function() {
  Ext.Error.raise({msg:"Layer.getLastMapRequest() Not implemented! Must be implemented in sub-class"});
}, reload:function() {
  Ext.Error.raise({msg:"Layer.reload() Not implemented! Must be implemented in sub-class"});
}, fire:function(a, b) {
  this.fireEvent(a, this, b);
}, destroy:function() {
  this.clearListeners();
  viewer.viewercontroller.controller.Layer.superclass.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.controller.TilingLayer", {extend:"viewer.viewercontroller.controller.Layer", config:{protocol:null, resolutions:null, serviceEnvelope:null, tileWidth:null, tileHeight:null, extension:null}, constructor:function(a) {
  viewer.viewercontroller.controller.TilingLayer.superclass.constructor.call(this, a);
  this.type = viewer.viewercontroller.controller.Layer.TILING_TYPE;
}, setQuery:function(a) {
}, getLayerLegendInfo:function() {
  return null;
}});
Ext.define("viewer.viewercontroller.controller.WMSLayer", {extend:"viewer.viewercontroller.controller.Layer", constructor:function(a) {
  viewer.viewercontroller.controller.WMSLayer.superclass.constructor.call(this, a);
  this.type = viewer.viewercontroller.controller.Layer.WMS_TYPE;
  this.url = a.options.url;
}, getLayerLegendInfo:function(a, b) {
  var c = this.id;
  this.appLayerId && (c = this.config.viewerController.getAppLayerById(this.appLayerId).alias);
  a({name:c, parts:[{url:this.getLegendGraphic()}]});
}, getLegendGraphic:function() {
  var a = {REQUEST:"GetLegendGraphic", LAYER:this.getAppLayerName(), VERSION:"1.1.1", FORMAT:"image/png"};
  this.getOption("sld") && (a.SLD = this.getOption("SLD"));
  this.getOption("sld_body") && (a.SLD_BODY = this.getOption("SLD_BODY"));
  this.config.sldLegendStyle && (a.STYLE = this.config.sldLegendStyle);
  this.config.extraLegendParameters && Ext.Object.merge(a, this.config.extraLegendParameters);
  return url = Ext.urlAppend(this.url, Ext.Object.toQueryString(a));
}});
Ext.define("viewer.viewercontroller.controller.ImageLayer", {extend:"viewer.viewercontroller.controller.Layer", config:{extent:null}, constructor:function(a) {
  viewer.viewercontroller.controller.ImageLayer.superclass.constructor.call(this, a);
  this.type = viewer.viewercontroller.controller.Layer.IMAGE_TYPE;
}, setExtent:function(a) {
  Ext.Error.raise({msg:"ImageLayer.setExtent() Not implemented! Must be implemented in sub-class"});
}, getLayerLegendInfo:function() {
  return null;
}});
Ext.define("viewer.viewercontroller.controller.VectorLayer", {extend:"viewer.viewercontroller.controller.Layer", config:{geometrytypes:null, showmeasures:null, editable:!0, labelPropertyName:null, style:{fillcolor:"0xFF0000", fillopacity:50, strokecolor:"0xFF0000", strokeopacity:100}, colorPrefix:null, defaultFeatureStyle:null, addStyleToFeature:!1, addAttributesToFeature:!1, allowselection:!0}, constructor:function(a) {
  viewer.viewercontroller.controller.VectorLayer.superclass.constructor.call(this, a);
}, removeAllFeatures:function() {
  Ext.Error.raise({msg:"VectorLayer.removeAllFeatures() Not implemented! Must be implemented in sub-class"});
}, removeFeature:function(a) {
  Ext.Error.raise({msg:"VectorLayer.removeFeature() Not implemented! Must be implemented in sub-class"});
}, getActiveFeature:function() {
  Ext.Error.raise({msg:"VectorLayer.getActiveFeature() Not implemented! Must be implemented in sub-class"});
}, getFeature:function(a) {
  Ext.Error.raise({msg:"VectorLayer.getFeature() Not implemented! Must be implemented in sub-class"});
}, getFeatureById:function(a) {
  Ext.Error.raise({msg:"VectorLayer.getFeatureById() Not implemented! Must be implemented in sub-class"});
}, getAllFeatures:function() {
  Ext.Error.raise({msg:"VectorLayer.getAllFeatures() Not implemented! Must be implemented in sub-class"});
}, addFeature:function(a) {
  Ext.Error.raise({msg:"VectorLayer.addFeature() Not implemented! Must be implemented in sub-class"});
}, addFeatures:function(a) {
  Ext.Error.raise({msg:"VectorLayer.addFeatures() Not implemented! Must be implemented in sub-class"});
}, drawFeature:function(a) {
  Ext.getDoc().on("keydown", this._keyListener, this);
}, stopDrawing:function() {
  Ext.getDoc().un("keydown", this._keyListener, this);
}, _keyListener:function(a, b, c) {
  switch(a.keyCode) {
    case 90:
      (a.metaKey || a.ctrlKey) && this.undoSketch();
      break;
    case 89:
      (a.metaKey || a.ctrlKey) && this.redoSketch();
      break;
    case 27:
      this.cancelSketch();
  }
}, undoSketch:function() {
  Ext.Error.raise({msg:"VectorLayer.undoSketch() Not implemented! Must be implemented in sub-class"});
}, redoSketch:function() {
  Ext.Error.raise({msg:"VectorLayer.redoSketch() Not implemented! Must be implemented in sub-class"});
}, cancelSketch:function() {
  Ext.Error.raise({msg:"VectorLayer.cancelSketch() Not implemented! Must be implemented in sub-class"});
}, frameworkStyleToFeatureStyle:function(a) {
  Ext.Error.raise({msg:"VectorLayer.frameworkStyleToFeatureStyle() Not implemented! Must be implemented in sub-class"});
}});
Ext.define("viewer.viewercontroller.controller.ArcLayer", {extend:"viewer.viewercontroller.controller.Layer", legendInfoCache:{}, constructor:function(a) {
  viewer.viewercontroller.controller.ArcLayer.superclass.constructor.call(this, a);
}, getLayerLegendInfo:function(a, b) {
  this.getType() == viewer.viewercontroller.controller.Layer.ARCSERVER_TYPE || this.getType() == viewer.viewercontroller.controller.Layer.ARCSERVERREST_TYPE ? this.getLayerLegendInfoArcGIS(function(b) {
    var d = {name:b.layerName, parts:[]}, e;
    for (e in b.legend) {
      if (b.legend.hasOwnProperty(e)) {
        var f = b.legend[e];
        d.parts.push({label:f.label, url:"data:" + f.contentType + ";base64," + f.imageData});
      }
    }
    a(d);
  }, b) : (this.getViewerController().logger.warn("appLayer " + this.getAppLayerId() + ": legend for ArcXML layers not supported"), b());
}, getLayerLegendInfoArcGIS:function(a, b) {
  var c = this, d = "appLayer " + this.getAppLayerId() + ": legend for ArcGIS not available: ", e = this.appLayerId, f = this.getViewerController().getAppLayerById(e), e = this.getViewerController().app.services[f.serviceId];
  if (e.arcGISVersion) {
    if (10 > e.arcGISVersion.major) {
      this.getViewerController().logger.warn(d + "needs at least ArcGIS Server version 10 but version is " + e.arcGISVersion.s), b();
    } else {
      var g = this.legendInfoCache[e.url];
      if (g && g.failedPreviously) {
        b();
      } else {
        var h = function(c) {
          (c = c[f.layerName]) ? a(c) : b();
        };
        g && !g.inProgress ? h(g) : g && g.inProgress ? g.joiners.push({success:h, failure:b}) : (g = {inProgress:!0, joiners:[]}, this.legendInfoCache[e.url] = g, Ext.data.JsonP.request({url:e.url + "/legend", params:{f:"json"}, disableCaching:!1, success:function(a) {
          for (var b in a.layers) {
            if (a.layers.hasOwnProperty(b)) {
              var c = a.layers[b];
              g[c.layerId] = c;
            }
          }
          g.inProgress = !1;
          h(g);
          for (b = 0;b < g.joiners.length;b++) {
            g.joiners[b].success(g);
          }
          delete g.joiners;
        }, failure:function(a) {
          g.failedPreviously = !0;
          g.inProgress = !1;
          c.getViewerController().logger.error(d + "error retrieving legend JSON from ArcGIS: " + a);
          b();
          for (a = 0;a < g.joiners.length;a++) {
            g.joiners[a].failure();
          }
          delete g.joiners;
        }}));
      }
    }
  } else {
    this.getViewerController().logger.warn(d + "no server version info, please update service registry"), b();
  }
}, getId:function() {
  Ext.Error.raise({msg:"ArcLayer.getId() Not implemented! Must be implemented in sub-class"});
}, reload:function() {
  Ext.Error.raise({msg:"ArcLayer.reload() Not implemented! Must be implemented in sub-class"});
}, getName:function() {
  Ext.Error.raise({msg:"ArcLayer.getName() Not implemented! Must be implemented in sub-class"});
}, getServer:function() {
  Ext.Error.raise({msg:"ArcLayer.getServer() Not implemented! Must be implemented in sub-class"});
}, getService:function() {
  Ext.Error.raise({msg:"ArcLayer.getService() Not implemented! Must be implemented in sub-class"});
}, getServlet:function() {
  Ext.Error.raise({msg:"ArcLayer.getServlet() Not implemented! Must be implemented in sub-class"});
}, getMapservice:function() {
  Ext.Error.raise({msg:"ArcLayer.getMapservice() Not implemented! Must be implemented in sub-class"});
}, getLayers:function() {
  Ext.Error.raise({msg:"ArcLayer.getLayers() Not implemented! Must be implemented in sub-class"});
}, setMaptips:function(a) {
  Ext.Error.raise({msg:"ArcLayer.setMaptips() Not implemented! Must be implemented in sub-class"});
}, passMaptips:function() {
  Ext.Error.raise({msg:"ArcLayer.passMaptips() Not implemented! Must be implemented in sub-class"});
}, setVisible:function(a) {
  Ext.Error.raise({msg:"ArcLayer.setVisible() Not implemented! Must be implemented in sub-class"});
}, getLegendGraphic:function() {
  Ext.Error.raise({msg:"ArcLayer.getLegendGraphic() Not implemented! Must be implemented in sub-class"});
}, setBuffer:function(a, b) {
  Ext.Error.raise({msg:"ArcLayer.setBuffer() Not implemented! Must be implemented in sub-class"});
}, removeBuffer:function(a) {
  Ext.Error.raise({msg:"ArcLayer.removeBuffer() Not implemented! Must be implemented in sub-class"});
}});
Ext.define("viewer.viewercontroller.controller.Feature", {config:{id:null, wktgeom:null, color:null, label:null, style:null, attributes:{}}, constructor:function(a) {
  this.initConfig(a);
  this.label || (this.label = "");
}, getStyle:function() {
  return this.config.style;
}, getAttributes:function() {
  return this.config.attributes;
}, toJsonObject:function() {
  var a = {};
  a.id = this._id;
  a.wktgeom = this._wktgeom;
  a.color = this.color;
  a.label = this.label;
  return a;
}, getExtent:function() {
  if (null === this._wktgeom) {
    return null;
  }
  var a = this._wktgeom.match(/(\d+[\.]?\d*)/g);
  if (null === a) {
    return null;
  }
  for (var b = [], c = [], d = 0;d < a.length;d++) {
    0 === d % 2 ? b.push(parseFloat(a[d])) : c.push(parseFloat(a[d]));
  }
  return Ext.create("viewer.viewercontroller.controller.Extent", Ext.Array.min(b), Ext.Array.min(c), Ext.Array.max(b), Ext.Array.max(c));
}});
Ext.define("viewer.viewercontroller.controller.FeatureStyle", {config:{label:null, labelOutlineColor:null, labelOutlineWidth:null, labelAlign:null, fontSize:null, fontColor:null, rotation:null, labelXOffset:null, labelYOffset:null, fillColor:null, fillOpacity:null, strokeColor:null, strokeOpacity:null, strokeDashstyle:null, strokeWidth:null, graphicName:null, pointRadius:null}, constructor:function(a) {
  this.initConfig(a);
}, getProperties:function() {
  var a = {}, b;
  for (b in this.config) {
    this.config.hasOwnProperty(b) && null !== this.config[b] && (a[b] = this.config[b]);
  }
  return a;
}, set:function(a, b) {
  this.config[a] = b;
}});
function MapTip(a, b, c) {
  this.layer = a;
  this.mapTipField = b;
  this.aka = c;
}
;Ext.define("viewer.viewercontroller.controller.Extent", {minx:null, maxx:null, miny:null, maxy:null, constructor:function(a, b, c, d) {
  void 0 != a && void 0 == b && void 0 == c && void 0 == d ? (a = a.split(","), 4 != a.length && Ext.Error.raise({msg:"Can not create Extent because there is no bbox found"}), this.minx = a[0], this.miny = a[1], this.maxx = a[2], this.maxy = a[3]) : (this.minx = a, this.maxx = c, this.miny = b, this.maxy = d);
  return this;
}, isIn:function(a, b) {
  return null == this.minx || null == this.maxx || null == this.miny || null == this.maxy ? !1 : a >= this.minx && a <= this.maxx && b >= this.miny && b <= this.maxy ? !0 : !1;
}, toWKT:function() {
  var a;
  a = "POLYGON((" + (this.minx + " " + this.miny + ", ");
  a += this.maxx + " " + this.miny + ", ";
  a += this.maxx + " " + this.maxy + ", ";
  a += this.minx + " " + this.maxy + ", ";
  return a += this.minx + " " + this.miny + "))";
}, equals:function(a) {
  return null == a || this.minx != a.minx || this.miny != a.miny || this.maxx != a.maxx || this.maxy != a.maxy ? !1 : !0;
}, expand:function(a) {
  this.minx = Math.min(this.minx, a.minx);
  this.miny = Math.min(this.miny, a.miny);
  this.maxx = Math.max(this.maxx, a.maxx);
  this.maxy = Math.max(this.maxy, a.maxy);
}, buffer:function(a) {
  this.minx -= a;
  this.miny -= a;
  this.maxx += a;
  this.maxy += a;
}, toString:function() {
  return "" + (this.minx + "," + this.miny + "," + this.maxx + "," + this.maxy);
}});
Ext.define("viewer.viewercontroller.controller.Event", {statics:{ON_CONFIG_COMPLETE:"ON_CONFIG_COMPLETE", ON_SET_TOOL:"ON_SET_TOOL", ON_GET_FEATURE_INFO_PROGRESS:"ON_GET_FEATURE_INFO_PROGRESS", ON_GET_FEATURE_INFO:"ON_GET_FEATURE_INFO", ON_GET_FEATURE_INFO_DATA:"ON_GET_FEATURE_INFO_DATA", ON_ALL_LAYERS_LOADING_COMPLETE:"ON_ALL_LAYERS_LOADING_COMPLETE", ON_CHANGE_EXTENT:"ON_CHANGE_EXTENT", ON_FINISHED_CHANGE_EXTENT:"ON_FINISHED_CHANGE_EXTENT", ON_LAYERS_INITIALIZED:"ON_LAYERS_INITIALIZED", ON_LAYER_ADDED:"ON_LAYER_ADDED", 
ON_LAYER_REMOVED:"ON_LAYER_REMOVED", ON_LAYER_CLICKED:"ON_LAYER_CLICKED", ON_MAPTIP_CANCEL:"ON_MAPTIP_CANCEL", ON_GET_CAPABILITIES:"ON_REQUEST", ON_REQUEST:"ON_REQUEST", ON_LOADING_START:"ON_LOADING_START", ON_LOADING_END:"ON_LOADING_END", ON_MAPTIP:"ON_MAPTIP", ON_MAPTIP_DATA:"ON_MAPTIP_DATA", ON_EVENT_DOWN:"ON_EVENT_DOWN", ON_EVENT_UP:"ON_EVENT_UP", ON_EVENT_OVER:"ON_EVENT_OVER ", ON_CLICK:"ON_CLICK", ON_HELP:"ON_HELP", ON_MEASURE:"ON_MEASURE", ON_ONIT:"ON_ONIT", ON_LAYER_VISIBILITY_CHANGED:"ON_LAYER_VISIBILITY_CHANGED", 
ON_LAYERSELECTOR_CHANGE:"ON_LAYERSELECTOR_CHANGE", ON_LAYERSELECTOR_INITLAYERS:"ON_LAYERSELECTOR_INITLAYERS", ON_COMPONENTS_FINISHED_LOADING:"ON_COMPONENTS_FINISHED_LOADING", ON_SELECTEDCONTENT_CHANGE:"ON_SELECTEDCONTENT_CHANGE", ON_MAP_CLICKED:"ON_MAP_CLICKED", ON_ACTIVE_FEATURE_CHANGED:"ON_ACTIVE_FEATURE_CHANGED", ON_FEATURE_ADDED:"ON_FEATURE_ADDED", ON_FILTER_ACTIVATED:"ON_FILTER_ACTIVATED", ON_ACTIVATE:"ON_ACTIVATE", ON_DEACTIVATE:"ON_DEACTIVATE", ON_GET_SERVICE_INFO:"ON_GET_SERVICE_INFO", ON_ZOOM_END:"ON_ZOOM_END"}});
Ext.define("viewer.viewercontroller.controller.Tool", {extend:"Ext.util.Observable", statics:{NAVIGATION_HISTORY:1, ZOOMIN_BOX:2, ZOOMOUT_BOX:3, ZOOMIN_BUTTON:26, ZOOMOUT_BUTTON:6, ZOOM:7, PAN:4, SUPERPAN:5, GET_FEATURE_INFO:10, MEASURELINE:11, MEASUREAREA:12, ZOOM_BAR:13, DEFAULT:15, PREVIOUS_EXTENT:19, NEXT_EXTENT:20, FULL_EXTENT:21, MAP_CLICK:22, TOGGLE:23, BUTTON:24, MAP_TOOL:25}, tool:null, mapComponent:null, events:null, blocksDefaultTool:null, config:{id:null, frameworkObject:null, visible:!0, 
type:null, tooltip:null, iconUrl_up:null, iconUrl_over:null, iconUrl_sel:null, iconUrl_dis:null, viewerController:null, preventActivationAsFirstTool:!1}, constructor:function(a) {
  this.initConfig(a);
  viewer.viewercontroller.controller.Tool.superclass.constructor.call(this, this.config);
  this.events = [];
  this.blocksDefaultTool = !0;
  return this;
}, getFrameworkTool:function() {
  return this.frameworkObject;
}, getFrameworkObject:function() {
  return this.frameworkObject;
}, setToolVisible:function() {
  Ext.Error.raise({msg:"Tool.setVisible() not implemented! Must be implemented in sub-class"});
}, fire:function(a, b) {
  this.fireEvent(a, this, b);
}, isActive:function() {
  Ext.Error.raise({msg:"Tool.isActive() not implemented! Must be implemented in sub-class"});
}, activate:function() {
  Ext.Error.raise({msg:"Tool.activate() not implemented! Must be implemented in sub-class"});
}, deactivate:function() {
  Ext.Error.raise({msg:"Tool.deactivate() not implemented! Must be implemented in sub-class"});
}, getVisible:function() {
  return this.config.visible;
}});
Ext.define("viewer.viewercontroller.controller.Component", {extend:"Ext.util.Observable", config:{id:null, frameworkObject:null, type:-1, viewerController:null}, constructor:function(a) {
  this.initConfig(a);
  return this;
}, statics:{LOADING_BAR:1, SCALEBAR:2, BORDER_NAVIGATION:3, COORDINATES:4, NAVIGATIONPANEL:5, MAPTIP:6, LOADMONITOR:7, OVERVIEW:8, SNAPPING:9}, setVisible:function(a) {
  Ext.Error.raise({msg:"setVisible() function must be implemented in implementation"});
}, destroy:function() {
  this.clearListeners();
  viewer.viewercontroller.controller.Component.superclass.destroy.call(this);
}, getFrameworkObject:function() {
  return this.frameworkObject;
}});
Ext.define("viewer.viewercontroller.controller.ToolMapClick", {extend:"viewer.viewercontroller.controller.Tool", id:null, config:{name:null}, constructor:function(a) {
  viewer.viewercontroller.controller.ToolMapClick.superclass.constructor.call(this, a);
  return this;
}, activateTool:function() {
  Ext.Error.raise({msg:"ToolMapClick.activateTool() Not implemented! Must be implemented in sub-class"});
}, deactivateTool:function() {
  Ext.Error.raise({msg:"ToolMapClick.deactivateTool() Not implemented! Must be implemented in sub-class"});
}});
Ext.define("viewer.viewercontroller.controller.SnappingController", {extend:"viewer.viewercontroller.controller.Component", config:{mapComponent:null, options:null, style:null}, frameworkLayer:null, frameworkControl:null, snapLayers:[], snapLayers_prefix:"snapping_", constructor:function(a) {
  viewer.viewercontroller.controller.SnappingController.superclass.constructor.call(this, a);
  a.id = a.name;
  a.type = viewer.viewercontroller.controller.Component.SNAPPING;
  this.initConfig(a);
  return this;
}, addAppLayer:function(a) {
  Ext.Error.raise({msg:"SnappingController.addAppLayer() Not implemented! Must be implemented in sub-class"});
}, removeAll:function() {
  Ext.Error.raise({msg:"SnappingController.removeAll() Not implemented! Must be implemented in sub-class"});
}, removeLayer:function(a) {
  Ext.Error.raise({msg:"SnappingController.removeLayer() Not implemented! Must be implemented in sub-class"});
}, activate:function() {
  Ext.Error.raise({msg:"SnappingController.activate() Not implemented! Must be implemented in sub-class"});
}});
