/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.image;

import com.sun.imageio.plugins.png.PNGMetadata;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import nl.b3p.viewer.image.Bbox;
import nl.b3p.viewer.image.CombineImageSettings;
import nl.b3p.viewer.image.CombineImageWkt;
import nl.b3p.viewer.image.FeatureStyle;
import nl.b3p.viewer.image.ImageBbox;
import nl.b3p.viewer.image.ReferencedImage;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;

public class ImageTool {
    private static final Log log = LogFactory.getLog(ImageTool.class);
    private BufferedImage bi;
    public static final String TIFF = "image/tiff";
    public static final String GIF = "image/gif";
    public static final String JPEG = "image/jpeg";
    public static final String PNG = "image/png";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImage(HttpMethod method, String mime) throws Exception {
        ImageReader ir = null;
        BufferedImage i = null;
        try {
            String mimeType;
            if (mime.indexOf(";") != -1) {
                mime = mime.substring(0, mime.indexOf(";"));
            }
            if ((mimeType = ImageTool.getMimeType(mime)) == null) {
                mimeType = PNG;
            }
            if (mimeType == null) {
                log.error((Object)("Response from server not understood (mime = " + mime + "): " + method.getResponseBodyAsString()));
                throw new Exception("Response from server not understood (mime = " + mime + "): " + method.getResponseBodyAsString());
            }
            ir = ImageTool.getReader(mimeType);
            if (ir == null) {
                log.error((Object)("no reader available for imageformat: " + mimeType.substring(mimeType.lastIndexOf("/") + 1)));
                throw new Exception("no reader available for imageformat: " + mimeType.substring(mimeType.lastIndexOf("/") + 1));
            }
            InputStream is = method.getResponseBodyAsStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int bytesRead = 0;
            byte[] buffer = new byte[2048];
            while (bytesRead != -1) {
                bytesRead = is.read(buffer, 0, buffer.length);
                if (bytesRead <= 0) continue;
                baos.write(buffer, 0, bytesRead);
            }
            ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(baos.toByteArray()));
            ir.setInput(stream, true);
            i = ir.read(0);
            if (!i.getColorModel().hasAlpha() && ir.getImageMetadata(0) instanceof PNGMetadata) {
                PNGMetadata metadata = (PNGMetadata)ir.getImageMetadata(0);
                if (metadata.tRNS_present) {
                    int alphaPix = metadata.tRNS_red << 16 | metadata.tRNS_green << 8 | metadata.tRNS_blue;
                    BufferedImage tmp = new BufferedImage(i.getWidth(), i.getHeight(), 2);
                    for (int x = 0; x < i.getWidth(); ++x) {
                        for (int y = 0; y < i.getHeight(); ++y) {
                            int rgb = i.getRGB(x, y);
                            rgb = (rgb & 0xFFFFFF) == alphaPix ? alphaPix : rgb;
                            tmp.setRGB(x, y, rgb);
                        }
                    }
                    i = tmp;
                }
            }
        }
        finally {
            if (ir != null) {
                ir.dispose();
            }
        }
        return i;
    }

    public static void writeImage(BufferedImage image, String mime, OutputStream os) throws Exception {
        String mimeType = ImageTool.getMimeType(mime);
        if (mimeType == null) {
            log.error((Object)("unsupported mime type: " + mime));
            throw new Exception("unsupported mime type: " + mime);
        }
        if (mime.equals(TIFF)) {
            ImageTool.writeTIFFImage(image, os);
        } else {
            ImageTool.writeOtherImage(image, os, mimeType.substring(mimeType.lastIndexOf("/") + 1));
        }
    }

    public static BufferedImage drawGeometries(BufferedImage bi, CombineImageSettings settings) throws Exception {
        int srid = 28992;
        if (settings.getSrid() != null) {
            srid = settings.getSrid();
        }
        int width = 500;
        int height = 500;
        ImageBbox imbbox = settings.getRequestBbox();
        if (imbbox.getWidth() != null && imbbox.getHeight() != null) {
            width = imbbox.getWidth();
            height = imbbox.getHeight();
        } else {
            Integer[] hw = settings.getWidthAndHeightFromUrls();
            if (hw != null && hw.length == 2) {
                width = hw[0];
                height = hw[1];
            }
        }
        Bbox bbox = imbbox.getBbox();
        if (bbox == null) {
            bbox = settings.getBbox();
        }
        if (bbox == null) {
            bbox = settings.getBboxFromUrls();
        }
        if (bbox == null) {
            log.error((Object)"No BBOX found");
            throw new Exception("Can't find bbox in settings or URL");
        }
        return ImageTool.drawGeometries(bi, settings, srid, bbox, width, height);
    }

    public static BufferedImage drawGeometries(BufferedImage bi, CombineImageSettings settings, int srid, Bbox bbox, int width, int height) throws Exception {
        List wktGeoms = settings.getWktGeoms();
        if (wktGeoms == null || wktGeoms.size() <= 0) {
            return bi;
        }
        BufferedImage newBufIm = new BufferedImage(width, height, 3);
        Graphics2D gbi = newBufIm.createGraphics();
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        RenderingHints rh = new RenderingHints(hints);
        gbi.setRenderingHints(rh);
        gbi.drawImage((Image)bi, 0, 0, null);
        Font font = gbi.getFont().deriveFont(1, gbi.getFont().getSize());
        int yoffset = gbi.getFontMetrics().getHeight() / 2;
        for (int i = 0; i < wktGeoms.size(); ++i) {
            gbi.setComposite(AlphaComposite.getInstance(3, 0.5f));
            CombineImageWkt ciw = (CombineImageWkt)wktGeoms.get(i);
            FeatureStyle fs = ciw.getStyle();
            font = font.deriveFont(fs.getFontSize());
            float strokeWidth = fs.getStrokeWidth().floatValue();
            double pointRadius = fs.getPointRadius();
            gbi.setStroke(new BasicStroke(strokeWidth));
            gbi.setComposite(AlphaComposite.getInstance(3, fs.getFillOpacity().floatValue()));
            gbi.setColor(fs.getFillColor());
            String wktGeom = ciw.getWktGeom();
            Geometry geom = ImageTool.geometrieFromText(wktGeom, srid);
            Shape shape = ImageTool.createImage(geom, srid, bbox, width, height);
            java.awt.Point centerPoint = null;
            if (geom instanceof Polygon || geom instanceof MultiPolygon) {
                gbi.setComposite(AlphaComposite.getInstance(3, fs.getFillOpacity().floatValue()));
                gbi.fill(shape);
                gbi.setColor(fs.getStrokeColor());
                gbi.setComposite(AlphaComposite.getInstance(3, fs.getStrokeOpacity().floatValue()));
                gbi.draw(shape);
            } else if (geom instanceof Point) {
                int pointwidth = (int)pointRadius * 2;
                int pointheight = (int)pointRadius * 2;
                int xpointoffset = -pointwidth / 2;
                int ypointoffset = -pointheight / 2;
                centerPoint = ImageTool.calculateCenter(shape, srid, bbox, width, height, xpointoffset, ypointoffset);
                AffineTransform at = gbi.getTransform();
                Shape s = fs.getGraphicName() != null && !fs.getGraphicName().isEmpty() ? ImageTool.drawPointGraphic(centerPoint, fs, xpointoffset, ypointoffset, gbi) : new Ellipse2D.Double(centerPoint.getX(), centerPoint.getY(), pointwidth, pointheight);
                gbi.setComposite(AlphaComposite.getInstance(3, fs.getFillOpacity().floatValue()));
                gbi.fill(s);
                gbi.draw(s);
                gbi.setTransform(at);
            } else if (geom instanceof LineString) {
                BasicStroke stroke;
                String dash = fs.getStrokeDashstyle();
                Color strokecolor = fs.getStrokeColor();
                gbi.setColor(strokecolor);
                switch (dash) {
                    case "dot": {
                        stroke = new BasicStroke(strokeWidth, 0, 2, 0.0f, new float[]{3.0f, 10.0f}, 0.0f);
                        break;
                    }
                    case "dash": {
                        stroke = new BasicStroke(strokeWidth, 0, 2, 0.0f, new float[]{13.0f, 7.0f}, 0.0f);
                        break;
                    }
                    default: {
                        stroke = new BasicStroke(strokeWidth);
                    }
                }
                gbi.setStroke(stroke);
                gbi.setComposite(AlphaComposite.getInstance(3, fs.getStrokeOpacity().floatValue()));
                gbi.draw(shape);
            }
            if (ciw.getLabel() == null || ciw.getLabel().isEmpty()) continue;
            gbi.setComposite(AlphaComposite.getInstance(3, 1.0f));
            int xoffset = -1 * (gbi.getFontMetrics().stringWidth(ciw.getLabel()) / 2);
            if (centerPoint == null) {
                centerPoint = ImageTool.calculateCenter(shape, srid, bbox, width, height, 0, 0);
            }
            AffineTransform t = gbi.getTransform();
            double rotation = fs.getRotation();
            AffineTransform rot = new AffineTransform(t);
            rot.rotate(Math.toRadians(rotation), centerPoint.getX(), centerPoint.getY());
            double labelXOffset = fs.getLabelXOffset();
            double labelYOffset = fs.getLabelYOffset();
            centerPoint.translate(xoffset + (int)labelXOffset, yoffset - (int)labelYOffset);
            gbi.setColor(fs.getFontColor());
            BufferedImage b = ImageTool.createStringImage(gbi, ciw.getLabel());
            rot.translate(centerPoint.getX(), centerPoint.getY());
            gbi.drawImage(b, rot, null);
            gbi.setTransform(t);
        }
        gbi.dispose();
        return newBufIm;
    }

    private static BufferedImage createStringImage(Graphics g, String s) {
        int w = g.getFontMetrics().stringWidth(s) + 8;
        int h = g.getFontMetrics().getHeight();
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D gbi = image.createGraphics();
        gbi.setFont(gbi.getFont());
        gbi.setColor(Color.WHITE);
        int halosize = 1;
        gbi.drawString(s, 0, h - g.getFontMetrics().getDescent() - halosize);
        gbi.drawString(s, 0, h - g.getFontMetrics().getDescent() + halosize);
        gbi.drawString(s, -halosize, h - g.getFontMetrics().getDescent());
        gbi.drawString(s, halosize, h - g.getFontMetrics().getDescent());
        gbi.setColor(Color.BLACK);
        gbi.drawString(s, 0, h - g.getFontMetrics().getDescent());
        gbi.dispose();
        return image;
    }

    private static Shape drawPointGraphic(java.awt.Point origin, FeatureStyle fs, int xoffset, int yoffset, Graphics2D gbi) {
        double rotation = fs.getRotation();
        int length = fs.getPointRadius().intValue() * 2;
        int halfLength = length / 2;
        int originX = (int)origin.getX();
        int originY = (int)origin.getY();
        int ycorrected = rotation % 360.0 < 180.0 ? yoffset * 2 : yoffset;
        AffineTransform rot = gbi.getTransform();
        rot.rotate(Math.toRadians(rotation), originX - xoffset, originY + length + yoffset);
        gbi.setTransform(rot);
        int[] x = new int[]{originX - halfLength - xoffset, originX - xoffset, originX + halfLength - xoffset};
        int[] y = new int[]{originY + length - ycorrected, originY - ycorrected, originY + length - ycorrected};
        java.awt.Polygon s = new java.awt.Polygon(x, y, 3);
        return s;
    }

    private static java.awt.Point calculateCenter(Shape shape, int srid, Bbox bbox, int width, int height, int xoffset, int yoffset) throws Exception {
        java.awt.Point centerPoint = new java.awt.Point();
        double x = shape.getBounds2D().getCenterX();
        double y = shape.getBounds2D().getCenterY();
        centerPoint.setLocation(x, y);
        centerPoint = ImageTool.transformToScreen(centerPoint, srid, bbox, width, height);
        centerPoint.translate(xoffset, yoffset);
        return centerPoint;
    }

    public static Shape createImage(Geometry geometrie, int bboxSrid, Bbox bbox, int width, int height) throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(bbox.getMinx(), bbox.getMaxx(), bbox.getMiny(), bbox.getMaxy(), CRS.decode((String)("EPSG:" + bboxSrid)));
        AffineTransform transform = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)re, (Rectangle)new Rectangle(width, height));
        LiteShape ls = new LiteShape(geometrie, transform, false);
        return ls;
    }

    public static java.awt.Point transformToScreen(java.awt.Point source, int bboxSrid, Bbox bbox, int width, int height) throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(bbox.getMinx(), bbox.getMaxx(), bbox.getMiny(), bbox.getMaxy(), CRS.decode((String)("EPSG:" + bboxSrid)));
        AffineTransform transform = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)re, (Rectangle)new Rectangle(width, height));
        java.awt.Point result = new java.awt.Point();
        transform.transform(source, result);
        return result;
    }

    public static Geometry geometrieFromText(String wktgeom, int srid) {
        WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), srid));
        try {
            Geometry geom = wktreader.read(wktgeom);
            return geom;
        }
        catch (ParseException p) {
            log.error((Object)("Can't create geomtry from wkt: " + wktgeom), (Throwable)p);
            return null;
        }
    }

    private static void writeTIFFImage(BufferedImage bufferedImage, OutputStream os) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "tif", baos);
        os.write(baos.toByteArray());
    }

    private static void writeOtherImage(BufferedImage bufferedImage, OutputStream os, String extension) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
        ImageIO.write((RenderedImage)bufferedImage, extension, ios);
        os.write(baos.toByteArray());
        ios.flush();
        ios.close();
    }

    public static BufferedImage combineImages(List<ReferencedImage> images, String mime, Integer width, Integer height) {
        if (mime.equals(JPEG)) {
            return ImageTool.combineJPGImages(images, width, height);
        }
        return ImageTool.combineOtherImages(images, width, height);
    }

    private static BufferedImage combineJPGImages(List<ReferencedImage> images, Integer width, Integer height) {
        if (images.get(0) != null) {
            BufferedImage bi = images.get(0).getImage();
            if (width == null) {
                width = bi.getWidth();
            }
            if (height == null) {
                height = bi.getHeight();
            }
        }
        BufferedImage newBufIm = new BufferedImage(width, height, 1);
        Graphics2D gbi = newBufIm.createGraphics();
        for (ReferencedImage image : images) {
            ImageTool.drawImage(gbi, image);
        }
        return newBufIm;
    }

    private static BufferedImage combineOtherImages(List<ReferencedImage> images, Integer width, Integer height) {
        if (images.get(0) != null) {
            BufferedImage bi = images.get(0).getImage();
            if (height == null) {
                height = bi.getHeight();
            }
            if (width == null) {
                width = bi.getWidth();
            }
        }
        BufferedImage newBufIm = new BufferedImage(width, height, 3);
        Graphics2D gbi = newBufIm.createGraphics();
        gbi.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        for (int i = 0; i < images.size(); ++i) {
            ReferencedImage image = images.get(i);
            ImageTool.drawImage(gbi, image);
        }
        return newBufIm;
    }

    private static void drawImage(Graphics2D gbi, ReferencedImage image) {
        if (image.getAlpha() != null) {
            gbi.setComposite(AlphaComposite.getInstance(3, image.getAlpha().floatValue()));
        } else {
            gbi.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        Integer x = image.getX();
        Integer y = image.getY();
        if (x == null) {
            x = 0;
        }
        if (y == null) {
            y = 0;
        }
        if (image.getHeight() != null && image.getWidth() != null) {
            gbi.drawImage(image.getImage(), x, y, image.getWidth(), image.getHeight(), null);
        } else {
            gbi.drawImage((Image)image.getImage(), x, (int)y, null);
        }
    }

    public static String getMimeType(String mime) {
        if ("image/jpg".equalsIgnoreCase(mime)) {
            mime = JPEG;
        }
        String[] mimeTypes = ImageIO.getReaderMIMETypes();
        for (int i = 0; i < mimeTypes.length; ++i) {
            if (!mimeTypes[i].equalsIgnoreCase(mime)) continue;
            return mimeTypes[i];
        }
        return null;
    }

    private static ImageReader getReader(String mime) {
        if (mime.equals(JPEG) || mime.equals(PNG)) {
            return ImageTool.getJPGOrPNGReader(mime);
        }
        return ImageTool.getGIFOrTIFFReader(mime);
    }

    private static ImageReader getJPGOrPNGReader(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageReader imTest = null;
        String name = null;
        while (it.hasNext()) {
            imTest = it.next();
            name = imTest.getClass().getPackage().getName();
            String generalPackage = name.substring(0, name.lastIndexOf("."));
            if (!generalPackage.equalsIgnoreCase("com.sun.media.imageioimpl.plugins")) continue;
        }
        return imTest;
    }

    private static ImageReader getGIFOrTIFFReader(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageReader imTest = null;
        String name = null;
        while (it.hasNext()) {
            imTest = it.next();
            name = imTest.getClass().getPackage().getName();
        }
        return imTest;
    }

    private ImageWriter getWriter(String mime) {
        if (mime.equals(JPEG) || mime.equals(PNG)) {
            return this.getJPGOrPNGWriter(mime);
        }
        return this.getGIFOrTIFFWriter(mime);
    }

    private ImageWriter getJPGOrPNGWriter(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageWriter imTest = null;
        while (it.hasNext()) {
            imTest = (ImageWriter)((Object)it.next());
            String name = imTest.getClass().getPackage().getName();
            String generalPackage = name.substring(0, name.lastIndexOf("."));
            if (!generalPackage.equalsIgnoreCase("com.sun.media.imageioimpl.plugins")) continue;
        }
        return imTest;
    }

    private ImageWriter getGIFOrTIFFWriter(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageWriter imTest = null;
        while (it.hasNext()) {
            imTest = (ImageWriter)((Object)it.next());
        }
        return imTest;
    }

    public static BufferedImage changeColor(BufferedImage im, Color color, Color newColor) {
        for (int x = 0; x < im.getWidth(); ++x) {
            for (int y = 0; y < im.getHeight(); ++y) {
                if (im.getRGB(x, y) != color.getRGB()) continue;
                im.setRGB(x, y, newColor.getRGB());
            }
        }
        return im;
    }
}

