/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.image.Bbox;
import nl.b3p.viewer.image.CombineImageSettings;
import nl.b3p.viewer.image.CombineImageWkt;
import nl.b3p.viewer.image.ImageTool;
import nl.b3p.viewer.util.ChangeMatchCase;
import nl.b3p.viewer.util.FlamingoCQL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.WKTReader2;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/Buffer")
@StrictBinding
public class BufferActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(BufferActionBean.class);
    private ActionBeanContext context;
    @Validate
    private String bbox;
    @Validate
    private Long serviceId;
    @Validate
    private String layerName;
    @Validate
    private Integer width;
    @Validate
    private Integer height;
    @Validate
    private Integer buffer;
    @Validate
    private Integer maxFeatures = 250;
    @Validate
    private String color;
    @Validate
    private String[] features;
    @Validate
    private String filter;
    private final Integer MAX_FEATURES = 250;
    private static final String JSP = "/WEB-INF/jsp/error.jsp";

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getBbox() {
        return this.bbox;
    }

    public void setBbox(String bbox) {
        this.bbox = bbox;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Integer buffer) {
        this.buffer = buffer;
    }

    public Integer getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(Integer maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String[] getFeatures() {
        return this.features;
    }

    public void setFeatures(String[] features) {
        this.features = features;
    }

    @DefaultHandler
    public Resolution image() {
        final CombineImageSettings cis = new CombineImageSettings();
        try {
            cis.setBbox(this.bbox);
            cis.setWidth(this.width);
            cis.setHeight(this.height);
            Color c = Color.RED;
            if (this.color != null) {
                c = Color.decode("#" + this.color);
            }
            cis.setDefaultWktGeomColor(c);
            EntityManager em = Stripersist.getEntityManager();
            List<CombineImageWkt> wkts = this.getFeatures(cis.getBbox(), em);
            cis.setWktGeoms(wkts);
            final BufferedImage bi = ImageTool.drawGeometries(null, cis);
            if (bi != null) {
                StreamingResolution res = new StreamingResolution(cis.getMimeType()){

                    public void stream(HttpServletResponse response) throws Exception {
                        ImageTool.writeImage(bi, cis.getMimeType(), (OutputStream)response.getOutputStream());
                    }
                };
                return res;
            }
            log.info((Object)"No geometries used to draw a buffer");
        }
        catch (Exception e) {
            log.error((Object)"Error generating buffered image", (Throwable)e);
        }
        final BufferedImage empty = new BufferedImage(this.width, this.height, 3);
        StreamingResolution res = new StreamingResolution(cis.getMimeType()){

            public void stream(HttpServletResponse response) throws Exception {
                ImageTool.writeImage(empty, cis.getMimeType(), (OutputStream)response.getOutputStream());
            }
        };
        return res;
    }

    public Resolution bufferGeometry() throws JSONException {
        JSONObject json = new JSONObject();
        JSONArray featureArray = new JSONArray();
        json.put("success", (Object)Boolean.FALSE);
        json.put("features", (Object)featureArray);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 28992);
        WKTReader2 reader = new WKTReader2(gf);
        try {
            for (String feature : this.features) {
                Geometry geom = reader.read(feature);
                Geometry buffered = geom.buffer((double)this.buffer.intValue());
                featureArray.put((Object)buffered.toText());
            }
            json.put("success", (Object)Boolean.TRUE);
        }
        catch (ParseException ex) {
            log.error((Object)"could not parse: ", (Throwable)ex);
            json.put("errorMessage", (Object)ex.getLocalizedMessage());
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CombineImageWkt> getFeatures(Bbox bbox, EntityManager em) throws Exception {
        ArrayList<CombineImageWkt> wkts = new ArrayList<CombineImageWkt>();
        GeoService gs = (GeoService)em.find(GeoService.class, (Object)this.serviceId);
        Layer l = gs.getLayer(this.layerName, em);
        if (l.getFeatureType() == null) {
            throw new Exception("Layer has no feature type");
        }
        FeatureSource fs = l.getFeatureType().openGeoToolsFeatureSource();
        String geomAttribute = fs.getSchema().getGeometryDescriptor().getLocalName();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 28992);
        WKTReader2 reader = new WKTReader2(gf);
        Polygon p = (Polygon)reader.read(bbox.toWKT());
        Intersects featureFilter = ff.intersects((Expression)ff.property(geomAttribute), (Expression)ff.literal((Object)p));
        if (this.filter != null) {
            Filter attributeFilter = FlamingoCQL.toFilter(this.filter, em);
            attributeFilter = (Filter)attributeFilter.accept((FilterVisitor)new ChangeMatchCase(false), null);
            if (this.filter.indexOf("POINT") == -1) {
                And and = ff.and((Filter)featureFilter, attributeFilter);
                featureFilter = and;
            } else {
                featureFilter = attributeFilter;
            }
        }
        Query q = new Query(fs.getName().toString());
        q.setFilter((Filter)featureFilter);
        q.setMaxFeatures(Math.min(this.maxFeatures, this.MAX_FEATURES));
        FeatureIterator it = fs.getFeatures(q).features();
        try {
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Geometry g = (Geometry)f.getDefaultGeometry();
                if (g == null) continue;
                g = g.buffer((double)this.buffer.intValue());
                wkts.add(new CombineImageWkt(g.toText()));
            }
        }
        finally {
            it.close();
            fs.getDataStore().dispose();
        }
        return wkts;
    }
}

