/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.features;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class StreamingShapeWriter {
    protected static final Log log = LogFactory.getLog(StreamingShapeWriter.class);
    private Map props = new HashMap();
    private HashMap<String, ShapefileDataStore> datastores = new HashMap();
    private HashMap<String, FeatureWriter> writers = new HashMap();
    private int featuresGiven = 0;
    private int featuresWritten = 0;
    private String workingDir = null;
    private boolean shapeIndex = true;
    private List<String> skipAttributeNames = null;
    private CoordinateReferenceSystem defaultCoordRefSys = null;

    public StreamingShapeWriter(String workingDir, CoordinateReferenceSystem defaultCoordRefSys) throws IOException {
        this(workingDir);
        this.defaultCoordRefSys = defaultCoordRefSys;
    }

    public StreamingShapeWriter(String workingDir) throws IOException {
        this(workingDir, true);
    }

    public StreamingShapeWriter(String workingDir, boolean shapeIndex, List<String> skipAttributeNames) throws IOException {
        this(workingDir, shapeIndex);
        this.skipAttributeNames = skipAttributeNames;
    }

    public StreamingShapeWriter(String workingDir, boolean shapeIndex) throws IOException {
        this.props.put(ShapefileDataStoreFactory.URLP.key, "");
        this.props.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, shapeIndex);
        this.workingDir = workingDir;
        File testFile = new File(workingDir);
        if (!testFile.exists()) {
            throw new IOException("Given path does not exists");
        }
        if (!testFile.isDirectory()) {
            throw new IOException("Given path is not a directory");
        }
        if (!testFile.canWrite()) {
            throw new IOException("Can't write in given path");
        }
        this.shapeIndex = shapeIndex;
        this.skipAttributeNames = new ArrayList();
        this.skipAttributeNames.add("boundedBy");
    }

    public void write(SimpleFeature f) throws IOException, SAXException, TransformerConfigurationException, TransformerException, ParserConfigurationException, TransformException, FactoryException {
        ++this.featuresGiven;
        Class<MultiPoint> newGeomClass = null;
        String suffix = "";
        if (f.getDefaultGeometry() instanceof Point || f.getDefaultGeometry() instanceof MultiPoint) {
            newGeomClass = MultiPoint.class;
            suffix = "_p";
        } else if (f.getDefaultGeometry() instanceof Polygon || f.getDefaultGeometry() instanceof MultiPolygon) {
            newGeomClass = MultiPolygon.class;
            suffix = "_v";
        } else if (f.getDefaultGeometry() instanceof LineString || f.getDefaultGeometry() instanceof MultiLineString) {
            newGeomClass = MultiLineString.class;
            suffix = "_l";
        } else if (f.getDefaultGeometry() == null) {
            log.error((Object)"No default geometry set.");
        } else {
            log.error((Object)("Geometry type not found: " + f.getDefaultGeometry().getClass().toString()));
        }
        if (newGeomClass != null) {
            String hashKey = this.createHashKey(newGeomClass, f.getType().getTypeName());
            FeatureWriter writer = (FeatureWriter)this.writers.get(hashKey);
            if (writer == null) {
                this.writers.put(hashKey, this.createNewWriter(newGeomClass, f.getType(), suffix));
                writer = (FeatureWriter)this.writers.get(hashKey);
            }
            if (writer != null) {
                this.write(writer, f);
                ++this.featuresWritten;
            } else {
                log.error((Object)("writer for class: " + newGeomClass + " is not created"));
            }
        }
    }

    public void close() {
        Iterator it = this.writers.keySet().iterator();
        while (it.hasNext()) {
            try {
                FeatureWriter writer = (FeatureWriter)this.writers.get(it.next());
                if (writer == null) continue;
                writer.close();
            }
            catch (IOException ioe) {
                log.error((Object)"Error while closing writer: ", (Throwable)ioe);
            }
        }
        it = this.datastores.keySet().iterator();
        while (it.hasNext()) {
            ShapefileDataStore ds = (ShapefileDataStore)this.datastores.get(it.next());
            if (ds == null) continue;
            ds.dispose();
        }
    }

    private void write(FeatureWriter writer, SimpleFeature feature) throws IOException {
        SimpleFeature newFeature = (SimpleFeature)writer.next();
        try {
            boolean geometryAttributeIsMoved = false;
            int indexNewGeomAttribute = newFeature.getFeatureType().indexOf(newFeature.getFeatureType().getGeometryDescriptor().getName());
            int indexOldGeomAttribute = feature.getFeatureType().indexOf(feature.getFeatureType().getGeometryDescriptor().getName());
            if (indexNewGeomAttribute != indexOldGeomAttribute) {
                geometryAttributeIsMoved = true;
            }
            List ads = newFeature.getFeatureType().getAttributeDescriptors();
            for (int i = 0; i < ads.size(); ++i) {
                Name name;
                AttributeDescriptor ad;
                block15: {
                    ad = (AttributeDescriptor)ads.get(i);
                    name = ad.getName();
                    if (feature.getProperty(name) == null) {
                        String new10CharName = name.getLocalPart();
                        if (new10CharName.length() > 10) {
                            new10CharName = new10CharName.substring(0, 10);
                        }
                        ArrayList<Name> validNames = new ArrayList<Name>();
                        List oldAds = feature.getFeatureType().getAttributeDescriptors();
                        for (int a = 0; a < oldAds.size(); ++a) {
                            if (!((AttributeDescriptor)oldAds.get(a)).getName().getLocalPart().startsWith(new10CharName)) continue;
                            validNames.add(((AttributeDescriptor)oldAds.get(a)).getName());
                        }
                        if (validNames.size() == 1) {
                            name = (Name)validNames.get(0);
                        } else if (validNames.size() > 1) {
                            try {
                                int index = 0;
                                if (name.getLocalPart().length() > 10) {
                                    index = new Integer(name.getLocalPart().substring(10, name.getLocalPart().length()));
                                }
                                if (index < validNames.size()) {
                                    name = (Name)validNames.get(index);
                                    break block15;
                                }
                                name = (Name)validNames.get(validNames.size() - 1);
                            }
                            catch (NumberFormatException e) {
                                log.error((Object)"Can't make a number out of the string that is added to the attribute name to make it unique.");
                            }
                        } else {
                            log.debug((Object)"Can't find the correct attribute name.");
                        }
                    }
                }
                newFeature.setAttribute(ad.getName(), feature.getAttribute(name));
            }
            newFeature.setDefaultGeometry(feature.getDefaultGeometry());
        }
        catch (IllegalAttributeException writeProblem) {
            throw new IllegalAttributeException("Could not create " + feature.getFeatureType().getTypeName() + " out of provided SimpleFeature: " + feature.getID() + "\n" + (Object)((Object)writeProblem));
        }
        writer.write();
    }

    private FeatureWriter createNewWriter(Class geomClass, SimpleFeatureType type, String suffix) throws MalformedURLException, IOException {
        String filePath = "";
        filePath = filePath + this.getWorkingDir();
        filePath = type.getTypeName().indexOf(":") >= 0 ? filePath + type.getTypeName().split(":")[1] : filePath + type.getTypeName();
        filePath = filePath + suffix;
        filePath = filePath + ".shp";
        String hashKey = this.createHashKey(geomClass, type.getTypeName());
        ShapefileDataStore ds = (ShapefileDataStore)this.datastores.get(hashKey);
        if (ds == null) {
            ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
            File newShape = new File(filePath);
            this.props.put(ShapefileDataStoreFactory.URLP.key, newShape.toURI().toURL());
            ds = (ShapefileDataStore)factory.createNewDataStore(this.props);
            ds.createSchema(StreamingShapeWriter.changeGeometryBinding((SimpleFeatureType)type, (Class)geomClass));
            this.datastores.put(hashKey, ds);
        }
        if (this.defaultCoordRefSys != null) {
            ds.forceSchemaCRS(this.defaultCoordRefSys);
        }
        String[] typeNames = ds.getTypeNames();
        for (int i = 0; i < typeNames.length; ++i) {
            if (typeNames[i].equals(type.getTypeName())) {
                return ds.getFeatureWriterAppend(type.getTypeName(), Transaction.AUTO_COMMIT);
            }
            if (!typeNames[i].equals(type.getTypeName() + suffix)) continue;
            return ds.getFeatureWriterAppend(type.getTypeName() + suffix, Transaction.AUTO_COMMIT);
        }
        if (ds.getTypeNames().length == 1) {
            return ds.getFeatureWriterAppend(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
        }
        return ds.getFeatureWriterAppend(type.getTypeName() + suffix, Transaction.AUTO_COMMIT);
    }

    private String createHashKey(Class newGeomClass, String typeName) {
        return typeName + " " + newGeomClass.getName();
    }

    public static SimpleFeatureType changeGeometryBinding(SimpleFeatureType ft, Class geomBinding) {
        ArrayList<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>(ft.getAttributeDescriptors());
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(ft);
        if (ft.getGeometryDescriptor() != null) {
            AttributeDescriptor gd = StreamingShapeWriter.changeGeometryBinding((GeometryDescriptor)ft.getGeometryDescriptor(), (Class)geomBinding);
            attributeDescriptors.set(ft.indexOf(ft.getGeometryDescriptor().getName()), gd);
            builder.setDefaultGeometry(ft.getGeometryDescriptor().getName().getLocalPart());
            builder.setAttributes(attributeDescriptors);
        }
        SimpleFeatureType newFt = builder.buildFeatureType();
        return newFt;
    }

    public static AttributeDescriptor changeGeometryBinding(GeometryDescriptor gd, Class geomBinding) {
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.init((AttributeDescriptor)gd);
        builder.setBinding(geomBinding);
        builder.setCRS(gd.getCoordinateReferenceSystem());
        return builder.buildDescriptor(gd.getLocalName());
    }

    public int getFeaturesGiven() {
        return this.featuresGiven;
    }

    public int getFeaturesWritten() {
        return this.featuresWritten;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public boolean isShapeIndex() {
        return this.shapeIndex;
    }

    public List<String> getSkipAttributeNames() {
        return this.skipAttributeNames;
    }

    public void setSkipAttributeNames(List<String> skipAttributeNames) {
        this.skipAttributeNames = skipAttributeNames;
    }
}

