/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.awt.geom.AffineTransform;
import java.io.Reader;
import java.io.StringReader;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opensphere.geometry.algorithm.ConcaveHull;

@UrlBinding(value="/action/ontbrandings")
@StrictBinding
public class OntbrandingsActionBean
implements ActionBean {
    private static final Log LOG = LogFactory.getLog(OntbrandingsActionBean.class);
    private ActionBeanContext context;
    private WKTReader2 wkt;
    private GeometryFactory gf;
    @Validate
    private String features;

    @DefaultHandler
    public Resolution calculate() throws TransformException {
        JSONObject result = new JSONObject();
        result.put("type", (Object)"calculate");
        this.gf = new GeometryFactory(new PrecisionModel(), 28992);
        this.wkt = new WKTReader2(this.gf);
        JSONArray jsonFeatures = new JSONArray(this.features);
        JSONObject mainLocation = null;
        for (JSONObject feature : jsonFeatures) {
            JSONObject attrs = feature.getJSONObject("attributes");
            if (!attrs.getString("type").equals("audienceLocation") || !attrs.getBoolean("mainLocation")) continue;
            mainLocation = feature;
            break;
        }
        JSONArray safetyZones = new JSONArray();
        for (JSONObject feature : jsonFeatures) {
            try {
                JSONArray obs = this.calculateSafetyZone(feature, mainLocation);
                if (obs == null || obs.length() <= 0) continue;
                for (JSONObject g : obs) {
                    safetyZones.put((Object)g);
                }
            }
            catch (ParseException ex) {
                LOG.debug((Object)"Error calculating safetyzone: ", (Throwable)ex);
            }
        }
        result.put("safetyZones", (Object)safetyZones);
        return new StreamingResolution("application/json", (Reader)new StringReader(result.toString()));
    }

    private JSONArray calculateSafetyZone(JSONObject feature, JSONObject mainLocation) throws ParseException, TransformException {
        JSONObject attributes = feature.getJSONObject("attributes");
        String type = attributes.getString("type");
        JSONArray gs = new JSONArray();
        if (type.equals("ignitionLocation")) {
            boolean fan = false;
            fan = attributes.getString("fireworks_type").equals("consumer") ? attributes.getBoolean("zonedistance_consumer_fan") : attributes.getBoolean("zonedistance_professional_fan");
            if (fan) {
                this.calculateFan(feature, mainLocation, gs);
            } else {
                this.calculateNormalSafetyZone(feature, mainLocation, gs);
            }
        }
        return gs;
    }

    private void calculateFan(JSONObject feature, JSONObject mainLocation, JSONArray gs) throws ParseException, TransformException {
        Geometry zone;
        double fanHeight;
        double fanLength;
        JSONObject attributes = feature.getJSONObject("attributes");
        if (attributes.getString("fireworks_type").equals("consumer")) {
            fanLength = attributes.getDouble("zonedistance_consumer_m") * 1.5;
            fanHeight = attributes.getDouble("zonedistance_consumer_m");
        } else {
            fanLength = attributes.getDouble("zonedistance_professional_m") * 1.5;
            fanHeight = attributes.getDouble("zonedistance_professional_m");
        }
        Geometry ignition = this.wkt.read(feature.getString("wktgeom"));
        Geometry audience = this.wkt.read(mainLocation.getString("wktgeom"));
        Geometry boundary = ignition.getBoundary();
        LineString boundaryLS = (LineString)boundary;
        LengthIndexedLine lil = new LengthIndexedLine((Geometry)boundaryLS);
        Point ignitionCentroid = ignition.getCentroid();
        Point audienceCentroid = audience.getCentroid();
        double offset = fanHeight / 2.0;
        int endIndex = (int)lil.getEndIndex();
        Geometry unioned = zone = this.createNormalSafetyZone(feature, ignition);
        double dx = ignitionCentroid.getX() - audienceCentroid.getX();
        double dy = ignitionCentroid.getY() - audienceCentroid.getY();
        double theta = Math.atan2(dy, dx);
        double correctBearing = 1.5707963267948966;
        double rotation = theta - correctBearing;
        int i = 0;
        while (i < endIndex) {
            Coordinate c = lil.extractPoint((double)i);
            Geometry fan = this.createEllipse(c, rotation, fanLength, fanHeight, 220);
            if (!fan.isEmpty()) {
                unioned = unioned.union(fan);
            }
            i = (int)((double)i + offset);
        }
        ConcaveHull con = new ConcaveHull(unioned, fanHeight);
        Geometry g = con.getConcaveHull();
        TopologyPreservingSimplifier tp = new TopologyPreservingSimplifier(g);
        tp.setDistanceTolerance(0.5);
        gs.put((Object)this.createFeature(tp.getResultGeometry(), "safetyZone", ""));
        this.createSafetyDistances(gs, audience, ignition, g);
    }

    private void createSafetyDistances(JSONArray gs, Geometry audience, Geometry ignition, Geometry safetyZone) throws TransformException {
        Point audienceCentroid = audience.getCentroid();
        Point ignitionCentroid = ignition.getCentroid();
        Coordinate[] coords = new Coordinate[]{audienceCentroid.getCoordinate(), ignitionCentroid.getCoordinate()};
        LineString audience2ignition = this.gf.createLineString(coords);
        double dx = ignitionCentroid.getX() - audienceCentroid.getX();
        double dy = ignitionCentroid.getY() - audienceCentroid.getY();
        double length = audience2ignition.getLength();
        double ratioX = dx / length;
        double ratioY = dy / length;
        double fanX = ratioX * 1000.0;
        double fanY = ratioY * 1000.0;
        Point eindLoodlijn = this.gf.createPoint(new Coordinate(ignitionCentroid.getX() + fanX, ignitionCentroid.getY() + fanY));
        Coordinate ancorPoint = ignitionCentroid.getCoordinate();
        double angleRad = Math.toRadians(90.0);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(angleRad, ancorPoint.x, ancorPoint.y);
        AffineTransform2D mathTransform = new AffineTransform2D(affineTransform);
        Geometry rotatedPoint = JTS.transform((Geometry)eindLoodlijn, (MathTransform)mathTransform);
        Coordinate[] loodLijnCoords = new Coordinate[]{ignitionCentroid.getCoordinate(), rotatedPoint.getCoordinate()};
        LineString loodLijn = this.gf.createLineString(loodLijnCoords);
        Geometry cutoffLoodlijn = loodLijn.intersection(safetyZone);
        cutoffLoodlijn = cutoffLoodlijn.difference(ignition);
        gs.put((Object)this.createFeature(cutoffLoodlijn, "safetyDistance", (int)cutoffLoodlijn.getLength() + " m"));
        Coordinate[] endContinuousLine = new Coordinate[]{ignitionCentroid.getCoordinate(), eindLoodlijn.getCoordinate()};
        LineString continuousLine = this.gf.createLineString(endContinuousLine);
        Geometry cutoffContLine = continuousLine.intersection(safetyZone);
        cutoffContLine = cutoffContLine.difference(ignition);
        gs.put((Object)this.createFeature(cutoffContLine, "safetyDistance", (int)cutoffContLine.getLength() + " m"));
    }

    public Geometry createEllipse(Coordinate startPoint, double rotation, double fanlength, double fanheight, int numPoints) throws TransformException {
        GeometricShapeFactory gsf = new GeometricShapeFactory(this.gf);
        gsf.setBase(new Coordinate(startPoint.x - fanlength, startPoint.y - fanheight));
        gsf.setWidth(fanlength * 2.0);
        gsf.setHeight(fanheight * 2.0);
        gsf.setNumPoints(numPoints);
        gsf.setRotation(rotation);
        Polygon ellipse = gsf.createEllipse();
        return ellipse;
    }

    private void calculateNormalSafetyZone(JSONObject feature, JSONObject audienceObj, JSONArray gs) throws ParseException, TransformException {
        Geometry ignition = this.wkt.read(feature.getString("wktgeom"));
        Geometry audience = this.wkt.read(audienceObj.getString("wktgeom"));
        Geometry zone = this.createNormalSafetyZone(feature, ignition);
        gs.put((Object)this.createFeature(zone, "safetyZone", ""));
        this.createSafetyDistances(gs, audience, ignition, zone);
    }

    private Geometry createNormalSafetyZone(JSONObject feature, Geometry ignition) throws ParseException {
        JSONObject attributes = feature.getJSONObject("attributes");
        Integer zoneDistance = attributes.getString("fireworks_type").equals("consumer") ? Integer.valueOf(attributes.getInt("zonedistance_consumer_m")) : Integer.valueOf(attributes.getInt("zonedistance_professional_m"));
        Geometry zone = ignition.buffer((double)zoneDistance.intValue());
        return zone;
    }

    private JSONObject createFeature(Geometry geom, String type, String label) {
        JSONObject feat = new JSONObject();
        JSONObject attrs = new JSONObject();
        feat.put("attributes", (Object)attrs);
        feat.put("wktgeom", (Object)geom.toText());
        attrs.put("type", (Object)type);
        attrs.put("label", (Object)label);
        return feat;
    }

    public Resolution print() {
        JSONObject result = new JSONObject();
        result.put("type", (Object)"print");
        return new StreamingResolution("application/json", (Reader)new StringReader(result.toString()));
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getFeatures() {
        return this.features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }
}

