Ext.define("viewer.viewercontroller.flamingo.FlamingoLayer", {enabledEvents:null, type:null, constructor:function(a) {
  a.id && (this.id = a.viewerController.mapComponent.makeFlamingoAcceptableId(a.id), a.id = this.id);
  this.enabledEvents = {};
  this.map = this.viewerController ? this.viewerController.mapComponent.getMap() : null;
  return this;
}, getFrameworkLayer:function() {
  return null == this.map ? null : this.map.getFrameworkMap();
}, toXML:function() {
  Ext.Error.raise({msg:"FlamingoLayer.toXML(): .toXML() must be made!"});
}, getTagName:function() {
  Ext.Error.raise({msg:"FlamingoLayer.getTagName: .getTagName() must be made!"});
}, setOption:function(a, b) {
  this.options[a] = b;
}, getId:function() {
  return this.id;
}, getFrameworkId:function() {
  return this.map.getId() + "_" + this.getId();
}, setAlpha:function(a) {
  this.map && this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "setAlpha", a);
}, getAlpha:function() {
  return this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "getAlpha");
}, getLastMapRequest:function() {
  var a = this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "getLastGetMapRequest");
  return null == a ? null : [a];
}, getType:function() {
  return this.type;
}, reload:function() {
  if (null != this.map && this.map.getFrameworkMap()) {
    return this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "update");
  }
}, addListener:function(a, b, c) {
  var d = this.viewerController.mapComponent.eventList[a];
  void 0 != d && void 0 == this.enabledEvents[d] && (this.map.getFrameworkMap().callMethod(this.viewerController.mapComponent.getId(), "addAllowExternalInterface", this.getFrameworkId() + "." + d), this.enabledEvents[d] = !0);
  "viewer.viewercontroller.flamingo.FlamingoArcLayer" == this.superclass.$className ? this.superclass.superclass.addListener.call(this, a, b, c) : this.superclass.addListener.call(this, a, b, c);
}, setVisible:function(a) {
  this.visible = a;
  null != this.options && (this.options.visible = a);
  null != this.map && this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "setVisible", a);
}, getVisible:function() {
  null != this.map && (this.visible = this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "getVisible"));
  null != this.options && (this.options.visible = this.visible);
  return this.visible;
}, destroy:function() {
  "viewer.viewercontroller.flamingo.FlamingoArcLayer" == this.superclass.$className ? this.superclass.superclass.destroy.call(this) : this.superclass.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.flamingo.FlamingoArcLayer", {extend:"viewer.viewercontroller.controller.ArcLayer", mixins:{flamingoLayer:"viewer.viewercontroller.flamingo.FlamingoLayer"}, constructor:function(a) {
  viewer.viewercontroller.flamingo.FlamingoArcLayer.superclass.constructor.call(this, a);
  this.mixins.flamingoLayer.constructor.call(this, a);
  this.initConfig(a);
  return this;
}, toXML:function() {
  var a;
  a = "\x3cfmc:" + this.getTagName();
  a = a + ' xmlns:fmc\x3d"fmc"' + (' id\x3d"' + this.getId() + '"');
  for (var b in this.options) {
    "url" != b.toLowerCase() && "sld" != b.toLowerCase() && (a += " " + b + '\x3d"' + this.options[b] + '"');
  }
  a += "\x3e";
  for (b = 0;b < this.getMaptips().length;b++) {
    var c = this.getMaptips()[b];
    a += "\x3clayer";
    a += ' id\x3d"' + c.layer + '"';
    null != c.mapTipField && (a += ' maptip\x3d"' + c.mapTipField + '"');
    null != c.aka && (a += ' aka\x3d"' + c.aka + '"');
    a += "/\x3e";
  }
  return a += "\x3c/fmc:" + this.getTagName() + "\x3e";
}, getId:function() {
  return this.id;
}, getName:function() {
  return this.options.name;
}, getServer:function() {
  return this.options.server;
}, getService:function() {
  return this.options.service;
}, getServlet:function() {
  return this.options.servlet;
}, getMapservice:function() {
  return this.options.mapservice;
}, getLayers:function() {
  return this.options.visibleids;
}, setMaptips:function(a) {
  viewer.viewercontroller.flamingo.FlamingoArcLayer.superclass.setMaptips.call(this, a);
  this.passMaptips();
}, passMaptips:function() {
  this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "setMaptipLayers", this.maptips.join(","));
}, getLegendGraphic:function() {
  return null;
}, setBuffer:function(a, b) {
  console.log("FlamingoArcLayer.setBuffer: .setBuffer() must be made!");
}, removeBuffer:function(a) {
  console.log("FlamingoArcLayer.removeBuffer: .removeBuffer() must be made!");
}, getLastMapRequest:function() {
  return this.mixins.flamingoLayer.getLastMapRequest.call(this);
}, getType:function() {
  return this.mixins.flamingoLayer.getType.call(this);
}, setVisible:function(a) {
  this.mixins.flamingoLayer.setVisible.call(this, a);
}, getVisible:function() {
  return 0 <= this.mixins.flamingoLayer.getVisible.call(this) ? !0 : !1;
}, setAlpha:function(a) {
  this.mixins.flamingoLayer.setAlpha.call(this, a);
}, reload:function() {
  this.mixins.flamingoLayer.reload.call(this);
}, addListener:function(a, b, c) {
  this.mixins.flamingoLayer.addListener.call(this, a, b, c);
}, destroy:function() {
  this.mixins.flamingoLayer.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.flamingo.FlamingoArcServerLayer", {extend:"viewer.viewercontroller.flamingo.FlamingoArcLayer", constructor:function(a) {
  viewer.viewercontroller.flamingo.FlamingoArcServerLayer.superclass.constructor.call(this, a);
  this.initConfig(a);
  this.type = viewer.viewercontroller.controller.Layer.ARCSERVER_TYPE;
  return this;
}, getTagName:function() {
  return "LayerArcServer";
}, setQuery:function(a) {
  a = null != a ? a.getCQL() : "";
  if ("" != a) {
    var b = this;
    Ext.create("viewer.ArcQueryUtil").cqlToArcFIDS(a, this.appLayerId, function(a, d) {
      var e = "-1";
      0 != a.length && (e = d + " IN(" + a.join(",") + ")");
      b.map.getFrameworkMap().callMethod(b.getFrameworkId(), "setDefinitionQuery", e, b.config.options.name);
      setTimeout(function() {
        b.reload();
      }, 500);
    }, function(a) {
      b.getViewerController().logger.error(a);
    });
  } else {
    this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "setDefinitionQuery", null, this.config.options.name), this.reload();
  }
}});
Ext.define("viewer.viewercontroller.flamingo.FlamingoArcIMSLayer", {extend:"viewer.viewercontroller.flamingo.FlamingoArcLayer", constructor:function(a) {
  a.options.layerorder = !0;
  this.id = a.id;
  viewer.viewercontroller.flamingo.FlamingoArcIMSLayer.superclass.constructor.call(this, a);
  this.initConfig(a);
  this.type = viewer.viewercontroller.controller.Layer.ARCIMS_TYPE;
  return this;
}, getTagName:function() {
  return "LayerArcIMS";
}, setBuffer:function(a, b) {
  this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "setLayerProperty", b, "buffer", {radius:a});
  this.map.update();
}, removeBuffer:function(a) {
  this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "setLayerProperty", a, "buffer");
  this.map.update();
}, setQuery:function(a) {
  if (a) {
    var b = this;
    Ext.create("viewer.ArcQueryUtil").cqlToArcXMLSpatialQuery(a.getCQL(), function(a) {
      b.map.getFrameworkMap().callMethod(b.getFrameworkId(), "setQuery", "#ALL#", a);
      b.reload();
    }, console.log);
  } else {
    this.map.getFrameworkMap().callMethod(b.getFrameworkId(), "setQuery", "#ALL#", null), this.reload();
  }
}});
Ext.define("viewer.viewercontroller.flamingo.FlamingoWMSLayer", {extend:"viewer.viewercontroller.controller.WMSLayer", mixins:{flamingoLayer:"viewer.viewercontroller.flamingo.FlamingoLayer"}, constructor:function(a) {
  viewer.viewercontroller.flamingo.FlamingoWMSLayer.superclass.constructor.call(this, a);
  this.mixins.flamingoLayer.constructor.call(this, a);
  this.initConfig(a);
  return this;
}, getTagName:function() {
  return "LayerOGWMS";
}, toXML:function() {
  var a;
  a = "\x3cfmc:" + this.getTagName();
  a = a + ' xmlns:fmc\x3d"fmc"' + (' id\x3d"' + this.getId() + '"');
  var b = {sld:!0}, c;
  for (c in this.options) {
    var d = this.options[c];
    b[c.toLowerCase()] && (d = encodeURIComponent(d));
    a += " " + c + '\x3d"' + d + '"';
  }
  a += "\x3e";
  for (b = 0;b < this.getMaptips().length;b++) {
    c = this.getMaptips()[b], a += "\x3clayer", a += ' id\x3d"' + c.layer + '"', null != c.mapTipField && (a += ' maptip\x3d"' + c.mapTipField + '"'), null != c.aka && (a += ' aka\x3d"' + c.aka + '"'), a += "/\x3e";
  }
  return a += "\x3c/fmc:" + this.getTagName() + "\x3e";
}, setMaptips:function(a) {
  viewer.viewercontroller.flamingo.FlamingoWMSLayer.superclass.setMaptips.call(this, a);
  this.passMaptips();
}, passMaptips:function() {
  this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "setMaptipLayers", this.maptips.join(","));
}, setQuery:function(a) {
  if (a && "" != a.getCQL()) {
    var b = this.config.viewerController.app.services[this.serviceId].layers[this.options.name];
    if (void 0 != b.details) {
      var c = b.details.filterable;
      void 0 != c && null != c && (c = Ext.JSON.decode(c)) && (a = Ext.create(viewer.SLD).createURL(this.options.layers, this.getOption("styles") || "default", [a.getCQL()], b.hasFeatureType ? b.featureTypeName : null, this.config.sld ? this.config.sld.id : null), this.getFrameworkLayer().callMethod(this.map.getId() + "_" + this.getId(), "setAttribute", "sld", encodeURIComponent(a)), this.reload());
    }
  } else {
    a = this.getFrameworkLayer(), this.config.originalSldUrl ? a.callMethod(this.map.getId() + "_" + this.getId(), "setAttribute", "sld", encodeURIComponent(this.config.originalSldUrl)) : a.callMethod(this.map.getId() + "_" + this.getId(), "removeAttribute", "sld"), this.reload();
  }
}, getLayers:function() {
  return this.getFrameworkLayer().options.layers;
}, setUrl:function(a) {
  this.url = a;
  this.mixins.flamingoLayer.reload.call(this);
}, setVisible:function(a) {
  this.mixins.flamingoLayer.setVisible.call(this, a);
}, getVisible:function() {
  return 0 <= this.mixins.flamingoLayer.getVisible.call(this) ? !0 : !1;
}, setAlpha:function(a) {
  this.mixins.flamingoLayer.setAlpha.call(this, a);
}, getLastMapRequest:function() {
  return this.mixins.flamingoLayer.getLastMapRequest.call(this);
}, getType:function() {
  return this.mixins.flamingoLayer.getType.call(this);
}, reload:function() {
  this.mixins.flamingoLayer.reload.call(this);
}, addListener:function(a, b, c) {
  this.mixins.flamingoLayer.addListener.call(this, a, b, c);
}, destroy:function() {
  this.mixins.flamingoLayer.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.flamingo.FlamingoVectorLayer", {extend:"viewer.viewercontroller.controller.VectorLayer", mixins:{flamingoLayer:"viewer.viewercontroller.flamingo.FlamingoLayer"}, isLoaded:!1, gisId:null, constructor:function(a) {
  null == a.labelPropertyName && (a.labelPropertyName = "label");
  viewer.viewercontroller.flamingo.FlamingoVectorLayer.superclass.constructor.call(this, a);
  this.mixins.flamingoLayer.constructor.call(this, a);
  this.initConfig(a);
  this.colorPrefix = "0x";
  this.id = a.name;
  this.type = viewer.viewercontroller.controller.Layer.VECTOR_TYPE;
  return this;
}, getFrameworkId:function() {
  return this.map.editMapId;
}, toXML:function() {
  var a;
  a = "\x3cfmc:Layer " + ("id\x3d'" + this.id + "' ");
  a += "name\x3d'" + this.id + "' ";
  a = a + "visible\x3d'true' " + ("labelpropertyname\x3d'" + this.labelPropertyName + "' ");
  null != this.getGeometrytypes() && 0 < this.getGeometrytypes().length && (a += "geometrytypes\x3d'" + this.getGeometrytypes().join() + "' ");
  null != this.getShowmeasures() && (a += "showmeasures\x3d'" + this.getShowmeasures() + "' ");
  null != this.getEditable() && (a += "editable\x3d'" + this.getEditable() + "' ");
  a = a + "\x3e" + ("\x3cfmc:Property name\x3d'" + this.labelPropertyName + "' title\x3d'Label' type\x3d'SingleLine'/\x3e");
  a += "\x3cfmc:Style ";
  null != this.style.fillcolor && (a += "fillcolor\x3d'" + this.colorPrefix + this.style.fillcolor + "' ");
  null != this.style.fillopacity && (a += "fillopacity\x3d'" + this.style.fillopacity + "' ");
  null != this.style.strokecolor && (a += "strokecolor\x3d'" + this.colorPrefix + this.style.strokecolor + "' ");
  null != this.style.strokeopacity && (a += "strokeopacity\x3d'" + this.style.strokeopacity + "' ");
  return a + "/\x3e\x3c/fmc:Layer\x3e";
}, adjustStyle:function() {
  var a = "\x3cfmc:Style ";
  null != this.style.fillcolor && (a += "fillcolor\x3d'" + this.colorPrefix + this.style.fillcolor + "' ");
  null != this.style.fillopacity && (a += "fillopacity\x3d'" + this.style.fillopacity + "' ");
  null != this.style.strokecolor && (a += "strokecolor\x3d'" + this.colorPrefix + this.style.strokecolor + "' ");
  null != this.style.strokeopacity && (a += "strokeopacity\x3d'" + this.style.strokeopacity + "' ");
  a += "/\x3e";
  this.map.getFrameworkMap().callMethod(this.gisId, "setCompositeInLayer", a, "Style", this.getId());
}, getLayerName:function() {
  return this.layerName;
}, removeAllFeatures:function() {
  this.map.getFrameworkMap().callMethod(this.gisId, "removeAllLayerFeatures", this.getId(), !1);
}, removeFeature:function(a) {
  this.map.getFrameworkMap().callMethod(this.gisId, "removeLayerFeatureById", this.getId(), a.getId(), !1);
}, getActiveFeature:function() {
  var a = this.map.getFrameworkMap().callMethod(this.gisId, "getActiveFeatureAsObject");
  return null == a ? null : this.fromFlamingoFeature(a);
}, getFeature:function(a) {
  return this.getAllFeatures()[a];
}, addFeature:function(a) {
  this.map.getFrameworkMap().callMethod(this.map.editMapId, "addFeature", this.getId(), this.toFlamingoFeature(a));
}, getAllFeatures:function() {
  for (var a = this.map.getFrameworkMap().callMethod(this.getGisId(), "getFeaturesAsObject", !1, this.getId()), b = [], c = 0;c < a.length;c++) {
    var d = this.fromFlamingoFeature(a[c]);
    b.push(d);
  }
  return b;
}, getFeatureById:function(a) {
  a = this.map.getFrameworkMap().callMethod(this.getGisId(), "getFeature", this.getId(), a);
  return null != a ? this.fromFlamingoFeature(a) : null;
}, drawFeature:function(a) {
  null != this.map && null != this.map.editMapId && this.map.getFrameworkMap().callMethod(this.map.editMapId, "editMapDrawNewGeometry", this.getId(), a);
}, stopDrawDrawFeature:function() {
  this.map.getFrameworkMap().callMethod(this.getId(), "removeEditMapCreateGeometry", this.getLayerName());
}, setGisId:function(a) {
  this.gisId = a;
}, getGisId:function() {
  return this.gisId;
}, setLabel:function(a, b) {
  this.map.getFrameworkMap().callMethod(this.gisId, "setFeatureValue", this.getId(), a, this.getLabelPropertyName(), b);
}, fromFlamingoFeature:function(a) {
  a.wkt = a.wktgeom;
  return new viewer.viewercontroller.controller.Feature(a);
}, toFlamingoFeature:function(a) {
  var b = {};
  b.id = a.getId();
  b.wktgeom = a.getWktgeom();
  "" != a.getLabel() ? b[this.labelPropertyName] = a.getLabel() : b[this.labelPropertyName] = null;
  return b;
}, getVisible:function() {
  return this.visible;
}, setVisible:function(a) {
  this.visible = a;
  this.map.getFrameworkMap().callMethod(this.map.editMapId, "setLayerVisibility", this.getId(), a);
}, fire:function(a, b) {
  this.fireEvent(a, this, b);
}, getType:function() {
  return this.mixins.flamingoLayer.getType.call(this);
}, addListener:function(a, b, c) {
  this.mixins.flamingoLayer.addListener.call(this, a, b, c);
}, destroy:function() {
  this.mixins.flamingoLayer.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.flamingo.FlamingoMap", {extend:"viewer.viewercontroller.controller.Map", posAttrNames:"left right top bottom width height".split(" "), enabledEvents:{}, editMapId:null, gisId:"gis", constructor:function(a) {
  a.options.startExtent && (a.options.extent = a.options.startExtent.toString(), delete a.options.startExtent);
  a.options.maxExtent && (a.options.fullextent = a.options.maxExtent.toString(), delete a.options.maxExtent);
  a.options.bottom = "bottom -" + a.options.bottom;
  viewer.viewercontroller.flamingo.FlamingoMap.superclass.constructor.call(this, a);
  this.frameworkMap = this.mapComponent.viewerObject;
  if (Ext.isGecko) {
    var b = this;
    this.frameworkMap.addEventListener("DOMMouseScroll", function(a) {
      b.frameworkMap.callMethod(b.id, "mouseWheelUsed", 0 - a.detail);
    }, !1);
  }
  return this;
}, getId:function() {
  return this.id;
}, getAllWMSLayers:function() {
  for (var a = [], b = 0;b < this.layers.length;b++) {
    this.layers[b] instanceof viewer.viewercontroller.flamingo.FlamingoWMSLayer && a.push(this.layers[b]);
  }
  return a;
}, getAllVectorLayers:function() {
  for (var a = [], b = 0;b < this.layers.length;b++) {
    this.layers[b] instanceof viewer.viewercontroller.flamingo.FlamingoVectorLayer && a.push(this.layers[b]);
  }
  return a;
}, remove:function() {
  this.getFrameworkMap().callMethod("flamingo", "killComponent", this.getId());
}, addLayer:function(a) {
  this.superclass.addLayer.call(this, a);
  a instanceof viewer.viewercontroller.flamingo.FlamingoVectorLayer ? (null == this.editMapId && this.addEditMap(), a.setGisId(this.gisId), this.addLayerToGis(a)) : this.getFrameworkMap().callMethod(this.getId(), "addLayer", a.toXML());
}, addLayerToGis:function(a) {
  if (this.getFrameworkMap().callMethod("flamingo", "isLoaded", this.gisId, !0)) {
    this.getFrameworkMap().callMethod(this.gisId, "addLayerAsString", a.toXML()), a.isLoaded = !0;
  } else {
    var b = this;
    setTimeout(function() {
      b.addLayerToGis(a, b);
    }, 500);
  }
}, removeLayer:function(a) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoVectorLayer ? this.getFrameworkMap().callMethod(this.gisId, "removeLayer", a.getId()) : this.getFrameworkMap().callMethod(this.getId(), "removeLayer", this.getId() + "_" + a.getId());
  this.superclass.removeLayer.call(this, a);
}, addEditMap:function() {
  this.editMapId = "editMap";
  this.getFrameworkMap().callMethod(this.getMapComponent().mainContainerId, "addComponent", "\x3cfmc:GIS xmlns:fmc\x3d'fmc' id\x3d'" + this.gisId + "' geometryeditable\x3d'true' alwaysdrawpoints\x3d'false'\x3e\x3c/fmc:GIS\x3e");
  var a = this.getPositionAttributes(), b = "\x3cfmc:EditMap xmlns:fmc\x3d'fmc' id\x3d'" + this.editMapId + "' editable\x3d'true'", c;
  for (c in a) {
    b += " " + c + "\x3d'" + a[c] + "'";
  }
  b += "listento\x3d'" + this.gisId + "," + this.id + "'/\x3e";
  this.getFrameworkMap().callMethod(this.getMapComponent().mainContainerId, "addComponent", b);
}, getLayerByFlamingoId:function(a) {
  var b = null;
  0 == a.indexOf(this.getId() + "_") && (b = this.getLayer(a.replace(this.getId() + "_", "")));
  null == b && (b = this.getLayer(a));
  return b;
}, setLayerIndex:function(a, b) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoVectorLayer || this.getFrameworkMap().callMethod(this.getId(), "swapLayer", this.getId() + "_" + a.getId(), b);
  return this.superclass.setLayerIndex(a, b);
}, setLayerVisible:function(a, b) {
  this.superclass.setLayerVisible.call(this, a, b);
  a.setVisible(b);
}, zoomToExtent:function(a) {
  this.getFrameworkMap().callMethod(this.getId(), "moveToExtent", a, 0);
}, zoomToMaxExtent:function() {
  this.zoomToExtent(this.getFrameworkMap().callMethod(this.getId(), "getFullExtent"));
}, zoomToResolution:function(a) {
  this.getFrameworkMap().callMethod(this.getId(), "moveToScale", a, void 0, 0);
}, zoomToScale:function(a) {
  this.zoomToResolution(a);
}, moveTo:function(a, b) {
  this.getFrameworkMap().callMethod(this.getId(), "moveToCoordinate", {x:a, y:b}, 1);
}, setMaxExtent:function(a) {
  this.getFrameworkMap().callMethod(this.getId(), "setFullExtent", a);
}, getMaxExtent:function() {
  var a = this.getFrameworkMap().callMethod(this.getId(), "getFullExtent");
  return new viewer.viewercontroller.controller.Extent(a.minx, a.miny, a.maxx, a.maxy);
}, doIdentify:function(a, b) {
  Ext.Error.raise({msg:"Map.doIdentify() Not implemented!"});
}, getExtent:function() {
  var a = this.getFrameworkMap().callMethod(this.getId(), "getCurrentExtent");
  return new viewer.viewercontroller.controller.Extent(a.minx, a.miny, a.maxx, a.maxy);
}, update:function() {
  this.getFrameworkMap().callMethod(this.getId(), "update", 100, !0);
}, forceUpdate:function() {
  var a = this;
  this.isUpdating() ? setTimeout(function() {
    a.forceUpdate();
  }, 100) : this.update();
}, setMarker:function(a, b, c, d) {
  this.getFrameworkMap().callMethod(this.getId(), "setMarker", a, d, Number(b), Number(c));
}, removeMarker:function(a) {
  this.getFrameworkMap().callMethod(this.getId(), "removeMarker", a);
}, getScale:function(a) {
  return this.getResolution(a);
}, getResolution:function(a) {
  a || (a = this.getExtent());
  return this.getFrameworkMap().callMethod(this.getId(), "getScale", a);
}, getResolutions:function() {
  if (this.options && this.options.resolutions) {
    for (var a = this.options.resolutions.split(","), b = [], c = 0;c < a.length;c++) {
      var d = Number(a[c]);
      isNaN(d) || b.push(d);
    }
    return b;
  }
  return null;
}, coordinateToPixel:function(a, b) {
  return this.getFrameworkMap().callMethod(this.getId(), "coordinate2Point", {x:a, y:b});
}, getCenter:function() {
  return this.getFrameworkMap().callMethod(this.getId(), "getCenter");
}, getWidth:function() {
  return this.getFrameworkMap().callMethod(this.getId(), "getMovieClipWidth");
}, getHeight:function() {
  return this.getFrameworkMap().callMethod(this.getId(), "getMovieClipHeight");
}, updateSize:function() {
}, isUpdating:function() {
  return this.getFrameworkMap().callMethod(this.getId(), "isUpdating");
}, getPositionAttributes:function() {
  for (var a = {}, b = 0;b < this.posAttrNames.length;b++) {
    var c = this.posAttrNames[b];
    this.options[c] && (a[c] = this.options[c]);
  }
  return a;
}, toXML:function() {
  var a;
  a = '\x3cfmc:Map xmlns:fmc\x3d"fmc"' + (' id\x3d"' + this.getId() + '"');
  for (var b in this.options) {
    a += " " + b + '\x3d"' + this.options[b] + '"';
  }
  return a + "\x3e\x3c/fmc:Map\x3e";
}, addListener:function(a, b, c) {
  viewer.viewercontroller.flamingo.FlamingoMap.superclass.addListener.call(this, a, b, c);
  a = this.mapComponent.eventList[a];
  if (Ext.isArray(a)) {
    for (b = 0;b < a.length;b++) {
      this.addExternalInterface(a[b]);
    }
  } else {
    this.addExternalInterface(a);
  }
}, addExternalInterface:function(a) {
  void 0 != a && void 0 == this.enabledEvents[a] && (this.getFrameworkMap().callMethod(this.mapComponent.getId(), "addAllowExternalInterface", this.getId() + "." + a), "onRemoveLayer" != a && "onAddLayer" != a || this.getFrameworkMap().callMethod(this.mapComponent.getId(), "addAllowExternalInterface", this.gisId + "." + a), this.enabledEvents[a] = !0);
}});
Ext.define("viewer.viewercontroller.flamingo.FlamingoTool", {extend:"viewer.viewercontroller.controller.Tool", enabledEvents:null, config:{width:null, height:null, left:null, right:null, top:null, bottom:null, listenTo:null, decimals:null, magicnumber:null, units:null}, constructor:function(a) {
  a.id && (a.id = a.id.replace(/\./g, "_"));
  this.enabledEvents = {};
  viewer.viewercontroller.flamingo.FlamingoTool.superclass.constructor.call(this, a);
  this.initConfig(a);
  return this;
}, setVisible:function(a) {
  this.visible = a;
  this.getFrameworkTool() && this.getFrameworkTool().callMethod(this.getId(), "setVisible", a);
}, toXML:function() {
  var a;
  a = "\x3cfmc:" + this.getTagName(this.getType());
  null != this.getId() && (a += " id\x3d'" + this.getId() + "'");
  null != this.getWidth() && (a += " width\x3d'" + this.getWidth() + "'");
  null != this.getHeight() && (a += " height\x3d'" + this.getHeight() + "'");
  null != this.getTop() && (a += " top\x3d'" + this.getTop() + "'");
  null != this.getLeft() && (a += " left\x3d'" + this.getLeft() + "'");
  null != this.getRight() && (a += " right\x3d'" + this.getRight() + "'");
  null != this.getBottom() && (a += " bottom\x3d'" + this.getBottom() + "'");
  null != this.getDecimals() && (a += " decimals\x3d'" + this.getDecimals() + "'");
  null != this.getMagicnumber() && (a += " magicnumber\x3d'" + this.getMagicnumber() + "'");
  null != this.getUnits() && (a += " units\x3d'" + this.getUnits() + "'");
  null != this.getListenTo() && (a += " listento\x3d'" + this.getListenTo() + "'");
  a += "\x3e";
  null != this.getTooltip() && (a += "\x3cstring id\x3d'tooltip' en\x3d'" + this.getTooltip() + "'/\x3e");
  return a += "\x3c/fmc:" + this.getTagName(this.getType()) + "\x3e";
}, getTagName:function(a) {
  return a == viewer.viewercontroller.controller.Tool.ZOOMIN_BOX ? "ToolZoomin" : a == viewer.viewercontroller.controller.Tool.ZOOMOUT_BOX || a == viewer.viewercontroller.controller.Tool.ZOOMOUT_BUTTON ? "ToolZoomout" : a == viewer.viewercontroller.controller.Tool.GET_FEATURE_INFO ? "ToolIdentify" : a == viewer.viewercontroller.controller.Tool.PAN ? "ToolPan" : a == viewer.viewercontroller.controller.Tool.SUPERPAN ? "ToolSuperPan" : a == viewer.viewercontroller.controller.Tool.MEASURELINE ? "ToolMeasure" : 
  a == viewer.viewercontroller.controller.Tool.DEFAULT ? "ToolDefault" : a == viewer.viewercontroller.controller.Tool.FULL_EXTENT ? "ButtonFull" : a == viewer.viewercontroller.controller.Tool.NEXT_EXTENT ? "ButtonNext" : a == viewer.viewercontroller.controller.Tool.PREVIOUS_EXTENT ? "ButtonPrev" : null;
}, activate:function() {
  this.getFrameworkTool().callMethod(this.config.viewerController.mapComponent.toolGroupId, "setTool", this.getId());
}, deactivate:function() {
  this.getFrameworkTool().callMethod(this.getId(), "setActive", !1);
}, addListener:function(a, b, c) {
  viewer.viewercontroller.flamingo.FlamingoTool.superclass.addListener.call(this, a, b, c);
  a = (this.mapComponent ? this.mapComponent : this.viewerController.mapComponent).eventList[a];
  void 0 != a && void 0 == this.enabledEvents[a] && (this.getFrameworkTool().callMethod((this.mapComponent ? this.mapComponent : this.viewerController.mapComponent).getId(), "addAllowExternalInterface", this.getId() + "." + a), this.enabledEvents[a] = !0);
}});
Ext.define("viewer.viewercontroller.flamingo.FlamingoImageLayer", {extend:"viewer.viewercontroller.controller.ImageLayer", mixins:{flamingoLayer:"viewer.viewercontroller.flamingo.FlamingoLayer"}, constructor:function(a) {
  viewer.viewercontroller.flamingo.FlamingoImageLayer.superclass.constructor.call(this, a);
  this.mixins.flamingoLayer.constructor.call(this, a);
  this.initConfig(a);
  this.type = viewer.viewercontroller.controller.Layer.IMAGE_TYPE;
  return this;
}, getTagName:function() {
  return "LayerImage";
}, toXML:function() {
  var a;
  a = "\x3cfmc:" + this.getTagName();
  a = a + ' xmlns:fmc\x3d"fmc"' + (' id\x3d"' + this.id + '"');
  a += ' url\x3d"' + this.url + '"';
  a += ' extent\x3d"' + this.extent + '"';
  a += ' visible\x3d"' + this.visible + '"';
  return a += "\x3e\x3c/fmc:" + this.getTagName() + "\x3e";
}, setUrl:function(a) {
  this.url = a;
  null != this.getFrameworkLayer() && null != this.getMap() && this.getFrameworkLayer().callMethod(this.getFrameworkId(), "setAttribute", "url", a);
}, setExtent:function(a) {
  this.extent = a;
  null != this.getFrameworkLayer() && null != this.map && this.getFrameworkLayer().callMethod(this.getFrameworkId(), "setAttribute", "extent", a.toString());
}, getLastMapRequest:function() {
  return [{url:this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "getServiceUrl"), body:null, extent:this.getExtent()}];
}, setVisible:function(a) {
  this.mixins.flamingoLayer.setVisible.call(this, a);
}, getVisible:function() {
  return this.mixins.flamingoLayer.getVisible.call(this);
}, setAlpha:function(a) {
  this.mixins.flamingoLayer.setAlpha.call(this, a);
}, reload:function() {
  this.mixins.flamingoLayer.reload.call(this);
}, addListener:function(a, b, c) {
  this.mixins.flamingoLayer.addListener.call(this, a, b, c);
}, getType:function() {
  return this.mixins.flamingoLayer.getType.call(this);
}, destroy:function() {
  this.mixins.flamingoLayer.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.flamingo.FlamingoTilingLayer", {extend:"viewer.viewercontroller.controller.TilingLayer", mixins:{flamingoLayer:"viewer.viewercontroller.flamingo.FlamingoLayer"}, constructor:function(a) {
  viewer.viewercontroller.flamingo.FlamingoTilingLayer.superclass.constructor.call(this, a);
  this.mixins.flamingoLayer.constructor.call(this, a);
  return this;
}, getTagName:function() {
  return "TilingLayer";
}, toXML:function() {
  var a = this.getUrl();
  "ArcGisRest" == this.getProtocol() && (/\/tile\/?$/.test(a) || (a += "/tile/"));
  var b;
  b = "\x3cfmc:" + this.getTagName();
  b = b + ' xmlns:fmc\x3d"fmc"' + (' id\x3d"' + this.getId() + '"');
  b = b + (' serviceurl\x3d"' + a + '"') + (' resolutions\x3d"' + this.getResolutions().join(",") + '"');
  b += ' serviceenvelope\x3d"' + this.getServiceEnvelope() + '"';
  null != this.getProtocol() && (b += ' type\x3d"' + this.getProtocol() + '"');
  null != this.getTileHeight() && (b += ' tileheight\x3d"' + this.getTileHeight() + '"');
  null != this.getTileWidth() && (b += ' tilewidth\x3d"' + this.getTileWidth() + '"');
  null != this.getExtension() && (b += ' extension\x3d"' + this.getExtension() + '"');
  null != this.config.alpha && (b += ' alpha\x3d"' + this.config.alpha + '"');
  return b += "\x3e\x3c/fmc:" + this.getTagName() + "\x3e";
}, getLegendGraphic:function() {
  return null;
}, getLayers:function() {
  return null;
}, getLastMapRequest:function() {
  var a = this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "getLastRequests"), b;
  for (b in a) {
    a[b].extent && (a[b].extent = new viewer.viewercontroller.controller.Extent(a[b].extent.minx, a[b].extent.miny, a[b].extent.maxx, a[b].extent.maxy));
  }
  return a;
}, setUrl:function(a) {
  this.url = a;
}, setVisible:function(a) {
  this.mixins.flamingoLayer.setVisible.call(this, a);
}, getVisible:function() {
  return this.mixins.flamingoLayer.getVisible.call(this);
}, setAlpha:function(a) {
  this.mixins.flamingoLayer.setAlpha.call(this, a);
}, reload:function() {
  this.mixins.flamingoLayer.reload.call(this);
}, addListener:function(a, b, c) {
  this.mixins.flamingoLayer.addListener.call(this, a, b, c);
}, getType:function() {
  return this.mixins.flamingoLayer.getType.call(this);
}, destroy:function() {
  this.mixins.flamingoLayer.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.flamingo.ToolMapClick", {extend:"viewer.viewercontroller.controller.ToolMapClick", enabledEvents:null, constructor:function(a) {
  viewer.viewercontroller.flamingo.ToolMapClick.superclass.constructor.call(this, a);
  this.visible = !1;
  this.id = a.id + "_toolMapClick";
  this.enabledEvents = {};
  this.initConfig(a);
  this.mapComponent = this.config.viewerController.mapComponent;
  this.frameworkObject = this.config.viewerController.mapComponent.viewerObject;
  this.addListener(viewer.viewercontroller.controller.Event.ON_MAP_CLICKED, a.handler.fn, a.handler.scope);
  this.addTool();
  return this;
}, addTool:function() {
  var a;
  a = "\x3cfmc:ToolGroup id\x3d'" + this.mapComponent.getToolGroup() + "'\x3e" + ("\x3cfmc:ToolMapClick id\x3d'" + this.id + "' listento\x3d'" + this.mapComponent.getMap().getId() + "' visible\x3d'" + this.visible + "'/\x3e");
  this.frameworkObject.callMethod(this.mapComponent.flamingoId, "addComponent", a + "\x3c/fmc:ToolGroup\x3e");
  this.mapComponent.tools.push(this);
}, activateTool:function() {
  this.frameworkObject.callMethod(this.id, "activate");
}, deactivateTool:function() {
  this.frameworkObject.callMethod(this.id, "deactivate");
}, addListener:function(a, b, c) {
  viewer.viewercontroller.flamingo.ToolMapClick.superclass.addListener.call(this, a, b, c);
  a = this.config.viewerController.mapComponent.eventList[a];
  void 0 != a && void 0 == this.enabledEvents[a] && (this.frameworkObject.callMethod(this.config.viewerController.mapComponent.getId(), "addAllowExternalInterface", this.getId() + "." + a), this.enabledEvents[a] = !0);
}});
Ext.define("viewer.viewercontroller.flamingo.FlamingoComponent", {extend:"viewer.viewercontroller.controller.Component", strings:null, config:{tagName:null, width:null, height:null, left:null, right:null, top:null, bottom:null, listenTo:null, units:null, maptipdelay:500, decimals:null, showZoomerButtons:null}, constructor:function(a) {
  a.id && (a.id = a.id.replace(/\./g, "_"));
  this.strings = {};
  viewer.viewercontroller.flamingo.FlamingoComponent.superclass.constructor.call(this, a);
  this.initConfig(a);
  if (a.type == viewer.viewercontroller.controller.Component.BORDER_NAVIGATION) {
    this.setTagName("BorderNavigation");
    var b = a.viewerController.mapComponent.getMap().getPositionAttributes(), c;
    for (c in b) {
      this[c] = b[c];
    }
    void 0 != a.tooltip_pan_right && this.addString("tooltip_west", a.tooltip_pan_right);
    void 0 != a.tooltip_pan_left && this.addString("tooltip_east", a.tooltip_pan_left);
    void 0 != a.tooltip_pan_up && this.addString("tooltip_north", a.tooltip_pan_up);
    void 0 != a.tooltip_pan_down && this.addString("tooltip_south", a.tooltip_pan_down);
  } else {
    a.type == viewer.viewercontroller.controller.Component.SCALEBAR ? (this.setTagName("Scalebar"), this.setBottom("bottom +20"), this.setLeft("50"), this.setWidth("200"), null == this.getUnits() && this.setUnits("m")) : a.type == viewer.viewercontroller.controller.Component.COORDINATES ? (this.setTagName("Coordinates"), this.setBottom("bottom"), this.setRight("right -80"), this.addString("xy", "X: [x] Y: [y]")) : a.type == viewer.viewercontroller.controller.Component.NAVIGATIONPANEL ? (this.setTagName("NavigationControl"), 
    this.setTop("50"), this.setLeft("20"), null != this.getHeight() && "" != this.getHeight() || this.setHeight("300"), void 0 != a.show_zoom_buttons && this.setShowZoomerButtons(a.show_zoom_buttons), void 0 != a.tooltip_pan_right && this.addString("tooltip_west", a.tooltip_pan_right), void 0 != a.tooltip_pan_left && this.addString("tooltip_east", a.tooltip_pan_left), void 0 != a.tooltip_pan_up && this.addString("tooltip_north", a.tooltip_pan_up), void 0 != a.tooltip_pan_down && this.addString("tooltip_south", 
    a.tooltip_pan_down), void 0 != a.tooltip_slider && this.addString("tooltip_slider", a.tooltip_slider)) : a.type == viewer.viewercontroller.controller.Component.MAPTIP ? this.setTagName("Maptip") : a.type == viewer.viewercontroller.controller.Component.LOADMONITOR ? (this.setTagName("MonitorMap"), null == this.getWidth() && this.setWidth("200"), void 0 != a.loadingText && (this.addString("loading", a.loadingText), this.addString("waiting", a.loadingText))) : a.type != viewer.viewercontroller.controller.Component.OVERVIEW && 
    Ext.Error.raise({msg:"Can't find type of component or component not supported"});
  }
  return this;
}, setVisible:function(a) {
  this.getFrameworkTool().callMethod(this.getId(), "setVisible", a);
}, toXML:function() {
  var a;
  a = "\x3cfmc:" + this.getTagName();
  a += "  xmlns:fmc\x3d'fmc' " + this.getParamsAsXml();
  a += "\x3e";
  for (var b in this.strings) {
    a += "\x3cstring id\x3d'" + b + "' en\x3d'" + this.strings[b] + "'/\x3e";
  }
  return a += "\x3c/fmc:" + this.getTagName() + "\x3e";
}, getParamsAsXml:function() {
  var a = "";
  null != this.getId() && (a += "id\x3d'" + this.getId() + "'");
  null != this.getWidth() && (a += " width\x3d'" + this.getWidth() + "'");
  null != this.getHeight() && (a += " height\x3d'" + this.getHeight() + "'");
  null != this.getTop() && (a += " top\x3d'" + this.getTop() + "'");
  null != this.getLeft() && (a += " left\x3d'" + this.getLeft() + "'");
  null != this.getRight() && (a += " right\x3d'" + this.getRight() + "'");
  null != this.getBottom() && (a += " bottom\x3d'" + this.getBottom() + "'");
  null != this.getListenTo() && (a += " listento\x3d'" + this.getListenTo() + "'");
  null != this.getUnits() && (a += " units\x3d'" + this.getUnits() + "'");
  null != this.getDecimals() && (a += " decimals\x3d'" + this.getDecimals() + "'");
  null != this.getShowZoomerButtons() && (a += " showzoomerbuttons\x3d'" + this.getShowZoomerButtons() + "'");
  return a;
}, addString:function(a, b) {
  this.strings[a] = b;
}, getString:function(a) {
  return this.strings[a];
}, resize:function() {
}});
Ext.define("viewer.viewercontroller.FlamingoMapComponent", {extend:"viewer.viewercontroller.MapComponent", viewerObject:null, toolGroupId:"toolgroup", toolGroupCreated:!1, flamingoId:"flamingo", mainContainerId:"mainContainer", bottomContainerId:null, toolMargin:30, enabledEvents:{}, spriteIsSet:!1, config:{movetime:null, movesteps:null, swfPath:null}, constructor:function(a, b, c) {
  viewer.viewercontroller.FlamingoMapComponent.superclass.constructor.call(this, a, b, c);
  null == this.config.swfPath && (this.config.swfPath = "flamingo/flamingo.swf");
  var d = this;
  this.addListener(viewer.viewercontroller.controller.Event.ON_CONFIG_COMPLETE, function() {
    if (!d.spriteIsSet) {
      d.spriteIsSet = !0;
      var b = a.getApplicationSprite();
      0 !== b.toLowerCase().indexOf("http") && (b = ".." + b);
      d.viewerObject.callMethod("flamingo", "setSprite", b);
    }
  }, this);
  c = new SWFObject(this.config.swfPath + "?config\x3dconfig.xml", this.flamingoId, "100%", "100%", "8", "#FFFFFF");
  c.addParam("wmode", "transparent");
  c.write(b);
  this.viewerObject = document.getElementById("flamingo");
  return this;
}, initEvents:function() {
  this.eventList[viewer.viewercontroller.controller.Event.ON_EVENT_DOWN] = "onEvent";
  this.eventList[viewer.viewercontroller.controller.Event.ON_EVENT_UP] = "onEvent";
  this.eventList[viewer.viewercontroller.controller.Event.ON_EVENT_OVER] = "onEvent";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_CAPABILITIES] = "onGetCapabilities";
  this.eventList[viewer.viewercontroller.controller.Event.ON_CONFIG_COMPLETE] = "onConfigComplete";
  this.eventList[viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED] = "onGeometryDrawFinished";
  this.eventList[viewer.viewercontroller.controller.Event.ON_REQUEST] = "onRequest";
  this.eventList[viewer.viewercontroller.controller.Event.ON_SET_TOOL] = "onSetTool";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO] = "onIdentify";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO_PROGRESS] = "onIdentifyProgress";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO_DATA] = "onIdentifyData";
  this.eventList[viewer.viewercontroller.controller.Event.ON_ALL_LAYERS_LOADING_COMPLETE] = "onUpdateComplete";
  this.eventList[viewer.viewercontroller.controller.Event.ON_FINISHED_CHANGE_EXTENT] = "onReallyChangedExtent";
  this.eventList[viewer.viewercontroller.controller.Event.ON_CHANGE_EXTENT] = "onChangeExtent";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_ADDED] = "onAddLayer";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED] = "onRemoveLayer";
  this.eventList[viewer.viewercontroller.controller.Event.ON_MAPTIP_DATA] = "onMaptipData";
  this.eventList[viewer.viewercontroller.controller.Event.ON_MAPTIP] = "onMaptip";
  this.eventList[viewer.viewercontroller.controller.Event.ON_MAPTIP_CANCEL] = "onMaptipCancel";
  this.eventList[viewer.viewercontroller.controller.Event.ON_MAP_CLICKED] = "onMapClicked";
  this.eventList[viewer.viewercontroller.controller.Event.ON_ACTIVE_FEATURE_CHANGED] = "onActiveFeatureChange";
  this.eventList[viewer.viewercontroller.controller.Event.ON_ACTIVATE] = "onActivate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_DEACTIVATE] = "onDeactivate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_SERVICE_INFO] = "onGetServiceInfo";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED] = ["onShowLayer", "onHideLayer"];
}, getId:function() {
  return "flamingo";
}, createMap:function(a, b) {
  b.id = a;
  b.mapComponent = this;
  null != this.config.resolutions && "" != this.config.resolutions && (b.options.resolutions = this.config.resolutions);
  null != this.config.movetime && "" != this.config.movetime && (b.options.movetime = this.config.movetime);
  null != this.config.movesteps && "" != this.config.movesteps && (b.options.movesteps = this.config.movesteps);
  return new viewer.viewercontroller.flamingo.FlamingoMap(b);
}, createWMSLayer:function(a, b, c, d, e) {
  e = {};
  e.name = a;
  e.url = b;
  e.timeout = 30;
  e.retryonerror = 1;
  e.initService = !1;
  b = null;
  for (var f in c) {
    e[f] = c[f];
  }
  for (f in d) {
    "id" == f.toLowerCase() ? b = d[f] : e[f] = d[f];
  }
  void 0 != d.alpha && (e.alpha = 100 - d.alpha);
  null == b && (b = a);
  return new viewer.viewercontroller.flamingo.FlamingoWMSLayer({id:b, options:e, frameworkLayer:this.viewerObject, viewerController:this.viewerController});
}, createTilingLayer:function(a, b, c, d) {
  if (void 0 == c || null == c) {
    c = {};
  }
  c.url = b;
  c.type = c.protocol;
  void 0 != c.alpha && (c.alpha = 100 - c.alpha);
  return Ext.create("viewer.viewercontroller.flamingo.FlamingoTilingLayer", c);
}, createArcConfig:function(a, b, c, d) {
  var e = b.substring(0, b.indexOf("/", 7));
  b = -1 != b.indexOf("?") ? b.substring(b.indexOf("/", 7) + 1, b.indexOf("?")) : b.substring(b.indexOf("/", 7) + 1);
  c.visibleids = c.layers;
  var f = c.id;
  delete c.id;
  c.name = a;
  c.server = e;
  c.servlet = b;
  c.timeout = 30;
  c.retryonerror = 1;
  c.initService = !1;
  return {id:f, options:c, frameworkLayer:this.viewerObject, viewerController:d};
}, createArcIMSLayer:function(a, b, c, d) {
  a = this.createArcConfig(a, b, c, d);
  return new viewer.viewercontroller.flamingo.FlamingoArcIMSLayer(a);
}, createArcServerLayer:function(a, b, c, d) {
  a = this.createArcConfig(a, b, c, d);
  c.mapservice = c.servlet.substring(21, c.servlet.toLowerCase().indexOf("/mapserver"));
  delete a.options.servlet;
  a.options.esriArcServerVersion = "9.3";
  a.options.dataframe = "layers";
  return new viewer.viewercontroller.flamingo.FlamingoArcServerLayer(a);
}, createImageLayer:function(a, b, c, d) {
  return Ext.create("viewer.viewercontroller.flamingo.FlamingoImageLayer", {id:a, url:b, extent:c, frameworkLayer:this.viewerObject, viewerController:this.viewerController});
}, createVectorLayer:function(a) {
  a.frameworkLayer = this.viewerObject;
  return new viewer.viewercontroller.flamingo.FlamingoVectorLayer(a);
}, createTool:function(a) {
  Ext.isEmpty(a.listenTo) && (a.listenTo = this.getMap().getId());
  a.viewerController = this.viewerController;
  a.type == viewer.viewercontroller.controller.Tool.MAP_CLICK ? a = Ext.create("viewer.viewercontroller.flamingo.ToolMapClick", a) : a.type == viewer.viewercontroller.controller.Tool.TOGGLE || a.type == viewer.viewercontroller.controller.Tool.MAP_TOOL ? (a.toggle = !0, a = Ext.create("viewer.components.tools.JSButton", a)) : a.type == viewer.viewercontroller.controller.Tool.BUTTON ? (a.toggle = !1, a = Ext.create("viewer.components.tools.JSButton", a)) : a = a.type === viewer.viewercontroller.controller.Tool.MEASUREAREA ? 
  Ext.create("viewer.components.tools.FlamingoMeasureArea", a) : new viewer.viewercontroller.flamingo.FlamingoTool(a);
  a.frameworkObject = this.viewerObject;
  return a;
}, createComponent:function(a) {
  Ext.isEmpty(a.listenTo) && (a.listenTo = this.getMap().getId());
  Ext.isEmpty(a.id) && (a.id = a.name);
  a.viewerController = this.viewerController;
  return a.type == viewer.viewercontroller.controller.Component.OVERVIEW ? Ext.create("viewer.viewercontroller.flamingo.Overview", a) : new viewer.viewercontroller.flamingo.FlamingoComponent(a);
}, createToolGroup:function(a) {
  var b = this.viewerController.getLayout("top_menu"), c = b.height ? b.height : -1, d = "";
  if (0 <= c) {
    var e = c;
    b.heightmeasure && (e += "px" == b.heightmeasure ? "" : b.heightmeasure);
    d += "\x3cfmc:Container top\x3d'0' width\x3d'100%' height\x3d'" + e + "'";
    b.bgcolor && (d += "backgroundcolor\x3d'" + b.bgcolor + "'");
    d += "\x3e";
  }
  var d = d + "\x3cfmc:ToolGroup ", f;
  for (f in a) {
    d += f + '\x3d"' + a[f] + '" ';
  }
  d += "\x3e\x3c/fmc:ToolGroup\x3e";
  0 <= c && (d += "\x3c/fmc:Container\x3e");
  this.viewerObject.callMethod(this.mainContainerId, "addComponent", d);
}, addTool:function(a) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoTool || Ext.Error.raise({msg:"The given tool is not of type 'FlamingoTool'"});
  var b = this.tools.length;
  null == a.getLeft() && null == a.getRight() && a.setLeft(b * this.toolMargin);
  this.getToolGroup(a);
  viewer.viewercontroller.FlamingoMapComponent.superclass.addTool.call(this, a);
  b = "\x3cfmc:ToolGroup id\x3d'" + this.toolGroupId + "'\x3e";
  b += a.toXML();
  this.viewerObject.callMethod(this.flamingoId, "addComponent", b + "\x3c/fmc:ToolGroup\x3e");
  var b = 0, c = !1;
  try {
    c = a instanceof viewer.components.tools.JSButton;
  } catch (e) {
    c = !1;
  }
  if (a.getVisible() && !c) {
    for (c = 0;c < this.tools.length;c++) {
      var d = !1;
      try {
        d = this.tools[c] instanceof viewer.components.tools.JSButton;
      } catch (e) {
        d = !1;
      }
      this.tools[c].getVisible() && !d && b++;
    }
    1 == b && this.activateTool(a.getId());
  }
}, getNumberOfVisibleTools:function() {
  for (var a = 0, b = 0;b < this.tools.length;b++) {
    this.tools[b].getVisible() && a++;
  }
  return a;
}, getToolGroup:function(a) {
  if (!this.toolGroupCreated) {
    var b = this.getMap().id;
    if (void 0 == b || null == b) {
      b = a.getListenTo();
    }
    this.createToolGroup({id:this.toolGroupId, listento:b, width:"100%", height:"100", left:"5", top:"5"});
    this.toolGroupCreated = !0;
  }
  return this.toolGroupId;
}, createBottomContent:function() {
  var a = this.viewerController.getLayout("content_bottom"), b = a && a.height && 0 <= a.height ? a.height : -1;
  return 0 < b ? (a.heightmeasure && (b += "px" == a.heightmeasure ? "" : a.heightmeasure), b = "\x3cfmc:Container id\x3d'bottomContainer' bottom\x3d'bottom' width\x3d'100%' height\x3d'" + b + "'", a.bgcolor && (b += "backgroundcolor\x3d'" + a.bgcolor + "'"), this.addComponentXml(b + "\x3e\x3c/fmc:Container\x3e"), "bottomContainer") : null;
}, addComponentXml:function(a) {
  this.viewerObject.callMethod(this.mainContainerId, "addComponent", a);
}, activateTool:function(a, b) {
  b && (a = this.tools[0].id);
  this.viewerObject.call(this.toolGroupId, "setTool", a);
}, removeTool:function(a) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoTool || Ext.Error.raise({msg:"The given tool is not of type 'FlamingoTool'"});
  this.viewerObject.callMethod(a.getId(), "setVisible", !1);
  MapComponent.prototype.removeTool.call(this, a);
}, removeToolById:function(a) {
  a = this.getTool(a);
  null != a && a instanceof viewer.viewercontroller.flamingo.FlamingoTool || Ext.Error.raise({msg:"The given tool is not of type 'FlamingoTool' or the given id does not exist"});
  this.removeTool(a);
}, addComponent:function(a) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoComponent || Ext.Error.raise({msg:"The given Component is not of type 'FlamingoComponent'"});
  viewer.viewercontroller.FlamingoMapComponent.superclass.addComponent.call(this, a);
  var b = this.mainContainerId, c = a.toXML();
  "content_bottom" == a.config.regionName && (0 <= this.viewerController.getLayoutHeight("content_bottom") && null == this.bottomContainerId && (this.bottomContainerId = this.createBottomContent()), this.bottomContainerId && (b = this.bottomContainerId));
  b && this.viewerObject.callMethod(b, "addComponent", c);
  a.type == viewer.viewercontroller.controller.Component.MAPTIP && void 0 == this.viewerObject.callMethod(this.getMap().id, "getMaptipdelay") && this.viewerObject.callMethod(this.getMap().id, "setMaptipdelay", a.getMaptipdelay());
}, addMap:function(a) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoMap || Ext.Error.raise({msg:"FlamingoMapComponent.addMap(): The given map is not of the type 'FlamingoMap'"});
  this.viewerObject.callMethod(this.mainContainerId, "addComponent", a.toXML());
  this.maps.push(a);
}, getMap:function(a) {
  if (void 0 == a && 1 == this.maps.length) {
    return this.maps[0];
  }
  for (var b = "", c = 0;c < this.maps.length;c++) {
    if (0 != c && (b += ","), b += this.maps[c].getId(), this.maps[c].getId() == a) {
      return this.maps[c];
    }
  }
  return null;
}, getObject:function(a) {
  a instanceof Array && (a = a[0]);
  a = "" + a;
  if (null != this.getMap(a)) {
    return this.getMap(a);
  }
  if (this.getMap() && null != this.getMap().getLayer(a)) {
    return this.getMap().getLayer(a);
  }
  if (this.getMap() && 0 == a.indexOf(this.getMap().getId() + "_") && null != this.getMap().getLayer(a.replace(this.getMap().getId() + "_", ""))) {
    return this.getMap().getLayer(a.replace(this.getMap().getId() + "_", ""));
  }
  if (null != this.getTool(a)) {
    return this.getTool(a);
  }
  if (a == this.getId()) {
    return this;
  }
  if (this.getMap() && this.getMap().gisId == a) {
    return this.getMap();
  }
  if (!this.getMap() || !this.getMap().editMapId) {
    return null;
  }
}, handleEvents:function(a, b) {
  var c = b[0], d = this.getObject(c);
  if ("onEvent" == a) {
    b[1].rollover || b[1].rolloff ? a = viewer.viewercontroller.controller.Event.ON_EVENT_OVER : b[1].toggle ? b[1].selected && b[1].down ? a = viewer.viewercontroller.controller.Event.ON_EVENT_DOWN : !b[1].selected && b[1].down && (a = viewer.viewercontroller.controller.Event.ON_EVENT_UP) : b[1].down && (a = viewer.viewercontroller.controller.Event.ON_EVENT_DOWN);
  } else {
    if ("onHideLayer" == a || "onShowLayer" == a) {
      var e = this.getObject(b[1]);
      this.getMap();
      var f = "onShowLayer" == a;
      a = viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED;
      b = {};
      b.layer = e;
      b.visible = f;
    } else {
      if (a = this.getGenericEventName(a), null == a) {
        return;
      }
    }
  }
  if (a == viewer.viewercontroller.controller.Event.ON_REQUEST) {
    var g = b[2];
    "GetMap" == g.requesttype && (c = b[0].split("_"), 2 == c.length && this.getMap(c[0]).getLayer(c[1]).setURL(g.url), 3 == c.length && this.getMap(c[0]).getLayer(c[1] + "_" + c[2]).setURL(g.url));
  } else {
    if (a == viewer.viewercontroller.controller.Event.ON_SET_TOOL) {
      c = this.getId(), d = this.getObject(c);
    } else {
      if (a == viewer.viewercontroller.controller.Event.ON_ACTIVATE) {
        console.log("On Activate");
      } else {
        if (a == viewer.viewercontroller.controller.Event.ON_DEACTIVATE) {
          console.log("On Deactivate");
        } else {
          if (a == viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO) {
            var c = b[1], e = (c.minx + c.maxx) / 2, f = (c.miny + c.maxy) / 2, h = d.coordinateToPixel(e, f);
            b = e = {coord:{x:e, y:f}, x:h.x, y:h.y};
          } else {
            if (a == viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO_PROGRESS) {
              b = {nr:b[1], total:b[2]};
            } else {
              if (a == viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO_DATA) {
                c = b[2];
                e = (c.minx + c.maxx) / 2;
                f = (c.miny + c.maxy) / 2;
                h = this.getMap().coordinateToPixel(e, f);
                e = {coord:{x:e, y:f}, x:h.x, y:h.y};
                e.extent = c;
                e.nr = b[4];
                e.total = b[5];
                c = [];
                f = 0;
                for (g in b[1]) {
                  c[f] = {request:{appLayer:d.appLayerId, serviceLayer:g}, features:b[1][g]}, f++;
                }
                e.data = c;
                b = e;
              } else {
                if (a == viewer.viewercontroller.controller.Event.ON_LAYER_ADDED) {
                  g = b[1];
                  0 == g.indexOf(c + "_") && (g = g.substring(c.length + 1));
                  e = d.getLayer(g);
                  if (null == e) {
                    return;
                  }
                  b = {layer:e};
                } else {
                  if (a == viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED) {
                    g = b[1], 0 == g.indexOf(c + "_") && (g = g.substring(c.length + 1)), e = d.getLayer(g), b = {}, b.layer = e;
                  } else {
                    if (a == viewer.viewercontroller.controller.Event.ON_MAPTIP) {
                      e = {}, e.x = b[1], e.y = b[2], e.coord = b[3], b = e;
                    } else {
                      if (a == viewer.viewercontroller.controller.Event.ON_MAPTIP_DATA) {
                        e = {};
                        e.coord = b[2];
                        e.x = b[2].x;
                        e.y = b[2].y;
                        e.coord.x = b[2].minx;
                        e.coord.y = b[2].miny;
                        c = [];
                        f = 0;
                        for (g in b[1]) {
                          c[f] = {request:{appLayer:d.appLayerId, serviceLayer:g}, features:b[1][g]};
                        }
                        e.data = c;
                        b = e;
                      } else {
                        if (a == viewer.viewercontroller.controller.Event.ON_ACTIVE_FEATURE_CHANGED || a == viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED) {
                          g = b[1].fmc_layername, d = this.getMap().getLayer(g), b = Ext.create("viewer.viewercontroller.controller.Feature", b[1]);
                        } else {
                          if (a == viewer.viewercontroller.controller.Event.ON_ALL_LAYERS_LOADING_COMPLETE) {
                            if (!this.viewerController.layersInitialized) {
                              return;
                            }
                          } else {
                            if (a == viewer.viewercontroller.controller.Event.ON_FINISHED_CHANGE_EXTENT) {
                              e = {};
                              if (b[1]) {
                                e.extent = new viewer.viewercontroller.controller.Extent(b[1].minx, b[1].miny, b[1].maxx, b[1].maxy);
                              } else {
                                return;
                              }
                              b = e;
                            } else {
                              a == viewer.viewercontroller.controller.Event.ON_CHANGE_EXTENT ? b = e = {extent:d.getExtent()} : a == viewer.viewercontroller.controller.Event.ON_MAP_CLICKED && (b = e = {coord:b[1]});
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  void 0 != d && d.fire(a, b);
}, fire:function(a, b) {
  this.fireEvent(a, this, b);
}, addListener:function(a, b, c) {
  viewer.viewercontroller.FlamingoMapComponent.superclass.addListener.call(this, a, b, c);
}, getWidth:function() {
  return this.viewerObject.callMethod(this.flamingoId, "getWidth");
}, getHeight:function() {
  return this.viewerObject.callMethod(this.flamingoId, "getHeight");
}, setCursor:function(a, b) {
}, makeFlamingoAcceptableId:function(a) {
  a = "" + a;
  -1 != a.indexOf(":") && (a = a.replace(/:/g, "_"));
  return a;
}});
function dispatchEventJS(a, b) {
  null == b[0] && (b[0] = FlamingoAppLoader.get("viewerController").mapComponent.getId(), b[1] = {});
  try {
    FlamingoAppLoader.get("viewerController").mapComponent.handleEvents(a, b);
  } catch (c) {
    window.console && console.log && console.log(c);
  }
}
;Ext.define("viewer.viewercontroller.flamingo.Overview", {extend:"viewer.viewercontroller.flamingo.FlamingoComponent", showButton:null, config:{position:null, url:null, lox:null, loy:null, rbx:null, rby:null, picSelected:null, picOver:null, picNormal:null, picTop:null, picLeft:null, followZoom:null}, constructor:function(a) {
  this.initConfig(a);
  viewer.viewercontroller.flamingo.Overview.superclass.constructor.call(this, this.config);
  this.events = [];
  return this;
}, toXML:function() {
  var a = this.lox + "," + this.loy + "," + this.rbx + "," + this.rby, b = "\x3cfmc:Map id\x3d'Map" + this.name + "'  width\x3d'" + this.width + "' height\x3d'" + this.height + "' clear\x3d'true' ", b = b + ("extent\x3d'" + this.config.viewerController.mapComponent.getMap().getExtent().toString() + "' fullextent\x3d'" + this.config.viewerController.mapComponent.getMap().getMaxExtent().toString() + "'"), b = b + ("listento\x3d'" + this.config.viewerController.mapComponent.getMap().getId() + "'\x3e"), 
  b = b + ("\x3cfmc:LayerOverview xmlns:fmc\x3d'fmc' id\x3d'LayerOverview" + this.name + "' listento\x3d'" + this.config.viewerController.mapComponent.getMap().getId() + "' color\x3d'#76B6D1'"), b = void 0 !== this.followZoom && null !== this.followZoom && !1 === this.followZoom ? b + " followfactor\x3d'10000'/\x3e" : b + " followfactor\x3d'200'/\x3e", b = b + ("\x3cfmc:LayerImage id\x3d'layerimageoverview" + this.name + "' imageurl\x3d'" + this.url + "'"), b = b + (" extent\x3d'" + a + "' listento\x3d'" + 
  this.config.viewerController.mapComponent.getMap().getId() + "'/\x3e"), b = b + "\x3c/fmc:Map\x3e", a = "";
  if ("upperleft" == this.position) {
    var c = this.config.viewerController.getLayout("top_menu"), a = "left \x3d 'left 0' top \x3d '" + c.height, a = a + ("px" == c.heightmeasure ? "" : c.heightmeasure), a = a + "'"
  } else {
    "upperright" == this.position ? (c = this.config.viewerController.getLayout("top_menu"), a = "right \x3d 'right 0' top \x3d '" + c.height, a += "px" == c.heightmeasure ? "" : c.heightmeasure, a += "'") : "lowerleft" == this.position ? (c = this.config.viewerController.getLayout("content_bottom"), a = "left \x3d 'left 0' bottom \x3d 'bottom -" + c.height, a += "px" == c.heightmeasure ? "" : c.heightmeasure, a += "'") : "lowerright" == this.position && (c = this.config.viewerController.getLayout("content_bottom"), 
    a = "right \x3d 'right 0' bottom \x3d 'bottom -" + c.height, a += "px" == c.heightmeasure ? "" : c.heightmeasure, a += "'");
  }
  c = {toggle:!0, enabled:!0, visible:!0, selected:!0};
  c.iconUrl_up = this.picNormal;
  c.iconUrl_over = this.picOver;
  c.iconUrl_sel = this.picSelected;
  c.iconUrl_dis = this.picNormal;
  c.left = this.picLeft;
  c.top = this.picTop;
  c.viewerController = this.config.viewerController;
  c.tooltip = "Open/sluit de overzichtskaart";
  this.showButton = Ext.create("viewer.components.tools.JSButton", c);
  var d = this;
  this.showButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN, function() {
    d.showOverview(!0);
  }, this);
  this.showButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_UP, function() {
    d.showOverview(!1);
  }, this);
  a = "\x3cfmc:Container id\x3d'" + this.name + "windowcontainer' " + a + " width\x3d'" + this.width + "' height\x3d'" + this.height + "' borderwidth\x3d'0' bordercolor\x3d'#D0D0D0' backgroundcolor\x3d'#FFFFFF'\x3e";
  return a + b + "\x3c/fmc:Container\x3e";
}, getExtComponents:function() {
  return [];
}, showOverview:function(a) {
  this.config.viewerController.mapComponent.viewerObject.callMethod(this.name + "windowcontainer", "setVisible", a);
}});
Ext.define("viewer.components.tools.JSButton", {extend:"viewer.viewercontroller.flamingo.FlamingoTool", config:{name:"JSButton", iconUrl_up:null, iconUrl_over:null, iconUrl_sel:null, iconUrl_dis:null, toggle:!1, enabled:!1, selected:!1, tooltip:null}, constructor:function(a) {
  this.initConfig(a);
  viewer.components.tools.JSButton.superclass.constructor.call(this, this.config);
  this.id = this.name;
  this.mapComponent = this.config.viewerController.mapComponent;
  this.frameworkObject = this.config.viewerController.mapComponent.viewerObject;
  this.config.viewerController.mapComponent.addTool(this);
  return this;
}, toXML:function() {
  var a;
  a = "\x3cfmc:" + this.getTagName();
  a += " xmlns:fmc\x3d'fmc'";
  null != this.getId() && (a += " id\x3d'" + this.getId() + "'");
  null != this.getWidth() && (a += " width\x3d'" + this.getWidth() + "'");
  null != this.getHeight() && (a += " height\x3d'" + this.getHeight() + "'");
  null != this.getTop() && (a += " top\x3d'" + this.getTop() + "'");
  null != this.getLeft() && (a += " left\x3d'" + this.getLeft() + "'");
  null != this.getRight() && (a += " right\x3d'" + this.getRight() + "'");
  null != this.getBottom() && (a += " bottom\x3d'" + this.getBottom() + "'");
  null != this.getListenTo() && (a += " listento\x3d'" + this.getListenTo() + "'");
  a += " iconurl_up\x3d'" + this.iconUrl_up + "'";
  a += " iconurl_down\x3d'" + this.iconUrl_down + "'";
  a += " iconurl_over\x3d'" + this.iconUrl_over + "'";
  a += " iconurl_sel\x3d'" + this.iconUrl_sel + "'";
  a += " iconurl_dis\x3d'" + this.iconUrl_dis + "'";
  void 0 != this.visible && (a += " visible\x3d'" + this.visible + "'");
  null != this.getEnabled() && (a += " enabled\x3d'" + this.enabled + "'");
  a += " selected\x3d'" + this.selected + "'";
  a += " toggle\x3d'" + this.toggle + "'";
  a += "\x3e";
  null != this.getTooltip() && (a += "\x3cstring id\x3d'tooltip' en\x3d'" + this.getTooltip() + "'/\x3e");
  return a += "\x3c/fmc:" + this.getTagName(this.getType()) + "\x3e";
}, getTagName:function() {
  return "JsButton";
}, activate:function() {
  this.setSelectedState(!0);
}, deactivate:function() {
  this.setSelectedState(!1);
}, setSelectedState:function(a) {
  this.frameworkObject.callMethod(this.getId(), "setSelectedState", a);
}});
Ext.define("viewer.components.tools.FlamingoMeasureArea", {extend:"viewer.viewercontroller.flamingo.FlamingoTool", config:{name:"MeasureArea", iconUrl_up:null, iconUrl_over:null, iconUrl_sel:null, iconUrl_dis:null, toggle:!1, enabled:!1, selected:!1, tooltip:null}, vectorLayer:null, button:null, constructor:function(a) {
  this.initConfig(a);
  viewer.components.tools.FlamingoMeasureArea.superclass.constructor.call(this, this.config);
  this.id = this.name;
  a.iconUrl_up = FlamingoAppLoader.get("contextPath") + "/viewer-html/components/resources/images/measureArea/ruler_square.png";
  a.iconUrl_over = FlamingoAppLoader.get("contextPath") + "/viewer-html/components/resources/images/measureArea/ruler_square_over.png";
  a.iconUrl_sel = FlamingoAppLoader.get("contextPath") + "/viewer-html/components/resources/images/measureArea/ruler_square_over.png";
  a.iconUrl_dis = FlamingoAppLoader.get("contextPath") + "/viewer-html/components/resources/images/measureArea/ruler_square.png";
  a.toggle = !0;
  a.left = this.picLeft;
  a.top = this.picTop;
  this.button = Ext.create("viewer.components.tools.JSButton", a);
  var b = this;
  this.button.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN, function() {
    b.startMeasure(!0);
  }, this);
  this.button.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_UP, function() {
    b.startMeasure(!1);
  }, this);
  this.vectorLayer = this.config.viewerController.mapComponent.createVectorLayer({name:"measureAreaVector", geometrytypes:["Polygon"], showmeasures:!0, viewerController:this.config.viewerController, style:{fillcolor:"FF0000", fillopacity:50, strokecolor:"FF0000", strokeopacity:50}});
  this.config.viewerController.mapComponent.getMap().addLayer(this.vectorLayer);
  this.vectorLayer.addListener(viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED, function() {
    this.startMeasure(!1);
  }, this);
  this.mapComponent = this.config.viewerController.mapComponent;
  this.frameworkObject = this.config.viewerController.mapComponent.viewerObject;
  this.config.viewerController.mapComponent.addTool(this);
  return this;
}, startMeasure:function(a) {
  a ? this.vectorLayer.drawFeature("Polygon") : this.vectorLayer.removeAllFeatures();
}, toXML:function() {
  return "";
}, getTagName:function() {
  return "";
}, activate:function() {
  this.setSelectedState(!0);
}, deactivate:function() {
  this.setSelectedState(!1);
}, setSelectedState:function(a) {
  this.frameworkObject.callMethod(this.getId(), "setSelectedState", a);
}});
