/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.geotools.filter.visitor.RemoveDistanceUnit;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.WFSFeatureSource;
import nl.b3p.viewer.util.ChangeMatchCase;
import nl.b3p.viewer.util.FeatureToJson;
import nl.b3p.viewer.util.FlamingoCQL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.text.cql2.CQLException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/attributes")
@StrictBinding
public class AttributesActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(AttributesActionBean.class);
    private ActionBeanContext context;
    @Validate
    private Application application;
    @Validate
    private ApplicationLayer appLayer;
    @Validate
    private SimpleFeatureType featureType;
    protected Layer layer = null;
    @Validate
    private int limit;
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private String dir;
    @Validate
    private String sort;
    @Validate
    private boolean arrays;
    @Validate
    private boolean edit = false;
    @Validate
    private String filter;
    @Validate
    private boolean aliases = true;
    @Validate
    private boolean includeRelations = true;
    @Validate
    private boolean debug;
    @Validate
    private boolean noCache;
    private boolean unauthorized;
    private boolean userAllowedToEditGeom = true;
    @Validate
    private List<Long> attributesToInclude = new ArrayList<Long>();
    @Validate
    private List<Long> attributesNotNull = new ArrayList<Long>();
    @Validate
    private boolean graph = false;
    private static final String CACHE_APPLAYER = "total_count_cache_applayer";
    private static final String CACHE_FILTER = "total_count_cache_filter";
    private static final String CACHE_TIME = "total_count_cache_time";
    private static final String CACHE_COUNT = "total_count_cache";
    private static final int CACHE_MAX_AGE = 600000;
    private static final int MAX_CACHE_SIZE = 50;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public boolean isArrays() {
        return this.arrays;
    }

    public void setArrays(boolean arrays) {
        this.arrays = arrays;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(SimpleFeatureType ft) {
        this.featureType = ft;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public List<Long> getAttributesToInclude() {
        return this.attributesToInclude;
    }

    public void setAttributesToInclude(List<Long> attributesToInclude) {
        this.attributesToInclude = attributesToInclude;
    }

    public boolean isGraph() {
        return this.graph;
    }

    public void setGraph(boolean graph) {
        this.graph = graph;
    }

    public List<Long> getAttributesNotNull() {
        return this.attributesNotNull;
    }

    public void setAttributesNotNull(List<Long> attributesNotNull) {
        this.attributesNotNull = attributesNotNull;
    }

    public boolean isAliases() {
        return this.aliases;
    }

    public void setAliases(boolean aliases) {
        this.aliases = aliases;
    }

    public boolean isIncludeRelations() {
        return this.includeRelations;
    }

    public void setIncludeRelations(boolean includeRelations) {
        this.includeRelations = includeRelations;
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void loadLayer() {
        this.layer = this.appLayer.getService().getSingleLayer(this.appLayer.getLayerName(), Stripersist.getEntityManager());
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.application == null || this.appLayer == null || !Authorizations.isApplicationReadAuthorized((Application)this.application, (HttpServletRequest)this.context.getRequest(), (EntityManager)em) || !Authorizations.isAppLayerReadAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
            this.unauthorized = true;
        }
        this.userAllowedToEditGeom = Authorizations.isLayerGeomWriteAuthorized((Layer)this.layer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em);
    }

    public Resolution attributes() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = null;
        if (this.appLayer == null) {
            error = "Invalid parameters";
        } else if (this.unauthorized) {
            error = "Not authorized";
        } else {
            this.appLayer.addAttributesJSON(json, true, Stripersist.getEntityManager());
            if (!this.userAllowedToEditGeom) {
                JSONArray attr = json.getJSONArray("attributes");
                if (json.has("geometryAttributeIndex")) {
                    JSONObject geomAttr = attr.getJSONObject(json.getInt("geometryAttributeIndex"));
                    geomAttr.put("userAllowedToEditGeom", this.userAllowedToEditGeom);
                }
            }
            json.put("success", (Object)Boolean.TRUE);
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public static void clearTotalCountCache(ActionBeanContext context) {
        HttpSession sess = context.getRequest().getSession();
        sess.removeAttribute(CACHE_APPLAYER);
        sess.removeAttribute(CACHE_FILTER);
        sess.removeAttribute(CACHE_TIME);
        sess.removeAttribute(CACHE_COUNT);
    }

    private int lookupTotalCountCache(Callable<Integer> countProducer) throws Exception {
        Long time;
        HttpSession session = this.context.getRequest().getSession();
        Integer total = null;
        Long age = null;
        Long cacheAppLayerId = (Long)session.getAttribute(CACHE_APPLAYER);
        if (this.appLayer.getId().equals(cacheAppLayerId) && (this.filter == null && session.getAttribute(CACHE_FILTER) == null || this.filter != null && this.filter.equals(session.getAttribute(CACHE_FILTER))) && (time = (Long)session.getAttribute(CACHE_TIME)) != null && (age = Long.valueOf(System.currentTimeMillis() - time)) <= 600000L) {
            total = (Integer)session.getAttribute(CACHE_COUNT);
        }
        if (total != null) {
            log.debug((Object)String.format("Returning cached total count value %d which was cached %s ms ago for app layer id %d", total, age, this.appLayer.getId()));
            return total;
        }
        long startTime = System.currentTimeMillis();
        total = countProducer.call();
        log.debug((Object)String.format("Caching total count value %d which took %d ms to get for app layer id %d", total, System.currentTimeMillis() - startTime, this.appLayer.getId()));
        session.setAttribute(CACHE_APPLAYER, (Object)this.appLayer.getId());
        session.setAttribute(CACHE_FILTER, (Object)this.filter);
        session.setAttribute(CACHE_TIME, (Object)System.currentTimeMillis());
        session.setAttribute(CACHE_COUNT, (Object)total);
        return total;
    }

    private void setFilter(Query q, SimpleFeatureType ft, ApplicationLayer al, EntityManager em) throws Exception {
        if (this.filter != null && this.filter.trim().length() > 0) {
            Filter f = FlamingoCQL.toFilter(this.filter, em);
            f = (Filter)f.accept((FilterVisitor)new RemoveDistanceUnit(), null);
            f = (Filter)f.accept((FilterVisitor)new ChangeMatchCase(false), null);
            f = FeatureToJson.reformatFilter(f, ft, this.includeRelations);
            q.setFilter(f);
        }
        this.setAttributesNotNullFilters(q, al, ft, em);
    }

    public Resolution store() throws JSONException, Exception {
        JSONObject json = new JSONObject();
        if (this.unauthorized) {
            json.put("success", false);
            json.put("message", (Object)"Not authorized");
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        json = this.executeStore(Stripersist.getEntityManager());
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }

    protected JSONObject executeStore(EntityManager em) {
        JSONObject json = new JSONObject();
        try {
            int total = 0;
            if (this.featureType != null || this.layer != null && this.layer.getFeatureType() != null) {
                FeatureSource fs;
                SimpleFeatureType ft = this.featureType;
                if (ft == null) {
                    ft = this.layer.getFeatureType();
                }
                if (this.isDebug() && ft.getFeatureSource() instanceof WFSFeatureSource) {
                    HashMap<String, Boolean> extraDataStoreParams = new HashMap<String, Boolean>();
                    extraDataStoreParams.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.FALSE);
                    fs = ((WFSFeatureSource)ft.getFeatureSource()).openGeoToolsFeatureSource(ft, extraDataStoreParams);
                } else {
                    fs = ft.openGeoToolsFeatureSource();
                }
                boolean startIndexSupported = fs.getQueryCapabilities().isOffsetSupported();
                final Query q = new Query(fs.getName().toString());
                this.setFilter(q, ft, this.appLayer, em);
                final FeatureSource fs2 = fs;
                total = this.lookupTotalCountCache(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return fs2.getCount(q);
                    }
                });
                if (total == -1) {
                    json.put("virtualtotal", true);
                    total = 1000;
                }
                q.setStartIndex(Integer.valueOf(this.start));
                q.setMaxFeatures(Math.min(this.limit, 1000));
                FeatureToJson ftoj = new FeatureToJson(this.arrays, this.edit, this.graph, this.aliases, this.attributesToInclude);
                JSONArray features = ftoj.getJSONFeatures(this.appLayer, ft, fs, q, this.sort, this.dir, em, null, null);
                if (!startIndexSupported && features.length() < this.limit) {
                    total = this.start + features.length();
                }
                json.put("success", true);
                json.put("features", (Object)features);
            }
            json.put("total", total);
        }
        catch (Exception e) {
            log.error((Object)"Error loading features", (Throwable)e);
            json.put("success", false);
            String message = "Fout bij ophalen features: " + e.toString();
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                message = message + "; " + cause.toString();
            }
            json.put("message", (Object)message);
        }
        return json;
    }

    private void setAttributesNotNullFilters(Query q, ApplicationLayer al, SimpleFeatureType ft, EntityManager em) throws CQLException {
        FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        List attrs = al.getAttributes(ft);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (ConfiguredAttribute attr : attrs) {
            if (!this.attributesNotNull.contains(attr.getId())) continue;
            Filter f = FlamingoCQL.toFilter(attr.getAttributeName() + " is not null", em);
            filters.add(f);
        }
        if (q.getFilter() != null) {
            filters.add(q.getFilter());
        }
        And and = ff2.and(filters);
        q.setFilter((Filter)and);
    }
}

