/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.services.SolrConf;
import nl.b3p.viewer.search.SearchClient;
import nl.b3p.viewer.search.SearchResult;
import nl.b3p.viewer.solr.SolrInitializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

public class SolrSearchClient
extends SearchClient {
    private static final Log log = LogFactory.getLog(SolrSearchClient.class);
    private JSONObject config;
    private List<Long> visibleLayers;
    private Map<Long, SolrConf> configMap = new HashMap<Long, SolrConf>();

    @Override
    public SearchResult search(String term) {
        SearchResult result = new SearchResult();
        JSONArray respDocs = new JSONArray();
        try {
            if (term == null) {
                term = "";
            } else {
                String[] terms = term.split(" ");
                String newTerm = null;
                for (String t : terms) {
                    newTerm = newTerm != null ? newTerm + " AND " : "";
                    newTerm = newTerm + t;
                }
                term = newTerm;
                term = term.replaceAll("\\:", "\\\\:");
                term = term + " AND (";
            }
            SolrServer server = SolrInitializer.getServerInstance();
            String extraQuery = this.createAttributeSourceQuery();
            term = !extraQuery.isEmpty() ? term + extraQuery + ")" : term + "searchConfig:\\-1)";
            SolrQuery query = new SolrQuery();
            query.setQuery(term);
            query.setRequestHandler("/select");
            QueryResponse rsp = server.query((SolrParams)query);
            SolrDocumentList list = rsp.getResults();
            for (SolrDocument solrDocument : list) {
                JSONObject doc = this.solrDocumentToResult(solrDocument);
                if (doc == null) continue;
                respDocs.put((Object)doc);
            }
            result.setResults(respDocs);
            result.setLimitReached(list.getNumFound() > (long)list.size());
        }
        catch (SolrServerException ex) {
            log.error((Object)"Error doing solr search:", (Throwable)ex);
        }
        catch (JSONException ex) {
            log.error((Object)"Error doing solr search:", (Throwable)ex);
        }
        return result;
    }

    @Override
    public JSONArray autosuggest(String term) throws JSONException {
        JSONObject obj = new JSONObject();
        JSONArray respDocs = new JSONArray();
        try {
            SolrServer server = SolrInitializer.getServerInstance();
            JSONObject response = new JSONObject();
            response.put("docs", (Object)respDocs);
            obj.put("response", (Object)response);
            String extraQuery = this.createAttributeSourceQuery();
            term = term + " AND (";
            term = !extraQuery.isEmpty() ? term + extraQuery + ")" : term + "searchConfig:\\-1)";
            SolrQuery query = new SolrQuery();
            query.setQuery(term);
            query.setRequestHandler("/select");
            QueryResponse rsp = server.query((SolrParams)query);
            SolrDocumentList list = rsp.getResults();
            for (SolrDocument solrDocument : list) {
                JSONObject doc = this.solrDocumentToResult(solrDocument);
                if (doc == null) continue;
                respDocs.put((Object)doc);
            }
            response.put("docs", (Object)respDocs);
            return respDocs;
        }
        catch (SolrServerException ex) {
            log.error((Object)ex);
            return respDocs;
        }
    }

    private String createAttributeSourceQuery() throws JSONException {
        String extraQuery = "";
        JSONObject solrConfigsJson = this.config.getJSONObject("solrConfig");
        Iterator it = solrConfigsJson.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!this.canBeSearched(key)) continue;
            if (!extraQuery.isEmpty()) {
                extraQuery = extraQuery + " OR ";
            }
            extraQuery = extraQuery + "searchConfig:" + key;
        }
        return extraQuery;
    }

    private boolean canBeSearched(String key) throws JSONException {
        JSONObject solrConfigsJson = this.config.getJSONObject("solrConfig");
        JSONObject solrConfig = solrConfigsJson.getJSONObject(key);
        JSONArray requiredLayers = solrConfig.getJSONArray("requiredLayers");
        boolean allVisible = true;
        for (int i = 0; i < requiredLayers.length(); ++i) {
            long reqLayerId = requiredLayers.getInt(i);
            boolean visible = false;
            for (Long visibleId : this.visibleLayers) {
                if (visibleId != reqLayerId) continue;
                visible = true;
                break;
            }
            if (visible) continue;
            allVisible = false;
            break;
        }
        return allVisible;
    }

    private JSONObject solrDocumentToResult(SolrDocument doc) {
        JSONObject result = null;
        try {
            Collection resultValues = doc.getFieldValues("resultValues");
            if (resultValues != null) {
                result = new JSONObject();
                String resultLabel = "";
                ArrayList labels = new ArrayList(resultValues);
                for (String label : labels) {
                    if (!resultLabel.isEmpty()) {
                        resultLabel = resultLabel + ", ";
                    }
                    resultLabel = resultLabel + label;
                }
                result.put("label", (Object)resultLabel);
                HashMap<String, Object> bbox = new HashMap<String, Object>();
                bbox.put("minx", doc.getFieldValue("minx"));
                bbox.put("miny", doc.getFieldValue("miny"));
                bbox.put("maxx", doc.getFieldValue("maxx"));
                bbox.put("maxy", doc.getFieldValue("maxy"));
                result.put("location", bbox);
                result.put("searchConfig", doc.getFieldValue("searchConfig"));
                String naam = this.getConfigurationNaam((Integer)doc.getFieldValue("searchConfig"));
                result.put("type", (Object)naam);
            }
        }
        catch (JSONException ex) {
            log.error((Object)ex);
        }
        return result;
    }

    private String getConfigurationNaam(Integer id) {
        Long longValue = new Long(id.intValue());
        if (!this.configMap.containsKey(longValue)) {
            EntityManager em = Stripersist.getEntityManager();
            SolrConf configuration = (SolrConf)em.find(SolrConf.class, (Object)longValue);
            this.configMap.put(longValue, configuration);
            return configuration.getName();
        }
        return this.configMap.get(longValue).getName();
    }

    public JSONObject getConfig() {
        return this.config;
    }

    public void setConfig(JSONObject config) {
        this.config = config;
    }

    public void setVisibleLayers(List<Long> visibleLayers) {
        this.visibleLayers = visibleLayers;
    }
}

