/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.util.Set;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.mail.Mailer;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ConfiguredComponent;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

@UrlBinding(value="/action/contact")
@StrictBinding
public class ContactActionBean
extends LocalizableApplicationActionBean
implements ActionBean {
    private static final Log LOG = LogFactory.getLog(ContactActionBean.class);
    private static final String COMPONENT_NAME = "viewer.components.Contactform";
    @Validate
    private String params;
    @Validate
    private Application application;
    private ActionBeanContext context;

    @DefaultHandler
    public Resolution contact() throws JSONException {
        JSONObject req = new JSONObject(this.params);
        JSONObject config = this.getContactformConfig();
        JSONObject resp = new JSONObject();
        resp.put("success", false);
        resp.put("message", (Object)this.getBundle().getString("viewer.contactactionbean.not_configured"));
        if (config != null && config.has("receiverTo") && StringUtils.isNotEmpty((CharSequence)config.getString("receiverTo"))) {
            String subject = this.getBundle().getString("viewer.contactactionbean.default_subject");
            if (config.has("receiverSubject") && StringUtils.isNotEmpty((CharSequence)config.getString("receiverSubject"))) {
                subject = config.getString("receiverSubject");
            }
            try {
                Mailer.sendMail((String)req.getString("name"), (String)req.getString("email"), (String)config.getString("receiverTo"), (String)subject, (String)req.getString("message"));
                resp.put("success", true);
                resp.remove("message");
            }
            catch (Exception ex) {
                LOG.error((Object)("Error sending mail. " + ex.getLocalizedMessage()), (Throwable)ex);
            }
        }
        return new StreamingResolution("application/json", resp.toString());
    }

    private JSONObject getContactformConfig() throws JSONException {
        JSONObject obj = null;
        if (this.application != null) {
            Set components = this.application.getComponents();
            for (ConfiguredComponent comp : components) {
                if (!comp.getClassName().equals(COMPONENT_NAME)) continue;
                obj = new JSONObject(comp.getConfig());
                break;
            }
        }
        return obj;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }
}

