/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.util.Locale;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.controller.LifecycleStage;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.i18n.ResourceBundleProvider;
import nl.b3p.viewer.config.app.Application;
import org.apache.commons.lang.LocaleUtils;

abstract class LocalizableApplicationActionBean
extends LocalizableActionBean
implements ActionBean {
    LocalizableApplicationActionBean() {
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void initBundle() {
        Locale locale = LocalizableApplicationActionBean.determineLocaleForBundle(this.getContext(), this.getApplication());
        this.setBundle(ResourceBundleProvider.getResourceBundle((Locale)locale));
    }

    public static Locale determineLocaleForBundle(ActionBeanContext context, Application application) {
        Locale locale = context.getRequest().getLocale();
        if (application != null) {
            try {
                locale = LocaleUtils.toLocale((String)application.getLang());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return locale;
    }

    public abstract Application getApplication();
}

