/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.util.LayerListHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/layerList")
@StrictBinding
public class LayerListActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(LayerListActionBean.class);
    private ActionBeanContext context;
    @Validate
    private Long appId;
    @Validate
    private Boolean filterable = false;
    @Validate
    private Boolean bufferable = false;
    @Validate
    private Boolean editable = false;
    @Validate
    private Boolean influence = false;
    @Validate
    private Boolean arc = false;
    @Validate
    private Boolean wfs = false;
    @Validate
    private Boolean attribute = false;
    @Validate
    private Boolean hasConfiguredLayers = false;
    @Validate
    private List<Long> layers = new ArrayList();

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Boolean getBufferable() {
        return this.bufferable;
    }

    public void setBufferable(Boolean bufferable) {
        this.bufferable = bufferable;
    }

    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public Boolean getFilterable() {
        return this.filterable;
    }

    public void setFilterable(Boolean filterable) {
        this.filterable = filterable;
    }

    public Boolean getInfluence() {
        return this.influence;
    }

    public void setInfluence(Boolean influence) {
        this.influence = influence;
    }

    public Boolean getArc() {
        return this.arc;
    }

    public void setArc(Boolean arc) {
        this.arc = arc;
    }

    public Boolean getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Boolean attribute) {
        this.attribute = attribute;
    }

    public Boolean getWfs() {
        return this.wfs;
    }

    public void setWfs(Boolean wfs) {
        this.wfs = wfs;
    }

    public List<Long> getLayers() {
        return this.layers;
    }

    public void setLayers(List<Long> layers) {
        this.layers = layers;
    }

    public Boolean getHasConfiguredLayers() {
        return this.hasConfiguredLayers;
    }

    public void setHasConfiguredLayers(Boolean hasConfiguredLayers) {
        this.hasConfiguredLayers = hasConfiguredLayers;
    }

    public Resolution source() {
        EntityManager em = Stripersist.getEntityManager();
        JSONArray jsonArray = new JSONArray();
        if (this.appId != null) {
            Application app = (Application)em.find(Application.class, (Object)this.appId);
            HttpServletRequest request = this.context.getRequest();
            List filteredLayers = LayerListHelper.getLayers((Application)app, (Boolean)this.filterable, (Boolean)this.bufferable, (Boolean)this.editable, (Boolean)this.influence, (Boolean)this.arc, (Boolean)this.wfs, (Boolean)this.attribute, (Boolean)this.hasConfiguredLayers, (List)this.layers, (EntityManager)em);
            for (ApplicationLayer layer : filteredLayers) {
                if (!Authorizations.isAppLayerReadAuthorized((Application)app, (ApplicationLayer)layer, (HttpServletRequest)request, (EntityManager)em)) continue;
                try {
                    jsonArray.put((Object)layer.toJSONObject(em));
                }
                catch (JSONException je) {
                    log.error((Object)("Error while getting JSONObject of Layer with id: " + layer.getId()), (Throwable)je);
                }
            }
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(jsonArray.toString()));
    }
}

