Ext.define("viewer.viewercontroller.openlayers.OpenLayersLayer", {config:{name:null}, enabledEvents:null, events:null, type:null, alpha:100, constructor:function(a) {
  this.initConfig(a);
  this.enabledEvents = {};
  this.events = {};
  return this;
}, getOption:function(a) {
  a = a.toLowerCase();
  for (var b in this.getFrameworkLayer().options) {
    if (b.toLowerCase() == a) {
      return this.getFrameworkLayer().options[b];
    }
  }
  for (b in this.getFrameworkLayer().params) {
    if (b.toLowerCase() == a) {
      return this.getFrameworkLayer().params[b];
    }
  }
  return null;
}, setOption:function(a, b) {
  var c = {};
  c[a] = b;
  this.getFrameworkLayer().setOptions(c);
}, setAlpha:function(a) {
  this.alpha = a;
  this.frameworkLayer && this.frameworkLayer.setOpacity(a / 100);
}, getAlpha:function() {
  return this.alpha;
}, reload:function() {
  this.getFrameworkLayer().redraw(!0);
}, addListener:function(a, b, c) {
  var d = this.config.viewerController.mapComponent.getSpecificEventName(a);
  d && (c || (c = this), "featureadded" == !d && (this.enabledEvents[d] ? this.enabledEvents[d]++ : (this.enabledEvents[d] = 1, this.frameworkLayer.events.register(d, this, this.handleEvent))));
  viewer.viewercontroller.controller.Layer.superclass.addListener.call(this, a, b, c);
}, removeListener:function(a, b, c) {
  var d = this.config.viewerController.mapComponent.getSpecificEventName(a);
  d && (c || (c = this), this.enabledEvents[d] && (this.enabledEvents[d]--, 0 >= this.enabledEvents[d] && (this.enabledEvents[d] = 0, this.frameworkLayer.events.unregister(d, this, this.handleEvent))));
  viewer.viewercontroller.controller.Layer.superclass.removeListener.call(this, a, b, c);
}, getType:function() {
  return this.type;
}, handleEvent:function(a) {
  var b = {};
  b.layer = this.map.getLayerByOpenLayersId(a.element.id);
  b.feature = this.fromOpenLayersFeature(a.feature);
  var c = this.config.viewerController.mapComponent.getGenericEventName(a.type);
  c || (c = a);
  this.fireEvent(c, b);
}, setVisible:function(a) {
  this.visible = a;
  null != this.frameworkLayer && this.frameworkLayer.setVisibility(a);
}, getVisible:function() {
  return null != this.frameworkLayer ? this.frameworkLayer.getVisibility() : null;
}, destroy:function() {
  null != this.frameworkLayer && this.frameworkLayer.destroy();
  "viewer.viewercontroller.openlayers.OpenLayersArcLayer" == this.superclass.$className ? this.superclass.superclass.destroy.call(this) : this.superclass.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.openlayers.OpenLayersArcLayer", {extend:"viewer.viewercontroller.controller.ArcLayer", mixins:{openLayersLayer:"viewer.viewercontroller.openlayers.OpenLayersLayer"}, constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersArcLayer.superclass.constructor.call(this, a);
  this.mixins.openLayersLayer.constructor.call(this, a);
  this.initConfig(a);
  return this;
}, getId:function() {
  return this.id;
}, getName:function() {
  return this.options.name;
}, getServer:function() {
  return this.options.server;
}, getService:function() {
  return this.options.service;
}, getServlet:function() {
  return this.options.servlet;
}, getMapservice:function() {
  return this.options.mapservice;
}, getLayers:function() {
  return this.options.layers;
}, getLegendGraphic:function() {
  return null;
}, setBuffer:function(a, b) {
  console.log(i18next.t("viewer_viewercontroller_openlayers_openlayersarclayer_0"));
}, removeBuffer:function(a) {
  console.log(i18next.t("viewer_viewercontroller_openlayers_openlayersarclayer_1"));
}, getType:function() {
  return this.mixins.openLayersLayer.getType.call(this);
}, setVisible:function(a) {
  this.mixins.openLayersLayer.setVisible.call(this, a);
}, getVisible:function() {
  return this.mixins.openLayersLayer.getVisible.call(this);
}, setAlpha:function(a) {
  this.mixins.openLayersLayer.setAlpha.call(this, a);
}, reload:function() {
  this.mixins.openLayersLayer.reload.call(this);
}, addListener:function(a, b, c) {
  this.mixins.openLayersLayer.addListener.call(this, a, b, c);
}, removeListener:function(a, b, c) {
  this.mixins.openLayersLayer.removeListener.call(this, a, b, c);
}, destroy:function() {
  this.mixins.openLayersLayer.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.openlayers.OpenLayersArcIMSLayer", {extend:"viewer.viewercontroller.openlayers.OpenLayersArcLayer", constructor:function(a) {
  this.id = a.id;
  viewer.viewercontroller.openlayers.OpenLayersArcIMSLayer.superclass.constructor.call(this, a);
  this.initConfig(a);
  this.type = viewer.viewercontroller.controller.Layer.ARCIMS_TYPE;
  a = {async:!0, singleTile:!1, tileSize:new OpenLayers.Size(1024, 1024), transparent:!0, format:"image/png", opacity:void 0 != this.config.opacity ? this.config.opacity : 1, attribution:this.config.attribution};
  a.serviceName = this.serviceName;
  a.filterCoordSys = "28992";
  a.featureCoordSys = "28992";
  a.layers = [{id:this.layers, visible:!0, query:{where:""}}];
  this.frameworkLayer = new OpenLayers.Layer.ArcIMS(this.name, this.url, a);
  return this;
}, setBuffer:function(a, b) {
  this.config.viewerController.logger.error(i18next.t("viewer_viewercontroller_openlayers_openlayersarcimslayer_0"));
}, removeBuffer:function(a) {
}, setQuery:function(a) {
  if (a) {
    var b = this;
    Ext.create("viewer.ArcQueryUtil").cqlToArcXMLWhere(a.getCQL(), function(a) {
      b.frameworkLayer.layers[0].query.where = a;
      b.reload();
    }, this.config.viewerController.logger.error);
  } else {
    this.frameworkLayer.layers[0].query.where = "", this.reload();
  }
}});
Ext.define("viewer.viewercontroller.openlayers.OpenLayersArcServerLayer", {extend:"viewer.viewercontroller.openlayers.OpenLayersArcLayer", constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersArcServerLayer.superclass.constructor.call(this, a);
  this.frameworkLayer = new OpenLayers.Layer.ArcGIS93Rest(this.name, this.url + "/export", {layers:"show:" + a.layers, transparent:"true"}, {visibility:this.visible, singleTile:!0, transitionEffect:"resize", opacity:void 0 != this.config.opacity ? this.config.opacity : 1, attribution:this.config.attribution});
  this.type = viewer.viewercontroller.controller.Layer.ARCSERVERREST_TYPE;
}, getLastMapRequest:function() {
  var a = this.getFrameworkLayer().map.getExtent(), a = this.getFrameworkLayer().getURL(a), b = "SIZE\x3d" + this.getMap().getWidth() + "%2C" + this.getMap().getHeight(), a = a.replace("SIZE\x3d256%2C256", b);
  return [{url:a}];
}, setQuery:function(a) {
  var b = this;
  a = null != a ? a.getCQL() : "";
  "" != a ? Ext.create("viewer.ArcQueryUtil").cqlToArcFIDS(a, this.appLayerId, function(a, d) {
    var e = "-1";
    0 != a.length && (e = d + " IN(" + a.join(",") + ")");
    b.getFrameworkLayer().setLayerFilter(b.layers, e);
    setTimeout(function() {
      b.reload();
    }, 500);
  }, function(a) {
    b.getViewerController().logger.error(a);
  }) : (b.getFrameworkLayer().setLayerFilter(b.layers, null), setTimeout(function() {
    b.reload();
  }, 500));
}});
Ext.define("viewer.viewercontroller.openlayers.OpenLayersWMSLayer", {extend:"viewer.viewercontroller.controller.WMSLayer", mixins:{openLayersLayer:"viewer.viewercontroller.openlayers.OpenLayersLayer"}, constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersWMSLayer.superclass.constructor.call(this, a);
  this.mixins.openLayersLayer.constructor.call(this, a);
  this.options.visibility = this.visible;
  this.options.singleTile = !0;
  this.options.serviceId = a.serviceId;
  this.options.transitionEffect = "resize";
  this.options.attribution = this.config.attribution;
  this.frameworkLayer = new OpenLayers.Layer.WMS(this.options.name, this.url, this.ogcParams, this.options);
  this.type = viewer.viewercontroller.controller.Layer.WMS_TYPE;
  this.mapTipControl = this.getFeatureInfoControl = null;
}, getLastMapRequest:function() {
  return [{url:this.getFrameworkLayer().getURL(this.getFrameworkLayer().map.getExtent())}];
}, getLayers:function() {
  return this.getFrameworkLayer().options.layers;
}, getStyles:function() {
  return this.getFrameworkLayer().options.styles;
}, setUrl:function(a) {
  this.url = a;
  this.getFrameworkLayer() && this.getFrameworkLayer().setUrl(a);
}, setOGCParams:function(a) {
  this.getFrameworkLayer().mergeNewParams(a);
}, setGetFeatureInfoControl:function(a) {
  this.getFeatureInfoControl = a;
}, getGetFeatureInfoControl:function() {
  return this.getFeatureInfoControl;
}, setMapTipControl:function(a) {
  this.mapTipControl = a;
}, getMapTipControl:function() {
  return this.mapTipControl;
}, setQuery:function(a, b, c) {
  if (a && "" != a.getCQL()) {
    var d = this.config.viewerController.app.services[this.serviceId].layers[this.options.name];
    if (void 0 != d.details) {
      var e = d.details.filterable;
      void 0 != e && null != e && (e = Ext.JSON.decode(e)) && (a = b ? Ext.create(viewer.SLD).createURLWithHash(b, c, this.options.layers, this.getOption("styles") || "default") : Ext.create(viewer.SLD).createURL(this.options.layers, this.getOption("styles") || "default", null, d.hasFeatureType ? d.featureTypeName : null, this.config.sld ? this.config.sld.id : null, a.getCQL()), this.setOGCParams({SLD:a}), this.reload());
    }
  } else {
    this.setOGCParams({SLD:this.config.originalSldUrl || null});
  }
}, setVisible:function(a) {
  this.mixins.openLayersLayer.setVisible.call(this, a);
}, getVisible:function() {
  return this.mixins.openLayersLayer.getVisible.call(this);
}, setAlpha:function(a) {
  this.mixins.openLayersLayer.setAlpha.call(this, a);
}, reload:function() {
  this.mixins.openLayersLayer.reload.call(this);
}, addListener:function(a, b, c) {
  this.mixins.openLayersLayer.addListener.call(this, a, b, c);
}, removeListener:function(a, b, c) {
  this.mixins.openLayersLayer.removeListener.call(this, a, b, c);
}, getType:function() {
  return this.mixins.openLayersLayer.getType.call(this);
}, destroy:function() {
  this.mixins.openLayersLayer.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.openlayers.OpenLayersVectorLayer", {extend:"viewer.viewercontroller.controller.VectorLayer", mixins:{openLayersLayer:"viewer.viewercontroller.openlayers.OpenLayersLayer"}, point:null, line:null, polygon:null, circle:null, box:null, freehand:null, drawFeatureControls:null, activeDrawFeatureControl:null, modifyFeature:null, constructor:function(a) {
  a.colorPrefix = "#";
  viewer.viewercontroller.openlayers.OpenLayersVectorLayer.superclass.constructor.call(this, a);
  this.mixins.openLayersLayer.constructor.call(this, a);
  this.defaultFeatureStyle = a.defaultFeatureStyle || this.mapStyleConfigToFeatureStyle();
  a.styleMap = this.getStylemapFromFeatureStyle(this.defaultFeatureStyle);
  delete a.style;
  this.frameworkLayer = new OpenLayers.Layer.Vector(a.id, a);
  this.type = viewer.viewercontroller.controller.Layer.VECTOR_TYPE;
  var b = this.config.viewerController.mapComponent.getMap().getFrameworkMap();
  a.showmeasures && (this.pathMeasureControl = new OpenLayers.Control.Measure(OpenLayers.Handler.Path), this.polygonMeasureControl = new OpenLayers.Control.Measure(OpenLayers.Handler.Polygon), b.addControl(this.pathMeasureControl), b.addControl(this.polygonMeasureControl));
  this.point = new OpenLayers.Control.DrawFeature(this.frameworkLayer, OpenLayers.Handler.Point, {displayClass:"olControlDrawFeaturePoint"}, this.frameworkLayer);
  this.line = new OpenLayers.Control.DrawFeature(this.frameworkLayer, OpenLayers.Handler.Path, this.addMeasureListener(OpenLayers.Handler.Path, {displayClass:"olControlDrawFeaturePath"}, this.frameworkLayer));
  this.polygon = new OpenLayers.Control.DrawFeature(this.frameworkLayer, OpenLayers.Handler.Polygon, this.addMeasureListener(OpenLayers.Handler.Polygon, {displayClass:"olControlDrawFeaturePolygon"}, this.frameworkLayer));
  this.circle = new OpenLayers.Control.DrawFeature(this.frameworkLayer, OpenLayers.Handler.RegularPolygon, {handlerOptions:{sides:40}});
  this.box = new OpenLayers.Control.DrawFeature(this.frameworkLayer, OpenLayers.Handler.RegularPolygon, {handlerOptions:{sides:4, irregular:!0}}, this.frameworkLayer);
  this.freehand = new OpenLayers.Control.DrawFeature(this.frameworkLayer, OpenLayers.Handler.Polygon, this.addMeasureListener(OpenLayers.Handler.Polygon, {displayClass:"olControlDrawFeaturePolygon", handlerOptions:{freehand:!0}}, this.frameworkLayer));
  this.freehandLine = new OpenLayers.Control.DrawFeature(this.frameworkLayer, OpenLayers.Handler.Path, this.addMeasureListener(OpenLayers.Handler.Path, {displayClass:"olControlDrawFeaturePath", handlerOptions:{freehand:!0}}, this.frameworkLayer));
  this.drawFeatureControls = [];
  this.drawFeatureControls.push(this.circle);
  this.drawFeatureControls.push(this.polygon);
  this.drawFeatureControls.push(this.line);
  this.drawFeatureControls.push(this.point);
  this.drawFeatureControls.push(this.box);
  this.drawFeatureControls.push(this.freehand);
  this.drawFeatureControls.push(this.freehandLine);
  this.modifyFeature = new OpenLayers.Control.ModifyFeature(this.frameworkLayer, {createVertices:void 0 !== a.mustCreateVertices && null !== a.mustCreateVertices ? a.mustCreateVertices : !0, vertexRenderIntent:"select"});
  b.addControl(this.point);
  b.addControl(this.line);
  b.addControl(this.polygon);
  b.addControl(this.circle);
  b.addControl(this.box);
  b.addControl(this.freehand);
  b.addControl(this.freehandLine);
  b.addControl(this.modifyFeature);
  var c = this;
  this.modifyFeature.selectControl.onBeforeSelect = function() {
    c.beforeSelect();
  };
  this.modifyFeature.selectControl.events.register("featurehighlighted", this, this.activeFeatureChanged);
  this.frameworkLayer.events.register("afterfeaturemodified", this, this.featureModified);
  this.frameworkLayer.events.register("featuremodified", this, this.featureModified);
  this.frameworkLayer.events.register("featureadded", this, this.featureAdded);
  this.allowSelection() && this.modifyFeature.activate();
}, beforeSelect:function() {
  this.config.viewerController.mapComponent.deselectAllOtherFeatures(this);
}, allowSelection:function() {
  return !this.config.hasOwnProperty("allowselection") || this.config.allowselection;
}, addMeasureListener:function(a, b, c) {
  if (this.config.showmeasures) {
    var d = a === OpenLayers.Handler.Path ? this.pathMeasureControl : this.polygonMeasureControl, e = this.config.name || "vectorMeasure";
    if (c) {
      c.events.on({sketchmodified:function(a) {
        viewer.viewercontroller.openlayers.tools.OpenLayersMeasureHandler.modifyHandler(d, {containerPrefix:e}, a.vertex);
      }});
    }
  }
  return b;
}, removeMeasures:function() {
  this.config.showmeasures && viewer.viewercontroller.openlayers.tools.OpenLayersMeasureHandler.removeMeasure(this.config.name || "vectorMeasure");
}, mapStyleConfigToFeatureStyle:function() {
  var a = {fillColor:this.colorPrefix + (this.getStyleConfig("fillcolor") || "FF0000"), fillOpacity:(this.getStyleConfig("fillopacity") || 100) / 100, strokeColor:this.colorPrefix + (this.getStyleConfig("strokecolor") || "FF0000"), strokeOpacity:(this.getStyleConfig("strokeopacity") || 100) / 100};
  return Ext.create("viewer.viewercontroller.controller.FeatureStyle", a);
}, getStylemapFromFeatureStyle:function(a) {
  return new OpenLayers.StyleMap({"default":this.getCurrentStyleHash(a), temporary:this.getCurrentStyleHash(a), select:this.getSelectedStyleHash(a)}, {extendDefault:!1});
}, getCurrentStyleHash:function(a) {
  a || (a = this.defaultFeatureStyle);
  a = a.getProperties();
  return Ext.Object.merge({}, {strokeWidth:3, pointRadius:6}, a);
}, getSelectedStyleHash:function(a) {
  a || (a = this.defaultFeatureStyle);
  a = a.getProperties();
  var b = this.getStyleConfig("fillcolor");
  return Ext.Object.merge({}, {strokeColor:"#FF0000", strokeWidth:2, fillColor:b ? this.colorPrefix + b : "transparent", fillOpacity:.4, strokeOpacity:.8, pointRadius:6}, a);
}, getStyleConfig:function(a) {
  return this.style && this.style.hasOwnProperty(a) ? this.style[a] : "";
}, adjustStyle:function() {
  this.defaultFeatureStyle = this.mapStyleConfigToFeatureStyle();
}, removeAllFeatures:function() {
  this.getFrameworkLayer().removeAllFeatures();
  this.stopDrawing();
}, getActiveFeature:function() {
  var a = this.getFrameworkLayer().features[0];
  return a ? this.fromOpenLayersFeature(a) : null;
}, getFeature:function(a) {
  return this.getFrameworkLayer().features[a];
}, getFeatureById:function(a) {
  return this.fromOpenLayersFeature(this.getFrameworkLayer().getFeatureById(a));
}, getAllFeatures:function(a) {
  for (var b = this.getFrameworkLayer().features, c = [], d = 0;d < b.length;d++) {
    var e = b[d];
    a && e._sketch || (e = this.fromOpenLayersFeature(e), c.push(e));
  }
  return c;
}, addFeature:function(a) {
  var b = [];
  b.push(a);
  this.addFeatures(b);
}, removeFeature:function(a) {
  a = this.getFrameworkLayer().getFeatureById(a.getId());
  this.modifyFeature.unselectFeature(a);
  this.getFrameworkLayer().removeFeatures([a]);
}, removeFeaturesByAttribute:function(a, b) {
  var c = this.getFrameworkLayer().getFeaturesByAttribute(a, b);
  this.getFrameworkLayer().removeFeatures(c);
}, addFeatures:function(a) {
  for (var b = [], c = 0;c < a.length;c++) {
    var d = a[c], e = this.toOpenLayersFeature(d);
    b.push(e);
    d.config.label && (e.style.label = d.config.label);
    d.config.color && (e.style.fillcolor = d.config.color, e.style.strokecolor = d.config.color);
  }
  return this.getFrameworkLayer().addFeatures(b);
}, drawFeature:function(a) {
  this.superclass.drawFeature.call(this, a);
  "Point" === a ? (this.activeDrawFeatureControl = this.point, this.point.activate()) : "LineString" === a ? (this.activeDrawFeatureControl = this.line, this.line.activate()) : "Polygon" === a ? (this.activeDrawFeatureControl = this.polygon, this.polygon.activate()) : "Circle" === a ? (this.activeDrawFeatureControl = this.circle, this.circle.activate()) : "Box" === a ? (this.activeDrawFeatureControl = this.box, this.box.activate()) : "Freehand" === a ? (this.activeDrawFeatureControl = this.freehand, 
  this.freehand.activate()) : "FreehandLine" === a ? (this.activeDrawFeatureControl = this.freehandLine, this.freehandLine.activate()) : this.config.viewerController.logger.warning("Feature type \x3e" + a + "\x3c not implemented!");
}, stopDrawing:function() {
  this.superclass.stopDrawing.call(this);
  this.point.active && (this.point.cancel(), this.point.deactivate());
  this.line.active && (this.line.cancel(), this.line.deactivate());
  this.polygon.active && (this.polygon.cancel(), this.polygon.deactivate());
  this.circle.active && (this.circle.cancel(), this.circle.deactivate());
  this.box.active && (this.box.cancel(), this.box.deactivate());
  this.freehand.active && (this.freehand.cancel(), this.freehand.deactivate());
  this.activeDrawFeatureControl = null;
}, undoSketch:function() {
  if (this.activeDrawFeatureControl && this.activeDrawFeatureControl !== this.circle) {
    try {
      this.activeDrawFeatureControl.undo();
    } catch (a) {
    }
  }
}, redoSketch:function() {
  this.activeDrawFeatureControl && this.activeDrawFeatureControl !== this.circle && this.activeDrawFeatureControl.redo();
}, cancelSketch:function() {
  this.activeDrawFeatureControl && this.activeDrawFeatureControl.cancel();
}, activeFeatureChanged:function(a) {
  a = this.fromOpenLayersFeature(a.feature);
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_ACTIVE_FEATURE_CHANGED, this, a);
}, featureModified:function(a) {
  var b = this.fromOpenLayersFeature(a.feature);
  this.removeMeasures();
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_ACTIVE_FEATURE_CHANGED, this, b, a);
}, featureAdded:function(a) {
  for (var b = this.fromOpenLayersFeature(a.feature), c = 0;c < this.drawFeatureControls.length;c++) {
    this.drawFeatureControls[c].deactivate();
  }
  a.feature.style || (a.feature.style = this.getCurrentStyleHash());
  this.removeMeasures();
  this.editFeature(a.feature);
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED, this, b);
}, editFeature:function(a) {
  this.modifyFeature.selectControl.unselectAll();
  this.modifyFeature.selectControl.select(a);
  a = this.fromOpenLayersFeature(a);
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_ACTIVE_FEATURE_CHANGED, this, a);
}, toOpenLayersFeature:function(a) {
  var b = OpenLayers.Geometry.fromWKT(a.config.wktgeom), c = this.getCurrentStyleHash();
  c.label = a.config.label;
  var d = a.getStyle();
  d && (c = Ext.Object.merge({}, c, this.toOpenLayersStyle(d)));
  a = Ext.Object.merge({}, {id:a.config.id}, a.getAttributes());
  return new OpenLayers.Feature.Vector(b, a, c);
}, fromOpenLayersFeature:function(a) {
  if (!a) {
    return null;
  }
  var b = new viewer.viewercontroller.controller.Feature({id:a.id, wktgeom:a.geometry.toString()});
  if (a.style) {
    b.label = a.style.label;
    var c = a.style.fillColor;
    -1 !== c.indexOf("#") && (c = c.substring(c.indexOf("#") + 1, c.length));
    b.color = c;
  }
  b.style = this.frameworkStyleToFeatureStyle(a).getProperties();
  this.config.addAttributesToFeature && (b.attributes = a.attributes);
  return b;
}, toOpenLayersStyle:function(a) {
  return a.getProperties();
}, frameworkStyleToFeatureStyle:function(a) {
  a = a.style || this.getCurrentStyleHash();
  return Ext.create("viewer.viewercontroller.controller.FeatureStyle", a);
}, setLabel:function(a, b) {
  var c = this.getFrameworkLayer().getFeatureById(a);
  c && (c.style.label = b, this.reload());
}, setFeatureStyle:function(a, b, c) {
  if (a = this.getFrameworkLayer().getFeatureById(a)) {
    a.style = Ext.Object.merge({}, a.style, b.getProperties()), c || this.reload();
  }
}, getFeatureGeometry:function(a) {
  return (a = this.getFrameworkLayer().getFeatureById(a)) ? a.geometry : {};
}, editFeatureById:function(a) {
  (a = this.getFrameworkLayer().getFeatureById(a)) && this.editFeature(a);
}, getFeatureSize:function(a) {
  var b = null;
  a = this.getFrameworkLayer().getFeatureById(a);
  if (!a) {
    return b;
  }
  if ("OpenLayers.Geometry.Polygon" === a.geometry.CLASS_NAME || "OpenLayers.Geometry.MultiPolygon" === a.geometry.CLASS_NAME || "OpenLayers.Geometry.LinearRing" === a.geometry.CLASS_NAME) {
    b = a.geometry.getArea();
  }
  if ("OpenLayers.Geometry.LineString" === a.geometry.CLASS_NAME || "OpenLayers.Geometry.MultiLineString" === a.geometry.CLASS_NAME) {
    b = a.geometry.getLength();
  }
  return b;
}, unselectAll:function() {
  this.modifyFeature.selectControl.unselectAll();
}, readGeoJSON:function(a) {
  a = (new OpenLayers.Format.GeoJSON).read(a);
  this.getFrameworkLayer().addFeatures(a);
}, setVisible:function(a) {
  this.mixins.openLayersLayer.setVisible.call(this, a);
}, getVisible:function() {
  return this.mixins.openLayersLayer.getVisible.call(this);
}, setAlpha:function(a) {
  this.mixins.openLayersLayer.setAlpha.call(this, a);
}, reload:function() {
  this.mixins.openLayersLayer.reload.call(this);
}, addListener:function(a, b, c) {
  this.mixins.openLayersLayer.addListener.call(this, a, b, c);
}, removeListener:function(a, b, c) {
  this.mixins.openLayersLayer.removeListener.call(this, a, b, c);
}, getType:function() {
  return this.mixins.openLayersLayer.getType.call(this);
}, destroy:function() {
  this.mixins.openLayersLayer.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.openlayers.OpenLayersImageLayer", {extend:"viewer.viewercontroller.controller.ImageLayer", mixins:{openLayersLayer:"viewer.viewercontroller.openlayers.OpenLayersLayer"}, constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersImageLayer.superclass.constructor.call(this, a);
  this.mixins.openLayersLayer.constructor.call(this, a);
  this.utils = Ext.create("viewer.viewercontroller.openlayers.Utils");
  this.type = viewer.viewercontroller.controller.Layer.IMAGE_TYPE;
  a = this.config.viewerController.mapComponent.getMap().getWidth();
  var b = this.config.viewerController.mapComponent.getMap().getHeight();
  null == this.options && (this.options = {});
  void 0 == this.options.maxExtent && (this.options.displayOutsideMaxExtent = !0, this.options.alwaysInRange = !0);
  this.options.visibility = this.visible;
  this.frameworkLayer = new OpenLayers.Layer.Image(this.name, this.url, this.utils.createBounds(this.extent), new OpenLayers.Size(a, b), this.options);
}, setExtent:function(a) {
  this.extent = a;
  this.frameworkLayer && (this.frameworkLayer.extent = this.utils.createBounds(a));
}, setUrl:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersImageLayer.superclass.setUrl.call(this, a);
  this.frameworkLayer && this.frameworkLayer.setUrl(a);
}, getLastMapRequest:function() {
  return [{url:this.url, extent:this.extent}];
}, getType:function() {
  return this.mixins.openLayersLayer.getType.call(this);
}, setVisible:function(a) {
  this.mixins.openLayersLayer.setVisible.call(this, a);
}, getVisible:function() {
  return this.mixins.openLayersLayer.getVisible.call(this);
}, setAlpha:function(a) {
  this.mixins.openLayersLayer.setAlpha.call(this, a);
}, reload:function() {
  this.mixins.openLayersLayer.reload.call(this);
}, addListener:function(a, b, c) {
  this.mixins.openLayersLayer.addListener.call(this, a, b, c);
}, removeListener:function(a, b, c) {
  this.mixins.openLayersLayer.removeListener.call(this, a, b, c);
}, destroy:function() {
  this.mixins.openLayersLayer.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.openlayers.OpenLayersTilingLayer", {extend:"viewer.viewercontroller.controller.TilingLayer", mixins:{openLayersLayer:"viewer.viewercontroller.openlayers.OpenLayersLayer"}, utils:null, serverRes:null, constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersTilingLayer.superclass.constructor.call(this, a);
  if (!Ext.Array.contains(["TMS", "ArcGisRest", "WMTS"], this.getProtocol())) {
    throw Error(i18next.t("viewer_viewercontroller_openlayers_openlayerstilinglayer_0") + this.getProtocol());
  }
  this.mixins.openLayersLayer.constructor.call(this, a);
  this.type = viewer.viewercontroller.controller.Layer.TILING_TYPE;
  this.utils = Ext.create("viewer.viewercontroller.openlayers.Utils");
  a = {serverResolutions:this.resolutions, type:this.extension, transitionEffect:1 === (void 0 !== this.config.opacity ? this.config.opacity : 1) ? "resize" : null, visibility:void 0 === this.visible ? !0 : this.visible, opacity:void 0 !== this.config.opacity ? this.config.opacity : 1, attribution:this.config.attribution};
  this.getTileWidth() && this.getTileHeight() && (a.tileSize = new OpenLayers.Size(this.getTileWidth(), this.getTileHeight()));
  if (this.serviceEnvelope) {
    var b = this.serviceEnvelope.split(","), c = Number(b[0]), d = Number(b[1]);
    if ("ArcGisRest" === this.getProtocol() || "WMTS" === this.getProtocol()) {
      d = Number(b[3]);
    }
    a.maxExtent = new OpenLayers.Bounds(Number(b[0]), Number(b[1]), Number(b[2]), Number(b[3]));
    a.tileOrigin = new OpenLayers.LonLat(c, d);
  }
  this.resolutions && (a.maxResolution = this.resolutions[0]);
  "TMS" === this.getProtocol() ? (this.url.lastIndexOf("/") === this.url.length - 1 && (this.url = this.url.substring(0, this.url.length - 1)), d = this.url.split("/"), c = d[d.length - 1], b = d[d.length - 2], d.splice(d.length - 2, 2), this.url = d.join("/") + "/", a.serviceVersion = b, a.layername = c, this.frameworkLayer = new OpenLayers.Layer.TMS(c, this.url, a)) : "ArcGisRest" === this.getProtocol() ? (a.resolutions = this.resolutions, a.projection = "EPSG:28992", this.frameworkLayer = new OpenLayers.Layer.ArcGISCache(this.name, 
  this.url, a)) : "WMTS" === this.getProtocol() && (a.url = this.url, a.style = this.config.style, a.layer = this.config.name, a.matrixSet = this.config.matrixSet.identifier, a.matrixIds = this.getMatrixIds(this.config.matrixSet.matrices), a.format = this.extension, a.serverResolutions = this.serverRes, this.config.matrixSet.bbox && (b = this.config.matrixSet.bbox, this.serviceEnvelope = b.minx + "," + b.miny + "," + b.maxx + "," + b.maxy), this.frameworkLayer = new OpenLayers.Layer.WMTS(a));
}, getMatrixIds:function(a) {
  var b = [], c = 1 / 2.8E-4;
  this.serverRes = [];
  for (var d = 0;d < a.length;d++) {
    var e = a[d], f = e.topLeftCorner, g = f.substring(0, f.indexOf(" ")), f = f.substring(f.indexOf(" ") + 1);
    this.serverRes.push(parseFloat(e.scaleDenominator) / c);
    e = {identifier:e.identifier, scaleDenominator:parseFloat(e.scaleDenominator), topLeftCorner:new OpenLayers.LonLat(g, f), tileWidth:e.tileWidth, tileHeight:e.tileHeight};
    b.push(e);
  }
  return b;
}, setUrl:function(a) {
  this.url = a;
}, getLayers:function() {
  return this.frameworkLayer.options.layername;
}, getLegendGraphic:function() {
  return null;
}, getLastMapRequest:function() {
  for (var a = [], b = this.getFrameworkLayer().grid, c = 0;c < b.length;c++) {
    for (var d = 0;d < b[c].length;d++) {
      var e = b[c][d], f = e.url;
      a.push({extent:this.utils.createExtent(e.bounds), url:f});
    }
  }
  return a;
}, setVisible:function(a) {
  this.mixins.openLayersLayer.setVisible.call(this, a);
}, getVisible:function() {
  return this.mixins.openLayersLayer.getVisible.call(this);
}, setAlpha:function(a) {
  this.frameworkLayer && (this.frameworkLayer.transitionEffect = 100 > a ? null : "resize");
  this.mixins.openLayersLayer.setAlpha.call(this, a);
}, reload:function() {
  this.mixins.openLayersLayer.reload.call(this);
}, addListener:function(a, b, c) {
  this.mixins.openLayersLayer.addListener.call(this, a, b, c);
}, removeListener:function(a, b, c) {
  this.mixins.openLayersLayer.removeListener.call(this, a, b, c);
}, getType:function() {
  return this.mixins.openLayersLayer.getType.call(this);
}, destroy:function() {
  this.mixins.openLayersLayer.destroy.call(this);
}});
Ext.define("viewer.viewercontroller.openlayers.OpenLayersTool", {extend:"viewer.viewercontroller.controller.Tool", controls:null, enabledEvents:null, constructor:function(a, b) {
  viewer.viewercontroller.openlayers.OpenLayersTool.superclass.constructor.call(this, a);
  this.frameworkObject = b;
  this.controls = [];
  this.enabledEvents = {};
  this.overwriteStyle(a);
  if (this.type == viewer.viewercontroller.controller.Tool.BUTTON) {
    var c = this;
    b.trigger = function() {
      c.fire(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN);
    };
  }
  return this;
}, overwriteStyle:function(a) {
  a.hasOwnProperty("iconUrl") && a.iconUrl && (this.iconUrl_dis = this.iconUrl_sel = this.iconUrl_over = this.iconUrl_up = a.iconUrl);
  if (null != this.iconUrl_up || null != this.iconUrl_sel) {
    this.frameworkObject.flamingoIconDefined = !0, a = "", null != this.iconUrl_up && (a += ".olControlPanel ." + this.frameworkObject.displayClass + "ItemInactive", a += '{background-image: url("' + this.iconUrl_up + '");background-repeat: no-repeat;background-position: center center;}'), null != this.iconUrl_sel && (a += ".olControlPanel ." + this.frameworkObject.displayClass + "ItemActive", a += '{background-image: url("' + this.iconUrl_sel + '");background-repeat: no-repeat;background-position: center center;}'), 
    Ext.util.CSS.createStyleSheet(a);
  }
}, setVisible:function(a) {
  this.visible = a;
  this.getFrameworkTool() && (a ? this.getFrameworkTool().panel_div.style.display = "block" : this.getFrameworkTool().panel_div.style.display = "none");
}, isActive:function() {
  return this.getFrameworkTool().active;
}, activate:function() {
  this.getFrameworkTool().activate();
}, deactivate:function() {
  this.getFrameworkTool().deactivate();
}, addListener:function(a, b, c) {
  var d = this.config.viewerController.mapComponent.getSpecificEventName(a);
  d && (c || (c = this), this.enabledEvents[d] ? this.enabledEvents[d]++ : (this.enabledEvents[d] = 1, this.frameworkObject.events.register(d, this, this.handleEvent)));
  viewer.viewercontroller.openlayers.OpenLayersTool.superclass.addListener.call(this, a, b, c);
}, removeListener:function(a, b, c) {
  var d = this.config.viewerController.mapComponent.getSpecificEventName(a);
  d && (c || (c = this), this.enabledEvents[d] && (this.enabledEvents[d]--, 0 >= this.enabledEvents[d] && (this.enabledEvents[d] = 0, this.frameworkObject.events.unregister(d, this, this.handleEvent))));
  viewer.viewercontroller.openlayers.OpenLayersTool.superclass.removeListener.call(this, a, b, c);
}, handleEvent:function(a) {
  var b = this.config.viewerController.mapComponent.getGenericEventName(a.type);
  b || (b = a);
  this.fire(b, {});
}});
Ext.define("viewer.viewercontroller.openlayers.OpenLayersMap", {extend:"viewer.viewercontroller.controller.Map", layersLoading:null, utils:null, markerIcons:null, constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersMap.superclass.constructor.call(this, a);
  this.initConfig(a);
  this.utils = Ext.create("viewer.viewercontroller.openlayers.Utils");
  var b = null;
  a.options.maxExtent && (b = this.utils.createBounds(a.options.maxExtent));
  var c;
  a.options.startExtent && (c = this.utils.createBounds(a.options.startExtent));
  c ? a.center = c.getCenterLonLat() : b ? a.center = b.getCenterLonLat() : this.config.viewerController.logger.error(i18next.t("viewer_viewercontroller_openlayers_openlayersmap_0"));
  a.restrictedExtent = b;
  var d = this;
  a.controls = [new OpenLayers.Control.Attribution, new OpenLayers.Control.Navigation];
  this.frameworkMap = new OpenLayers.Map(a.domId, a);
  this.frameworkMap.centerLayerContainer();
  if (a.options.startExtent) {
    var d = this, e = function() {
      d.zoomToExtent(a.options.startExtent);
      d.removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, e, e);
    };
    this.addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, e, e);
  }
  this.layersLoading = 0;
  this.markerLayer = null;
  this.defaultIcon = {};
  this.markerIcons = {"default":{icon:FlamingoAppLoader.get("contextPath") + "/viewer-html/common/openlayers/img/marker.png", defaultSize:17, align:"bottom"}, circle:{icon:FlamingoAppLoader.get("contextPath") + "/resources/images/circle.svg", defaultSize:25, align:"center"}, spinner:{icon:FlamingoAppLoader.get("contextPath") + "/resources/images/spinner.gif", defaultSize:17, align:"bottom"}};
  this.markers = {};
  this.getFeatureInfoControl = null;
  this.addListener(viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED, this.layerRemoved, this);
  this.viewerController.addListener(viewer.viewercontroller.controller.Event.ON_SELECTEDCONTENT_CHANGE, function() {
    this.markerLayer && this.frameworkMap.setLayerIndex(this.markerLayer, this.frameworkMap.getNumLayers());
  }, this);
  return this;
}, getAllWMSLayers:function() {
  for (var a = [], b = 0;b < this.layers.length;b++) {
    this.layers[b] instanceof viewer.viewercontroller.openlayers.OpenLayersWMSLayer && a.push(this.layers[b]);
  }
  return a;
}, getAllVectorLayers:function() {
  for (var a = [], b = 0;b < this.layers.length;b++) {
    this.layers[b] instanceof viewer.viewercontroller.openlayers.OpenLayersVectorLayer && a.push(this.layers[b]);
  }
  return a;
}, remove:function() {
  this.getFrameworkMap().destroy();
}, addLayer:function(a) {
  this.superclass.addLayer.call(this, a);
  var b = this.getFrameworkMap();
  a = a.getFrameworkLayer();
  try {
    b.addLayer(a);
  } catch (c) {
    this.config.viewerController.logger.error(c);
  }
}, removeLayer:function(a) {
  this.getFrameworkMap().removeLayer(a.getFrameworkLayer());
}, layerRemoved:function(a, b) {
  for (var c = b.layer.getFrameworkLayer(), d = 0;d < this.layers.length;d++) {
    if (this.layers[d].getFrameworkLayer().id == c.id) {
      this.layers.splice(d, 1);
      break;
    }
  }
}, setLayerVisible:function(a, b) {
  this.superclass.setLayerVisible.call(this, a, b);
  a.setVisible(b);
}, setLayerIndex:function(a, b) {
  this.getFrameworkMap().setLayerIndex(a.getFrameworkLayer(), b);
  return this.callParent(arguments);
}, setGetFeatureInfoControl:function(a) {
  if (a.type != Tool.GET_FEATURE_INFO) {
    throw i18next.t("viewer_viewercontroller_openlayers_openlayersmap_1") + a.type;
  }
  this.getFeatureInfoControl = a;
}, zoomToMaxExtent:function() {
  this.getFrameworkMap().zoomToExtent(this.getFrameworkMap().getMaxExtent());
}, zoomToExtent:function(a) {
  a = this.utils.createBounds(a);
  this.getFrameworkMap().zoomToExtent(a, !0);
}, zoomToScale:function(a) {
  this.getFrameworkMap().zoomToResolution(a);
}, zoomToResolution:function(a) {
  this.getFrameworkMap().zoomTo(this.getFrameworkMap().getZoomForResolution(a));
}, moveTo:function(a, b) {
  this.getFrameworkMap().panTo(new OpenLayers.LonLat(a, b));
}, setMaxExtent:function(a) {
  null != this.getFrameworkMap() && this.getFrameworkMap().setOptions({maxExtent:Utils.createBounds(a)});
}, getMaxExtent:function() {
  return Utils.createExtent(this.getFrameworkMap().getMaxExtent());
}, getExtent:function() {
  return this.utils.createExtent(this.getFrameworkMap().getExtent());
}, setMarker:function(a, b, c, d) {
  null === this.markerLayer && (this.markerLayer = new OpenLayers.Layer.Markers("Markers"), this.frameworkMap.addLayer(this.markerLayer));
  d || (d = "default");
  if (!Ext.isDefined(this.defaultIcon[d])) {
    var e = this.markerIcons.hasOwnProperty(d) ? this.markerIcons[d] : this.markerIcons["default"], f = e.defaultSize || 17, f = new OpenLayers.Size(f, f), g = new OpenLayers.Pixel(-(f.w / 2), -f.h);
    "center" === e.align && (g = new OpenLayers.Pixel(-(f.w / 2), -(f.h / 2)));
    this.defaultIcon[d] = new OpenLayers.Icon(e.icon, f, g);
  }
  d = this.defaultIcon[d].clone();
  void 0 === this.markers[a] ? (this.markers[a] = new OpenLayers.Marker(new OpenLayers.LonLat(b, c), d), this.markerLayer.addMarker(this.markers[a])) : this.markers[a].moveTo(this.frameworkMap.getLayerPxFromLonLat(new OpenLayers.LonLat(b, c)));
}, removeMarker:function(a) {
  this.markers[a] && null != this.markerLayer && (this.markerLayer.removeMarker(this.markers[a]), this.markers[a].destroy(), delete this.markers[a]);
}, addListener:function(a, b, c) {
  var d = this.viewerController.mapComponent.getSpecificEventName(a);
  d && (c || (c = this), this.enabledEvents[d] ? this.enabledEvents[d]++ : (this.enabledEvents[d] = 1, this.frameworkMap.events.register(d, this, this.handleEvent)));
  viewer.viewercontroller.openlayers.OpenLayersMap.superclass.addListener.call(this, a, b, c);
}, removeListener:function(a, b, c) {
  var d = this.viewerController.mapComponent.getSpecificEventName(a);
  d ? (c || (c = this), this.enabledEvents[d] && (this.enabledEvents[d]--, 0 >= this.enabledEvents[d] && (this.enabledEvents[d] = 0, this.frameworkMap.events.unregister(d, this, this.handleEvent))), viewer.viewercontroller.openlayers.OpenLayersMap.superclass.removeListener.call(this, a, b, c)) : this.viewerController.logger.warning(i18next.t("viewer_viewercontroller_openlayers_openlayersmap_2", {event:a}));
}, handleEvent:function(a) {
  var b = {}, c = this.config.viewerController.mapComponent.getGenericEventName(a.type);
  if (c == viewer.viewercontroller.controller.Event.ON_LAYER_ADDED) {
    if (b.layer = this.getLayerByOpenLayersId(a.layer.id), void 0 == b.layer) {
      return;
    }
  } else {
    if (c == viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED) {
      b.layer = this.getLayerByOpenLayersId(a.layer.id);
      if (void 0 == b.layer) {
        return;
      }
      b.visible = a.layer.visibility;
    } else {
      if (c == viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED) {
        if (b.layer = this.getLayerByOpenLayersId(a.layer.id), void 0 == b.layer) {
          return;
        }
      } else {
        c == viewer.viewercontroller.controller.Event.ON_FINISHED_CHANGE_EXTENT || c == viewer.viewercontroller.controller.Event.ON_ZOOM_END || c == viewer.viewercontroller.controller.Event.ON_CHANGE_EXTENT ? b.extent = this.getExtent() : this.config.viewerController.logger.error(i18next.t("viewer_viewercontroller_openlayers_openlayersmap_3", {genericEvent:c}));
      }
    }
  }
  this.fireEvent(c, this, b);
}, getScale:function() {
  return this.getResolution();
}, getActualScale:function() {
  if ("degrees" === this.units) {
    return "";
  }
  var a = OpenLayers.Util.getScaleFromResolution(this.getResolution(), this.units);
  return Math.round(a);
}, getResolution:function() {
  return this.getFrameworkMap().getResolution();
}, getResolutions:function() {
  return this.getFrameworkMap().resolutions;
}, coordinateToPixel:function(a, b) {
  return this.getFrameworkMap().getPixelFromLonLat(new OpenLayers.LonLat(a, b));
}, pixelToCoordinate:function(a, b) {
  var c = this.getFrameworkMap().getLonLatFromPixel(new OpenLayers.Pixel(a, b));
  return {x:c.lon, y:c.lat};
}, getCenter:function() {
  var a = this.getFrameworkMap().getCenter();
  a.x = a.lon;
  a.y = a.lat;
  return a;
}, getWidth:function() {
  return this.frameworkMap.getSize().w;
}, getHeight:function() {
  return this.frameworkMap.getSize().h;
}, updateSize:function() {
  this.getFrameworkMap().updateSize();
}, getLayerByOpenLayersId:function(a) {
  for (var b = 0;b < this.layers.length;b++) {
    if (this.layers[b] && this.layers[b].frameworkLayer && this.layers[b].frameworkLayer.id == a) {
      return this.layers[b];
    }
  }
}});
Ext.define("viewer.viewercontroller.openlayers.Utils", {createBounds:function(a) {
  return new OpenLayers.Bounds(a.minx, a.miny, a.maxx, a.maxy);
}, createExtent:function(a) {
  return new viewer.viewercontroller.controller.Extent(a.left, a.bottom, a.right, a.top);
}});
OpenLayers.Events.buttonclick = OpenLayers.Class({target:null, events:"mousedown mouseup click dblclick touchstart touchmove touchend keydown".split(" "), startRegEx:/^mousedown|touchstart$/, cancelRegEx:/^touchmove$/, completeRegEx:/^mouseup|touchend$/, isDeviceTouchCapable:"ontouchstart" in window || window.DocumentTouch && document instanceof window.DocumentTouch, initialize:function(a) {
  this.target = a;
  for (a = this.events.length - 1;0 <= a;--a) {
    this.target.register(this.events[a], this, this.buttonClick, {extension:!0});
  }
}, destroy:function() {
  for (var a = this.events.length - 1;0 <= a;--a) {
    this.target.unregister(this.events[a], this, this.buttonClick);
  }
  delete this.target;
}, getPressedButton:function(a) {
  var b = 3, c;
  do {
    if (OpenLayers.Element.hasClass(a, "olButton")) {
      c = a;
      break;
    }
    a = a.parentNode;
  } while (0 < --b && a);
  return c;
}, ignore:function(a) {
  var b = 3, c = !1;
  do {
    if ("a" === a.nodeName.toLowerCase()) {
      c = !0;
      break;
    }
    a = a.parentNode;
  } while (0 < --b && a);
  return c;
}, buttonClick:function(a) {
  var b = !0, c = OpenLayers.Event.element(a);
  if (c && (OpenLayers.Event.isLeftClick(a) && !this.isDeviceTouchCapable || !~a.type.indexOf("mouse"))) {
    if (c = this.getPressedButton(c)) {
      if ("keydown" === a.type) {
        switch(a.keyCode) {
          case OpenLayers.Event.KEY_RETURN:
          ;
          case OpenLayers.Event.KEY_SPACE:
            this.target.triggerEvent("buttonclick", {buttonElement:c}), OpenLayers.Event.stop(a), b = !1;
        }
      } else {
        if (this.startEvt) {
          if (this.completeRegEx.test(a.type)) {
            var b = OpenLayers.Util.pagePosition(c), d = OpenLayers.Util.getViewportElement(), e = window.pageYOffset || d.scrollTop;
            b[0] -= window.pageXOffset || d.scrollLeft;
            b[1] -= e;
            this.target.triggerEvent("buttonclick", {buttonElement:c, buttonXY:{x:this.startEvt.clientX - b[0], y:this.startEvt.clientY - b[1]}});
          }
          this.cancelRegEx.test(a.type) && a.touches && this.startEvt.touches && 4 < (4 < Math.abs(a.touches[0].olClientX - this.startEvt.touches[0].olClientX) || Math.abs(a.touches[0].olClientY - this.startEvt.touches[0].olClientY)) && delete this.startEvt;
          OpenLayers.Event.stop(a);
          b = !1;
        }
      }
      this.startRegEx.test(a.type) && (this.startEvt = a, OpenLayers.Event.stop(a), b = !1);
    } else {
      b = !this.ignore(OpenLayers.Event.element(a)), delete this.startEvt;
    }
  }
  return b;
}});
OpenLayers.Control.MouseWheelZoom = OpenLayers.Class(OpenLayers.Control, {button:null, initialize:function(a) {
  OpenLayers.Control.prototype.initialize.apply(this, arguments);
  this.handler = new OpenLayers.Handler.MouseWheel(this, {up:function(a, c) {
    this.wheelUp(a, c);
  }, down:function(a, c) {
    this.wheelDown(a, c);
  }});
}, wheelChange:function(a, b) {
  var c = this.map.getZoom(), d = this.map.getZoom() + Math.round(b), d = Math.max(d, 0), d = Math.min(d, this.map.getNumZoomLevels());
  if (d !== c) {
    var e = this.map.getSize(), c = e.w / 2 - a.xy.x, e = a.xy.y - e.h / 2, f = this.map.baseLayer.getResolutionForZoom(d), g = this.map.getLonLatFromPixel(a.xy), c = new OpenLayers.LonLat(g.lon + c * f, g.lat + e * f);
    this.map.setCenter(c, d);
  }
}, wheelUp:function(a, b) {
  this.wheelChange(a, b || 1);
}, wheelDown:function(a, b) {
  this.wheelChange(a, b || -1);
}});
OpenLayers.Control.LoadingPanel = OpenLayers.Class(OpenLayers.Control, {counter:0, maximized:!1, visible:!0, initialize:function(a) {
  OpenLayers.Control.prototype.initialize.apply(this, [a]);
}, setVisible:function(a) {
  (this.visible = a) ? OpenLayers.Element.show(this.div) : OpenLayers.Element.hide(this.div);
}, getVisible:function() {
  return this.visible;
}, hide:function() {
  this.setVisible(!1);
}, show:function() {
  this.setVisible(!0);
}, toggle:function() {
  this.setVisible(!this.getVisible());
}, addLayer:function(a) {
  a.layer && (a.layer.events.register("loadstart", this, this.increaseCounter), a.layer.events.register("loadend", this, this.decreaseCounter));
}, setMap:function(a) {
  OpenLayers.Control.prototype.setMap.apply(this, arguments);
  this.map.events.register("preaddlayer", this, this.addLayer);
  for (var b = 0;b < this.map.layers.length;b++) {
    var c = this.map.layers[b];
    c.events.register("loadstart", this, this.increaseCounter);
    c.events.register("loadend", this, this.decreaseCounter);
  }
}, increaseCounter:function() {
  this.counter++;
  0 < this.counter && !this.maximized && this.visible && this.maximizeControl();
}, decreaseCounter:function() {
  0 < this.counter && this.counter--;
  0 == this.counter && this.maximized && this.visible && this.minimizeControl();
}, draw:function() {
  OpenLayers.Control.prototype.draw.apply(this, arguments);
  return this.div;
}, minimizeControl:function(a) {
  this.div.style.display = "none";
  this.maximized = !1;
  null != a && OpenLayers.Event.stop(a);
}, maximizeControl:function(a) {
  this.div.style.display = "block";
  this.maximized = !0;
  null != a && OpenLayers.Event.stop(a);
}, destroy:function() {
  if (this.map && (this.map.events.unregister("preaddlayer", this, this.addLayer), this.map.layers)) {
    for (var a = 0;a < this.map.layers.length;a++) {
      var b = this.map.layers[a];
      b.events.unregister("loadstart", this, this.increaseCounter);
      b.events.unregister("loadend", this, this.decreaseCounter);
    }
  }
  OpenLayers.Control.prototype.destroy.apply(this, arguments);
}, CLASS_NAME:"OpenLayers.Control.LoadingPanel"});
OpenLayers.Control.Click = OpenLayers.Class(OpenLayers.Control, {defaultHandlerOptions:{single:!0, "double":!1, pixelTolerance:10, stopSingle:!1, stopDouble:!1}, initialize:function(a) {
  this.handlerOptions = OpenLayers.Util.extend({}, this.defaultHandlerOptions);
  Ext.apply(this.handlerOptions, a.handlerOptions);
  OpenLayers.Control.prototype.initialize.apply(this, arguments);
  a.click && (this.onClick = a.click);
  a.dblclick && (this.onDblclick = a.dblclick);
  this.handler = new OpenLayers.Handler.Click(this, {click:this.onClick, pixelTolerance:10, dblclick:this.onDblclick}, this.handlerOptions);
}, onClick:function(a) {
}, onDblclick:function(a) {
}});
function handleResponse(a, b, c, d, e) {
  this.cache || (this.cache = {});
  this.cache[c] || (this.cache[c] = {}, this.cache[c].features = [], this.cache[c].counter = 0);
  this.cache[c].counter++;
  var f = b.responseXML;
  f && f.documentElement || (f = b.responseText);
  f = this.format.read(f);
  this.cache[c].features = this.cache[c].features.concat(f);
  for (var g = 0;g < f.length;g++) {
    f[g].layerNames = d, f[g].styleNames = e, f[g].url = c;
  }
  !1 === this.drillDown ? this.triggerGetFeatureInfo(b, a, f, d, e) : (this._requestCount++, this._features = "object" === this.output ? (this._features || []).concat({url:c, features:f}) : (this._features || []).concat(f), b._headers.total === this.cache[c].counter && (this.cache[c].counter = 0, this.triggerGetFeatureInfo(b, a, this.cache[c].features, d, e), delete this._features, delete this._requestCount, delete this.cache[c], delete this._numRequests));
}
function requestWmsGFI(a, b) {
  var c = this.findLayers();
  if (0 == c.length) {
    this.events.triggerEvent("nogetfeatureinfo"), OpenLayers.Element.removeClass(this.map.viewPortDiv, "olCursorWait");
  } else {
    if (b = b || {}, !1 === this.drillDown) {
      var d = this.buildWMSOptions(this.url, c, a, c[0].params.FORMAT), c = OpenLayers.Request.GET(d);
      !0 === b.hover && (this.hoverRequest = c);
    } else {
      this._numRequests = this._requestCount = 0;
      this.features = [];
      for (var e = {}, f, g = 0, d = c.length;g < d;g++) {
        var h = c[g];
        f = OpenLayers.Util.isArray(h.url) ? h.url[0] : h.url;
        f in e ? e[f].push(h) : (this._numRequests++, e[f] = [h]);
      }
      for (f in e) {
        for (c = e[f], g = 0;g < c.length;g++) {
          d = this.buildWMSOptions(f, [c[g]], a, c[0].params.FORMAT), d.headers = {}, d.headers.total = c.length, d.headers.index = g, OpenLayers.Request.GET(d);
        }
      }
    }
  }
}
function buildWMSOptions(a, b, c, d) {
  for (var e = [], f = [], g = 0, h = b.length;g < h;g++) {
    null != b[g].params.LAYERS && (e = e.concat(b[g].params.LAYERS), null !== this.getStyleNames(b[g]) && "" !== this.getStyleNames(b[g]) && (f = f.concat(this.getStyleNames(b[g]))));
  }
  b = b[0];
  g = this.map.getProjection();
  (h = b.projection) && h.equals(this.map.getProjectionObject()) && (g = h.getCode());
  d = OpenLayers.Util.extend({service:"WMS", version:b.params.VERSION, request:"GetFeatureInfo", exceptions:b.params.EXCEPTIONS, bbox:this.map.getExtent().toBBOX(null, b.reverseAxisOrder()), feature_count:this.maxFeatures, height:this.map.getSize().h, width:this.map.getSize().w, format:d, info_format:b.params.INFO_FORMAT || this.infoFormat}, 1.3 <= parseFloat(b.params.VERSION) ? {crs:g, i:parseInt(c.x), j:parseInt(c.y)} : {srs:g, x:parseInt(c.x), y:parseInt(c.y)});
  0 != e.length && (d = OpenLayers.Util.extend({layers:e, query_layers:e, styles:f}, d));
  OpenLayers.Util.applyDefaults(d, this.vendorParams);
  return {url:a, params:OpenLayers.Util.upperCaseObject(d), extra:e, callback:function(b) {
    this.handleResponse(c, b, a, e, f);
  }, proxy:OpenLayers.ProxyHost + "serviceId\x3d" + b.serviceId + "\x26url\x3d", scope:this};
}
OpenLayers.Layer.Grid.prototype.initGriddedTiles = function(a) {
  this.clearTileQueue();
  var b = this.map.getSize(), c = Math.ceil(b.h / this.tileSize.h) + Math.max(1, 2 * this.buffer), b = Math.ceil(b.w / this.tileSize.w) + Math.max(1, 2 * this.buffer), d = this.getTileOrigin(), e = this.getServerResolution(), d = this.calculateGridLayout(a, d, e), e = Math.round(d.tileoffsetx), f = Math.round(d.tileoffsety), g = d.tileoffsetlon, h = d.tileoffsetlat, k = d.tilelon, l = d.tilelat, t = e, n = g, v = 0, x = parseInt(this.map.layerContainerDiv.style.left), y = parseInt(this.map.layerContainerDiv.style.top), 
  d = [], w = this.map.getCenter();
  do {
    var r = this.grid[v++];
    r || (r = [], this.grid.push(r));
    var g = n, e = t, u = 0;
    do {
      u || (g = n);
      var p = new OpenLayers.Bounds(g, h, g + k, h + l), m = e, m = m - x, q = f, q = q - y, q = new OpenLayers.Pixel(m, q);
      (m = r[u++]) ? m.moveTo(p, q, !1) : (m = this.addTile(p, q), this.addTileMonitoringHooks(m), r.push(m));
      p = p.getCenterLonLat();
      d.push({tile:m, distance:Math.pow(p.lon - w.lon, 2) + Math.pow(p.lat - w.lat, 2)});
      g += k;
      e += this.tileSize.w;
    } while (g <= a.right + k * this.buffer || u < b);
    h -= l;
    f += this.tileSize.h;
  } while (h >= a.bottom - l * this.buffer || v < c);
  this.removeExcessTiles(v, u);
  this.gridResolution = this.getServerResolution();
  d.sort(function(a, b) {
    return a.distance - b.distance;
  });
  a = 0;
  for (c = d.length;a < c;++a) {
    d[a].tile.draw();
  }
};
OpenLayers.Strategy.Cluster.prototype.cluster = function(a) {
  if ((!a || a.zoomChanged || "moveend" == a.type && !a.zoomChanged) && this.features) {
    this.resolution = this.layer.map.getResolution();
    a = [];
    for (var b, c, d, e = this.layer.map.getExtent(), f = 0;f < this.features.length;++f) {
      if (b = this.features[f], b.geometry && e.intersectsBounds(b.geometry.getBounds())) {
        c = !1;
        for (var g = a.length - 1;0 <= g;--g) {
          if (d = a[g], this.shouldCluster(d, b)) {
            this.addToCluster(d, b);
            c = !0;
            break;
          }
        }
        c || a.push(this.createCluster(this.features[f]));
      }
    }
    this.clustering = !0;
    this.layer.removeAllFeatures();
    this.clustering = !1;
    if (0 < a.length) {
      if (1 < this.threshold) {
        for (b = a.slice(), a = [], f = 0, d = b.length;f < d;++f) {
          c = b[f], c.attributes.count < this.threshold ? Array.prototype.push.apply(a, c.cluster) : a.push(c);
        }
      }
      this.clustering = !0;
      this.layer.addFeatures(a);
      this.clustering = !1;
    }
    this.clusters = a;
  }
};
OpenLayers.Layer.Vector.prototype.getFeatureFromEvent = function(a) {
  if (!this.renderer) {
    throw Error("getFeatureFromEvent called on layer with no renderer. This usually means you destroyed a layer, but not some handler which is associated with it.");
  }
  var b = null;
  a.l = this;
  (a = this.renderer.getFeatureIdFromEvent(a)) && (b = "string" === typeof a ? this.getFeatureById(a) : a);
  return b;
};
OpenLayers.Renderer.SVG.prototype.getFeatureIdFromEvent = function(a) {
  var b = OpenLayers.Renderer.Elements.prototype.getFeatureIdFromEvent.apply(this, arguments);
  b || (b = a.target, b = b.parentNode && b != this.rendererRoot ? b.parentNode._featureId : void 0);
  if (!b) {
    for (var c = this.vectorRoot.childNodes, d = this.map.getLonLatFromPixel(a.xy), e = 0;e < c.length;e++) {
      var f = c[e];
      if (f._featureId) {
        var g = a.l.getFeatureById(f._featureId);
        if (g.atPoint(d) && g.geometry.containsPoint && g.geometry.containsPoint({x:d.lon, y:d.lat})) {
          b = f._featureId;
          break;
        }
      }
    }
  }
  return b;
};
Ext.define("viewer.viewercontroller.openlayers.ToolMapClick", {extend:"viewer.viewercontroller.controller.ToolMapClick", handler:null, scope:null, config:{id:null, name:null, handlerOptions:null}, constructor:function(a) {
  viewer.viewercontroller.openlayers.ToolMapClick.superclass.constructor.call(this, a);
  this.initConfig(a);
  var b = this;
  this.type = viewer.viewercontroller.controller.Tool.MAP_CLICK;
  this.initConfig(a);
  this.handler = a.handler.fn;
  this.scope = a.handler.scope;
  this.olMap = this.config.viewerController.mapComponent.getMap().getFrameworkMap();
  this.clickControl = new OpenLayers.Control.Click({handlerOptions:b.config.handlerOptions, click:function(a) {
    b.handleClick(a);
  }});
  this.olMap.addControl(this.clickControl);
  return this;
}, handleClick:function(a) {
  var b = this.olMap.getLonLatFromPixel(a.xy);
  this.handler.call(this.scope, this, {x:a.xy.x, y:a.xy.y, coord:{x:b.lon, y:b.lat}});
}, activateTool:function() {
  this.clickControl.activate();
}, deactivateTool:function() {
  this.clickControl.deactivate();
}});
Ext.define("viewer.viewercontroller.openlayers.OpenLayersComponent", {extend:"viewer.viewercontroller.controller.Component", constructor:function(a, b) {
  viewer.viewercontroller.openlayers.OpenLayersComponent.superclass.constructor.call(this, a);
  this.frameworkObject = b;
  if ("content_bottom" == a.regionName && this.config.viewerController.mapComponent.contentBottom) {
    var c = document.createElement("div");
    c.id = a.id + "content_bottom";
    b.div.appendChild(c);
    b.div = c;
    a.cssClass && c.setAttribute("class", a.cssClass);
  }
}, doAfterAdd:function() {
}});
Ext.define("viewer.viewercontroller.OpenLayersMapComponent", {extend:"viewer.viewercontroller.MapComponent", mapOptions:null, contentTop:null, contentBottom:null, config:{theme:"flamingo"}, constructor:function(a, b, c) {
  this.domId = Ext.id();
  var d = document.createElement("div");
  d.id = this.domId;
  d.style.height = "100%";
  d.style.width = "100%";
  document.getElementById(b).appendChild(d);
  viewer.viewercontroller.OpenLayersMapComponent.superclass.constructor.call(this, a, this.domId, c);
  this.polygonButton = this.lineButton = this.pointButton = null;
  if (c && c.resolutions) {
    if ("false" === c.resolutions) {
      a = null;
    } else {
      for (b = c.resolutions.split(","), a = [], c = 0;c < b.length;c++) {
        d = Number(b[c]), isNaN(d) || a.push(d);
      }
    }
  } else {
    a = [3440.64, 1720.32, 860.16, 430.08, 215.04, 107.52, 53.76, 26.88, 13.44, 6.72, 3.36, 1.68, .84, .42, .21, .105];
  }
  b = void 0 != this.viewerController.app.maxExtent ? new OpenLayers.Bounds(this.viewerController.app.maxExtent.minx, this.viewerController.app.maxExtent.miny, this.viewerController.app.maxExtent.maxx, this.viewerController.app.maxExtent.maxy) : new OpenLayers.Bounds(7700, 304E3, 28E4, 62E4);
  c = new OpenLayers.Projection(this.projection);
  this.mapOptions = {projection:c, maxExtent:b, allOverlays:!0, units:c.getUnits(), resolutions:a};
  var e = this;
  this.viewerController.addListener(viewer.viewercontroller.controller.Event.ON_COMPONENTS_FINISHED_LOADING, function() {
    setTimeout(function() {
      e.checkTools();
    }, 10);
  }, this);
  return this;
}, checkTools:function() {
  var a = !0;
  if (0 !== this.getTools().length) {
    for (var b = this.getTools(), c = 0;c < b.length;c++) {
      b[c].blocksDefaultTool && (a = !1);
    }
  }
  a && (a = new viewer.viewercontroller.openlayers.tools.OpenLayersDefaultTool({viewerController:this.viewerController, id:"defaultTool"}), this.addTool(a), a.setVisible(!1), a.activate());
  a = this.createVectorLayer({name:"DUMMYVECTOR_FOR_STUPID_PANIDENTIFYBUG", viewerController:this.viewerController});
  this.getMap().addLayer(a);
}, initEvents:function() {
  this.eventList[viewer.viewercontroller.controller.Event.ON_EVENT_DOWN] = "activate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_EVENT_UP] = "deactivate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_CAPABILITIES] = "onGetCapabilities";
  this.eventList[viewer.viewercontroller.controller.Event.ON_CONFIG_COMPLETE] = "onConfigComplete";
  this.eventList[viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED] = "featureadded";
  this.eventList[viewer.viewercontroller.controller.Event.ON_CLICK] = "click";
  this.eventList[viewer.viewercontroller.controller.Event.ON_SET_TOOL] = "activate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_ALL_LAYERS_LOADING_COMPLETE] = "onUpdateComplete";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LOADING_START] = "loadstart";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LOADING_END] = "loadend";
  this.eventList[viewer.viewercontroller.controller.Event.ON_MEASURE] = "measure";
  this.eventList[viewer.viewercontroller.controller.Event.ON_FINISHED_CHANGE_EXTENT] = "moveend";
  this.eventList[viewer.viewercontroller.controller.Event.ON_CHANGE_EXTENT] = "move";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED] = "removelayer";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_ADDED] = "addlayer";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO] = "getfeatureinfo";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED] = "changelayer";
  this.eventList[viewer.viewercontroller.controller.Event.ON_ACTIVATE] = "activate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_DEACTIVATE] = "deactivate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_ZOOM_END] = "zoomend";
}, getPanel:function() {
  null == this.panel && this.createPanel();
  return this.panel;
}, createPanel:function(a) {
  a = new OpenLayers.Control.Panel({saveState:!0, div:this.contentTop});
  this.initSvgSupport(a);
  this.panel = a;
  this.maps[0].getFrameworkMap().addControl(this.panel);
}, initSvgSupport:function(a) {
  if (this.viewerController.hasSvgSprite()) {
    var b = this.viewerController.getApplicationSprite();
    OpenLayers.Util.extend(a, {createControlMarkup:function(a) {
      var d = document.createElement("div");
      if (a.flamingoIconDefined) {
        return d;
      }
      var e = a.displayClass.toLowerCase().replace("olcontrolnavigationhistory ", "");
      d.innerHTML = ['\x3cdiv class\x3d"svg-click-area"\x3e\x3c/div\x3e\x3csvg role\x3d"img" title\x3d""\x3e\x3cuse xlink:href\x3d"', b, "#icon-", e, '"/\x3e\x3c/svg\x3e'].join("");
      d.className += "svg-tool";
      a.events.on({activate:function() {
        d.className += " svg-tool-active";
      }, deactivate:function() {
        d.className = d.className.replace(" svg-tool-active", "");
      }});
      return d;
    }});
  }
}, createMap:function(a, b) {
  b = Ext.merge(this.mapOptions, b);
  b.theme = actionBeans.css + "?theme\x3d" + this.getTheme() + "\x26location\x3d" + OpenLayers._getScriptLocation() + "\x26app\x3d" + this.viewerController.app.id;
  b.mapComponent = this;
  b.viewerController = this.viewerController;
  b.domId = this.domId;
  return Ext.create("viewer.viewercontroller.openlayers.OpenLayersMap", b);
}, createMenus:function(a, b) {
  var c = document.getElementById(this.domId);
  c.style.position = "absolute";
  var d = Ext.get(this.getMap().frameworkMap.viewPortDiv.id), e = d.getHeight();
  d.dom.style.position = "absolute";
  var f;
  if (-1 == a.indexOf("%")) {
    e -= a, f = a;
  } else {
    var g = a.substring(0, a.indexOf("%")), h = e / 100 * g, e = e - h;
    f = h;
  }
  c.style.top = f + "px";
  -1 == b.indexOf("%") ? (g = b, e -= b) : (g = b.substring(0, b.indexOf("%")), g = h = e / 100 * g, e -= h);
  c.style.height = e + "px";
  this.contentTop = document.createElement("div");
  this.contentTop.id = "content_top";
  var h = this.contentTop.style, k = this.viewerController.getLayout("top_menu");
  k.height && (h.background = k.bgcolor, h.height = k.height + k.heightmeasure);
  d.dom.style.zIndex = 100;
  h.zIndex = d.dom.style.zIndex + 1;
  this.contentTop.setAttribute("class", "olControlPanel");
  c.parentNode.insertBefore(this.contentTop, c);
  g && 0 < parseInt(g) && (this.contentBottom = document.createElement("div"), this.contentBottom.id = "content_bottom", d = this.contentBottom.style, h = this.viewerController.getLayout("content_bottom"), d.height = g + "px", d.background = h.bgcolor, d.top = e + parseInt(f) + "px", d.position = "relative", c.parentNode.appendChild(this.contentBottom));
  this.getMap().updateSize();
}, doResize:function() {
  var a = Ext.get(document.getElementById(this.domId).parentNode).getHeight(), b = Number(this.viewerController.getLayout("top_menu").height);
  if (null !== this.contentBottom) {
    var c = Ext.get(this.contentBottom);
    c.setTop(a - c.getHeight() + "px");
  }
  var d = Ext.get(this.domId), a = a - b;
  null != c && (a -= c.getHeight());
  d.setHeight(a + "px");
}, createWMSLayer:function(a, b, c, d) {
  d.options = {};
  d.options.id = null;
  d.options.isBaseLayer = !0;
  d.options.transitionEffect = "resize";
  d.options.events = {};
  d.options.visibility = c.visible;
  d.options.name = a;
  d.options.url = b;
  for (var e in c) {
    d.options[e] = c[e];
  }
  d.ogcParams = c;
  d.viewerController = this.viewerController;
  d.options.url = b;
  void 0 != d.alpha && (d.options.opacity = d.alpha / 100);
  void 0 != d.ratio && (d.options.ratio = d.ratio);
  return Ext.create("viewer.viewercontroller.openlayers.OpenLayersWMSLayer", d);
}, createTilingLayer:function(a, b, c) {
  c.name = a;
  c.url = b;
  c.viewerController = this.viewerController;
  void 0 != c.alpha && (c.opacity = c.alpha / 100);
  return new viewer.viewercontroller.openlayers.OpenLayersTilingLayer(c);
}, createArcIMSLayer:function(a, b, c, d) {
  c.name = a;
  c.url = Ext.urlAppend(actionBeans.proxy, Ext.Object.toQueryString({url:b, mode:"arcims"}));
  void 0 != c.alpha && (c.opacity = c.alpha / 100);
  c.serviceName = c.mapservice;
  c.viewerController = this.viewerController;
  return Ext.create("viewer.viewercontroller.openlayers.OpenLayersArcIMSLayer", c);
}, createArcServerLayer:function(a, b, c, d) {
  c.name = a;
  c.url = b;
  c.viewerController = d;
  void 0 != c.alpha && (c.opacity = c.alpha / 100);
  return Ext.create("viewer.viewercontroller.openlayers.OpenLayersArcServerLayer", c);
}, createImageLayer:function(a, b, c) {
  return Ext.create("viewer.viewercontroller.openlayers.OpenLayersImageLayer", {id:a, url:b, extent:c, frameworkLayer:this.viewerObject, viewerController:this.viewerController});
}, createVectorLayer:function(a) {
  void 0 == a ? a = {isBaseLayer:!1} : void 0 == a.isBaseLayer && (a.isBaseLayer = !1);
  return Ext.create("viewer.viewercontroller.openlayers.OpenLayersVectorLayer", a);
}, createComponent:function(a) {
  var b = a.type, c = null;
  if (b == viewer.viewercontroller.controller.Component.LOADMONITOR) {
    c = Ext.create("viewer.viewercontroller.openlayers.components.OpenLayersLoadMonitor", a);
  } else {
    if (b == viewer.viewercontroller.controller.Component.OVERVIEW) {
      c = Ext.create("viewer.viewercontroller.openlayers.components.OpenLayersOverview", a);
    } else {
      if (b == viewer.viewercontroller.controller.Component.MAPTIP) {
        c = Ext.create("viewer.viewercontroller.openlayers.components.OpenLayersMaptip", a, this.getMap());
      } else {
        if (b == viewer.viewercontroller.controller.Component.NAVIGATIONPANEL) {
          b = Number(this.viewerController.getLayout("top_menu").height);
          b = 40 < b ? 4 : (40 - b) / 2 + 2;
          c = 0;
          a.top && (b += Number(a.top));
          a.left && (c = Number(a.left));
          var d = !0;
          a.hasOwnProperty("navigationPanel") && !a.navigationPanel && (d = !1);
          b = new OpenLayers.Control.PanZoomBar({position:new OpenLayers.Pixel(c, b), zoomWorldIcon:d, panIcons:d});
          if (a.zoomToFullIsStart) {
            var e = this;
            b.onButtonClick = function(a) {
              switch(a.buttonElement.action) {
                case "panup":
                  this.map.pan(0, -this.getSlideFactor("h"));
                  break;
                case "pandown":
                  this.map.pan(0, this.getSlideFactor("h"));
                  break;
                case "panleft":
                  this.map.pan(-this.getSlideFactor("w"), 0);
                  break;
                case "panright":
                  this.map.pan(this.getSlideFactor("w"), 0);
                  break;
                case "zoomin":
                  this.map.zoomIn();
                  this.fireEvent(viewer.viewercontroller.controller.Event.ON_ZOOM_END, position);
                  break;
                case "zoomout":
                  this.map.zoomOut();
                  this.fireEvent(viewer.viewercontroller.controller.Event.ON_ZOOM_END, position);
                  break;
                case "zoomworld":
                  e.viewerController.mapComponent.getMap().zoomToExtent(e.viewerController.mapComponent.mapOptions.options.startExtent), this.fireEvent(viewer.viewercontroller.controller.Event.ON_ZOOM_END, position);
              }
            };
          }
          c = Ext.create("viewer.viewercontroller.openlayers.OpenLayersComponent", a, b);
        } else {
          b == viewer.viewercontroller.controller.Component.BORDER_NAVIGATION ? c = Ext.create("viewer.viewercontroller.openlayers.components.OpenLayersBorderNavigation", a) : b == viewer.viewercontroller.controller.Component.COORDINATES ? (b = {numDigits:a.decimals}, this.contentBottom && (b.div = this.contentBottom, a.cssClass = "olControlMousePosition"), c = Ext.create("viewer.viewercontroller.openlayers.OpenLayersComponent", a, new OpenLayers.Control.MousePosition(b))) : b == viewer.viewercontroller.controller.Component.SCALEBAR ? 
          (b = {bottomOutUnits:"", bottomInUnits:""}, Ext.isEmpty(a.units) || (b.topOutUnits = a.units), this.contentBottom && (b.div = this.contentBottom, a.cssClass = "olControlScale"), c = Ext.create("viewer.viewercontroller.openlayers.OpenLayersComponent", a, new OpenLayers.Control.ScaleLine(b))) : b == viewer.viewercontroller.controller.Component.SNAPPING ? c = Ext.create("viewer.viewercontroller.openlayers.OpenLayersSnappingController", a) : this.viewerController.logger.warning("Framework specific component with type " + 
          b + " not yet implemented!");
        }
      }
    }
  }
  return c;
}, createTool:function(a) {
  var b = a.type;
  a.viewerController = this.viewerController;
  var c = {};
  a.frameworkOptions && (c = a.frameworkOptions);
  a.tooltip && (c.title = a.tooltip);
  if (b == viewer.viewercontroller.controller.Tool.NAVIGATION_HISTORY) {
    return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.NavigationHistory(options));
  }
  if (b == viewer.viewercontroller.controller.Tool.ZOOMIN_BOX) {
    return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.ZoomBox(c));
  }
  if (b == viewer.viewercontroller.controller.Tool.ZOOMIN_BUTTON) {
    return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.ZoomIn(c));
  }
  if (b == viewer.viewercontroller.controller.Tool.ZOOMOUT_BOX) {
    return c.out = !0, c.displayClass = "olControlZoomOut", new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.ZoomBox(c));
  }
  if (b == viewer.viewercontroller.controller.Tool.ZOOMOUT_BUTTON) {
    return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.ZoomOut(c));
  }
  if (b == viewer.viewercontroller.controller.Tool.ZOOM) {
    return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.Zoom(c));
  }
  if (b == viewer.viewercontroller.controller.Tool.PAN) {
    return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.DragPan(c));
  }
  if (b == viewer.viewercontroller.controller.Tool.SUPERPAN) {
    return c.enableKinetic = !0, new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.DragPan(c));
  }
  if (b == viewer.viewercontroller.controller.Tool.GET_FEATURE_INFO) {
    return new viewer.viewercontroller.openlayers.tools.OpenLayersIdentifyTool(a);
  }
  if (b === viewer.viewercontroller.controller.Tool.MEASURELINE || b === viewer.viewercontroller.controller.Tool.MEASUREAREA) {
    return a.frameworkOptions = c, new viewer.viewercontroller.openlayers.tools.OpenLayersMeasureTool(a);
  }
  if (b == viewer.viewercontroller.controller.Tool.ZOOM_BAR) {
    return new OpenLayersTool(a, new OpenLayers.Control.PanZoomBar(c));
  }
  if (b == viewer.viewercontroller.controller.Tool.DEFAULT) {
    return new viewer.viewercontroller.openlayers.tools.OpenLayersDefaultTool(a);
  }
  if (b == viewer.viewercontroller.controller.Tool.PREVIOUS_EXTENT || b == viewer.viewercontroller.controller.Tool.NEXT_EXTENT) {
    var c = {}, d;
    for (d in this.viewerController.app.components) {
      b = this.viewerController.app.components[d], "viewer.components.tools.NextExtent" == b.className ? c.nextOptions = {title:b.config.tooltip} : "viewer.components.tools.PreviousExtent" == b.className && (c.previousOptions = {title:b.config.tooltip});
    }
    return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.NavigationHistory(c));
  }
  if (b == viewer.viewercontroller.controller.Tool.FULL_EXTENT) {
    return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.ZoomToMaxExtent(c));
  }
  if (b == viewer.viewercontroller.controller.Tool.MAP_CLICK) {
    return Ext.create("viewer.viewercontroller.openlayers.ToolMapClick", a);
  }
  if (a.type == viewer.viewercontroller.controller.Tool.TOGGLE) {
    return c.type = OpenLayers.Control.TYPE_TOGGLE, c.displayClass = a.displayClass ? a.displayClass : "olToggle_" + a.id, new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control(c));
  }
  if (a.type == viewer.viewercontroller.controller.Tool.MAP_TOOL) {
    return c.type = OpenLayers.Control.TYPE_TOOL, c.displayClass = a.displayClass ? a.displayClass : "olButton_" + a.id, new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control(c));
  }
  if (a.type == viewer.viewercontroller.controller.Tool.BUTTON) {
    return c.type = OpenLayers.Control.TYPE_BUTTON, c.displayClass = a.displayClass ? a.displayClass : "olButton_" + a.id, new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control(c));
  }
  this.viewerController.logger.warning("Tool Type \x3e" + b + "\x3c not recognized. Please use existing type.");
}, activateGetFeatureControls:function() {
  for (var a = this.getMap().getAllWMSLayers(), b = 0;b < a.length;b++) {
    var c = a[b].getGetFeatureInfoControl();
    null != c && c.activate();
  }
}, deactivateGetFeatureControls:function() {
  for (var a = this.getMap().getAllWMSLayers(), b = 0;b < a.length;b++) {
    var c = a[b].getGetFeatureInfoControl();
    null != c && c.deactivate();
  }
}, addTool:function(a) {
  0 == this.maps.length && Ext.Error.raise({msg:"No map in MapComponent!"});
  if (a instanceof Array) {
    for (var b = 0;b < a.length;b++) {
      this.getMap().getFrameworkMap().addControl(a[b].getFrameworkTool()), this.addTool(a[b]), MapComponent.prototype.addTool.call(this, a[b]);
    }
  } else {
    if (a.getType() == viewer.viewercontroller.controller.Tool.NAVIGATION_HISTORY) {
      var c = this, d = function() {
        c.maps[0].getFrameworkMap().addControl(a.getFrameworkTool());
        c.getPanel().addControls([a.getFrameworkTool().previous, a.getFrameworkTool().next]);
        c.getMap().removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d);
        c.repaintTools();
      };
      this.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d);
    } else {
      a.getType() == viewer.viewercontroller.controller.Tool.CLICK ? (this.maps[0].getFrameworkMap().addControl(a.getFrameworkTool()), this.getPanel().addControls([a.getFrameworkTool().button])) : a.getType() == viewer.viewercontroller.controller.Tool.GET_FEATURE_INFO ? (this.getPanel().addControls([a.getFrameworkTool()]), this.maps[0].getFrameworkMap().addControl(a.getFrameworkTool())) : a.getType() == viewer.viewercontroller.controller.Tool.ZOOM_BAR ? this.maps[0].getFrameworkMap().addControl(a.getFrameworkTool()) : 
      a.getType() == viewer.viewercontroller.controller.Tool.ZOOM ? this.maps[0].getFrameworkMap().addControl(a.getFrameworkTool()) : a.getType() == viewer.viewercontroller.controller.Tool.PREVIOUS_EXTENT ? (c = this, d = function() {
        var b = a.getFrameworkTool(), e = c.maps[0].getFrameworkMap().getControlsByClass("OpenLayers.Control.NavigationHistory");
        0 < e.length ? b = e[0] : c.maps[0].getFrameworkMap().addControl(a.getFrameworkTool());
        c.getPanel().addControls([b.previous]);
        c.getMap().removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d);
        c.repaintTools();
      }, this.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d)) : a.getType() == viewer.viewercontroller.controller.Tool.NEXT_EXTENT ? (c = this, d = function() {
        var b = a.getFrameworkTool(), e = c.maps[0].getFrameworkMap().getControlsByClass("OpenLayers.Control.NavigationHistory");
        0 < e.length ? b = e[0] : c.maps[0].getFrameworkMap().addControl(a.getFrameworkTool());
        c.getPanel().addControls([b.next]);
        c.getMap().removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d);
        c.repaintTools();
      }, this.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d)) : (a.getFrameworkTool(), this.getPanel().addControls([a.getFrameworkTool()]));
    }
  }
  if (!(a instanceof Array) && (this.superclass.addTool.call(this, a), a.getVisible() && !a.getPreventActivationAsFirstTool())) {
    for (var e = b = 0;e < this.tools.length;e++) {
      this.tools[e].getVisible() && !this.tools[e].getPreventActivationAsFirstTool() && b++;
    }
    1 === b && this.activateTool(a.getId());
  }
}, repaintTools:function() {
  if (Ext.browser.is.IE) {
    for (var a = document.querySelectorAll(".svg-tool svg use"), b = 0;b < a.length;b++) {
      a[b].setAttribute("href", a[b].getAttribute("xlink:href"));
    }
  }
}, removeToolById:function(a) {
  a = this.getTool(a);
  this.removeTool(a);
}, removeTool:function(a) {
  a instanceof OpenLayersTool || Ext.Error.raise({msg:"The given tool is not of type 'OpenLayersTool'"});
  a.type == Tool.NAVIGATION_HISTORY ? (OpenLayers.Util.removeItem(this.getPanel().controls, a.getFrameworkTool().next), OpenLayers.Util.removeItem(this.getPanel().controls, a.getFrameworkTool().previous), a.getFrameworkTool().destroy()) : OpenLayers.Util.removeItem(this.getPanel().controls, a.getFrameworkTool());
  this.maps[0].getFrameworkMap().removeControl(a.getFrameworkTool());
  0 == this.getPanel().controls.length ? (this.getPanel().destroy(), this.panel = null) : this.getPanel().redraw();
  MapComponent.prototype.removeTool.call(this, a);
}, addComponent:function(a) {
  Ext.isEmpty(a) ? this.viewerController.logger.warning("Empty component added to OpenLayersMapComponent. \nProbably not yet implemented") : (this.getMap().getFrameworkMap().addControl(a.getFrameworkObject()), a.getFrameworkObject().activate(), a.doAfterAdd());
}, addMap:function(a) {
  a instanceof viewer.viewercontroller.openlayers.OpenLayersMap || Ext.Error.raise({msg:"The given map is not of the type 'OpenLayersMap'"});
  1 <= this.maps.length && Ext.Error.raise({msg:"Multiple maps not supported yet"});
  this.maps.push(a);
  this.createMenus(this.mapOptions.options.top, this.mapOptions.options.bottom);
  a.getFrameworkMap().events.register("mousemove", this, this.removeMaptip);
}, getMap:function(a) {
  return this.maps[0];
}, removeMap:function(a) {
  a.remove();
  this.maps = [];
}, activateTool:function(a, b) {
  for (var c = this.tools, d = 0;d < c.length;d++) {
    c[d].getFrameworkTool().deactivate();
  }
  d = this.getTool(a);
  b && (d = c[0]);
  d.getFrameworkTool().activate();
}, getWidth:function() {
  var a = this.getMap();
  return a ? a.getWidth() : null;
}, getHeight:function() {
  var a = this.getMap();
  return a ? a.getHeight() : null;
}, setCursor:function(a, b) {
  a ? Ext.get(this.domId).dom.style.cursor = b : Ext.get(this.domId).dom.style.cursor = "default";
}, deselectAllOtherFeatures:function(a) {
  for (var b = this.viewerController.mapComponent.getMap().getAllVectorLayers(), c = 0;c < b.length;c++) {
    var d = b[c];
    d.getId() !== a.getId() && d.unselectAll();
  }
}});
Ext.define("viewer.viewercontroller.openlayers.OpenLayersSnappingController", {extend:"viewer.viewercontroller.controller.SnappingController", frameworkLayer:null, frameworkControl:null, config:{style:{strokeColor:"#FF00FF", strokeOpacity:.5, strokeWidth:1, pointRadius:1, fillOpacity:.25, fillColor:"#FF00FF"}, viewerController:null}, frameworkMap:null, constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersSnappingController.superclass.constructor.call(this, a);
  this.frameworkMap = this.config.viewerController.mapComponent.getMap().getFrameworkMap();
  this.frameworkControl = new OpenLayers.Control.Snapping;
  this.config.viewerController.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, this.layerAdded, this);
  this.config.viewerController.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_FINISHED_CHANGE_EXTENT, this.changedExtent, this);
  return this;
}, layerAdded:function(a, b) {
  b.layer && Ext.Array.contains(this.config.viewerController.registeredSnappingLayers, b.layer) && (this.frameworkLayer = b.layer.getFrameworkLayer(), this.frameworkControl.setLayer(this.frameworkLayer), this.activate());
}, addAppLayer:function(a) {
  var b = this, c = this.config.viewerController.getAppLayerFeatureService(a);
  void 0 === a.attributes ? c.loadAttributes(a, function(d) {
    b.loadAttributes(c, a);
  }) : b.loadAttributes(c, a);
}, loadAttributes:function(a, b) {
  var c = this.config.viewerController.mapComponent.getMap().getExtent(), d = b.attributes[b.geometryAttributeIndex];
  d || (d = Ext.Array.findBy(b.attributes, function(a, c) {
    return a.name === b.geometryAttribute;
  }));
  a.loadFeatures(b, this.parseFeatures, function(a) {
    Ext.MessageBox.alert("Error", a);
  }, {store:1, limit:1E3, arrays:1, attributesToInclude:[d.id], edit:!1, graph:!0, filter:"INTERSECTS(" + d.name + ", " + c.toWKT() + ")"}, {me:this, appLayer:b});
}, removeLayer:function(a) {
  this.deactivate();
  if (a = this.frameworkMap.getLayersByName(this.getlayerName(a))[0]) {
    Ext.Array.remove(this.snapLayers, a), this.frameworkMap.removeLayer(a), this.frameworkControl.removeTargetLayer(a);
  }
  this.activate();
}, removeAll:function() {
  for (var a = 0;a < this.snapLayers.length;a++) {
    this.frameworkControl.removeTargetLayer(this.snapLayers[a]), this.frameworkMap.removeLayer(this.snapLayers[a]);
  }
  this.snapLayers = [];
  this.deactivate();
}, activate:function() {
  0 < this.snapLayers.length && this.frameworkControl.activate();
}, deactivate:function() {
  this.frameworkControl.deactivate();
}, parseFeatures:function(a) {
  var b = this.me.getlayerName(this.appLayer), c = this.me.frameworkMap.getLayersByName(b);
  0 < c.length ? (b = c[0], b.removeAllFeatures()) : (b = new OpenLayers.Layer.Vector(b, {styleMap:new OpenLayers.StyleMap({"default":this.me.config.style})}), this.me.snapLayers.push(b), this.me.frameworkMap.addLayers([b]), this.me.frameworkControl.addTargetLayer(b));
  var d = [], e, f;
  a.forEach(function(a, b, c) {
    f = a.c0;
    e = OpenLayers.Geometry.fromWKT(f);
    e.calculateBounds();
    d.push(new OpenLayers.Feature.Vector(e));
  });
  b.addFeatures(d);
  this.me.activate();
}, changedExtent:function(a, b) {
  for (var c = 0;c < this.snapLayers.length;c++) {
    this.addAppLayer(this.getAppLayer(this.snapLayers[c].name));
  }
}, getlayerName:function(a) {
  return this.snapLayers_prefix + a.id;
}, getAppLayer:function(a) {
  a = a.substring(this.snapLayers_prefix.length);
  return this.config.viewerController.getAppLayerById(a);
}});
OpenLayers.Control.LoadingPanel = OpenLayers.Class(OpenLayers.Control, {counter:0, minimizeTimeout:null, minimizeTimeoutDelay:null, maximized:!1, visible:!0, initialize:function(a) {
  OpenLayers.Control.prototype.initialize.apply(this, [a]);
}, setVisible:function(a) {
  (this.visible = a) ? OpenLayers.Element.show(this.div) : OpenLayers.Element.hide(this.div);
}, getVisible:function() {
  return this.visible;
}, hide:function() {
  this.setVisible(!1);
}, show:function() {
  this.setVisible(!0);
}, toggle:function() {
  this.setVisible(!this.getVisible());
}, addLayer:function(a) {
  a.layer && (a.layer.events.register("loadstart", this, this.increaseCounter), a.layer.events.register("loadend", this, this.decreaseCounter));
}, setMap:function(a) {
  OpenLayers.Control.prototype.setMap.apply(this, arguments);
  this.map.events.register("preaddlayer", this, this.addLayer);
  for (var b = 0;b < this.map.layers.length;b++) {
    var c = this.map.layers[b];
    c.events.register("loadstart", this, this.increaseCounter);
    c.events.register("loadend", this, this.decreaseCounter);
  }
}, increaseCounter:function() {
  var a = this, b = a.minimizeTimeoutDelay || 5E3;
  0 < this.counter && (null != this.minimizeTimeout && window.clearTimeout(this.minimizeTimeout), this.minimizeTimeout = window.setTimeout(function() {
    if (a.maximized) {
      for (;0 < a.counter;) {
        a.decreaseCounter();
      }
    }
  }, b));
  this.counter++;
  0 < this.counter && !this.maximized && this.visible && this.maximizeControl();
}, decreaseCounter:function() {
  0 < this.counter && this.counter--;
  0 == this.counter && this.maximized && this.visible && this.minimizeControl();
}, draw:function() {
  OpenLayers.Control.prototype.draw.apply(this, arguments);
  return this.div;
}, minimizeControl:function(a) {
  this.div.style.display = "none";
  this.maximized = !1;
  null != a && OpenLayers.Event.stop(a);
}, maximizeControl:function(a) {
  this.div.style.display = "block";
  this.maximized = !0;
  null != a && OpenLayers.Event.stop(a);
}, destroy:function() {
  if (this.map && (this.map.events.unregister("preaddlayer", this, this.addLayer), this.map.layers)) {
    for (var a = 0;a < this.map.layers.length;a++) {
      var b = this.map.layers[a];
      b.events.unregister("loadstart", this, this.increaseCounter);
      b.events.unregister("loadend", this, this.decreaseCounter);
    }
  }
  OpenLayers.Control.prototype.destroy.apply(this, arguments);
}, CLASS_NAME:"OpenLayers.Control.LoadingPanel"});
Ext.define("viewer.viewercontroller.openlayers.components.OpenLayersBorderNavigation", {extend:"viewer.viewercontroller.openlayers.OpenLayersComponent", north:null, south:null, east:null, west:null, buttonSize:0, timer:null, constructor:function(a) {
  this.callParent(arguments);
  this.frameworkObject = new OpenLayers.Control.PanPanel;
  return this;
}, doAfterAdd:function() {
  this.north = Ext.select(".olControlPanNorthItemInactive");
  this.south = Ext.select(".olControlPanSouthItemInactive");
  this.east = Ext.select(".olControlPanEastItemInactive");
  this.west = Ext.select(".olControlPanWestItemInactive");
  if (this.config.viewerController.hasSvgSprite()) {
    var a = function(a, c) {
      a.setHtml(['\x3cdiv class\x3d"svg-click-area"\x3e\x3c/div\x3e\x3csvg role\x3d"img" title\x3d""\x3e\x3cuse xlink:href\x3d"', b, "#icon-", c, '"/\x3e\x3c/svg\x3e'].join(""));
      a.addCls("svg-tool");
    }, b = this.config.viewerController.getApplicationSprite();
    a(this.north, "olcontrolpannorth");
    a(this.south, "olcontrolpansouth");
    a(this.east, "olcontrolpaneast");
    a(this.west, "olcontrolpanwest");
  }
  Ext.select(".olControlPanPanel").setStyle("left", "0px");
  Ext.select(".olControlPanPanel").setStyle("top", "0px");
  var c = this;
  Ext.on("resize", function() {
    c.resizeOnceAfter(100);
  });
  this.resize();
}, resizeOnceAfter:function(a) {
  var b = this;
  this.timer && clearTimeout(this.timer);
  this.timer = setTimeout(function() {
    b.resize();
  }, a);
}, resize:function() {
  if (0 == this.buttonSize) {
    this.buttonSize = this.north.item(0).getHeight();
    var a = this;
    setTimeout(function() {
      a.resize();
    }, 50);
  } else {
    var b = Ext.select(".olMap").item(0), c = b.getHeight(), d = b.getWidth(), b = b.getTop(!0), e = Number((c - this.buttonSize) / 2), f = Number((d - this.buttonSize) / 2);
    this.north.setStyle("top", "0px");
    this.north.setStyle("left", f + "px");
    b <= this.buttonSize && Ext.get(this.config.viewerController.mapComponent.contentTop).setStyle("width", f + "px");
    this.south.setStyle("top", c - this.buttonSize + "px");
    this.south.setStyle("left", f + "px");
    this.west.setStyle("top", e + "px");
    this.west.setStyle("left", "0px");
    this.east.setStyle("top", e + "px");
    this.east.setStyle("left", d - this.buttonSize + "px");
  }
}});
Ext.define("viewer.viewercontroller.openlayers.components.OpenLayersLoadMonitor", {extend:"viewer.viewercontroller.openlayers.OpenLayersComponent", config:{top:null, left:null, timeout:null}, constructor:function(a) {
  viewer.viewercontroller.openlayers.components.OpenLayersLoadMonitor.superclass.constructor.call(this, a);
  a = this.config.viewerController.mapComponent.getMap().getFrameworkMap();
  this.frameworkObject = new OpenLayers.Control.LoadingPanel({minimizeTimeoutDelay:this.config.timeout});
  a.addControl(this.frameworkObject);
  this.config.left && this.config.top && this.setPosition(this.config.top, this.config.left);
  return this;
}, setPosition:function(a, b) {
  var c = this.frameworkObject.div;
  c.style.top = a + "px";
  c.style.left = b + "px";
}, getExtComponents:function() {
  return [];
}});
Ext.define("viewer.viewercontroller.openlayers.components.OpenLayersOverview", {extend:"viewer.viewercontroller.openlayers.OpenLayersComponent", config:{top:null, left:null, url:null, layers:null, position:null, height:null, width:null, lox:null, loy:null, rbx:null, rby:null, followZoom:null}, constructor:function(a) {
  this.width = this.height = 300;
  viewer.viewercontroller.openlayers.components.OpenLayersOverview.superclass.constructor.call(this, a);
  if (Ext.isEmpty(this.config.url)) {
    throw Error(i18next.t("viewer_viewercontroller_openlayers_components_openlayersoverview_0"));
  }
  a = this.config.viewerController.mapComponent.getMap().frameworkMap.maxExtent;
  var b;
  b = null !== this.config.lox && null !== this.config.loy && null !== this.config.rbx && null !== this.config.rby && this.config.lox !== this.config.rbx && this.config.loy !== this.config.rby ? new OpenLayers.Bounds(parseFloat(this.config.lox), parseFloat(this.config.loy), parseFloat(this.config.rbx), parseFloat(this.config.rby)) : a;
  var c = new OpenLayers.Size(parseInt(this.config.width, 10), parseInt(this.config.height, 10));
  b = new OpenLayers.Layer.Image("OverviewLaag", this.config.url, b, c);
  this.frameworkObject = new OpenLayers.Control.OverviewMap({maximized:!0, mapOptions:{maxExtent:a, projection:"EPSG:28992", theme:null}, size:c, layers:[b]});
  void 0 !== this.config.followZoom && null !== this.config.followZoom && !1 === this.config.followZoom && (this.frameworkObject.maxRatio = 999999);
  return this;
}, getExtComponents:function() {
  return [];
}, setLox:function(a) {
  isNaN(a) ? this.lox = null : this.lox = Number(a);
}, setLoy:function(a) {
  isNaN(a) ? this.loy = null : this.loy = Number(a);
}, setRbx:function(a) {
  isNaN(a) ? this.rbx = null : this.rbx = Number(a);
}, setRby:function(a) {
  isNaN(a) ? this.rby = null : this.rby = Number(a);
}, setHeight:function(a) {
  isNaN(a) ? this.height = null : !Ext.isEmpty(a) && 0 < a && (this.height = Number(a));
}, setWidth:function(a) {
  isNaN(a) ? this.width = null : !Ext.isEmpty(a) && 0 < a && (this.width = Number(a));
}});
Ext.define("viewer.viewercontroller.openlayers.components.OpenLayersMaptip", {extend:"viewer.viewercontroller.openlayers.OpenLayersComponent", map:null, constructor:function(a, b) {
  viewer.viewercontroller.openlayers.components.OpenLayersMaptip.superclass.constructor.call(this, a);
  this.map = b;
  this.frameworkObject = new OpenLayers.Control;
  var c = this;
  this.frameworkObject.handler = new OpenLayers.Handler.Hover(this.frameworkObject, {pause:function(a) {
    c.onPause(a);
  }, move:this.onMove}, {delay:a.maptipdelay, pixelTolerance:null, stopMove:!1});
}, getFrameworkObject:function() {
  return this.frameworkObject;
}, onPause:function(a) {
  var b = this.map.getFrameworkMap().getLonLatFromViewPortPx(a.xy);
  this.map.fire(viewer.viewercontroller.controller.Event.ON_MAPTIP, {x:a.xy.x, y:a.xy.y, coord:{x:b.lon, y:b.lat}});
}, setVisible:function(a) {
  a ? this.frameworkObject.activate() : this.frameworkObject.deactivate();
}});
Ext.define("viewer.viewercontroller.openlayers.tools.OpenLayersMeasureTool", {extend:"viewer.viewercontroller.openlayers.OpenLayersTool", frameworkTool:null, handler:null, config:{}, constructor:function(a) {
  this.frameworkTool = new OpenLayers.Control.Measure(a.type === viewer.viewercontroller.controller.Tool.MEASURELINE ? OpenLayers.Handler.Path : OpenLayers.Handler.Polygon, a.frameworkOptions);
  var b = this;
  this.handler = this.frameworkTool.handler;
  this.frameworkTool.handler.activate = function() {
    b.activate.apply(b.handler);
    b.registerToSnapping();
  };
  new viewer.viewercontroller.openlayers.OpenLayersTool(a, this.frameworkTool);
  a.type === viewer.viewercontroller.controller.Tool.MEASUREAREA && (this.frameworkTool.displayClass = "olControlMeasureArea");
  viewer.viewercontroller.openlayers.tools.OpenLayersMeasureTool.superclass.constructor.call(this, a, this.frameworkTool);
}, activate:function() {
  if (!OpenLayers.Handler.prototype.activate.apply(this, arguments) || !this.map) {
    return !1;
  }
  var a = OpenLayers.Util.extend({displayInLayerSwitcher:!1, calculateInRange:OpenLayers.Function.True, wrapDateLine:this.citeCompliant}, this.layerOptions);
  this.layer = new OpenLayers.Layer.Vector(this.CLASS_NAME, a);
  this.map.addLayer(this.layer);
  return !0;
}, deactivate:function() {
  this.frameworkObject.deactivate();
  return !0;
}, registerToSnapping:function(a) {
  a = this.config.viewerController.getComponentsByClassName("viewer.components.Snapping");
  var b = this, c = {getFrameworkLayer:function() {
    return b.handler.layer;
  }}, d = {layer:c};
  this.config.viewerController.registerSnappingLayer(c);
  for (c = 0;c < a.length;c++) {
    a[c].snapCtl.layerAdded(null, d);
  }
}});
Ext.define("viewer.viewercontroller.openlayers.tools.OpenLayersIdentifyTool", {extend:"viewer.viewercontroller.openlayers.OpenLayersTool", map:null, deactivatedControls:null, wmsGetFeatureInfoControl:null, wmsGetFeatureInfoFormat:"application/vnd.ogc.gml", useWMSGetFeatureInfo:null, active:!1, layersToAdd:null, config:{maxFeatures:1E3}, constructor:function(a) {
  this.useWMSGetFeatureInfo = !0;
  var b = new OpenLayers.Control({displayClass:"olControlIdentify", type:OpenLayers.Control.TYPE_TOOL, title:a.tooltip});
  viewer.viewercontroller.openlayers.tools.OpenLayersIdentifyTool.superclass.constructor.call(this, a, b);
  this.map = this.config.viewerController.mapComponent.getMap();
  this.mapClick = new viewer.viewercontroller.openlayers.ToolMapClick({id:"mapclick_" + this.id, viewerController:this.config.viewerController, handler:{fn:this.handleClick, scope:this}, handlerOptions:{stopSingle:!0}});
  this.getViewerController().mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, this.onAddLayer, this);
  this.getViewerController().mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED, this.onRemoveLayer, this);
  this.setUseWMSGetFeatureInfo(this.useWMSGetFeatureInfo);
  this.getFrameworkTool().events.register("activate", this, this.activate);
  this.getFrameworkTool().events.register("deactivate", this, this.deactivate);
  return this;
}, setUseWMSGetFeatureInfo:function(a) {
  (this.useWMSGetFeatureInfo = a) ? (null == this.wmsGetFeatureInfoControl && (null == this.layersToAdd && (this.layersToAdd = []), this.wmsGetFeatureInfoControl = new OpenLayers.Control.WMSGetFeatureInfo({drillDown:!0, queryVisible:!0, infoFormat:this.wmsGetFeatureInfoFormat, layers:this.layersToAdd, maxFeatures:this.getMaxFeatures()}), this.wmsGetFeatureInfoControl.handleResponse = handleResponse, this.wmsGetFeatureInfoControl.buildWMSOptions = buildWMSOptions, this.wmsGetFeatureInfoControl.request = 
  requestWmsGFI, this.wmsGetFeatureInfoControl.events.register("getfeatureinfo", this, this.raiseOnDataEvent), this.wmsGetFeatureInfoControl.format.read_FeatureCollection = this.readFeatureCollection, this.map.getFrameworkMap().addControl(this.wmsGetFeatureInfoControl), OpenLayers.ProxyHost = FlamingoAppLoader.get("contextPath") + "/action/proxy/wms?"), this.active ? this.wmsGetFeatureInfoControl.activate() : this.wmsGetFeatureInfoControl.deactivate()) : null != this.wmsGetFeatureInfoControl && this.wmsGetFeatureInfoControl.deactivate();
}, onAddLayer:function(a, b) {
  var c = b.layer;
  if (null != c && c instanceof viewer.viewercontroller.controller.WMSLayer) {
    var d = c.getDetails();
    if (void 0 != d && !(Ext.isEmpty(d["summary.description"]) && Ext.isEmpty(d["summary.image"]) && Ext.isEmpty(d["summary.link"]) && Ext.isEmpty(d["summary.title"]))) {
      d = !0;
      if (c.appLayerId) {
        var e = this.config.viewerController.app.appLayers[c.appLayerId];
        this.config.viewerController.app.services[e.serviceId].layers[e.layerName].hasFeatureType && (d = !1);
      }
      d && this.addWmsClientLayer(c);
    }
  }
}, onRemoveLayer:function(a, b) {
  var c = b.layer;
  null != c && c instanceof viewer.viewercontroller.controller.WMSLayer && this.removeWmsClientLayer(c);
}, addWmsClientLayer:function(a) {
  a = a.getFrameworkLayer();
  null != this.wmsGetFeatureInfoControl ? (null == this.wmsGetFeatureInfoControl.layers && (this.wmsGetFeatureInfoControl.layers = []), this.wmsGetFeatureInfoControl.layers.push(a)) : (null == this.layersToAdd && (this.layersToAdd = []), this.layersToAdd.push(a));
}, removeWmsClientLayer:function(a) {
  a = a.getFrameworkLayer();
  null != this.wmsGetFeatureInfoControl ? null != this.wmsGetFeatureInfoControl.layers && (this.wmsGetFeatureInfoControl.layers = Ext.Array.remove(this.wmsGetFeatureInfoControl.layers, a)) : null != this.layersToAdd && (this.layersToAdd = Ext.Array.remove(this.layersToAdd, a));
}, activate:function() {
  if (viewer.components.MobileManager.isMobile()) {
    null == this.deactivatedControls && (this.deactivatedControls = []);
    for (var a = this.map.getFrameworkMap().getControlsByClass("OpenLayers.Control.Navigation"), b = 0;b < a.length;b++) {
      a[b].active && (this.deactivatedControls.push(a[b]), a[b].deactivate());
    }
  }
  this.active = !0;
  this.mapClick.activateTool();
  null != this.wmsGetFeatureInfoControl && this.wmsGetFeatureInfoControl.activate();
}, deactivate:function() {
  if (viewer.components.MobileManager.isMobile()) {
    for (;!Ext.isEmpty(this.deactivatedControls);) {
      this.deactivatedControls.pop().activate();
    }
  }
  this.active = !1;
  this.mapClick.deactivateTool();
  null != this.wmsGetFeatureInfoControl && this.wmsGetFeatureInfoControl.deactivate();
}, handleClick:function(a, b) {
  this.map.fire(viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO, b);
}, raiseOnDataEvent:function(a) {
  var b = {};
  b.x = a.xy.x;
  b.y = a.xy.y;
  var c = {}, d = this.map.pixelToCoordinate(b.x, b.y);
  c.x = d.x;
  c.y = d.y;
  b.coord = c;
  for (var c = {}, e = 0;e < a.features.length;e++) {
    var f = a.features[e], g = f.type ? f.type : f.layerNames, h = f.styleNames, d = this.getAppLayerByOpenLayersLayer(f.url, g, h);
    null === d && (d = this.getAppLayerByOpenLayersLayer(f.url, f.layerNames, h));
    c.hasOwnProperty(d.id) || (c[d.id] = {});
    c[d.id].hasOwnProperty(g) || (c[d.id][g] = {}, c[d.id][g].appLayerObj = d, c[d.id][g].features = []);
    c[d.id][g].features.push(f.attributes);
  }
  for (var k in c) {
    b.data = [];
    a = c[k];
    var d = null, l;
    for (l in a) {
      e = {request:{appLayer:k, serviceLayer:l}, features:a[l].features, appLayer:a[l].appLayerObj}, d = a[l].appLayerObj, b.data.push(e);
    }
    d.fire(viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO_DATA, b);
  }
}, getAppLayerByOpenLayersLayer:function(a, b, c) {
  for (var d = this.map.layers, e = 0;e < d.length;e++) {
    var f = d[e];
    if (f.url === a) {
      var g = f.getLayers();
      if (!(g instanceof Array)) {
        var h = [];
        h.push(g);
        g = h;
      }
      var k = f.getStyles();
      k instanceof Array || (h = [], h.push(k), k = h);
      if (g.length === b.length) {
        for (var h = !0, l = 0;l < b.length;l++) {
          for (var t = !1, n = 0;n < g.length;n++) {
            if (g[n] === b[l] && (null === c || 0 === c.length || k[n] === c[l])) {
              t = !0;
              break;
            }
          }
          if (!t) {
            h = !1;
            break;
          }
        }
        g = this.viewerController.isSummaryLayer(f);
        if (h && g) {
          return f;
        }
      }
    }
  }
  return null;
}, readFeatureCollection:function(a) {
  a = this.getSiblingNodesByTagCriteria(a, "featureMember");
  var b = [];
  if (a) {
    for (var c = 0, d = a.length;c < d;++c) {
      if (a.hasOwnProperty(c)) {
        var e = a[c].firstElementChild || a[c].firstChild || a[c].children[0] || {}, f = this.parseAttributes(e), g = this.parseGeometry(e), f = new OpenLayers.Feature.Vector(g.geometry, f, null);
        f.type = e.localName || e.baseName;
        b.push(f);
      }
    }
  }
  return b;
}});
Ext.define("viewer.viewercontroller.openlayers.tools.OpenLayersDefaultTool", {extend:"viewer.viewercontroller.openlayers.tools.OpenLayersIdentifyTool", map:null, navigationControl:null, mapClick:null, constructor:function(a) {
  var b = new OpenLayers.Control({displayClass:"olControlDefault", type:OpenLayers.Control.TYPE_TOOL, title:a.tooltip});
  viewer.viewercontroller.openlayers.tools.OpenLayersIdentifyTool.superclass.constructor.call(this, a, b);
  this.setType(viewer.viewercontroller.controller.Tool.DEFAULT);
  this.map = this.config.viewerController.mapComponent.getMap();
  this.mapClick = new viewer.viewercontroller.openlayers.ToolMapClick({id:"mapclick_" + this.id, viewerController:this.config.viewerController, handler:{fn:this.handleClick, scope:this}, handlerOptions:{pixelTolerance:10}});
  a = this.getViewerController().mapComponent.getMap().getLayers();
  for (b = 0;b < a.length;b++) {
    this.onAddLayer(null, {layer:a[b]});
  }
  this.getViewerController().mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, this.onAddLayer, this);
  this.getViewerController().mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED, this.onRemoveLayer, this);
  this.getFrameworkTool().events.register("activate", this, this.activate);
  this.getFrameworkTool().events.register("deactivate", this, this.deactivate);
  this.setUseWMSGetFeatureInfo(!0);
  return this;
}, activate:function() {
  this.active = !0;
  this.mapClick.activateTool();
  this.getFrameworkObject().activate();
  null != this.wmsGetFeatureInfoControl && this.wmsGetFeatureInfoControl.activate();
}, deactivate:function() {
  this.active = !1;
  this.mapClick.deactivateTool();
  this.getFrameworkObject().deactivate();
  null != this.wmsGetFeatureInfoControl && this.wmsGetFeatureInfoControl.deactivate();
}});
Ext.define("viewer.viewercontroller.openlayers.tools.OpenLayersMeasureHandler", {statics:{modifyHandler:function(a, b, c) {
  var d = (b.containerPrefix ? b.containerPrefix : "") + "olControlMeasureValue";
  if (c.parent) {
    var e = document.getElementById(d);
    if (null === e) {
      e = document.createElement("div");
      e.id = d;
      e.style.position = "absolute";
      a.map.div.appendChild(e);
      e.style.zIndex = "10000";
      e.className = "olControlMaptip";
      var f = document.createElement("div");
      f.id = d + "Text";
      e.appendChild(f);
    }
    f = a.map.getViewPortPxFromLonLat(new OpenLayers.LonLat(c.x, c.y));
    e.style.top = f.y + "px";
    e.style.left = f.x + 40 + "px";
    e.style.display = "block";
    var f = document.getElementById(d + "Text"), d = b.hasOwnProperty("decimals") && "" !== b.decimals ? +b.decimals : 3, e = b.decimalSeparator || ",", g, h;
    if (b.magicnumber && b.units) {
      if (g = b.units.replace(/\W/g, ""), OpenLayers.INCHES_PER_UNIT.hasOwnProperty(g) || (OpenLayers.INCHES_PER_UNIT[g] = OpenLayers.INCHES_PER_UNIT.km / (b.magicnumber / 10)), g = "OpenLayers.Handler.Polygon" === a.handler.CLASS_NAME ? a.getArea(c.parent, g) : a.getLength(c.parent, g), "OpenLayers.Handler.Polygon" === a.handler.CLASS_NAME && 0 > g && (g *= -1), h = b.units, b.addUnit) {
        a = viewer.viewercontroller.openlayers.tools.OpenLayersMeasureHandler.getBestMeasure(a, c);
        f.innerHTML = "" + ("" + a.measure.toFixed(d)).replace(".", e) + " " + a.units + " - " + ("" + g.toFixed(d)).replace(".", e) + " " + h;
        return;
      }
    } else {
      a = viewer.viewercontroller.openlayers.tools.OpenLayersMeasureHandler.getBestMeasure(a, c), g = a.measure, h = a.units;
    }
    f.innerHTML = ("" + g.toFixed(d)).replace(".", e) + " " + h;
  }
}, getBestLength:function(a, b) {
  for (var c = a.displaySystemUnits[a.displaySystem], d, e, f = 0, g = c.length;f < g && !(d = c[f], e = a.getLength(b, d), 1 < e || -1 > e);++f) {
  }
  return [e, d];
}, getBestArea:function(a, b) {
  for (var c = a.displaySystemUnits[a.displaySystem], d, e, f = 0, g = c.length;f < g && !(d = c[f], e = a.getArea(b, d), 1 < e || -1 > e);++f) {
  }
  return [e, d];
}, getBestMeasure:function(a, b) {
  var c;
  "OpenLayers.Handler.Polygon" === a.handler.CLASS_NAME ? (c = viewer.viewercontroller.openlayers.tools.OpenLayersMeasureHandler.getBestArea(a, b.parent), 0 > c[0] && (c[0] *= -1), c[1] += "\x3csup\x3e2\x3c/sup\x3e") : c = viewer.viewercontroller.openlayers.tools.OpenLayersMeasureHandler.getBestLength(a, b.parent);
  return {measure:c[0], units:c[1]};
}, removeMeasure:function(a) {
  if (a = document.getElementById((a ? a : "") + "olControlMeasureValue")) {
    a.style.display = "none";
  }
}}});
