/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.Bookmark;
import nl.b3p.viewer.stripes.ApplicationActionBean;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/bookmark")
@StrictBinding
public class BookmarkActionBean
extends LocalizableApplicationActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(BookmarkActionBean.class);
    private ActionBeanContext context;
    @Validate
    private Application application;
    @Validate
    @ValidateNestedProperties(value={@Validate(field="params", required=true, on={"create"}), @Validate(field="code", required=true, on={"load"})})
    private Bookmark bookmark;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(Bookmark bookmark) {
        this.bookmark = bookmark;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Resolution create() throws JSONException {
        String error;
        JSONObject json;
        block7: {
            json = new JSONObject();
            json.put("success", (Object)Boolean.FALSE);
            error = null;
            EntityManager em = Stripersist.getEntityManager();
            Resolution r = ApplicationActionBean.checkRestriction(this.context, this.application, em);
            if (r != null) {
                error = this.getBundle().getString("viewer.bookmarkactionbean.1");
            } else if (this.bookmark == null || this.bookmark.getParams() == null) {
                error = this.getBundle().getString("viewer.bookmarkactionbean.2");
            } else {
                try {
                    String createdBy = Bookmark.createCreatedBy((ActionBeanContext)this.context);
                    UUID uuid = UUID.randomUUID();
                    String code = uuid.toString();
                    code = code.replaceAll("-", "");
                    this.bookmark.setCreatedBy(createdBy);
                    this.bookmark.setCreatedAt(new Date());
                    this.bookmark.setApplication(this.application);
                    this.bookmark.setCode(code);
                    em.persist((Object)this.bookmark);
                    em.getTransaction().commit();
                    log.debug((Object)("Bookmark created with code " + this.bookmark.getCode() + " and params " + this.bookmark.getParams()));
                    json.put("bookmark", (Object)this.bookmark.getCode());
                    json.put("success", (Object)Boolean.TRUE);
                }
                catch (Exception e) {
                    log.error((Object)"Error creating bookmark", (Throwable)e);
                    error = e.toString();
                    if (e.getCause() == null) break block7;
                    error = error + "; cause: " + e.getCause().toString();
                }
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    @After(on={"load"}, stages={LifecycleStage.BindingAndValidation})
    private void loadEntities() {
        EntityManager em = Stripersist.getEntityManager();
        List bms = em.createQuery("FROM Bookmark WHERE application = :app and code = :code", Bookmark.class).setParameter("app", (Object)this.application).setParameter("code", (Object)this.bookmark.getCode()).getResultList();
        if (bms.isEmpty()) {
            bms = em.createQuery("FROM Bookmark WHERE code = :code", Bookmark.class).setParameter("code", (Object)this.bookmark.getCode()).getResultList();
        }
        if (!bms.isEmpty()) {
            this.bookmark = (Bookmark)bms.get(0);
        }
    }

    public Resolution load() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONObject json = new JSONObject();
        Resolution r = ApplicationActionBean.checkRestriction(this.context, this.application, em);
        if (r != null) {
            return r;
        }
        if (this.bookmark == null || this.bookmark.getCode() == null) {
            json.put("success", (Object)Boolean.FALSE);
            json.put("error", (Object)"Can't find bookmark");
        } else {
            json.put("success", (Object)Boolean.TRUE);
            json.put("params", (Object)this.bookmark.getParams());
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }
}

