/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.image.CombineImageSettings;
import nl.b3p.viewer.image.CombineImageWkt;
import nl.b3p.viewer.image.CombineImagesHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

@UrlBinding(value="/action/combineimage")
@StrictBinding
public class CombineImageActionBean
extends LocalizableActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(CombineImageActionBean.class);
    private static final LinkedHashMap<String, CombineImageSettings> imageSettings = new LinkedHashMap();
    public static final String WMS = "WMS";
    public static final String ARCIMS = "ARCIMS";
    public static final String ARCSERVER = "ARCSERVER";
    public static final String IMAGE = "IMAGE";
    public static final String ARCSERVERREST = "ARCSERVERREST";
    private static int maxStoredSettings = 500;
    private static int minStoredSettings = 400;
    private ActionBeanContext context;
    private int maxResponseTime = 10000;
    @Validate
    private String params;
    @Validate
    private String imageId;
    @Validate
    private String keepAlive;
    @Validate
    private Integer width = null;
    @Validate
    private Integer height = null;
    @Validate
    private String bbox = null;
    @Validate
    private String geom = null;

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(String keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String getBbox() {
        return this.bbox;
    }

    public void setBbox(String bbox) {
        this.bbox = bbox;
    }

    public String getGeom() {
        return this.geom;
    }

    public void setGeom(String geom) {
        this.geom = geom;
    }

    @DefaultHandler
    public Resolution create() throws JSONException, Exception {
        String orientation;
        JSONObject jRequest = new JSONObject(this.params);
        JSONObject jResponse = new JSONObject();
        String error = null;
        String pageFormat = jRequest.has("pageformat") ? jRequest.getString("pageformat") : "a4";
        String string = orientation = jRequest.has("orientation") ? jRequest.getString("orientation") : "portrait";
        if (orientation == null || pageFormat == null) {
            error = this.getBundle().getString("viewer.combineimageactionbean.1");
        } else {
            try {
                CombineImageSettings cis = CombineImageSettings.fromJson(jRequest);
                if (this.imageId == null) {
                    this.imageId = CombineImageActionBean.uniqueId();
                }
                if (imageSettings.size() > maxStoredSettings) {
                    Set<String> keyset = imageSettings.keySet();
                    Iterator<String> iterator = keyset.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                        if (imageSettings.size() >= minStoredSettings) continue;
                    }
                }
                imageSettings.put(this.imageId, cis);
                String url = this.context.getRequest().getRequestURL().toString();
                url = url + "?getImage=t&imageId=" + this.imageId;
                String jsessionId = null;
                String j = "jsessionid";
                int index = url.toLowerCase().indexOf(j);
                jsessionId = index != -1 ? url.substring(index += j.length() + 1, index + 32) : this.context.getRequest().getSession().getId();
                url = url + "&JSESSIONID=" + jsessionId;
                Cookie[] cookies = this.context.getRequest().getCookies();
                if (cookies != null) {
                    for (Cookie cookie : cookies) {
                        if (cookie == null || !cookie.getName().equalsIgnoreCase("JSESSIONIDSSO")) continue;
                        url = url + "&JSESSIONIDSSO=" + cookie.getValue();
                    }
                }
                jResponse.put("imageUrl", (Object)url);
                jResponse.put("success", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        if (error != null) {
            jResponse.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(jResponse.toString()));
    }

    public Resolution getImage() throws Exception {
        if (this.imageId == null || imageSettings.get(this.imageId) == null) {
            throw new Exception("No imageId provided");
        }
        final CombineImageSettings settings = imageSettings.get(this.imageId);
        if (this.getWidth() != null && this.getWidth() > 0) {
            settings.setWidth(this.getWidth());
        }
        if (this.getHeight() != null && this.getHeight() > 0) {
            settings.setHeight(this.getHeight());
        }
        if (this.bbox != null) {
            settings.setBbox(this.bbox);
        }
        if (this.getGeom() != null) {
            String firstChar = this.geom.substring(0, 1);
            try {
                int test = Integer.parseInt(firstChar);
                String[] tokens = this.geom.split(",");
                String minx = tokens[0];
                String miny = tokens[1];
                String maxx = tokens[2];
                String maxy = tokens[3];
                String wkt = "LINESTRING(";
                wkt = wkt + minx + " " + miny + ", ";
                wkt = wkt + maxx + " " + miny + ", ";
                wkt = wkt + maxx + " " + maxy + ", ";
                wkt = wkt + minx + " " + maxy + ", ";
                this.geom = wkt = wkt + minx + " " + miny + ")";
            }
            catch (NumberFormatException test) {
                // empty catch block
            }
            CombineImageWkt ciw = new CombineImageWkt(this.geom);
            ciw.setStrokeWidth(Float.valueOf(8.0f));
            if (settings.getWktGeoms() == null) {
                settings.setWktGeoms(new ArrayList<CombineImageWkt>());
            }
            settings.getWktGeoms().add(ciw);
        }
        final String ssojessionid = this.context.getRequest().getParameter("JSESSIONIDSSO");
        final String jessionid = this.context.getRequest().getParameter("JSESSIONID");
        StreamingResolution res = new StreamingResolution(settings.getMimeType()){

            public void stream(HttpServletResponse response) throws Exception {
                ServletOutputStream out = response.getOutputStream();
                response.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
                CombineImagesHandler.combineImage((OutputStream)out, settings, settings.getMimeType(), CombineImageActionBean.this.maxResponseTime, CombineImageActionBean.this.context.getRequest(), jessionid, ssojessionid);
            }
        };
        return res;
    }

    public static String uniqueId() {
        long now = new Date().getTime();
        String val1 = Long.toString(now, 36).toUpperCase();
        Random rg = new Random();
        long rnum = rg.nextInt(1000);
        String val2 = Long.toString(rnum, 36).toUpperCase();
        return val1 + val2;
    }
}

