/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.features;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.features.FeatureDownloader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.simple.SimpleFeature;

public class CSVDownloader
extends FeatureDownloader {
    private char separator = (char)59;
    private PrintWriter pw;
    private File f;

    public CSVDownloader(List<ConfiguredAttribute> attributes, SimpleFeatureSource fs, Map<String, AttributeDescriptor> featureTypeAttributes, Map<String, String> attributeAliases, String params) {
        super(attributes, fs, featureTypeAttributes, attributeAliases, params);
    }

    public void init() throws IOException {
        this.f = File.createTempFile("csvFeatures", ".csv");
        this.pw = new PrintWriter(this.f);
        ArrayList<String> header = new ArrayList<String>();
        for (ConfiguredAttribute configuredAttribute : this.attributes) {
            String alias;
            if (!configuredAttribute.isVisible() || (alias = (String)this.attributeAliases.get(configuredAttribute.getAttributeName())) == null) continue;
            header.add(alias);
        }
        this.writeRow(header);
    }

    public void processFeature(SimpleFeature oldFeature) {
        ArrayList<String> row = new ArrayList<String>();
        for (ConfiguredAttribute configuredAttribute : this.attributes) {
            if (!configuredAttribute.isVisible() || this.attributeAliases.get(configuredAttribute.getAttributeName()) == null) continue;
            Object attribute = oldFeature.getAttribute(configuredAttribute.getAttributeName());
            String value = null;
            if (attribute != null) {
                value = attribute.toString();
            }
            row.add(value);
        }
        this.writeRow(row);
    }

    public File write() throws IOException {
        this.pw.close();
        return this.f;
    }

    private void writeRow(List<String> row) {
        Object completeString = "";
        for (String col : row) {
            if (col != null) {
                completeString = (String)completeString + col;
            }
            completeString = (String)completeString + this.separator;
        }
        completeString = ((String)completeString).substring(0, ((String)completeString).length() - 1);
        this.pw.println((String)completeString);
    }
}

