/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.search;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import nl.b3p.viewer.search.SearchClient;
import nl.b3p.viewer.search.SearchResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ArcGisRestSearchClient
extends SearchClient {
    private static final Log log = LogFactory.getLog(ArcGisRestSearchClient.class);
    private String url;
    private static final int DEFAULT_ZOOMBOX_SIZE = 200;

    public ArcGisRestSearchClient(String url) {
        this.url = url;
    }

    public SearchResult search(String query) {
        SearchResult result = new SearchResult();
        Object queryUrl = this.url.contains("[ZOEKWOORD]") ? this.url.replace("[ZOEKWOORD]", query) : this.url + query;
        JSONArray returnValue = new JSONArray();
        try {
            JSONObject obj = new JSONObject(IOUtils.toString((InputStream)new URL((String)queryUrl).openStream(), (String)"UTF-8"));
            JSONArray candidates = (JSONArray)obj.get("candidates");
            returnValue = this.candidateToResult(candidates);
            result.setResults(returnValue);
            result.setLimitReached(Boolean.valueOf(false));
        }
        catch (JSONException je) {
            log.error((Object)"Search error while creating json objects", (Throwable)je);
        }
        catch (IOException ex) {
            log.error((Object)("Error while requesting url: " + (String)queryUrl), (Throwable)ex);
        }
        return result;
    }

    private JSONArray candidateToResult(JSONArray candidates) throws JSONException {
        JSONArray results = new JSONArray();
        for (int i = 0; i < candidates.length(); ++i) {
            JSONObject candidate = (JSONObject)candidates.get(i);
            results.put((Object)this.candidateToResult(candidate));
        }
        return results;
    }

    private JSONObject candidateToResult(JSONObject candidate) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("label", (Object)candidate.optString("address"));
        JSONObject loc = candidate.getJSONObject("location");
        JSONObject location = this.locationToBBOX(200, loc.getDouble("x"), loc.getDouble("y"));
        result.put("location", (Object)location);
        return result;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public JSONArray autosuggest(String query) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

