/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.search;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.viewer.search.SearchClient;
import nl.b3p.viewer.search.SearchResult;
import nl.geozet.openls.databinding.gml.Point;
import nl.geozet.openls.databinding.openls.Address;
import nl.geozet.openls.databinding.openls.GeocodeResponse;
import nl.geozet.openls.databinding.openls.GeocodeResponseList;
import nl.geozet.openls.databinding.openls.GeocodedAddress;
import nl.geozet.openls.parser.OpenLSResponseParser;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenLSSearchClient
extends SearchClient {
    private static final Log log = LogFactory.getLog(OpenLSSearchClient.class);
    private String url;
    private OpenLSResponseParser parser;
    private Map<String, Integer> zoomboxSizes = new HashMap();

    public OpenLSSearchClient(String url) {
        this.url = url;
        this.parser = new OpenLSResponseParser();
        this.zoomboxSizes.put("Street", 200);
        this.zoomboxSizes.put("MunicipalitySubdivision", 2000);
        this.zoomboxSizes.put("Municipality", 5000);
        this.zoomboxSizes.put("CountrySubdivision", 25000);
    }

    public SearchResult search(String query) {
        SearchResult result = new SearchResult();
        Object queryUrl = this.url.contains("[ZOEKWOORD]") ? this.url.replace("[ZOEKWOORD]", query) : this.url + query;
        JSONArray resultArray = new JSONArray();
        String response = null;
        try {
            String encodedQuery = URIUtil.encodeQuery((String)queryUrl, (String)"UTF-8");
            response = IOUtils.toString((InputStream)new URL(encodedQuery).openStream(), (String)"UTF-8");
            GeocodeResponse gecoderResponse = this.parser.parseOpenLSResponse(response);
            try {
                resultArray = this.responseToResult(gecoderResponse);
            }
            catch (JSONException ex) {
                log.error((Object)"Error while converting OpenLS result to JSON result", (Throwable)ex);
            }
            result.setResults(resultArray);
            result.setLimitReached(Boolean.valueOf(false));
        }
        catch (IOException ex) {
            log.error((Object)"Error while getting OpenLS response", (Throwable)ex);
        }
        return result;
    }

    private JSONArray responseToResult(GeocodeResponse response) throws JSONException {
        JSONArray results = new JSONArray();
        for (int l = 0; l < response.getGeocodeResponseListSize(); ++l) {
            GeocodeResponseList list = response.getGeocodeResponseListAt(l);
            for (int g = 0; g < list.getGeocodedAddressSize(); ++g) {
                GeocodedAddress geoAdress = list.getGeocodedAddressAt(g);
                if (!geoAdress.hasPoint() || geoAdress.getPoint().getPosSize() <= 0 || !geoAdress.hasAddress()) continue;
                JSONObject result = new JSONObject();
                String type = null;
                Address adr = geoAdress.getAddress();
                StringBuilder label = new StringBuilder();
                if (adr.hasStreetAddress() && adr.getStreetAddress().hasStreet()) {
                    type = "Street";
                    label.append(adr.getStreetAddress().getStreet().getStreet());
                    if (adr.hasStreetAddress() && adr.getStreetAddress().hasBuilding()) {
                        label.append(" " + adr.getStreetAddress().getBuilding().getNumber());
                    }
                }
                if (adr.hasPostalCode() && adr.getPostalCode().hasPostalCode()) {
                    label.append(" " + adr.getPostalCode().getPostalCode());
                }
                if (adr.getPlaceByType("MunicipalitySubdivision") != null) {
                    label.append(label.length() == 0 ? "" : ", ");
                    label.append(adr.getPlaceByType("MunicipalitySubdivision"));
                    if (type == null) {
                        type = "MunicipalitySubdivision";
                    }
                }
                if (adr.getPlaceByType("Municipality") != null && !adr.getPlaceByType("Municipality").equals(adr.getPlaceByType("MunicipalitySubdivision"))) {
                    label.append(label.length() == 0 ? "" : ", ");
                    label.append(adr.getPlaceByType("Municipality"));
                    if (type == null) {
                        type = "Municipality";
                    }
                }
                if (adr.getPlaceByType("CountrySubdivision") != null) {
                    label.append(label.length() == 0 ? "" : ", ");
                    label.append(" " + adr.getPlaceByType("CountrySubdivision"));
                    if (type == null) {
                        type = "CountrySubdivision";
                    }
                }
                result.put("label", (Object)label.toString());
                if (type != null) {
                    result.put("type", (Object)this.convertType(type));
                }
                Point p = geoAdress.getPoint();
                int zoomboxSize = this.getZoomBoxSize(type);
                JSONObject bbox = this.locationToBBOX(zoomboxSize, p.getPosAt(0).getX().doubleValue(), p.getPosAt(0).getY().doubleValue());
                result.put("location", (Object)bbox);
                results.put((Object)result);
            }
        }
        return results;
    }

    private String convertType(String openLSType) {
        if (openLSType.equalsIgnoreCase("Street")) {
            return "Straat";
        }
        if (openLSType.equalsIgnoreCase("MunicipalitySubdivision")) {
            return "Plaats";
        }
        if (openLSType.equalsIgnoreCase("Municipality")) {
            return "Gemeente";
        }
        if (openLSType.equalsIgnoreCase("CountrySubdivision")) {
            return "Provincie";
        }
        return "Onbekend";
    }

    public JSONArray autosuggest(String query) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getZoomBoxSize(String type) {
        return (Integer)this.zoomboxSizes.get(type);
    }
}

