/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.b3p.viewer.search.SearchClient;
import nl.b3p.viewer.search.SearchResult;
import nl.b3p.viewer.search.SolrSearchClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.geotools.geometry.jts.WKTReader2;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;

public class PDOKSearchClient
extends SearchClient {
    private static final Log log = LogFactory.getLog(SolrSearchClient.class);
    private SolrServer server = new HttpSolrServer("http://geodata.nationaalgeoregister.nl/locatieserver/v3");
    private WKTReader2 wkt = new WKTReader2();
    private String filter;
    private static final HashMap<String, Double> BUFFERS = new HashMap();

    public PDOKSearchClient(String filter) {
        this.filter = filter;
    }

    public SearchResult search(String term) {
        SearchResult result = new SearchResult();
        try {
            JSONArray respDocs = new JSONArray();
            SolrQuery query = new SolrQuery();
            term = (String)term + "*";
            if (this.filter != null) {
                query.setFilterQueries(new String[]{this.filter});
            }
            query.setQuery((String)term);
            query.setParam("fl", new String[]{"identificatie,weergavenaam,bron,type,openbareruimte_id,openbareruimtetype,straatnaam,adresseerbaarobject_id,nummeraanduiding_id,huisnummer,huisletter,huisnummertoevoeging,huis_nlt,postcode,woonplaatscode,woonplaatsnaam,gemeentenaam,provinciecode,provincienaam,kadastraal_object_id,kadastrale_gemeentecode,kadastrale_gemeentenaam,kadastrale_sectie,perceelnummer,kadastrale_grootte,gekoppeld_perceel,kadastrale_aanduiding,centroide_rd,boundingbox_rd,geometrie_rd,score"});
            query.setRequestHandler("/free");
            QueryResponse rsp = this.server.query((SolrParams)query);
            SolrDocumentList list = rsp.getResults();
            for (SolrDocument solrDocument : list) {
                JSONObject doc = this.solrDocumentToResult(solrDocument);
                if (doc == null) continue;
                respDocs.put((Object)doc);
            }
            result.setResults(respDocs);
            result.setLimitReached(Boolean.valueOf(list.getNumFound() > (long)list.size()));
        }
        catch (SolrServerException ex) {
            log.error((Object)"Cannot search:", (Throwable)ex);
        }
        return result;
    }

    public JSONArray autosuggest(String term) throws JSONException {
        SearchResult r = this.search(term);
        return r.getResults();
    }

    private JSONObject solrDocumentToResult(SolrDocument doc) {
        JSONObject result = null;
        try {
            Map values = doc.getFieldValueMap();
            result = new JSONObject();
            Iterator iterator = values.keySet().iterator();
            block10: while (iterator.hasNext()) {
                String key;
                switch (key = (String)iterator.next()) {
                    case "geometrie_rd": 
                    case "boundingbox_rd": 
                    case "centroide_rd": {
                        continue block10;
                    }
                }
                result.put(key, values.get(key));
            }
            String geom = (String)doc.getFieldValue("centroide_rd");
            if (values.containsKey("geometrie_rd")) {
                geom = (String)values.get("geometrie_rd");
            } else if (values.containsKey("boundingbox_rd")) {
                geom = (String)values.get("boundingbox_rd");
            }
            Geometry g = this.wkt.read(geom);
            if (g instanceof Point) {
                Double d = (Double)BUFFERS.get(result.getString("type"));
                if (d == null) {
                    d = (Double)BUFFERS.get("weg");
                }
                g = g.buffer(d.doubleValue());
            }
            if (geom != null) {
                Envelope env = g.getEnvelopeInternal();
                HashMap<String, Double> bbox = new HashMap<String, Double>();
                bbox.put("minx", env.getMinX());
                bbox.put("miny", env.getMinY());
                bbox.put("maxx", env.getMaxX());
                bbox.put("maxy", env.getMaxY());
                result.put("location", bbox);
            }
            result.put("label", values.get("weergavenaam"));
        }
        catch (JSONException | ParseException ex) {
            log.error((Object)ex);
        }
        return result;
    }

    static {
        BUFFERS.put("gemeente", 5000.0);
        BUFFERS.put("woonplaats", 2500.0);
        BUFFERS.put("weg", 50.0);
        BUFFERS.put("postcode", 50.0);
        BUFFERS.put("adres", 10.0);
        BUFFERS.put("hectometerpaal", 35.0);
        BUFFERS.put("perceel", 25.0);
    }
}

