/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.util.FlamingoCQL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/extent")
@StrictBinding
public class FeatureExtentActionBean
extends LocalizableActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(FeatureExtentActionBean.class);
    private ActionBeanContext context;
    @Validate
    private String filter;
    @Validate
    private ApplicationLayer appLayer;
    @Validate
    private int buffer;
    private Layer layer;
    private boolean unauthorized;

    @After(stages={LifecycleStage.BindingAndValidation})
    public void loadLayer() {
        this.layer = this.appLayer.getService().getSingleLayer(this.appLayer.getLayerName(), Stripersist.getEntityManager());
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        if (this.appLayer == null || !Authorizations.isLayerReadAuthorized((Layer)this.layer, (HttpServletRequest)this.context.getRequest(), (EntityManager)Stripersist.getEntityManager())) {
            this.unauthorized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution extent() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = null;
        if (this.appLayer == null || this.filter == null) {
            error = this.getBundle().getString("viewer.featureextentactionbean.1");
        } else if (this.unauthorized) {
            error = this.getBundle().getString("viewer.featureextentactionbean.2");
        } else {
            FeatureSource fs = null;
            try {
                fs = this.layer.getFeatureType().openGeoToolsFeatureSource();
                BoundingBox extent = this.getExtent(fs, Stripersist.getEntityManager());
                JSONObject e = new JSONObject();
                e.put("minx", extent.getMinX());
                e.put("miny", extent.getMinY());
                e.put("maxx", extent.getMaxX());
                e.put("maxy", extent.getMaxY());
                json.put("extent", (Object)e);
                json.put("success", (Object)Boolean.TRUE);
            }
            catch (CQLException c) {
                error = c.getLocalizedMessage();
                log.error((Object)error, (Throwable)c);
            }
            catch (IOException io) {
                error = io.getLocalizedMessage();
                log.error((Object)error, (Throwable)io);
            }
            catch (Exception ex) {
                error = ex.getLocalizedMessage();
                log.error((Object)error, (Throwable)ex);
            }
            finally {
                if (fs != null) {
                    fs.getDataStore().dispose();
                }
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    private BoundingBox getExtent(FeatureSource fs, EntityManager em) throws CQLException, IOException {
        Geometry geom;
        Filter f = FlamingoCQL.toFilter((String)this.filter, (EntityManager)em);
        Query q = new Query(fs.getName().toString());
        q.setFilter(f);
        q.setHandle("extent-query");
        q.setMaxFeatures(1000);
        q.setPropertyNames(new String[]{fs.getSchema().getGeometryDescriptor().getName().toString()});
        SimpleFeatureCollection feats = (SimpleFeatureCollection)fs.getFeatures(q);
        BoundsVisitor bounds = new BoundsVisitor();
        feats.accepts((FeatureVisitor)bounds, null);
        ReferencedEnvelope extent = bounds.getBounds();
        log.debug((Object)("feature(s) extent " + (BoundingBox)extent));
        if (extent.getSpan(0) < 5.0 || extent.getSpan(1) < 5.0) {
            geom = JTS.toGeometry((BoundingBox)extent).buffer(5.0);
            extent = new ReferencedEnvelope(geom.getEnvelopeInternal(), extent.getCoordinateReferenceSystem());
            log.debug((Object)("enlarged extent" + (BoundingBox)extent));
        }
        if (this.buffer > 0) {
            log.debug((Object)("enlarging extent using buffer distance: " + this.buffer));
            geom = JTS.toGeometry((BoundingBox)extent).buffer((double)this.buffer);
            extent = new ReferencedEnvelope(geom.getEnvelopeInternal(), extent.getCoordinateReferenceSystem());
            log.debug((Object)("buffered extent" + (BoundingBox)extent));
        }
        return extent;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }
}

