/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.FeatureTypeRelationKey;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public class ValidFilterExtractor
extends DuplicatingFilterVisitor {
    private static final Log log = LogFactory.getLog(ValidFilterExtractor.class);
    private FeatureTypeRelation relation;

    public ValidFilterExtractor(FeatureTypeRelation relation) {
        this.relation = relation;
    }

    public Object visit(PropertyIsBetween filter, Object data) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(filter.getExpression());
        expressions.add(filter.getLowerBoundary());
        expressions.add(filter.getUpperBoundary());
        Filter f = this.visit(expressions, (Filter)filter, data);
        if (f == null) {
            return super.visit(filter, data);
        }
        return f;
    }

    public Object visit(PropertyIsEqualTo filter, Object data) {
        Filter f = this.visitAbstract((BinaryComparisonOperator)filter, data);
        if (f == null) {
            return super.visit(filter, data);
        }
        return f;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        Filter f = this.visitAbstract((BinaryComparisonOperator)filter, data);
        if (f == null) {
            return super.visit(filter, data);
        }
        return f;
    }

    public Object visit(PropertyIsGreaterThan filter, Object data) {
        Filter f = this.visitAbstract((BinaryComparisonOperator)filter, data);
        if (f == null) {
            return super.visit(filter, data);
        }
        return f;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        Filter f = this.visitAbstract((BinaryComparisonOperator)filter, data);
        if (f == null) {
            return super.visit(filter, data);
        }
        return f;
    }

    public Object visit(PropertyIsLessThan filter, Object data) {
        Filter f = this.visitAbstract((BinaryComparisonOperator)filter, data);
        if (f == null) {
            return super.visit(filter, data);
        }
        return f;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        Filter f = this.visitAbstract((BinaryComparisonOperator)filter, data);
        if (f == null) {
            return super.visit(filter, data);
        }
        return f;
    }

    public Object visit(PropertyIsLike filter, Object data) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(filter.getExpression());
        Filter f = this.visit(expressions, (Filter)filter, data);
        if (f == null) {
            return super.visit(filter, data);
        }
        return f;
    }

    private Filter visitAbstract(BinaryComparisonOperator bco, Object o) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(bco.getExpression1());
        expressions.add(bco.getExpression2());
        return this.visit(expressions, (Filter)bco, o);
    }

    private Filter visit(List<Expression> expressions, Filter f, Object o) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (Expression exp : expressions) {
            if (!(exp instanceof PropertyName)) continue;
            propertyNames.add(((PropertyName)exp).getPropertyName());
        }
        if (propertyNames.isEmpty()) {
            return null;
        }
        return this.doVisit(propertyNames, f, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Filter doVisit(List<String> names, Filter filter, Object o) {
        boolean found = false;
        SimpleFeatureType featureType = this.relation.getForeignFeatureType();
        for (AttributeDescriptor ad : featureType.getAttributes()) {
            for (String propertyName : names) {
                if (!propertyName.equals(ad.getName())) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        if (found) {
            try {
                FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
                FeatureSource fs = featureType.openGeoToolsFeatureSource();
                Query q = new Query(fs.getName().toString());
                q.setFilter(filter);
                HashMap<String, List<Object>> orFilters = new HashMap<String, List<Object>>();
                ArrayList<String> propertyNames = new ArrayList<String>();
                for (FeatureTypeRelationKey key : this.relation.getRelationKeys()) {
                    propertyNames.add(key.getRightSide().getName());
                    orFilters.put(key.getRightSide().getName(), new ArrayList());
                }
                q.setPropertyNames(propertyNames);
                FeatureCollection fc = fs.getFeatures(q);
                FeatureIterator it = null;
                HashMap inFilters = new HashMap();
                try {
                    it = fc.features();
                    while (it.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)it.next();
                        for (FeatureTypeRelationKey key : this.relation.getRelationKeys()) {
                            Object value = feature.getAttribute(key.getRightSide().getName());
                            if (value == null) continue;
                            if (AttributeDescriptor.GEOMETRY_TYPES.contains(key.getRightSide().getType()) && AttributeDescriptor.GEOMETRY_TYPES.contains(key.getLeftSide().getType())) {
                                And fil = ff.and((Filter)ff.not((Filter)ff.isNull((Expression)ff.property(key.getLeftSide().getName()))), (Filter)ff.intersects((Expression)ff.property(key.getLeftSide().getName()), (Expression)ff.literal(value)));
                                ((List)orFilters.get(key.getRightSide().getName())).add(fil);
                                continue;
                            }
                            if (!inFilters.containsKey(key.getRightSide().getName())) {
                                inFilters.put(key.getRightSide().getName(), new ArrayList());
                            }
                            ((List)inFilters.get(key.getRightSide().getName())).add(value);
                        }
                    }
                }
                finally {
                    if (it != null) {
                        it.close();
                    }
                    fs.getDataStore().dispose();
                }
                for (String propertyName : inFilters.keySet()) {
                    List values = (List)inFilters.get(propertyName);
                    String filterString = propertyName + " IN ";
                    Object valueString = null;
                    for (Object value : values) {
                        valueString = valueString == null ? "(" : (String)valueString + ", ";
                        if (value instanceof String) {
                            valueString = (String)valueString + "'" + value + "'";
                            continue;
                        }
                        valueString = (String)valueString + value;
                    }
                    valueString = valueString + ")";
                    Filter fil = ECQL.toFilter((String)(filterString + (String)valueString));
                    orFilters.put(propertyName, Collections.singletonList(fil));
                }
                ArrayList<Object> andFilters = new ArrayList<Object>();
                for (FeatureTypeRelationKey key : this.relation.getRelationKeys()) {
                    List filters = (List)orFilters.get(key.getRightSide().getName());
                    if (filters == null) continue;
                    if (filters.size() == 1) {
                        andFilters.add((Filter)filters.get(0));
                        continue;
                    }
                    if (filters.size() <= 1) continue;
                    andFilters.add(ff.or(filters));
                }
                if (andFilters.isEmpty()) {
                    return Filter.EXCLUDE;
                }
                if (andFilters.size() == 1) {
                    return (Filter)andFilters.get(0);
                }
                return ff.and(andFilters);
            }
            catch (Exception e) {
                log.error((Object)"Error while creating query: ", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

