/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.image;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import nl.b3p.viewer.image.Bbox;
import nl.b3p.viewer.image.CombineImageUrl;
import nl.b3p.viewer.image.ImageBbox;

public class CombineStaticImageUrl
extends CombineImageUrl {
    private Bbox bbox;
    private Integer x;
    private Integer y;
    private Integer width;
    private Integer height;

    public CombineStaticImageUrl() {
    }

    public CombineStaticImageUrl(URL url, Float alpha) {
        super(url, alpha);
    }

    private CombineStaticImageUrl(CombineStaticImageUrl csiu) {
        super((CombineImageUrl)csiu);
        this.bbox = new Bbox(csiu.bbox);
        this.x = csiu.getX();
        this.y = csiu.getY();
        this.width = csiu.getWidth();
        this.height = csiu.getHeight();
    }

    public List<CombineImageUrl> calculateNewUrl(ImageBbox imbbox) {
        CombineStaticImageUrl csiu = new CombineStaticImageUrl(this);
        double unitsX = imbbox.getUnitsPixelX();
        double unitsY = imbbox.getUnitsPixelY();
        csiu.width = (int)Math.round(csiu.getBbox().getWidth() / unitsX);
        csiu.height = (int)Math.round(csiu.getBbox().getHeight() / unitsY);
        csiu.x = (int)Math.round((csiu.getBbox().getMinx() - imbbox.getBbox().getMinx()) / unitsX);
        csiu.y = (int)Math.round((imbbox.getBbox().getMaxy() - csiu.getBbox().getMaxy()) / unitsY);
        ArrayList<CombineImageUrl> list = new ArrayList<CombineImageUrl>();
        list.add((CombineImageUrl)csiu);
        return list;
    }

    public Bbox getBbox() {
        return this.bbox;
    }

    public void setBbox(Bbox bbox) {
        this.bbox = bbox;
    }

    public Integer getX() {
        return this.x;
    }

    public void setX(Integer x) {
        this.x = x;
    }

    public Integer getY() {
        return this.y;
    }

    public void setY(Integer y) {
        this.y = y;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }
}

