/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.util.HtmlUtil;
import net.sourceforge.stripes.util.StringUtil;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.i18n.ResourceBundleProvider;
import nl.b3p.viewer.components.ComponentRegistry;
import nl.b3p.viewer.components.ComponentRegistryInitializer;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ConfiguredComponent;
import nl.b3p.viewer.config.metadata.Metadata;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.security.User;
import nl.b3p.viewer.stripes.ComponentActionBean;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import nl.b3p.viewer.stripes.LoginActionBean;
import nl.b3p.viewer.util.SelectedContentCache;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
@UrlBinding(value="/app/{name}/v{version}")
@StrictBinding
public class ApplicationActionBean
extends LocalizableApplicationActionBean
implements ActionBean {
    private ActionBeanContext context;
    @Validate
    private String name;
    @Validate
    private boolean unknown;
    @Validate
    private String version;
    @Validate
    private String bookmark;
    @Validate
    private String extent;
    @Validate
    private String layers;
    @Validate
    private String levelOrder;
    @Validate
    private boolean debug;
    @Validate(on={"retrieveAppConfigJSON"})
    private Application application;
    private String componentSourceHTML;
    private String appConfigJSON;
    private String viewerType;
    private String title;
    private String language;
    private JSONObject user;
    private String loginUrl;
    private HashMap<String, Object> globalLayout;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public String getComponentSourceHTML() {
        return this.componentSourceHTML;
    }

    public void setComponentSourceHTML(String componentSourceHTML) {
        this.componentSourceHTML = componentSourceHTML;
    }

    public String getAppConfigJSON() {
        return this.appConfigJSON;
    }

    public void setAppConfigJSON(String appConfigJSON) {
        this.appConfigJSON = appConfigJSON;
    }

    public String getViewerType() {
        return this.viewerType;
    }

    public void setViewerType(String viewerType) {
        this.viewerType = viewerType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public JSONObject getUser() {
        return this.user;
    }

    public void setUser(JSONObject user) {
        this.user = user;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public HashMap getGlobalLayout() {
        return this.globalLayout;
    }

    public void setGlobalLayout(HashMap globalLayout) {
        this.globalLayout = globalLayout;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    public void setUnknown(boolean unknown) {
        this.unknown = unknown;
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    public String getExtent() {
        return this.extent;
    }

    public void setExtent(String extent) {
        this.extent = extent;
    }

    public String getLayers() {
        return this.layers;
    }

    public void setLayers(String layers) {
        this.layers = layers;
    }

    public String getLevelOrder() {
        return this.levelOrder;
    }

    public void setLevelOrder(String levelOrder) {
        this.levelOrder = levelOrder;
    }

    static Application findApplication(String name, String version) {
        block3: {
            EntityManager em = Stripersist.getEntityManager();
            if (name != null) {
                CriteriaBuilder cb = em.getCriteriaBuilder();
                CriteriaQuery q = cb.createQuery(Application.class);
                Root root = q.from(Application.class);
                Predicate namePredicate = cb.equal((Expression)root.get("name"), (Object)name);
                Predicate versionPredicate = version != null ? cb.equal((Expression)root.get("version"), (Object)version) : cb.isNull((Expression)root.get("version"));
                q.where((Expression)cb.and((Expression)namePredicate, (Expression)versionPredicate));
                try {
                    return (Application)em.createQuery(q).getSingleResult();
                }
                catch (NoResultException nre) {
                    String decodedName = StringUtil.urlDecode((String)name);
                    if (decodedName.equals(name)) break block3;
                    return ApplicationActionBean.findApplication((String)decodedName, (String)version);
                }
            }
        }
        return null;
    }

    public Resolution saveCache() throws JSONException, IOException {
        Resolution view = this.view();
        EntityManager em = Stripersist.getEntityManager();
        Resolution r = ApplicationActionBean.checkRestriction((ActionBeanContext)this.context, (Application)this.application, (EntityManager)em);
        if (r != null) {
            return r;
        }
        SelectedContentCache cache = new SelectedContentCache();
        JSONObject sc = cache.createSelectedContent(this.application, false, false, false, em);
        this.application.getDetails().put("selected_content_cache", new ClobElement(sc.toString()));
        em.getTransaction().commit();
        return view;
    }

    public Resolution retrieveCache() throws JSONException, IOException {
        Resolution view = this.view();
        EntityManager em = Stripersist.getEntityManager();
        Resolution r = ApplicationActionBean.checkRestriction((ActionBeanContext)this.context, (Application)this.application, (EntityManager)em);
        if (r != null) {
            return r;
        }
        ClobElement el = (ClobElement)this.application.getDetails().get("selected_content_cache");
        this.appConfigJSON = el.getValue();
        return view;
    }

    public Resolution retrieveAppConfigJSON() throws IOException {
        EntityManager em = Stripersist.getEntityManager();
        JSONObject response = new JSONObject();
        response.put("success", false);
        JSONObject obj = this.application.toJSON(this.context.getRequest(), false, false, em);
        JSONObject details = obj.optJSONObject("details");
        if (details != null) {
            details.remove("cachedExpandedSelectedContent");
            details.remove("cachedSelectedContent");
        }
        this.appConfigJSON = obj.toString();
        response.put("config", (Object)this.appConfigJSON);
        response.put("success", true);
        return new StreamingResolution("application/json", (Reader)new StringReader(response.toString()));
    }

    @DefaultHandler
    public Resolution view() throws JSONException, IOException {
        if (this.unknown) {
            this.getDefaultViewer();
            return ((RedirectResolution)((RedirectResolution)new RedirectResolution(ApplicationActionBean.class).addParameter("name", new Object[]{this.name})).addParameter("version", new Object[]{this.version})).addParameter("debug", new Object[]{this.debug});
        }
        this.application = ApplicationActionBean.findApplication((String)this.name, (String)this.version);
        if (this.application == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new LocalizableError("app.notfound", new Object[]{this.name + (this.version != null ? " v" + this.version : "")}));
            return new ForwardResolution("/WEB-INF/jsp/error.jsp");
        }
        RedirectResolution login = ((RedirectResolution)((RedirectResolution)((RedirectResolution)((RedirectResolution)new RedirectResolution(ApplicationActionBean.class).addParameter("name", new Object[]{this.name})).addParameter("version", new Object[]{this.version})).addParameter("debug", new Object[]{this.debug})).addParameter("uitloggen", new Object[]{true})).includeRequestParameters(true);
        this.addBookmarkParameters(login);
        this.loginUrl = login.getUrl(this.context.getLocale());
        String username = this.context.getRequest().getRemoteUser();
        if (this.application.isAuthenticatedRequired() && username == null) {
            return login;
        }
        EntityManager em = Stripersist.getEntityManager();
        Resolution r = ApplicationActionBean.checkRestriction((ActionBeanContext)this.context, (Application)this.application, (EntityManager)em);
        if (r != null) {
            return r;
        }
        if (username != null) {
            this.user = new JSONObject();
            this.user.put("name", (Object)username);
            JSONObject roles = new JSONObject();
            this.user.put("roles", (Object)roles);
            for (String role : Authorizations.getRoles((HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
                roles.put(role, (Object)Boolean.TRUE);
            }
        }
        this.buildComponentSourceHTML(em);
        this.appConfigJSON = this.application.toJSON(this.context.getRequest(), false, false, em).toString();
        this.viewerType = this.retrieveViewerType();
        if (StringUtils.isBlank((String)this.title)) {
            this.title = this.application.getName();
        }
        this.language = this.application.getLang();
        if (StringUtils.isBlank((String)this.language)) {
            this.language = "nl_NL";
        }
        this.globalLayout = new HashMap();
        JSONObject layout = this.application.getGlobalLayout();
        Iterator keys = layout.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.globalLayout.put(key, layout.get(key));
        }
        this.context.getResponse().addHeader("X-UA-Compatible", "IE=edge");
        return new ForwardResolution("/WEB-INF/jsp/app.jsp");
    }

    public static Resolution checkRestriction(ActionBeanContext context, Application application, EntityManager em) {
        ResourceBundle bundle;
        String username = context.getRequest().getRemoteUser();
        User u = null;
        if (username != null) {
            Principal p = context.getRequest().getUserPrincipal();
            u = p instanceof User ? (User)p : (User)em.find(User.class, (Object)p.getName());
        }
        if (Authorizations.isUserExpired(u, (ActionBeanContext)context)) {
            bundle = ResourceBundleProvider.getResourceBundle((Locale)ApplicationActionBean.determineLocaleForBundle((ActionBeanContext)context, (Application)application));
            String msg = bundle.getString("viewer.applicationactionbean.expired");
            context.getValidationErrors().addGlobalError((ValidationError)new SimpleError(msg, new Object[0]));
            context.getRequest().getSession().invalidate();
            return new ForwardResolution("/WEB-INF/jsp/error.jsp");
        }
        if (!Authorizations.isApplicationReadAuthorized((Application)application, (HttpServletRequest)context.getRequest(), (EntityManager)em) && (username == null || u != null && u.isAuthenticatedByIp())) {
            RedirectResolution login = ((RedirectResolution)((RedirectResolution)new RedirectResolution(LoginActionBean.class).addParameter("name", new Object[]{application.getName()})).addParameter("version", new Object[]{application.getVersion()})).includeRequestParameters(true);
            context.getRequest().getSession().invalidate();
            return login;
        }
        if (!Authorizations.isApplicationReadAuthorized((Application)application, (HttpServletRequest)context.getRequest(), (EntityManager)em) && username != null) {
            bundle = ResourceBundleProvider.getResourceBundle((Locale)ApplicationActionBean.determineLocaleForBundle((ActionBeanContext)context, (Application)application));
            String msg = bundle.getString("viewer.applicationactionbean.norights");
            context.getValidationErrors().addGlobalError((ValidationError)new SimpleError(msg, new Object[0]));
            context.getRequest().getSession().invalidate();
            return new ForwardResolution("/WEB-INF/jsp/error_retry.jsp");
        }
        return null;
    }

    public static int getRolesCachekey(HttpServletRequest request, EntityManager em) {
        Set roles = Authorizations.getRoles((HttpServletRequest)request, (EntityManager)em);
        if (roles.isEmpty()) {
            return 0;
        }
        ArrayList sorted = new ArrayList(roles);
        Collections.sort(sorted);
        int hash = 0;
        for (String role : sorted) {
            hash ^= role.hashCode();
        }
        return hash;
    }

    public Resolution uitloggen() {
        this.application = ApplicationActionBean.findApplication((String)this.name, (String)this.version);
        this.context.getRequest().getSession().invalidate();
        if ("true".equals(this.context.getRequest().getParameter("logout")) && "true".equals(this.context.getRequest().getParameter("returnAfterLogout"))) {
            RedirectResolution r = (RedirectResolution)((RedirectResolution)new RedirectResolution(ApplicationActionBean.class).addParameter("name", new Object[]{this.application.getName()})).addParameter("version", new Object[]{this.application.getVersion()});
            this.addBookmarkParameters(r);
            return r;
        }
        RedirectResolution r = (RedirectResolution)((RedirectResolution)new RedirectResolution(LoginActionBean.class).addParameter("name", new Object[]{this.application.getName()})).addParameter("version", new Object[]{this.application.getVersion()});
        this.addBookmarkParameters(r);
        return r;
    }

    private void addBookmarkParameters(RedirectResolution r) {
        if (this.bookmark != null) {
            r.addParameter("bookmark", new Object[]{this.bookmark});
        }
        if (this.extent != null) {
            r.addParameter("extent", new Object[]{this.extent});
        }
        if (this.layers != null) {
            r.addParameter("layers", new Object[]{this.layers});
        }
        if (this.levelOrder != null) {
            r.addParameter("levelOrder", new Object[]{this.levelOrder});
        }
    }

    private void buildComponentSourceHTML(EntityManager em) throws IOException {
        StringBuilder sb = new StringBuilder();
        ComponentRegistry cr = ComponentRegistryInitializer.getInstance();
        ArrayList comps = new ArrayList(this.application.getComponents());
        Collections.sort(comps);
        if (this.isDebug()) {
            HashSet<String> classNamesDone = new HashSet<String>();
            for (ConfiguredComponent cc : comps) {
                if (!Authorizations.isConfiguredComponentAuthorized((ConfiguredComponent)cc, (HttpServletRequest)this.context.getRequest(), (EntityManager)em) || classNamesDone.contains(cc.getClassName())) continue;
                classNamesDone.add(cc.getClassName());
                if (cc.getViewerComponent() == null || cc.getViewerComponent().getSources() == null) continue;
                for (File f : cc.getViewerComponent().getSources()) {
                    String url = ((ForwardResolution)((ForwardResolution)((ForwardResolution)((ForwardResolution)new ForwardResolution(ComponentActionBean.class, "source").addParameter("app", new Object[]{this.name})).addParameter("version", new Object[]{this.version})).addParameter("className", new Object[]{cc.getClassName()})).addParameter("file", new Object[]{f.getName()})).getUrl(this.context.getLocale());
                    sb.append("        <script type=\"text/javascript\" src=\"");
                    sb.append(HtmlUtil.encode((String)(this.context.getServletContext().getContextPath() + url)));
                    sb.append("\"></script>\n");
                }
            }
        } else {
            int hash = 0;
            HashSet<String> classNamesDone = new HashSet<String>();
            for (ConfiguredComponent cc : comps) {
                if (!Authorizations.isConfiguredComponentAuthorized((ConfiguredComponent)cc, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) continue;
                if (!classNamesDone.contains(cc.getClassName())) {
                    hash ^= cc.getClassName().hashCode();
                    continue;
                }
                classNamesDone.add(cc.getClassName());
            }
            if (this.user != null) {
                hash ^= ApplicationActionBean.getRolesCachekey((HttpServletRequest)this.context.getRequest(), (EntityManager)em);
                hash ^= (int)this.application.getAuthorizationsModified().getTime();
            }
            String url = ((ForwardResolution)((ForwardResolution)((ForwardResolution)((ForwardResolution)new ForwardResolution(ComponentActionBean.class, "source").addParameter("app", new Object[]{this.name})).addParameter("version", new Object[]{this.version})).addParameter("minified", new Object[]{true})).addParameter("hash", new Object[]{hash})).getUrl(this.context.getLocale());
            sb.append("        <script type=\"text/javascript\" src=\"");
            sb.append(HtmlUtil.encode((String)(this.context.getServletContext().getContextPath() + url)));
            sb.append("\"></script>\n");
        }
        this.componentSourceHTML = sb.toString();
    }

    private String retrieveViewerType() {
        String type = "openlayers";
        String typePrefix = "viewer.mapcomponents";
        Set components = this.application.getComponents();
        for (ConfiguredComponent component : components) {
            String className = component.getClassName();
            if (!className.startsWith(typePrefix)) continue;
            type = className.substring(typePrefix.length() + 1).toLowerCase().replace("map", "");
            break;
        }
        return type;
    }

    private void getDefaultViewer() {
        EntityManager em = Stripersist.getEntityManager();
        try {
            Metadata md = (Metadata)em.createQuery("from Metadata where configKey = :key", Metadata.class).setParameter("key", (Object)"default_application").getSingleResult();
            String appId = md.getConfigValue();
            Long id = Long.parseLong(appId);
            Application app = (Application)em.find(Application.class, (Object)id);
            this.name = app.getName();
            this.version = app.getVersion();
        }
        catch (NullPointerException | NoResultException e) {
            this.name = "default";
            this.version = null;
        }
    }
}

