/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.image;

import nl.b3p.viewer.image.Bbox;
import nl.b3p.viewer.image.CombineTileImageUrl;
import nl.b3p.viewer.image.ImageBbox;

public class CombineTMSUrl
extends CombineTileImageUrl {
    public CombineTMSUrl(CombineTileImageUrl ctiu) {
        super(ctiu);
    }

    public CombineTMSUrl() {
    }

    @Override
    protected String createUrl(ImageBbox imageBbox, Bbox tileBbox, int indexX, int indexY, int zoomlevel) {
        String requestUrl = this.url + "/" + zoomlevel + "/" + indexX + "/" + indexY + "." + this.extension;
        return requestUrl;
    }

    @Override
    public Integer getTileIndexX(Double xCoord, Double res, boolean max) {
        Double tileSpanX = res * (double)this.getTileWidth().intValue();
        Double tileIndexX = (xCoord - this.getServiceBbox().getMinx()) / (tileSpanX + epsilon);
        tileIndexX = max ? Double.valueOf(Math.ceil(tileIndexX)) : Double.valueOf(Math.floor(tileIndexX));
        if (tileIndexX < 0.0) {
            tileIndexX = 0.0;
        }
        Double maxBboxX = Math.floor((this.getServiceBbox().getMaxx() - this.getServiceBbox().getMinx()) / (tileSpanX + epsilon));
        if (tileIndexX > maxBboxX) {
            tileIndexX = maxBboxX;
        }
        return tileIndexX.intValue();
    }

    @Override
    public Integer getTileIndexY(double yCoord, Double res, boolean max) {
        Double tileSpanY = res * (double)this.getTileHeight().intValue();
        Double tileIndexY = (yCoord - this.getServiceBbox().getMiny()) / (tileSpanY + epsilon);
        tileIndexY = max ? Double.valueOf(Math.ceil(tileIndexY)) : Double.valueOf(Math.floor(tileIndexY));
        if (tileIndexY < 0.0) {
            tileIndexY = 0.0;
        }
        Double maxBboxY = Math.floor((this.getServiceBbox().getMaxy() - this.getServiceBbox().getMiny()) / (tileSpanY + epsilon));
        if (tileIndexY > maxBboxY) {
            tileIndexY = maxBboxY;
        }
        return tileIndexY.intValue();
    }
}

