/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.services.LayarService;
import nl.b3p.viewer.config.services.LayarSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/layar")
@StrictBinding
public class LayarActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(LayarActionBean.class);
    private static final Integer TIMEOUT = 10000;
    private static final Integer DEFAULT_RADIUS = 5000;
    private static Integer MAX_FEATURES = 500;
    private static GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    private static CoordinateReferenceSystem DEFAULT_CRS;
    private static CoordinateReferenceSystem layarCRS;
    private static FilterFactory2 ff;
    private ActionBeanContext context;
    @Validate(required=true)
    private String lon;
    @Validate(required=true)
    private String lat;
    @Validate
    private String countryCode;
    @Validate
    private String userId;
    @Validate
    private Integer radius;
    @Validate(required=true)
    private String layerName;
    @Validate
    private String version;
    @Validate
    private Integer accuracy;
    @Validate
    private String lang;
    @Validate
    private String action;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution json() throws JSONException {
        String error = "";
        Integer errorCode = 0;
        JSONObject root = new JSONObject();
        root.put("layar", (Object)this.layerName);
        LayarService layarService = (LayarService)Stripersist.getEntityManager().createQuery("from LayarService where name=:n").setParameter("n", (Object)this.layerName).getSingleResult();
        if (this.radius == null) {
            this.radius = DEFAULT_RADIUS;
        }
        if (layarService != null) {
            root.put("layer", (Object)layarService.getName());
            List layarSources = layarService.getLayarSources();
            Iterator lit = layarSources.iterator();
            JSONArray hotspots = new JSONArray();
            while (lit.hasNext() && MAX_FEATURES > hotspots.length()) {
                LayarSource layarSource = (LayarSource)lit.next();
                FeatureSource fs = null;
                FeatureIterator it = null;
                if (layarSource.getFeatureType() == null) continue;
                try {
                    fs = layarSource.getFeatureType().openGeoToolsFeatureSource(TIMEOUT.intValue());
                    CoordinateReferenceSystem featureCrs = this.getCRS(fs);
                    Filter filter = this.createFilter(fs, featureCrs);
                    Query q = new Query(fs.getName().toString(), filter);
                    q.setMaxFeatures(MAX_FEATURES - hotspots.length());
                    it = fs.getFeatures(q).features();
                    while (it.hasNext()) {
                        SimpleFeature f = (SimpleFeature)it.next();
                        try {
                            JSONObject hotspot = this.createHotspot(f, layarSource);
                            hotspots.put((Object)hotspot);
                        }
                        catch (Exception e) {
                            log.error((Object)"Error creating hotspot", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error while retrieving features ", (Throwable)e);
                    error = "Error while retrieving features: " + e.getMessage();
                }
                finally {
                    if (it != null) {
                        it.close();
                    }
                    if (fs == null) continue;
                    fs.getDataStore().dispose();
                }
            }
            root.put("hotspots", (Object)hotspots);
        }
        root.put("errorString", (Object)error);
        if (error.length() > 0 && errorCode < 20) {
            errorCode = 20;
        }
        root.put("errorCode", (Object)errorCode);
        root.put("radius", (Object)this.radius);
        return new StreamingResolution("application/json", (Reader)new StringReader(root.toString()));
    }

    private Filter createFilter(FeatureSource fs, CoordinateReferenceSystem featureCRS) throws FactoryException, MismatchedDimensionException, TransformException {
        Point requestPoint = geometryFactory.createPoint(new Coordinate(Double.parseDouble(this.lon), Double.parseDouble(this.lat)));
        Geometry targetGeometry = LayarActionBean.transform((Geometry)requestPoint, layarCRS, featureCRS);
        String geomAttr = fs.getSchema().getGeometryDescriptor().getLocalName();
        Intersects f = ff.intersects((Expression)ff.property(geomAttr), (Expression)ff.literal((Object)targetGeometry.buffer((double)this.radius.intValue())));
        return f;
    }

    private CoordinateReferenceSystem getCRS(FeatureSource fs) {
        CoordinateReferenceSystem crs = fs.getSchema().getCoordinateReferenceSystem();
        if (crs == null) {
            log.warn((Object)("No Crs found for FeatureType: " + fs.getSchema().getName() + " make use of default crs: " + DEFAULT_CRS.toString()));
            crs = DEFAULT_CRS;
        }
        return crs;
    }

    private JSONObject createHotspot(SimpleFeature feature, LayarSource layarSource) throws JSONException, FactoryException, MismatchedDimensionException, TransformException, Exception {
        JSONObject hotspot = new JSONObject();
        hotspot.put("id", (Object)(layarSource.getFeatureType().getTypeName() + feature.getID()));
        hotspot.put("anchor", (Object)this.createAnchor(feature));
        hotspot.put("text", (Object)this.createText(feature, layarSource));
        if (layarSource.getDetails().get("imageURL") != null) {
            hotspot.put("imageURL", (Object)this.replaceValuesInString((ClobElement)layarSource.getDetails().get("imageURL"), feature));
        }
        return hotspot;
    }

    private JSONObject createAnchor(SimpleFeature f) throws FactoryException, MismatchedDimensionException, TransformException, Exception {
        if (f.getDefaultGeometry() == null) {
            throw new Exception("No geometry found for feature: " + f.getID());
        }
        JSONObject anchor = new JSONObject();
        Geometry geom = (Geometry)f.getDefaultGeometry();
        Point featurePoint = geom instanceof Point ? (Point)geom : geom.getCentroid();
        CoordinateReferenceSystem sourceCRS = f.getDefaultGeometryProperty().getDescriptor().getCoordinateReferenceSystem();
        Point latLonPoint = (Point)LayarActionBean.transform((Geometry)featurePoint, sourceCRS, layarCRS);
        JSONObject geolocation = new JSONObject();
        geolocation.put("lat", latLonPoint.getY());
        geolocation.put("lon", latLonPoint.getX());
        anchor.put("geolocation", (Object)geolocation);
        return anchor;
    }

    private JSONObject createText(SimpleFeature f, LayarSource layarSource) throws JSONException, Exception {
        JSONObject text = new JSONObject();
        Map details = layarSource.getDetails();
        if (details.get("text.title") == null) {
            throw new Exception("text.title must be configured");
        }
        text.put("title", (Object)this.replaceValuesInString((ClobElement)details.get("text.title"), f));
        if (details.get("text.description") != null) {
            text.put("description", (Object)this.replaceValuesInString((ClobElement)details.get("text.description"), f));
        }
        if (details.get("text.footnote") != null) {
            text.put("footnote", (Object)this.replaceValuesInString((ClobElement)details.get("text.footnote"), f));
        }
        return text;
    }

    private String replaceValuesInString(ClobElement clob, SimpleFeature f) throws Exception {
        return this.replaceValuesInString(clob.toString(), f);
    }

    private String replaceValuesInString(String string, SimpleFeature f) throws Exception {
        if (string == null) {
            return null;
        }
        if (!string.contains("[") && !string.contains("]")) {
            return string;
        }
        StringBuilder url = new StringBuilder(string);
        int begin = -1;
        int end = -1;
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (c == '[') {
                if (begin == -1) {
                    begin = i;
                    continue;
                }
                throw new Exception("Configuration of \"" + string + "\" not correct. ']' missing .");
            }
            if (c == ']') {
                end = i;
                if (begin != -1 && end != -1) {
                    String attribName = url.substring(begin + 1, end);
                    Object value = null;
                    value = attribName == null || attribName.length() == 0 ? "" : f.getAttribute(attribName);
                    if (value == null) {
                        value = "";
                    }
                    url.replace(begin, end + 1, value.toString().trim());
                    i = begin;
                    begin = -1;
                    end = -1;
                    continue;
                }
                throw new Exception("Configuration of \"" + string + "\" not correct. Missing '[' .");
            }
            if (i != url.length() - 1 || begin == -1) continue;
            throw new Exception("Configuration of \"" + string + "\" not correct. Missing ']' .");
        }
        return url.toString();
    }

    private static Geometry transform(Geometry sourceGeometry, CoordinateReferenceSystem fromCrs, CoordinateReferenceSystem toCrs) throws FactoryException, MismatchedDimensionException, TransformException {
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)fromCrs, (CoordinateReferenceSystem)toCrs);
        Geometry targetGeometry = JTS.transform((Geometry)sourceGeometry, (MathTransform)transform);
        return targetGeometry;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getLon() {
        return this.lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public String getLat() {
        return this.lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Integer getRadius() {
        return this.radius;
    }

    public void setRadius(Integer radius) {
        this.radius = radius;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public Integer getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Integer accuracy) {
        this.accuracy = accuracy;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    static {
        ff = CommonFactoryFinder.getFilterFactory2();
        try {
            layarCRS = CRS.decode((String)"EPSG:4326");
            DEFAULT_CRS = CRS.decode((String)"EPSG:28992");
        }
        catch (Exception e) {
            log.error((Object)"Error while getting CRS.", (Throwable)e);
        }
    }
}

