/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.userlayer;

import java.io.IOException;
import java.sql.Connection;
import nl.b3p.viewer.userlayer.DataBase;
import nl.b3p.viewer.userlayer.Oracle;
import nl.b3p.viewer.userlayer.PostgreSQL;
import nl.b3p.viewer.userlayer.SQLServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCDataStore;

public class DataBaseFactory {
    private static final Log LOG = LogFactory.getLog(DataBaseFactory.class);

    private DataBaseFactory() {
    }

    public static DataBase getDataBase(JDBCDataStore dataStore) {
        DataBase d = null;
        try {
            Connection c = dataStore.getConnection(Transaction.AUTO_COMMIT);
            switch (dataStore.getSQLDialect().getClass().getSimpleName()) {
                case "PostGISDialect": {
                    d = new PostgreSQL(c);
                    break;
                }
                case "OracleDialect": {
                    d = new Oracle(c);
                    break;
                }
                case "SQLServerDialect": {
                    d = new SQLServer(c);
                    break;
                }
                default: {
                    throw new IOException("Cannot connect to " + dataStore.getSQLDialect().getClass().getSimpleName());
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Openen database connectie is mislukt", (Throwable)e);
        }
        return d;
    }
}

