/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.userlayer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import nl.b3p.viewer.userlayer.DataBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostgreSQL
implements DataBase {
    private static final Log LOG = LogFactory.getLog(PostgreSQL.class);
    private static final String SELECT_SQL = " SELECT * FROM %s %s ";
    private static final String CREATE_SQL = "CREATE OR REPLACE VIEW %s AS  SELECT * FROM %s %s ";
    private static final String DROP_SQL = "DROP VIEW IF EXISTS %s";
    private static final String COMMENTS_SQL = "COMMENT ON VIEW %s IS '%s'";
    private final Connection connection;

    public PostgreSQL(Connection connection) {
        this.connection = connection;
    }

    @Override
    public String preValidateView(String tableName, String filterSQL) {
        String result = null;
        try (PreparedStatement ps = this.connection.prepareStatement(String.format(SELECT_SQL, tableName, filterSQL));){
            ps.setFetchSize(1);
            ps.setMaxRows(1);
            ps.execute();
        }
        catch (SQLException throwables) {
            LOG.error((Object)throwables.getLocalizedMessage());
            result = String.format("Validatiefout voor selectiefilter (%s)", throwables.getLocalizedMessage()).replaceAll("\n", " ");
        }
        return result;
    }

    @Override
    public boolean createView(String viewName, String tableName, String filterSQL, String comments) {
        boolean result;
        LOG.debug((Object)("try to create view " + viewName + " using table " + tableName + " and query " + filterSQL));
        try (PreparedStatement ps = this.connection.prepareStatement(String.format(CREATE_SQL, viewName, tableName, filterSQL));
             PreparedStatement psComment = this.connection.prepareStatement(String.format(COMMENTS_SQL, viewName, comments.replaceAll("'", "''")));){
            result = 0 == ps.executeUpdate();
            psComment.executeUpdate();
        }
        catch (SQLException throwables) {
            LOG.error((Object)("Probleem tijdens maken van view: " + throwables.getLocalizedMessage()));
            result = false;
        }
        return result;
    }

    @Override
    public boolean dropView(String viewName) {
        boolean result;
        LOG.debug((Object)("try to drop view " + viewName));
        try (PreparedStatement ps = this.connection.prepareStatement(String.format(DROP_SQL, viewName));){
            result = 0 == ps.executeUpdate();
        }
        catch (SQLException throwables) {
            LOG.error((Object)("Probleem tijdens droppen van view: " + throwables.getLocalizedMessage()));
            result = false;
        }
        return result;
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException throwables) {
            LOG.error((Object)("Probleem tijdens sluiten van connectie: " + throwables.getLocalizedMessage()));
        }
    }
}

