/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.FeatureTypeRelationKey;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.util.ChangeMatchCase;
import nl.b3p.viewer.util.Subselect;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;

public class FlamingoCQL {
    private static final Log LOG = LogFactory.getLog(FlamingoCQL.class);
    private static final String BEGIN_APPLAYER_PART = "APPLAYER(";
    private static final String BEGIN_RELATED_PART = "RELATED_LAYER(";
    private static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);

    public static Filter toFilter(String filter, EntityManager em) throws CQLException {
        return FlamingoCQL.toFilter(filter, em, true);
    }

    public static Filter toFilter(String filter, EntityManager em, boolean simplify) throws CQLException {
        filter = FlamingoCQL.processFilter(filter, em);
        return FlamingoCQL.getFilter(filter, em, simplify);
    }

    private static String processFilter(String filter, EntityManager em) throws CQLException {
        if (filter.contains(BEGIN_APPLAYER_PART)) {
            filter = FlamingoCQL.replaceApplayerFilter(filter, em);
        }
        return filter;
    }

    private static Filter getFilter(String filter, EntityManager em, boolean simplify) throws CQLException {
        Filter f = null;
        f = filter.contains(BEGIN_RELATED_PART) ? FlamingoCQL.replaceSubselectsFromFilter(filter, em, simplify) : ECQL.toFilter((String)filter);
        return f;
    }

    private static Filter replaceSubselectsFromFilter(String filter, EntityManager em, boolean simplify) throws CQLException {
        String remainingFilter = filter;
        Filter f = null;
        Filter current = null;
        if (FlamingoCQL.startsWithRelatedLayer(remainingFilter)) {
            int startIndex = remainingFilter.indexOf(BEGIN_RELATED_PART) + BEGIN_RELATED_PART.length();
            int endIndex = FlamingoCQL.findIndexOfClosingBracket(startIndex - 1, remainingFilter);
            String filterPart = BEGIN_RELATED_PART + remainingFilter.substring(startIndex, endIndex + 1);
            if (simplify) {
                String replaced = FlamingoCQL.replaceRelatedFilter(filterPart, em);
                current = ECQL.toFilter((String)replaced);
            } else {
                current = FlamingoCQL.createSubselect(filterPart, em);
            }
            remainingFilter = remainingFilter.substring(0, remainingFilter.indexOf(BEGIN_RELATED_PART)) + remainingFilter.substring(endIndex + 1);
        } else {
            int endAnd = Math.max(0, remainingFilter.toLowerCase().indexOf(" and "));
            int endOR = Math.max(0, remainingFilter.toLowerCase().indexOf(" or "));
            int end = Math.max(endAnd, endOR);
            String filterPart = remainingFilter.substring(0, end);
            current = ECQL.toFilter((String)filterPart);
            remainingFilter = remainingFilter.substring(end);
        }
        remainingFilter = remainingFilter.trim();
        remainingFilter = FlamingoCQL.removeUnnecessaryParens(remainingFilter);
        if (!remainingFilter.isEmpty()) {
            remainingFilter = remainingFilter.trim();
            String nextFilter = remainingFilter.substring(remainingFilter.indexOf(" "));
            f = FlamingoCQL.getBinaryLogicOperator(remainingFilter, current, FlamingoCQL.getFilter(nextFilter, em, simplify));
        } else {
            f = current;
        }
        return f;
    }

    public static String removeUnnecessaryParens(String filter) {
        String newFilter = FlamingoCQL.removeAdjoiningParens(filter);
        newFilter = FlamingoCQL.removeEnclosingParens(newFilter);
        return newFilter;
    }

    public static String removeAdjoiningParens(String filter) {
        if (filter.isEmpty()) {
            return filter;
        }
        String cur = "";
        for (int i = 0; i < filter.length(); ++i) {
            char c = filter.charAt(i);
            if (i + 1 < filter.length()) {
                char next = filter.charAt(i + 1);
                if (c == '(' && next == ')') {
                    ++i;
                    continue;
                }
                cur = cur + c;
                continue;
            }
            cur = cur + c;
        }
        if (filter.length() > cur.length() && cur.length() >= 2) {
            cur = FlamingoCQL.removeAdjoiningParens(cur);
        }
        return cur;
    }

    public static String removeEnclosingParens(String filter) {
        String cur = filter;
        while (cur.startsWith("(") && cur.endsWith(")")) {
            cur = cur.substring(1, cur.length() - 1);
        }
        return cur;
    }

    private static boolean startsWithRelatedLayer(String filter) {
        int threshold = 6;
        return filter.substring(0, BEGIN_RELATED_PART.length() + threshold).contains(BEGIN_RELATED_PART);
    }

    private static BinaryLogicOperator getBinaryLogicOperator(String filter, Filter prev, Filter current) {
        int endIndex = filter.indexOf(" ");
        String logicPart = filter.substring(0, endIndex);
        return logicPart.contains("AND") ? ff.and(prev, current) : ff.or(prev, current);
    }

    private static Subselect createSubselect(String filter, EntityManager em) throws CQLException {
        FeatureTypeRelation relation = FlamingoCQL.retrieveFeatureTypeRelation(filter, em);
        SimpleFeatureType subSft = relation.getForeignFeatureType();
        FeatureTypeRelationKey key = (FeatureTypeRelationKey)relation.getRelationKeys().get(0);
        String relatedColumn = key.getRightSide().getName();
        String mainColumn = key.getLeftSide().getName();
        String relatedTable = subSft.getTypeName();
        Filter relatedFilter = FlamingoCQL.toFilter(FlamingoCQL.retrieveRelatedFilter(filter), em, false);
        Subselect s = new Subselect(relatedFilter, relatedColumn, mainColumn, relatedTable);
        return s;
    }

    private static int findIndexOfClosingBracket(int startIndex, String filter) {
        int openBrackets = 0;
        int closingBrackets = 0;
        int endIndex = 0;
        for (int i = startIndex; i < filter.length(); ++i) {
            char c = filter.charAt(i);
            if (c == '(') {
                ++openBrackets;
            }
            if (c == ')') {
                ++closingBrackets;
            }
            if (openBrackets != closingBrackets || c == ' ') continue;
            endIndex = i;
            break;
        }
        return endIndex;
    }

    private static String retrieveRelatedFilter(String filter) {
        int endSubFilter = StringUtils.ordinalIndexOf((String)filter, (String)",", (int)2) + 1;
        int endIndex = FlamingoCQL.findIndexOfClosingBracket(endSubFilter, filter);
        if (endIndex == endSubFilter) {
            endIndex = filter.indexOf(")", endSubFilter) - 1;
        }
        String relatedFilterString = filter.substring(endSubFilter, endIndex + 1);
        return relatedFilterString;
    }

    private static FeatureTypeRelation retrieveFeatureTypeRelation(String filter, EntityManager em) throws CQLException {
        int beginPartLength = filter.indexOf(BEGIN_RELATED_PART) + BEGIN_RELATED_PART.length();
        int endMainLayer = filter.indexOf(",", beginPartLength + 1);
        int endSimpleFeatureIdSub = filter.indexOf(",", endMainLayer + 1);
        if (endMainLayer == -1 || endSimpleFeatureIdSub == -1) {
            throw new CQLException("Related layer filter incorrectly formed. Must be of form: RELATED_LAYER(<LAYERID_MAIN>, <SIMPLEFEATURETYPEID_SUB>, <FILTER>)");
        }
        String appLayerIdMain = filter.substring(beginPartLength, endMainLayer);
        String simpleFeatureIdSub = filter.substring(endMainLayer + 1, endSimpleFeatureIdSub);
        if (appLayerIdMain.isEmpty() || simpleFeatureIdSub.isEmpty()) {
            throw new CQLException("Related layer filter incorrectly formed. Must be of form: RELATED_LAYER(<LAYERID_MAIN>, <SIMPLEFEATURETYPEID_SUB>, <FILTER>)");
        }
        appLayerIdMain = appLayerIdMain.trim();
        simpleFeatureIdSub = simpleFeatureIdSub.trim();
        try {
            ApplicationLayer appLayer = (ApplicationLayer)em.find(ApplicationLayer.class, (Object)Long.parseLong(appLayerIdMain));
            SimpleFeatureType sub = (SimpleFeatureType)em.find(SimpleFeatureType.class, (Object)Long.parseLong(simpleFeatureIdSub));
            Layer main = appLayer.getService() == null ? null : appLayer.getService().getLayer(appLayer.getLayerName(), em);
            List rels = main.getFeatureType().getRelations();
            AtomicReference atomRel = new AtomicReference();
            rels.forEach(rel -> {
                if (rel.getForeignFeatureType().getId().equals(sub.getId())) {
                    atomRel.set(rel);
                }
            });
            if (atomRel.get() == null) {
                throw new CQLException("Applicationlayer does not have a relation");
            }
            return (FeatureTypeRelation)atomRel.get();
        }
        catch (NumberFormatException nfe) {
            throw new CQLException("Related layer filter incorrectly formed. Ids are not parsable to Longs. Must be of form: RELATED_LAYER(<LAYERID_MAIN>, <SIMPLEFEATURETYPEID_SUB>, <FILTER>)");
        }
    }

    private static String replaceRelatedFilter(String filter, EntityManager em) throws CQLException {
        FeatureTypeRelation relation = FlamingoCQL.retrieveFeatureTypeRelation(filter, em);
        FeatureTypeRelationKey key = (FeatureTypeRelationKey)relation.getRelationKeys().get(0);
        String relatedFilter = FlamingoCQL.retrieveRelatedFilter(filter);
        List<Object> ids = FlamingoCQL.getFIDSFromRelatedFeatures(relation.getForeignFeatureType(), relatedFilter, key.getRightSide().getName());
        if (ids.isEmpty()) {
            String cql = "1 = 0";
            return cql;
        }
        String cql = key.getLeftSide().getName();
        cql = cql + " IN (";
        String cs = ",";
        String escapChar = key.getLeftSide().getType().equals("string") ? "'" : "";
        for (Object id : ids) {
            cql = cql + escapChar + id + escapChar + ",";
        }
        cql = cql.substring(0, cql.length() - 1);
        cql = cql + ")";
        return cql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Object> getFIDSFromRelatedFeatures(SimpleFeatureType sft, String filter, String column) {
        ArrayList<Object> arrayList;
        ArrayList<Object> fids = new ArrayList<Object>();
        FeatureSource fs = sft.openGeoToolsFeatureSource();
        Query q = new Query(fs.getName().toString());
        if (filter != null && !filter.isEmpty()) {
            Filter attributeFilter = ECQL.toFilter((String)filter);
            attributeFilter = (Filter)attributeFilter.accept((FilterVisitor)new ChangeMatchCase(false), null);
            q.setFilter(attributeFilter);
        }
        q.setMaxFeatures(1000);
        FeatureIterator it = fs.getFeatures(q).features();
        try {
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                fids.add(f.getAttribute(column));
            }
            arrayList = fids;
        }
        catch (Throwable throwable) {
            try {
                it.close();
                fs.getDataStore().dispose();
                throw throwable;
            }
            catch (Exception ex) {
                LOG.error((Object)("retrieving fids for RELATED_LAYER filter in flamingoCQL failed: " + ex));
                return fids;
            }
        }
        it.close();
        fs.getDataStore().dispose();
        return arrayList;
    }

    private static String replaceApplayerFilter(String filter, EntityManager em) throws CQLException {
        int begin = filter.indexOf(BEGIN_APPLAYER_PART);
        int startIndex = begin + BEGIN_APPLAYER_PART.length();
        int closingBrackets = 0;
        int openBrackets = 1;
        int endIndex = 0;
        for (int i = startIndex; i < filter.length(); ++i) {
            char c = filter.charAt(i);
            if (c == '(') {
                ++openBrackets;
            }
            if (c == ')') {
                ++closingBrackets;
            }
            if (openBrackets != closingBrackets) continue;
            endIndex = i;
            break;
        }
        String appLayerPart = filter.substring(startIndex, endIndex);
        appLayerPart = FlamingoCQL.processFilter(appLayerPart, em);
        String geometryFilter = FlamingoCQL.rewriteAppLayerFilter(appLayerPart, em);
        String beginpart = filter.substring(0, begin);
        String endpart = filter.substring(endIndex + 1);
        String result = beginpart + geometryFilter + endpart;
        return result;
    }

    private static String rewriteAppLayerFilter(String applayerfilter, EntityManager em) throws CQLException {
        int firstIndex = applayerfilter.indexOf(", ");
        int secondIndex = applayerfilter.indexOf(",", firstIndex + 1);
        String attribute = applayerfilter.substring(0, firstIndex);
        String appLayerId = applayerfilter.substring(firstIndex + 1, secondIndex);
        String filter = applayerfilter.substring(secondIndex + 1);
        filter = filter.trim();
        appLayerId = appLayerId.trim();
        Long id = Long.parseLong(appLayerId);
        String geom = FlamingoCQL.getUnionedFeatures(filter, id, em);
        String nieuwFilter = "intersects (" + attribute + ", " + geom + ")";
        return nieuwFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUnionedFeatures(String filter, Long appLayerId, EntityManager em) throws CQLException {
        String string;
        ApplicationLayer al = (ApplicationLayer)em.find(ApplicationLayer.class, (Object)appLayerId);
        GeoService gs = al.getService();
        Layer l = gs.getLayer(al.getLayerName(), em);
        if (l.getFeatureType() == null) {
            throw new Exception("Layer has no feature type");
        }
        FeatureSource fs = l.getFeatureType().openGeoToolsFeatureSource();
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 28992);
        Query q = new Query(fs.getName().toString());
        if (filter != null && !filter.isEmpty()) {
            Filter attributeFilter = ECQL.toFilter((String)filter);
            attributeFilter = (Filter)attributeFilter.accept((FilterVisitor)new ChangeMatchCase(false), null);
            q.setFilter(attributeFilter);
        }
        q.setMaxFeatures(1000);
        FeatureIterator it = fs.getFeatures(q).features();
        try {
            GeometryCollection gc = new GeometryCollection(null, gf);
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Geometry g = (Geometry)f.getDefaultGeometry();
                if (g == null) continue;
                gc = gc.union(g);
            }
            string = gc.union().toText();
        }
        catch (Throwable throwable) {
            try {
                it.close();
                fs.getDataStore().dispose();
                throw throwable;
            }
            catch (Exception ex) {
                LOG.error((Object)("retrieving geometry for intersects filter in flamingoCQL failed: " + ex));
                return null;
            }
        }
        it.close();
        fs.getDataStore().dispose();
        return string;
    }
}

