/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.audit.AuditMessageObject;
import nl.b3p.viewer.audit.Auditable;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/feature/editbulk")
@StrictBinding
public class EditBulkFeatureActionBean
extends LocalizableApplicationActionBean
implements Auditable {
    private ActionBeanContext context;
    private static final Log log = LogFactory.getLog(EditBulkFeatureActionBean.class);
    protected SimpleFeatureStore store;
    @Validate
    private Application application;
    @Validate
    private String features;
    @Validate
    private ApplicationLayer appLayer;
    protected Layer layer;
    private JSONObject currentFeature;
    private FeatureSource featureSource;
    protected EntityManager entityManager;
    private AuditMessageObject auditMessageObject;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public String getFeatures() {
        return this.features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public SimpleFeatureStore getStore() {
        return this.store;
    }

    public JSONObject getCurrentFeature() {
        return this.currentFeature;
    }

    public void setCurrentFeature(JSONObject currentFeature) {
        this.currentFeature = currentFeature;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public AuditMessageObject getAuditMessageObject() {
        return this.auditMessageObject;
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void initAudit() {
        this.auditMessageObject = new AuditMessageObject();
    }

    @DefaultHandler
    public Resolution editbulk() throws JSONException {
        JSONObject response = this.editbulkResponse();
        return new StreamingResolution("application/json", (Reader)new StringReader(response.toString(4)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject editbulkResponse() throws JSONException {
        this.featureSource = null;
        if (this.entityManager == null) {
            this.entityManager = Stripersist.getEntityManager();
        }
        JSONObject response = new JSONObject();
        try {
            this.saveFeatures();
            response.put("success", true);
            response.put("__fid", (Object)this.getFeatureIds());
        }
        catch (Exception e) {
            String errorMessage = this.getErrorMessage(e);
            log.error((Object)"Exception editing features", (Throwable)e);
            log.error((Object)("Returned error message editing feature: " + errorMessage));
            response.put("success", false);
            response.put("error", (Object)errorMessage);
        }
        finally {
            if (this.featureSource != null) {
                this.featureSource.getDataStore().dispose();
            }
        }
        this.auditMessageObject.addMessage((Object)response);
        return response;
    }

    private JSONArray getFeatureIds() {
        JSONArray fids = new JSONArray();
        for (JSONObject feature : this.getFeaturesArray()) {
            fids.put((Object)feature.getString("__fid"));
        }
        return fids;
    }

    private String getErrorMessage(Exception e) {
        String errorMessage = e.toString();
        if (e.getCause() != null) {
            errorMessage = errorMessage + "; cause: " + e.getCause().toString();
        }
        return errorMessage;
    }

    private void saveFeatures() throws IOException, ParseException, EditBulkFeatureActionBeanException {
        this.createStore();
        try (DefaultTransaction transaction = new DefaultTransaction("edit");){
            this.store.setTransaction((Transaction)transaction);
            for (JSONObject feature : this.getFeaturesArray()) {
                this.saveFeatureToStore(feature);
            }
            transaction.commit();
        }
    }

    JSONObject[] getFeaturesArray() {
        JSONArray jsonFeatures = new JSONArray(this.features);
        JSONObject[] list = new JSONObject[jsonFeatures.length()];
        for (int i = 0; i < jsonFeatures.length(); ++i) {
            list[i] = jsonFeatures.getJSONObject(i);
        }
        return list;
    }

    private void createStore() {
        if (this.appLayer == null) {
            throw new AppLayerNotFoundException();
        }
        if (!Authorizations.isAppLayerWriteAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)this.entityManager)) {
            throw new AppLayerWriteNotAuthorizedException();
        }
        this.layer = this.appLayer.getService().getLayer(this.appLayer.getLayerName(), this.entityManager);
        if (this.layer == null) {
            throw new LayerNotFoundException();
        }
        if (this.layer.getFeatureType() == null) {
            throw new NoFunctionTypeException();
        }
        try {
            this.featureSource = this.layer.getFeatureType().openGeoToolsFeatureSource();
        }
        catch (Exception e) {
            throw new CannotGetFeatureSourceException(e);
        }
        if (!(this.featureSource instanceof SimpleFeatureStore)) {
            throw new FeatureSourceDoesNotSupportEditingException();
        }
        this.store = (SimpleFeatureStore)this.featureSource;
    }

    private void saveFeatureToStore(JSONObject feature) throws IOException, ParseException, EditBulkFeatureActionBeanException {
        if (!this.isFeatureWriteAuthorized(this.appLayer, feature, this.context.getRequest())) {
            throw new FeatureWriteNotAuthorizedException();
        }
        String fid = feature.optString("__fid", null);
        if (fid == null) {
            throw new MissingFeatureIdException();
        }
        Pair<String[], Object[]> attributesAndValues = this.buildAttributesAndValues(feature);
        Object[] attributes = (String[])attributesAndValues.getKey();
        Object[] values = (Object[])attributesAndValues.getValue();
        log.debug((Object)String.format("Modifying features source #%d fid=%s, attributes=%s, values=%s", this.layer.getFeatureType().getId(), fid, Arrays.toString(attributes), Arrays.toString(values)));
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Id filter = ff.id(new FeatureId[]{new FeatureIdImpl(fid)});
        this.store.modifyFeatures((String[])attributes, values, (Filter)filter);
    }

    private Pair<String[], Object[]> buildAttributesAndValues(JSONObject feature) throws ParseException {
        ArrayList<String> attributes = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator it = feature.keys();
        while (it.hasNext()) {
            String attribute = (String)it.next();
            if ("__fid".equals(attribute)) continue;
            SimpleFeatureType schema = (SimpleFeatureType)this.store.getSchema();
            AttributeDescriptor ad = schema.getDescriptor(attribute);
            if (ad != null) {
                if (!this.isAttributeUserEditingDisabled(attribute)) {
                    attributes.add(attribute);
                    if (ad.getType() instanceof GeometryType) {
                        String wkt = feature.getString(ad.getLocalName());
                        Geometry g = null;
                        if (wkt != null) {
                            g = new WKTReader().read(wkt);
                        }
                        values.add(g);
                        continue;
                    }
                    if (ad.getType().getBinding().getCanonicalName().equals("byte[]")) {
                        Object ba = feature.get(attribute);
                        values.add(ba);
                        continue;
                    }
                    String v = feature.optString(attribute);
                    values.add(StringUtils.defaultIfBlank((CharSequence)v, null));
                    continue;
                }
                log.info((Object)String.format("Attribute \"%s\" not user editable; ignoring", attribute));
                continue;
            }
            log.warn((Object)String.format("Attribute \"%s\" not in features type; ignoring", attribute));
        }
        String[] arrAttributes = attributes.toArray(new String[0]);
        Object[] arrValues = values.toArray(new Object[0]);
        return new ImmutablePair((Object)arrAttributes, (Object)arrValues);
    }

    private boolean isAttributeUserEditingDisabled(String attrName) {
        ConfiguredAttribute attribute = this.getAppLayer().getAttribute(this.getLayer().getFeatureType(), attrName);
        return attribute != null && attribute.isDisableUserEdit();
    }

    private boolean isFeatureWriteAuthorized(ApplicationLayer appLayer, JSONObject jsonFeature, HttpServletRequest request) {
        if (appLayer.getDetails() != null && appLayer.getDetails().containsKey("editfeature.usernameAttribute")) {
            String attr = ((ClobElement)appLayer.getDetails().get("editfeature.usernameAttribute")).getValue();
            String featureUsername = jsonFeature.optString(attr);
            return featureUsername != null && featureUsername.equals(request.getRemoteUser());
        }
        return true;
    }

    private class CannotGetFeatureSourceException
    extends RuntimeException {
        public CannotGetFeatureSourceException(Exception e) {
            super(e);
        }
    }

    private class MissingFeatureIdException
    extends EditBulkFeatureActionBeanException {
        public MissingFeatureIdException() {
            super(EditBulkFeatureActionBean.this.getBundle().getString("viewer.editbulkfeatureactionbean.1"));
        }
    }

    private class FeatureWriteNotAuthorizedException
    extends EditBulkFeatureActionBeanException {
        public FeatureWriteNotAuthorizedException() {
            super(EditBulkFeatureActionBean.this.getBundle().getString("viewer.editfeatureactionbean.6"));
        }
    }

    private class FeatureSourceDoesNotSupportEditingException
    extends EditBulkFeatureActionBeanException {
        public FeatureSourceDoesNotSupportEditingException() {
            super(EditBulkFeatureActionBean.this.getBundle().getString("viewer.editfeatureactionbean.5"));
        }
    }

    private class NoFunctionTypeException
    extends EditBulkFeatureActionBeanException {
        public NoFunctionTypeException() {
            super(EditBulkFeatureActionBean.this.getBundle().getString("viewer.editfeatureactionbean.4"));
        }
    }

    private class LayerNotFoundException
    extends EditBulkFeatureActionBeanException {
        public LayerNotFoundException() {
            super(EditBulkFeatureActionBean.this.getBundle().getString("viewer.editfeatureactionbean.3"));
        }
    }

    private class AppLayerWriteNotAuthorizedException
    extends EditBulkFeatureActionBeanException {
        public AppLayerWriteNotAuthorizedException() {
            super(EditBulkFeatureActionBean.this.getBundle().getString("viewer.editfeatureactionbean.2"));
        }
    }

    private class AppLayerNotFoundException
    extends EditBulkFeatureActionBeanException {
        public AppLayerNotFoundException() {
            super(EditBulkFeatureActionBean.this.getBundle().getString("viewer.editfeatureactionbean.1"));
        }
    }

    private class EditBulkFeatureActionBeanException
    extends RuntimeException {
        public EditBulkFeatureActionBeanException(String s) {
            super(s);
        }
    }
}

