/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.StyleLibrary;
import nl.b3p.viewer.util.ChangeMatchCase;
import nl.b3p.viewer.util.FeatureToJson;
import nl.b3p.viewer.util.FlamingoCQL;
import nl.b3p.web.SharedSessionData;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.URI;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.styling.Extent;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.xml.styling.SLDTransformer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.stripesstuff.stripersist.Stripersist;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@UrlBinding(value="/action/sld")
@StrictBinding
public class SldActionBean
extends LocalizableActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(SldActionBean.class);
    private ActionBeanContext context;
    public static final String FORMAT_JSON = "json";
    public static final String FORMAT_XML = "xml";
    @Validate
    private Long id;
    @Validate
    private String layer;
    @Validate
    private String style;
    @Validate
    private String filter;
    @Validate
    private String color;
    @Validate
    private String commonAndFilter;
    @Validate
    private String commonOrFilter;
    @Validate
    private Boolean useRuleFilter = false;
    @Validate
    private String featureTypeName;
    @Validate
    private String format;
    @Validate
    private String sldId;
    @Validate
    private String sessId;
    @Validate
    private ApplicationLayer applicationLayer;
    private byte[] sldXml;
    private StyledLayerDescriptor newSld;
    private StyleFactory sldFactory;
    private static final String NS_SLD = "http://www.opengis.net/sld";
    private static final String NS_SE = "http://www.opengis.net/se";

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFeatureTypeName() {
        return this.featureTypeName;
    }

    public void setFeatureTypeName(String featureTypeName) {
        this.featureTypeName = featureTypeName;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public ApplicationLayer getApplicationLayer() {
        return this.applicationLayer;
    }

    public void setApplicationLayer(ApplicationLayer appLayer) {
        this.applicationLayer = appLayer;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getCommonAndFilter() {
        return this.commonAndFilter;
    }

    public void setCommonAndFilter(String commonAndFilter) {
        this.commonAndFilter = commonAndFilter;
    }

    public String getCommonOrFilter() {
        return this.commonOrFilter;
    }

    public void setCommonOrFilter(String commonOrFilter) {
        this.commonOrFilter = commonOrFilter;
    }

    public String getSldId() {
        return this.sldId;
    }

    public void setSldId(String sldId) {
        this.sldId = sldId;
    }

    public String getSessId() {
        return this.sessId;
    }

    public void setSessId(String sessId) {
        this.sessId = sessId;
    }

    private void getSldXmlOrCreateNewSld() throws Exception {
        EntityManager em = Stripersist.getEntityManager();
        if (this.id != null) {
            StyleLibrary sld = (StyleLibrary)em.find(StyleLibrary.class, (Object)this.id);
            if (sld == null) {
                throw new IllegalArgumentException(MessageFormat.format(this.getBundle().getString("viewer.sldactionbean.1"), this.id));
            }
            if (sld.getExternalUrl() == null) {
                this.sldXml = sld.getSldBody().getBytes("UTF8");
            } else {
                try {
                    InputStream externalSld = new URL(sld.getExternalUrl()).openStream();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)externalSld, (OutputStream)bos);
                    externalSld.close();
                    bos.flush();
                    bos.close();
                    this.sldXml = bos.toByteArray();
                }
                catch (IOException e) {
                    throw new IOException(MessageFormat.format(this.getBundle().getString("viewer.sldactionbean.2"), sld.getExternalUrl(), e));
                }
            }
        } else {
            this.newSld = this.sldFactory.createStyledLayerDescriptor();
            FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();
            String[] layers = null;
            String[] filters = null;
            String[] styles = null;
            String[] colors = null;
            if (this.layer != null) {
                layers = this.layer.split(",");
            }
            if (this.filter != null) {
                try {
                    JSONArray jsonFilters = new JSONArray(this.filter);
                    filters = new String[jsonFilters.length()];
                    for (int i = 0; i < jsonFilters.length(); ++i) {
                        filters[i] = jsonFilters.getString(i);
                    }
                }
                catch (JSONException je) {
                    log.warn((Object)"error while parsing filters to JSON", (Throwable)je);
                    filters = this.filter.split(",");
                }
            }
            if (this.color != null) {
                colors = this.color.split(",");
            }
            if (this.style != null) {
                styles = this.style.split(",");
            }
            Filter andFilter = null;
            Filter orFilter = null;
            if (this.commonAndFilter != null) {
                if (this.commonAndFilter.indexOf("%") > 0) {
                    this.commonAndFilter = URI.decode((String)this.commonAndFilter);
                }
                andFilter = FlamingoCQL.toFilter(this.commonAndFilter, em);
            }
            if (this.commonOrFilter != null) {
                if (this.commonOrFilter.indexOf("%") > 0) {
                    this.commonOrFilter = URI.decode((String)this.commonOrFilter);
                }
                orFilter = FlamingoCQL.toFilter(this.commonOrFilter, em);
            }
            if (layers != null) {
                for (int i = 0; i < layers.length; ++i) {
                    NamedStyle ns;
                    Object filter = null;
                    if (filters != null && i < filters.length && !"none".equals(filters[i]) && filters[i].length() > 0) {
                        filter = FlamingoCQL.toFilter(filters[i], em);
                    }
                    NamedLayer nl = this.sldFactory.createNamedLayer();
                    nl.setName(layers[i]);
                    this.newSld.addStyledLayer((StyledLayer)nl);
                    if (andFilter != null) {
                        filter = filter == null ? andFilter : filterFactory.and(filter, andFilter);
                    }
                    if (orFilter != null) {
                        filter = filter == null ? orFilter : filterFactory.or(filter, orFilter);
                    }
                    if (styles != null && i < styles.length && !"none".equals(styles[i])) {
                        ns = this.sldFactory.createNamedStyle();
                        ns.setName(styles[i]);
                        nl.addStyle((Style)ns);
                    } else if (colors != null && i < colors.length) {
                        FeatureTypeStyle fts = this.sldFactory.createFeatureTypeStyle();
                        Rule r = this.sldFactory.createRule();
                        if (this.useRuleFilter.booleanValue() && filter != null) {
                            r.setFilter(filter);
                        }
                        PolygonSymbolizer ps = this.createPolygonSymbolizer(this.sldFactory, colors[i]);
                        r.symbolizers().add(ps);
                        fts.rules().add(r);
                        Style style = this.sldFactory.createStyle();
                        style.setDefault(true);
                        style.setName("default");
                        style.featureTypeStyles().add(fts);
                        nl.addStyle(style);
                    } else {
                        ns = this.sldFactory.createNamedStyle();
                        ns.setName("default");
                        nl.addStyle((Style)ns);
                    }
                    if (this.useRuleFilter.booleanValue() || filter == null) continue;
                    FeatureTypeConstraint ftc = this.sldFactory.createFeatureTypeConstraint(layers[i], filter, new Extent[0]);
                    nl.setLayerFeatureConstraints(new FeatureTypeConstraint[]{ftc});
                }
            }
        }
    }

    private void addFilterToExistingSld() throws Exception {
        EntityManager em = Stripersist.getEntityManager();
        Filter f = FlamingoCQL.toFilter(this.filter, em);
        f = (Filter)f.accept((FilterVisitor)new ChangeMatchCase(false), null);
        if (this.featureTypeName == null) {
            this.featureTypeName = this.layer;
        }
        FeatureTypeConstraint ftc = this.sldFactory.createFeatureTypeConstraint(this.featureTypeName, f, new Extent[0]);
        if (this.newSld == null) {
            NodeList sldFTNs;
            SLDTransformer sldTransformer = new SLDTransformer();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            sldTransformer.transform((Object)ftc, (OutputStream)bos);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document sldXmlDoc = db.parse(new ByteArrayInputStream(this.sldXml));
            Document ftcDoc = db.parse(new ByteArrayInputStream(bos.toByteArray()));
            String sldVersion = sldXmlDoc.getDocumentElement().getAttribute("version");
            if ("1.1.0".equals(sldVersion) && (sldFTNs = ftcDoc.getElementsByTagNameNS(NS_SLD, "FeatureTypeName")).getLength() == 1) {
                Node sldFTN = sldFTNs.item(0);
                Element seFTN = ftcDoc.createElementNS(NS_SE, "FeatureTypeName");
                seFTN.setTextContent(sldFTN.getTextContent());
                sldFTN.getParentNode().replaceChild(seFTN, sldFTN);
            }
            NodeList namedLayers = sldXmlDoc.getElementsByTagNameNS(NS_SLD, "NamedLayer");
            for (int i = 0; i < namedLayers.getLength(); ++i) {
                Node namedLayer = namedLayers.item(i);
                NodeList childs = namedLayer.getChildNodes();
                Node insertBefore = null;
                Node layerFeatureConstraints = null;
                int j = childs.getLength() - 1;
                do {
                    Node child;
                    if ("LayerFeatureConstraints".equals((child = childs.item(j)).getLocalName())) {
                        layerFeatureConstraints = child;
                        break;
                    }
                    if ("Description".equals(child.getLocalName()) || "Name".equals(child.getLocalName())) break;
                    insertBefore = child;
                } while (--j >= 0);
                Node featureTypeConstraint = sldXmlDoc.adoptNode(ftcDoc.getDocumentElement().cloneNode(true));
                if (layerFeatureConstraints == null) {
                    layerFeatureConstraints = sldXmlDoc.createElementNS(NS_SLD, "LayerFeatureConstraints");
                    layerFeatureConstraints.appendChild(featureTypeConstraint);
                    namedLayer.insertBefore(layerFeatureConstraints, insertBefore);
                    continue;
                }
                layerFeatureConstraints.appendChild(featureTypeConstraint);
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            DOMSource source = new DOMSource(sldXmlDoc);
            bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            t.transform(source, result);
            this.sldXml = bos.toByteArray();
        }
    }

    private PolygonSymbolizer createPolygonSymbolizer(StyleFactory styleFactory, String color) {
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();
        Color col = Color.GRAY;
        if (color.startsWith("#")) {
            col = new Color(Integer.parseInt(color.substring(1), 16));
        }
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)col), (Expression)filterFactory.literal(1), (Expression)filterFactory.literal(0.9));
        Fill fill = styleFactory.createFill((Expression)filterFactory.literal((Object)col), (Expression)filterFactory.literal(0.9));
        PolygonSymbolizer sym = styleFactory.createPolygonSymbolizer(stroke, fill, null);
        return sym;
    }

    @DefaultHandler
    public Resolution create() throws JSONException, UnsupportedEncodingException {
        String error;
        JSONObject json;
        block7: {
            json = new JSONObject();
            json.put("success", (Object)Boolean.FALSE);
            error = null;
            try {
                this.sldFactory = CommonFactoryFinder.getStyleFactory();
                this.getSldXmlOrCreateNewSld();
                if (this.newSld == null && this.filter != null) {
                    this.addFilterToExistingSld();
                }
                if (this.newSld != null) {
                    SLDTransformer sldTransformer = new SLDTransformer();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    sldTransformer.transform((Object)this.newSld, (OutputStream)bos);
                    this.sldXml = bos.toByteArray();
                }
            }
            catch (Exception e) {
                log.error((Object)String.format("Error creating sld for layer=%s, style=%s, filter=%s, id=%d", this.layer, this.style, this.filter, this.id), (Throwable)e);
                error = e.toString();
                if (e.getCause() == null) break block7;
                error = error + "; cause: " + e.getCause().toString();
            }
        }
        if (error != null) {
            if (FORMAT_JSON.equals(this.format)) {
                json.put("error", error);
                return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
            }
            return new ErrorResolution(500, error);
        }
        if (FORMAT_JSON.equals(this.format)) {
            json.put("sld", (Object)new String(this.sldXml, "UTF8"));
            json.put("success", (Object)Boolean.TRUE);
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
        }
        return new StreamingResolution("text/xml", (InputStream)new ByteArrayInputStream(this.sldXml));
    }

    public Resolution transformFilter() throws JSONException {
        JSONObject json = new JSONObject();
        String error = null;
        EntityManager em = Stripersist.getEntityManager();
        try {
            json.put("success", (Object)Boolean.FALSE);
            if (this.filter != null && this.applicationLayer != null) {
                Layer layer = this.applicationLayer.getService().getLayer(this.applicationLayer.getLayerName(), em);
                if (layer == null) {
                    error = this.getBundle().getString("viewer.sldactionbean.3");
                } else {
                    SimpleFeatureType sft = layer.getFeatureType();
                    Filter f = FlamingoCQL.toFilter(this.filter, em);
                    f = (Filter)f.accept((FilterVisitor)new ChangeMatchCase(false), null);
                    f = FeatureToJson.reformatFilter(f, sft);
                    String cqlFilter = ECQL.toCQL((Filter)f);
                    if (f == Filter.EXCLUDE) {
                        String attributeName = ((AttributeDescriptor)sft.getAttributes().get(0)).getName();
                        cqlFilter = attributeName + " = 1 and " + attributeName + " <> 1";
                    }
                    String sId = this.context.getRequest().getSession().getId();
                    Map sharedData = SharedSessionData.find((String)sId);
                    log.debug((Object)MessageFormat.format(this.getBundle().getString("viewer.sldactionbean.4"), cqlFilter, this.applicationLayer.getId().toString(), sId));
                    sharedData.put(this.applicationLayer.getId().toString(), cqlFilter);
                    json.put("sessId", (Object)sId);
                    json.put("sldId", (Object)this.applicationLayer.getId().toString());
                    json.put("success", (Object)Boolean.TRUE);
                }
            } else {
                log.debug((Object)"No filter to transform or no applicationlayer, removing existing filter.");
                String sId = this.context.getRequest().getSession().getId();
                Map sharedData = SharedSessionData.find((String)sId);
                sharedData.remove(this.applicationLayer.getId().toString());
                json.put("success", (Object)Boolean.TRUE);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while reformating filter", (Throwable)e);
            error = e.toString();
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public Resolution findSLD() throws CQLException, JSONException, UnsupportedEncodingException {
        Map sharedData = SharedSessionData.find((String)this.sessId);
        String cqlFilter = (String)sharedData.get(this.sldId);
        JSONArray filterArray = new JSONArray();
        filterArray.put((Object)cqlFilter);
        this.filter = filterArray.toString();
        log.debug((Object)String.format("Filter (id: %s) retrieved for shared session data (%s): %s", this.sessId, this.sldId, this.filter));
        return this.create();
    }
}

