/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.features;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.features.FeatureDownloader;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.simple.SimpleFeature;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExcelDownloader
extends FeatureDownloader {
    private Workbook wb;
    private Sheet sheet;
    private int currentRow = -1;
    private Map<String, CellStyle> styles;

    public ExcelDownloader(List<ConfiguredAttribute> attributes, SimpleFeatureSource fs, Map<String, AttributeDescriptor> featureTypeAttributes, Map<String, String> attributeAliases, String params) {
        super(attributes, fs, featureTypeAttributes, attributeAliases, params);
    }

    public void init() throws IOException {
        this.wb = new XSSFWorkbook();
        this.styles = ExcelDownloader.createStyles((Workbook)this.wb);
        this.sheet = this.wb.createSheet(WorkbookUtil.createSafeSheetName((String)this.fs.getName().toString()));
        this.sheet.setDisplayGridlines(false);
        this.sheet.setPrintGridlines(false);
        this.sheet.setFitToPage(true);
        this.sheet.setHorizontallyCenter(true);
        PrintSetup printSetup = this.sheet.getPrintSetup();
        printSetup.setLandscape(true);
        this.sheet.setAutobreaks(true);
        printSetup.setFitHeight((short)1);
        printSetup.setFitWidth((short)1);
        Row headerRow = this.sheet.createRow(0);
        headerRow.setHeightInPoints(15.0f);
        int colNum = 0;
        Drawing drawing = this.sheet.createDrawingPatriarch();
        CreationHelper factory = this.wb.getCreationHelper();
        for (ConfiguredAttribute configuredAttribute : this.attributes) {
            String alias;
            if (!configuredAttribute.isVisible() || (alias = (String)this.attributeAliases.get(configuredAttribute.getAttributeName())) == null) continue;
            Cell cell = headerRow.createCell(colNum);
            cell.setCellValue(alias);
            if (!alias.equals(configuredAttribute.getAttributeName())) {
                ClientAnchor anchor = factory.createClientAnchor();
                anchor.setCol1(cell.getColumnIndex());
                anchor.setCol2(cell.getColumnIndex() + 1);
                anchor.setRow1(headerRow.getRowNum());
                anchor.setRow2(headerRow.getRowNum() + 3);
                Comment comment = drawing.createCellComment(anchor);
                RichTextString str = factory.createRichTextString(configuredAttribute.getAttributeName());
                comment.setString(str);
                cell.setCellComment(comment);
            }
            cell.setCellStyle((CellStyle)this.styles.get("header"));
            this.sheet.autoSizeColumn(colNum);
            ++colNum;
        }
        this.sheet.createFreezePane(0, 1);
        this.currentRow = 1;
    }

    public void processFeature(SimpleFeature oldFeature) {
        Row row = this.sheet.createRow(this.currentRow);
        String rowHeight = (String)this.parameterMap.get("rowHeight");
        if (rowHeight != null) {
            try {
                row.setHeight(Short.parseShort(rowHeight));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int colNum = 0;
        for (ConfiguredAttribute configuredAttribute : this.attributes) {
            if (!configuredAttribute.isVisible() || this.attributeAliases.get(configuredAttribute.getAttributeName()) == null) continue;
            Object attribute = oldFeature.getAttribute(configuredAttribute.getAttributeName());
            Cell cell = row.createCell(colNum);
            cell.setCellStyle((CellStyle)this.styles.get("cell_normal"));
            if (attribute == null) {
                cell.setBlank();
            } else if (attribute instanceof Boolean) {
                cell.setCellValue(((Boolean)attribute).booleanValue());
            } else if (attribute instanceof Number) {
                cell.setCellValue(((Number)attribute).doubleValue());
            } else if (attribute instanceof Date) {
                cell.setCellValue((Date)attribute);
                cell.setCellStyle((CellStyle)this.styles.get("cell_normal_date"));
            } else if (attribute instanceof Calendar) {
                cell.setCellValue((Calendar)attribute);
                cell.setCellStyle((CellStyle)this.styles.get("cell_normal_date"));
            } else {
                cell.setCellValue(attribute.toString());
            }
            ++colNum;
        }
        ++this.currentRow;
    }

    public File write() throws IOException {
        int i = 0;
        String autoSize = (String)this.parameterMap.get("autoSize");
        String rowWidths = (String)this.parameterMap.get("rowWidths");
        if (autoSize != null || rowWidths != null) {
            HashSet<String> autoSizeAttributes = autoSize == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(autoSize.split("\\|")));
            HashMap<String, Integer> attributeWidths = new HashMap<String, Integer>();
            if (rowWidths != null) {
                for (String w : rowWidths.split("\\|")) {
                    String[] p = w.split("@", 2);
                    if (p.length != 2) continue;
                    try {
                        attributeWidths.put(p[0], Integer.parseInt(p[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            for (ConfiguredAttribute configuredAttribute : this.attributes) {
                if (!configuredAttribute.isVisible()) continue;
                if (autoSizeAttributes.contains(configuredAttribute.getAttributeName())) {
                    this.sheet.autoSizeColumn(i);
                }
                if (attributeWidths.containsKey(configuredAttribute.getAttributeName())) {
                    this.sheet.setColumnWidth(i, ((Integer)attributeWidths.get(configuredAttribute.getAttributeName())).intValue());
                }
                ++i;
            }
        }
        File file = File.createTempFile("downloadExcel", ".xlsx");
        FileOutputStream out = new FileOutputStream(file);
        this.wb.write((OutputStream)out);
        out.close();
        return file;
    }

    private static Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        DataFormat df = wb.createDataFormat();
        Font headerFont = wb.createFont();
        headerFont.setBold(true);
        CellStyle style = ExcelDownloader.createBorderedStyle((Workbook)wb);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFont(headerFont);
        styles.put("header", style);
        style = ExcelDownloader.createBorderedStyle((Workbook)wb);
        style.setWrapText(true);
        styles.put("cell_normal", style);
        style = ExcelDownloader.createBorderedStyle((Workbook)wb);
        style.setWrapText(true);
        style.setDataFormat(df.getFormat("d-mmm-yyyy"));
        styles.put("cell_normal_date", style);
        return styles;
    }

    private static CellStyle createBorderedStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        return style;
    }
}

