/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.StartLayer;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/spinupdatastores")
@StrictBinding
public class DataStoreSpinupActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(DataStoreSpinupActionBean.class);
    public static final int MINIMUM_SPINUP_INTERVAL = 1800000;
    private ActionBeanContext context;
    @Validate
    private Application application;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Date lastSpinupTime;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    private boolean isAlreadySpunup(Map<String, ClobElement> details) {
        this.lastSpinupTime = null;
        try {
            String lastSpinupTimeString = ClobElement.nullSafeGet((ClobElement)details.get("lastSpinupTime"));
            if (lastSpinupTimeString != null) {
                this.lastSpinupTime = this.sdf.parse(lastSpinupTimeString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastSpinupTime != null && this.lastSpinupTime.getTime() > new Date().getTime() - 1800000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution spinup() throws JSONException {
        JSONObject j = new JSONObject();
        j.put("success", (Object)Boolean.FALSE);
        if (this.application != null) {
            if (this.isAlreadySpunup(this.application.getDetails())) {
                j.put("error", (Object)("Already spun up recently, at " + this.sdf.format(this.lastSpinupTime)));
                return new StreamingResolution("application/json", (Reader)new StringReader(j.toString()));
            }
            log.debug((Object)("Spinning up data stores for application " + this.application.getNameWithVersion()));
            EntityManager em = Stripersist.getEntityManager();
            this.application.getDetails().put("lastSpinupTime", new ClobElement(this.sdf.format(new Date())));
            em.getTransaction().commit();
            this.application = (Application)em.find(Application.class, (Object)this.application.getId());
            Application.TreeCache tc = this.application.loadTreeCache(em);
            HashMap<FeatureSource, CallSite> spunUpFeatureSources = new HashMap<FeatureSource, CallSite>();
            int errorCount = 0;
            int skipCount = 0;
            int successCount = 0;
            for (ApplicationLayer al : tc.getApplicationLayers()) {
                StartLayer startLayer = (StartLayer)al.getStartLayers().get(this.application);
                if (startLayer == null || !startLayer.isChecked() || !ClobElement.isNotBlank((ClobElement)((ClobElement)al.getDetails().get("summary.title")))) continue;
                try {
                    GeoService gs = al.getService();
                    Layer l = gs.getSingleLayer(al.getLayerName(), em);
                    if (this.isAlreadySpunup(l.getDetails())) {
                        log.debug((Object)String.format("Already spun up layer \"%s\" of %s geo service #%d \"%s\" at %s, skipping", l.getName(), gs.getProtocol(), gs.getId(), gs.getName(), ((ClobElement)l.getDetails().get("lastSpinupTime")).getValue()));
                        ++skipCount;
                        continue;
                    }
                    l.getDetails().put("lastSpinupTime", new ClobElement(this.sdf.format(new Date())));
                    SimpleFeatureType sft = l.getFeatureType();
                    if (sft == null) continue;
                    FeatureSource fs = sft.getFeatureSource();
                    if (spunUpFeatureSources.containsKey(fs)) {
                        log.debug((Object)String.format("Not opening data store for second feature type (name \"%s\") of %s feature source #%d \"%s\" because other type was already done: %s", sft.getTypeName(), fs.getProtocol(), fs.getId(), fs.getName(), spunUpFeatureSources.get(fs)));
                        continue;
                    }
                    long startTime = System.currentTimeMillis();
                    log.debug((Object)String.format("Requesting single feature for feature type name \"%s\" from %s feature source #%d \"%s\" to spin it up for future requests...", sft.getTypeName(), fs.getProtocol(), fs.getId(), fs.getName()));
                    Query q = new Query(sft.getTypeName());
                    q.setMaxFeatures(1);
                    org.geotools.data.FeatureSource gtfs = null;
                    try {
                        gtfs = sft.openGeoToolsFeatureSource();
                        FeatureCollection fc = gtfs.getFeatures(q);
                        long time = System.currentTimeMillis() - startTime;
                        log.debug((Object)String.format("Type name \"%s\": request took %dms (feature count: %d)", sft.getTypeName(), time, fc.size()));
                        spunUpFeatureSources.put(sft.getFeatureSource(), (CallSite)((Object)("type name " + sft.getTypeName() + " took " + time + "ms")));
                        ++successCount;
                    }
                    catch (Exception e) {
                        log.error((Object)"Error requesting feature", (Throwable)e);
                        spunUpFeatureSources.put(sft.getFeatureSource(), (CallSite)((Object)("(error requesting feature for type " + sft.getTypeName() + ")")));
                        ++errorCount;
                    }
                    finally {
                        if (gtfs == null) continue;
                        gtfs.getDataStore().dispose();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error", (Throwable)e);
                }
            }
            if (em.getTransaction().isActive()) {
                em.getTransaction().commit();
            }
            j.put("success", (Object)Boolean.TRUE);
            String summary = String.format("Succesfully spun up %d feature sources, already spun up: %d, errors: %d", successCount, skipCount, errorCount);
            log.debug((Object)("Spinup summary for app " + this.application.getNameWithVersion() + ": " + summary));
            j.put("message", (Object)summary);
        } else {
            j.put("error", (Object)"Application not found");
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(j.toString()));
    }
}

