/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.geotools.filter.visitor.RemoveDistanceUnit;
import nl.b3p.viewer.audit.AuditMessageObject;
import nl.b3p.viewer.audit.Auditable;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.FeatureTypeRelationKey;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import nl.b3p.viewer.util.ChangeMatchCase;
import nl.b3p.viewer.util.FeatureToJson;
import nl.b3p.viewer.util.FlamingoCQL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.GeometricShapeFactory;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Intersects;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/featureinfo")
@StrictBinding
public class FeatureInfoActionBean
extends LocalizableApplicationActionBean
implements Auditable {
    private static final Log log = LogFactory.getLog(FeatureInfoActionBean.class);
    public static final String FID = "__fid";
    private ActionBeanContext context;
    private static final int TIMEOUT = 5000;
    @Validate
    private Application application;
    @Validate
    private int limit = 10;
    @Validate
    private String x;
    @Validate
    private String y;
    @Validate
    private String requestId;
    @Validate
    private String distance;
    @Validate
    private String queryJSON;
    @Validate
    private boolean edit = false;
    @Validate
    private boolean arrays = false;
    @Validate
    private List<Long> attributesToInclude = new ArrayList<Long>();
    @Validate
    private boolean graph = false;
    @Validate
    private boolean ordered = false;
    private Layer layer;
    private AuditMessageObject auditMessageObject;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getDistance() {
        return this.distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }

    public String getQueryJSON() {
        return this.queryJSON;
    }

    public void setQueryJSON(String queryJSON) {
        this.queryJSON = queryJSON;
    }

    public String getX() {
        return this.x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public String getY() {
        return this.y;
    }

    public void setY(String y) {
        this.y = y;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public boolean isArrays() {
        return this.arrays;
    }

    public void setArrays(boolean arrays) {
        this.arrays = arrays;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public List<Long> getAttributesToInclude() {
        return this.attributesToInclude;
    }

    public void setAttributesToInclude(List<Long> attributesToInclude) {
        this.attributesToInclude = attributesToInclude;
    }

    public boolean isGraph() {
        return this.graph;
    }

    public void setGraph(boolean graph) {
        this.graph = graph;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public AuditMessageObject getAuditMessageObject() {
        return this.auditMessageObject;
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void initAudit() {
        this.auditMessageObject = new AuditMessageObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultHandler
    public Resolution info() throws JSONException {
        JSONArray queries = new JSONArray(this.queryJSON);
        JSONArray responses = new JSONArray();
        FeatureSource fs = null;
        EntityManager em = Stripersist.getEntityManager();
        for (int i = 0; i < queries.length(); ++i) {
            block23: {
                JSONObject query = queries.getJSONObject(i);
                JSONObject response = new JSONObject();
                responses.put((Object)response);
                response.put("request", (Object)query);
                if (this.requestId != null) {
                    response.put("requestId", (Object)this.requestId);
                }
                Object error = null;
                String exceptionMsg = query.toString();
                try {
                    ApplicationLayer al = null;
                    GeoService gs = null;
                    if (query.has("appLayer")) {
                        al = (ApplicationLayer)em.find(ApplicationLayer.class, (Object)query.getLong("appLayer"));
                    } else {
                        gs = (GeoService)em.find(GeoService.class, (Object)query.getLong("service"));
                    }
                    if (al == null && gs == null) {
                        error = this.getBundle().getString("viewer.featureinfoactionbean.1");
                    } else if (!Authorizations.isAppLayerReadAuthorized((Application)this.application, (ApplicationLayer)al, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
                        error = this.getBundle().getString("viewer.featureinfoactionbean.2");
                    } else {
                        this.layer = al != null ? al.getService().getLayer(al.getLayerName(), em) : gs.getLayer(query.getString("layer"), em);
                        if (this.layer == null) {
                            error = this.getBundle().getString("viewer.featureinfoactionbean.3");
                        } else if (this.layer.getFeatureType() == null) {
                            response.put("noFeatureType", true);
                        } else {
                            Intersects f;
                            Filter currentFilter;
                            response.put("featureType", (Object)this.layer.getFeatureType().getId());
                            String filter = query.optString("filter", null);
                            fs = this.layer.getFeatureType().openGeoToolsFeatureSource(5000);
                            Query q = new Query(fs.getName().toString());
                            String geomAttribute = fs.getSchema().getGeometryDescriptor().getLocalName();
                            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
                            Intersects spatialFilter = null;
                            boolean useIntersect = false;
                            if (this.layer.getService().getDetails().containsKey("useIntersect")) {
                                ClobElement ce = (ClobElement)this.layer.getService().getDetails().get("useIntersect");
                                useIntersect = Boolean.parseBoolean(ce.getValue());
                            }
                            GeometricShapeFactory shapeFact = new GeometricShapeFactory();
                            shapeFact.setNumPoints(32);
                            shapeFact.setCentre(new Coordinate(Double.parseDouble(this.x), Double.parseDouble(this.y)));
                            shapeFact.setSize(Double.parseDouble(this.distance) * 2.0);
                            Polygon p = shapeFact.createCircle();
                            spatialFilter = ff.intersects((Expression)ff.property(geomAttribute), (Expression)ff.literal((Object)p));
                            Filter filter2 = currentFilter = filter != null && filter.trim().length() > 0 ? FlamingoCQL.toFilter(filter, em) : null;
                            if (currentFilter != null) {
                                currentFilter = (Filter)currentFilter.accept((FilterVisitor)new ChangeMatchCase(false), null);
                            }
                            Object object = f = currentFilter != null ? ff.and((Filter)spatialFilter, currentFilter) : spatialFilter;
                            if ("jdbc".equals(this.layer.getService().getProtocol())) {
                                f = (Filter)f.accept((FilterVisitor)new RemoveDistanceUnit(), null);
                            }
                            f = FeatureToJson.reformatFilter((Filter)f, this.layer.getFeatureType());
                            q.setFilter((Filter)f);
                            q.setMaxFeatures(this.limit + 1);
                            JSONArray features = this.executeQuery(al, this.layer.getFeatureType(), fs, q);
                            if (features.length() > this.limit) {
                                JSONArray newArray = new JSONArray();
                                for (int j = 0; j < features.length(); ++j) {
                                    if (j >= this.limit) continue;
                                    newArray.put(features.get(j));
                                }
                                features = newArray;
                                response.put("moreFeaturesAvailable", true);
                            }
                            response.put("features", (Object)features);
                        }
                    }
                    if (error == null) break block23;
                }
                catch (Exception e) {
                    block24: {
                        try {
                            log.error((Object)("Exception loading feature info for " + exceptionMsg), (Throwable)e);
                            error = "Exception: " + e.toString();
                            if (error == null) break block24;
                        }
                        catch (Throwable throwable) {
                            if (error != null) {
                                response.put("error", error);
                            }
                            if (fs != null) {
                                fs.getDataStore().dispose();
                            }
                            throw throwable;
                        }
                        response.put("error", error);
                    }
                    if (fs == null) continue;
                    fs.getDataStore().dispose();
                    continue;
                }
                response.put("error", error);
            }
            if (fs == null) continue;
            fs.getDataStore().dispose();
            continue;
        }
        this.auditMessageObject.addMessage((Object)responses);
        return new StreamingResolution("application/json", (Reader)new StringReader(responses.toString(4)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution relatedInfo() throws JSONException, Exception {
        int i;
        JSONArray queries = new JSONArray(this.queryJSON);
        Boolean checkRelated = true;
        ApplicationLayer al = null;
        JSONObject response = new JSONObject();
        JSONObject jFeat = null;
        JSONArray responses = new JSONArray();
        FeatureSource fs = null;
        EntityManager em = Stripersist.getEntityManager();
        for (i = 0; i < queries.length(); ++i) {
            block30: {
                JSONObject query = queries.getJSONObject(i);
                response = new JSONObject();
                responses.put((Object)response);
                response.put("request", (Object)query);
                if (this.requestId != null) {
                    response.put("requestId", (Object)this.requestId);
                }
                Object error = null;
                String exceptionMsg = query.toString();
                try {
                    al = null;
                    GeoService gs = null;
                    if (query.has("appLayer")) {
                        al = (ApplicationLayer)em.find(ApplicationLayer.class, (Object)query.getLong("appLayer"));
                    } else {
                        gs = (GeoService)em.find(GeoService.class, (Object)query.getLong("service"));
                    }
                    if (al == null && gs == null) {
                        error = this.getBundle().getString("viewer.featureinfoactionbean.4");
                    } else if (!Authorizations.isAppLayerReadAuthorized((Application)this.application, (ApplicationLayer)al, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
                        error = this.getBundle().getString("viewer.featureinfoactionbean.5");
                    } else {
                        this.layer = al != null ? al.getService().getLayer(al.getLayerName(), em) : gs.getLayer(query.getString("layer"), em);
                        if (this.layer == null) {
                            error = this.getBundle().getString("viewer.featureinfoactionbean.6");
                        } else if (this.layer.getFeatureType() == null) {
                            response.put("noFeatureType", true);
                        } else {
                            DWithin f;
                            Filter currentFilter;
                            response.put("featureType", (Object)this.layer.getFeatureType().getId());
                            String filter = query.optString("filter", null);
                            fs = this.layer.getFeatureType().openGeoToolsFeatureSource(5000);
                            Query q = new Query(fs.getName().toString());
                            String geomAttribute = fs.getSchema().getGeometryDescriptor().getLocalName();
                            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
                            DWithin spatialFilter = null;
                            boolean useIntersect = false;
                            if (this.layer.getService().getDetails().containsKey("useIntersect")) {
                                ClobElement ce = (ClobElement)this.layer.getService().getDetails().get("useIntersect");
                                useIntersect = Boolean.parseBoolean(ce.getValue());
                            }
                            if (!useIntersect) {
                                Point point = new GeometryFactory().createPoint(new Coordinate(Double.parseDouble(this.x), Double.parseDouble(this.y)));
                                spatialFilter = ff.dwithin((Expression)ff.property(geomAttribute), (Expression)ff.literal((Object)point), Double.parseDouble(this.distance), "meters");
                            } else {
                                GeometricShapeFactory shapeFact = new GeometricShapeFactory();
                                shapeFact.setNumPoints(32);
                                shapeFact.setCentre(new Coordinate(Double.parseDouble(this.x), Double.parseDouble(this.y)));
                                shapeFact.setSize(Double.parseDouble(this.distance) * 2.0);
                                Polygon p = shapeFact.createCircle();
                                spatialFilter = ff.intersects((Expression)ff.property(geomAttribute), (Expression)ff.literal((Object)p));
                            }
                            Filter filter2 = currentFilter = filter != null && filter.trim().length() > 0 ? FlamingoCQL.toFilter(filter, em) : null;
                            if (currentFilter != null) {
                                currentFilter = (Filter)currentFilter.accept((FilterVisitor)new ChangeMatchCase(false), null);
                            }
                            Object object = f = currentFilter != null ? ff.and((Filter)spatialFilter, currentFilter) : spatialFilter;
                            if ("jdbc".equals(this.layer.getService().getProtocol())) {
                                f = (Filter)f.accept((FilterVisitor)new RemoveDistanceUnit(), null);
                            }
                            f = FeatureToJson.reformatFilter((Filter)f, this.layer.getFeatureType());
                            q.setFilter((Filter)f);
                            q.setMaxFeatures(this.limit + 1);
                            JSONArray features = this.executeQuery(al, this.layer.getFeatureType(), fs, q);
                            if (features.length() > this.limit) {
                                JSONArray newArray = new JSONArray();
                                for (int j = 0; j < features.length(); ++j) {
                                    if (j >= this.limit) continue;
                                    newArray.put(features.get(j));
                                }
                                features = newArray;
                                response.put("moreFeaturesAvailable", true);
                            }
                            jFeat = features.getJSONObject(0);
                            response.put("features", (Object)features);
                        }
                    }
                    if (error == null) break block30;
                }
                catch (Exception e) {
                    block31: {
                        try {
                            log.error((Object)("Exception loading feature info for " + exceptionMsg), (Throwable)e);
                            error = "Exception: " + e.getLocalizedMessage();
                            if (error == null) break block31;
                        }
                        catch (Throwable throwable) {
                            if (error != null) {
                                response.put("error", error);
                                checkRelated = false;
                            }
                            if (fs != null) {
                                fs.getDataStore().dispose();
                            }
                            throw throwable;
                        }
                        response.put("error", error);
                        checkRelated = false;
                    }
                    if (fs == null) continue;
                    fs.getDataStore().dispose();
                    continue;
                }
                response.put("error", error);
                checkRelated = false;
            }
            if (fs == null) continue;
            fs.getDataStore().dispose();
            continue;
        }
        if (this.layer.getFeatureType().hasRelations() && checkRelated.booleanValue()) {
            for (i = 0; i < response.getJSONArray("features").length(); ++i) {
                JSONObject js;
                jFeat = response.getJSONArray("features").getJSONObject(i);
                ArrayList<Long> attributesToInclude = new ArrayList<Long>();
                List attrs = al.getAttributes(this.layer.getFeatureType(), true);
                attrs.forEach(attr -> attributesToInclude.add(attr.getId()));
                if (jFeat.has("related_featuretypes") && (js = jFeat.getJSONArray("related_featuretypes").getJSONObject(0)).has("filter")) {
                    String s = js.getString("filter");
                    int fid = Integer.parseInt(s.replaceAll("[\\D]", ""));
                    jFeat.put("fid", fid);
                }
                FeatureToJson ftjson = new FeatureToJson(false, false, false, true, true, attributesToInclude);
                for (FeatureTypeRelation rel : this.layer.getFeatureType().getRelations()) {
                    if (!rel.getType().equals("relate")) continue;
                    SimpleFeatureType fType = rel.getForeignFeatureType();
                    String label = fType.getDescription() == null ? fType.getTypeName() : fType.getDescription();
                    List keys = rel.getRelationKeys();
                    String leftSide = ((FeatureTypeRelationKey)keys.get(0)).getLeftSide().getName();
                    String rightSide = ((FeatureTypeRelationKey)keys.get(0)).getRightSide().getName();
                    Query q = new Query(fType.getTypeName(), FlamingoCQL.toFilter(rightSide + "=" + jFeat.get(leftSide), em));
                    q.setMaxFeatures(11);
                    q.setHandle("FeatureReportActionBean_related_attributes");
                    fs = fType.openGeoToolsFeatureSource(5000);
                    JSONArray features = ftjson.getJSONFeatures(al, fType, fs, q, em, this.application, this.context.getRequest());
                    JSONArray jsonFeats = new JSONArray();
                    int colCount = 0;
                    int numFeats = features.length();
                    int maxFeatures = Math.min(numFeats, 10);
                    for (int featureCount = 0; featureCount < maxFeatures; ++featureCount) {
                        colCount = features.getJSONObject(featureCount).length();
                        jsonFeats.put((Object)features.getJSONObject(featureCount));
                    }
                    jFeat.put("related_features", (Object)jsonFeats);
                }
            }
        }
        this.auditMessageObject.addMessage((Object)responses);
        return new StreamingResolution("application/json", (Reader)new StringReader(responses.toString(4)));
    }

    protected JSONArray executeQuery(ApplicationLayer al, SimpleFeatureType ft, FeatureSource fs, Query q) throws IOException, JSONException, Exception {
        FeatureToJson ftjson = new FeatureToJson(this.arrays, this.edit, this.graph, true, false, this.attributesToInclude, this.ordered);
        JSONArray features = ftjson.getJSONFeatures(al, ft, fs, q, null, null, Stripersist.getEntityManager(), this.application, this.context.getRequest());
        return features;
    }
}

