/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.forms.Form;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.web.stripes.ErrorMessageResolution;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/form")
@StrictBinding
public class FormActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(FormActionBean.class);
    private ActionBeanContext context;
    @Validate
    private Application application;
    private boolean unauthorized;

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.application == null || !Authorizations.isApplicationReadAuthorized((Application)this.application, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
            this.unauthorized = true;
        }
    }

    @DefaultHandler
    public Resolution configs() {
        if (this.unauthorized) {
            return new ErrorMessageResolution("User unauthorized to read application");
        }
        EntityManager em = Stripersist.getEntityManager();
        List forms = em.createQuery("FROM Form", Form.class).getResultList();
        JSONObject fts = new JSONObject();
        HttpServletRequest request = this.context.getRequest();
        for (Form form : forms) {
            if (form.getJson() == null || form.getJson().isEmpty() || !Authorizations.isFormAuthorized((Form)form, (HttpServletRequest)request, (EntityManager)em)) continue;
            fts.put(form.getFeatureTypeName(), (Object)new JSONObject(form.getJson()));
        }
        JSONObject config = new JSONObject();
        config.put("config", (Object)fts);
        return new StreamingResolution("application/json", (Reader)new StringReader(config.toString()));
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }
}

