/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.web.filter;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeaderAuthenticationFilter
implements Filter {
    private static final Log log = LogFactory.getLog(HeaderAuthenticationFilter.class);
    private FilterConfig filterConfig = null;
    private static final String CONTEXT_PARAM_PREFIX = "headerAuth";
    public static final String PARAM_HEADER_PREFIX = "prefix";
    public static final String PARAM_USER_HEADER = "userHeader";
    public static final String PARAM_AUTH_PATH = "authPath";
    public static final String PARAM_AUTH_INIT_PATH = "authInitPath";
    public static final String PARAM_ROLES_HEADER = "rolesHeader";
    public static final String PARAM_ROLES_SEPARATOR = "rolesSeparator";
    public static final String PARAM_USE_ROLES_NSUFFIX = "useRolesNSuffix";
    public static final String PARAM_COMMON_ROLE = "commonRole";
    public static final String PARAM_SAVE_EXTRA_HEADERS = "saveExtraHeaders";
    private static final String ATTR_RETURN_TO = HeaderAuthenticationFilter.class.getName() + ".RETURN_TO";
    private static final String ATTR_PRINCIPAL = HeaderAuthenticationFilter.class.getName() + ".PRINCIPAL";
    private static final String ATTR_EXTRA_HEADERS = HeaderAuthenticationFilter.class.getName() + ".EXTRA_HEADERS";
    private String headerPrefix;
    private String userHeader;
    private String authPath;
    private String authInitPath;
    private String rolesHeader;
    private String rolesSeparator;
    private boolean useRolesNSuffix;
    private String commonRole;
    private String saveExtraHeaders;
    private boolean enabled;

    private String getInitParameter(String paramName) {
        String contextParamName = CONTEXT_PARAM_PREFIX + StringUtils.capitalize((String)paramName);
        String value = this.filterConfig.getServletContext().getInitParameter(contextParamName);
        if (value == null) {
            value = this.filterConfig.getInitParameter(paramName);
            log.debug((Object)("Using filter init parameter " + paramName + ": " + (PARAM_HEADER_PREFIX.equals(paramName) ? "<hidden for security reasons>" : value)));
        } else {
            log.debug((Object)("Using context parameter " + contextParamName + ": " + (PARAM_HEADER_PREFIX.equals(paramName) ? "<hidden for security reasons>" : value)));
        }
        return value;
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.headerPrefix = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getInitParameter(PARAM_HEADER_PREFIX), "[disabled]"});
        this.enabled = !"[disabled]".equals(this.headerPrefix);
        this.userHeader = this.headerPrefix + (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getInitParameter(PARAM_USER_HEADER), "_uid"});
        this.authPath = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getInitParameter(PARAM_AUTH_PATH), "auth/saml"});
        this.authInitPath = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getInitParameter(PARAM_AUTH_PATH), "auth/init"});
        this.rolesHeader = this.headerPrefix + (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getInitParameter(PARAM_ROLES_HEADER), "_roles"});
        this.rolesSeparator = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getInitParameter(PARAM_ROLES_SEPARATOR), ";"});
        this.useRolesNSuffix = "true".equals(this.getInitParameter(PARAM_USE_ROLES_NSUFFIX));
        this.commonRole = this.getInitParameter(PARAM_COMMON_ROLE);
        this.saveExtraHeaders = this.getInitParameter(PARAM_SAVE_EXTRA_HEADERS);
        log.info((Object)("Initialized - " + this.toString()));
    }

    public void destroy() {
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        if (!this.enabled) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getUserPrincipal() != null) {
            if (request.getRequestURI().equals(request.getContextPath() + "/" + this.authInitPath)) {
                log.warn((Object)"Login requested but already authenticated by servlet container!");
                session.invalidate();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("HeaderAuthenticationFilter: already authenticated as user " + request.getRemoteUser() + " (principal " + request.getUserPrincipal() + "), passing through " + request.getRequestURI()));
            }
            chain.doFilter((ServletRequest)request, servletResponse);
            return;
        }
        if (request.getRequestURI().equals(request.getContextPath() + "/" + this.authInitPath)) {
            String returnTo = request.getParameter("returnTo");
            String msg = returnTo == null || !returnTo.startsWith(request.getContextPath()) ? ((returnTo = request.getHeader("Referer")) != null ? ", redirecting to this Referer after successful login: " + returnTo : ", no relative returnTo parameter or Referer header, redirecting to contextPath after succesful login") : ", redirecting to returnTo parameter after successful login: " + returnTo;
            session.setAttribute(ATTR_RETURN_TO, (Object)returnTo);
            log.info((Object)("Redirecting to authPath " + this.authPath + msg));
            response.sendRedirect(request.getContextPath() + "/" + this.authPath);
            return;
        }
        if (request.getRequestURI().equals(request.getContextPath() + "/" + this.authPath)) {
            String returnTo;
            String user = request.getHeader(this.userHeader);
            if (user == null) {
                log.warn((Object)"No user header returned, Apache should have denied access!");
                response.sendError(403, "Not authorized by identity provider");
                return;
            }
            HashSet<String> roles = new HashSet<String>();
            if (this.commonRole != null) {
                roles.add(this.commonRole);
            }
            if (this.useRolesNSuffix) {
                String role;
                int i = 0;
                while ((role = request.getHeader(this.rolesHeader + "_" + i++)) != null && !"(null)".equals(role)) {
                    roles.add(role);
                }
            } else {
                String r = request.getHeader(this.rolesHeader);
                if (r != null) {
                    roles.addAll(Arrays.asList(r.split(Pattern.quote(this.rolesSeparator))));
                }
            }
            log.info((Object)("Authenticated user from header [prefix]" + this.userHeader.substring(this.headerPrefix.length()) + ": " + user + ", roles: " + roles));
            session.setAttribute(ATTR_PRINCIPAL, (Object)new HeaderAuthenticatedPrincipal(user, roles));
            if (this.saveExtraHeaders != null) {
                HashMap<String, String> extraHeaders = new HashMap<String, String>();
                for (String h : this.saveExtraHeaders.split(",")) {
                    extraHeaders.put(h, request.getHeader(this.headerPrefix + h));
                }
                session.setAttribute(ATTR_EXTRA_HEADERS, extraHeaders);
                log.info((Object)("Extra headers saved from auth request: " + extraHeaders));
            }
            if ((returnTo = (String)session.getAttribute(ATTR_RETURN_TO)) != null) {
                log.info((Object)("Redirecting after successful login to: " + returnTo));
                response.sendRedirect(returnTo);
            } else {
                log.info((Object)"Redirecting to default page after successful login");
                response.sendRedirect(request.getContextPath());
            }
            return;
        }
        final HeaderAuthenticatedPrincipal principal = (HeaderAuthenticatedPrincipal)session.getAttribute(ATTR_PRINCIPAL);
        if (principal != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Chaining authenticated request for user " + principal.getName() + " for URL " + request.getRequestURL()));
            }
            chain.doFilter((ServletRequest)new HttpServletRequestWrapper(request){

                public String getRemoteUser() {
                    return principal.getName();
                }

                public Principal getUserPrincipal() {
                    return principal;
                }

                public boolean isUserInRole(String role) {
                    return principal.isUserInRole(role);
                }
            }, (ServletResponse)response);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Chaining unauthenticated request for URL " + request.getRequestURL()));
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static Map<String, String> getExtraHeaders(HttpServletRequest request) {
        return (Map)request.getSession().getAttribute(ATTR_EXTRA_HEADERS);
    }

    private class HeaderAuthenticatedPrincipal
    implements Principal {
        private final String name;
        private final Set<String> roles;

        public HeaderAuthenticatedPrincipal(String name, Set<String> roles) {
            this.name = name;
            this.roles = roles;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean isUserInRole(String r) {
            return this.roles.contains(r);
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public void setRoles(Set<String> roles) {
            throw new UnsupportedOperationException();
        }
    }
}

