/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.web.stripes;

import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.Intercepts;
import net.sourceforge.stripes.controller.LifecycleStage;
import nl.b3p.viewer.audit.AuditMessageObject;
import nl.b3p.viewer.audit.Auditable;
import nl.b3p.viewer.audit.strategy.LoggingStrategy;
import nl.b3p.viewer.audit.strategy.LoggingStrategyFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Intercepts(value={LifecycleStage.ResolutionExecution})
public class AuditLoggingInterceptor
implements Interceptor {
    private static final Log LOG = LogFactory.getLog(AuditLoggingInterceptor.class);

    public Resolution intercept(ExecutionContext context) throws Exception {
        Resolution resolution = context.proceed();
        ActionBean actionbean = context.getActionBean();
        ActionBeanContext actionbeancontext = context.getActionBeanContext();
        String event = actionbeancontext.getEventName();
        String user = actionbeancontext.getRequest().getRemoteUser();
        LOG.debug((Object)("actionbean: " + actionbean));
        LOG.debug((Object)("actionbeancontext: " + actionbeancontext));
        LOG.debug((Object)("event: " + event));
        LOG.debug((Object)("user: " + user));
        try {
            LoggingStrategy ls = LoggingStrategyFactory.getStrategy((ActionBean)actionbean);
            if (ls != null) {
                AuditMessageObject amo = ((Auditable)actionbean).getAuditMessageObject();
                amo.setEvent(actionbean.getClass().getSimpleName() + "#" + event);
                amo.setUsername(user);
                ls.log((Auditable)actionbean, amo);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to write audit log for auditable: " + actionbean + ", event " + event), (Throwable)e);
        }
        return resolution;
    }
}

