/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.geotools.data.arcgis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import nl.tailormap.geotools.data.arcgis.ArcGISFeatureSource;
import nl.tailormap.geotools.data.arcgis.ArcGISUtils;
import nl.tailormap.geotools.data.arcgis.FilterToArcGISSQL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.Converters;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class ArcGISFeatureReader
implements SimpleFeatureReader {
    private static final Log log = LogFactory.getLog(ArcGISFeatureReader.class);
    private static final int BATCH_SIZE = 100;
    private ArcGISFeatureSource fs;
    private String typeName;
    private Query query;
    private boolean returnGeometry;
    private String outFields;
    private String objectIdFieldName;
    private List objectIds;
    private boolean initBeforeRequestDone = false;
    private SimpleFeatureBuilder builder;
    private SimpleFeatureType featureType;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private JSONArray batch;
    private int batchIndex = 0;
    private int index = 0;

    public ArcGISFeatureReader(ArcGISFeatureSource fs, Query query) {
        this.fs = fs;
        this.query = query;
        this.typeName = fs.getEntry().getTypeName();
    }

    public SimpleFeatureType getFeatureType() {
        return this.fs.getSchema();
    }

    public int getCount() throws IOException {
        if (this.fs.getArcGISDataStore().getCurrentMajorVersion() > 9) {
            return this.getObjectIds().size();
        }
        this.getJSONFeaturesDirect();
        return this.batch.size();
    }

    public List getObjectIds() throws IOException {
        if (this.objectIds != null) {
            return this.objectIds;
        }
        if (this.fs.getArcGISDataStore().getCurrentMajorVersion() < 10) {
            throw new UnsupportedOperationException("Object id queries not supported in ArcGIS REST version 9.x");
        }
        Map<String, String> params = null;
        try {
            params = this.createQueryParams();
        }
        catch (FilterToSQLException ex) {
            throw new IOException(ex);
        }
        params.put("returnIdsOnly", "true");
        try {
            JSONObject idsResponse = this.fs.getArcGISDataStore().getServerJSONResponse(this.typeName + "/query", params);
            if (!idsResponse.containsKey((Object)"objectIds") || !idsResponse.containsKey((Object)"objectIdFieldName")) {
                throw new Exception("Requested returnIdsOnly but no objectIds or objectIdFieldName in response");
            }
            this.objectIdFieldName = (String)idsResponse.get((Object)"objectIdFieldName");
            this.objectIds = (JSONArray)idsResponse.get((Object)"objectIds");
            if (this.objectIds == null) {
                return Collections.EMPTY_LIST;
            }
            Collections.sort(this.objectIds);
            int originalSize = this.objectIds.size();
            if (this.query.getStartIndex() != null) {
                this.objectIds = this.objectIds.subList(Math.min(this.query.getStartIndex(), this.objectIds.size()), this.objectIds.size());
            }
            if (this.objectIds.size() > this.query.getMaxFeatures()) {
                this.objectIds = this.objectIds.subList(0, this.query.getMaxFeatures());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Object ids count for layer %s: %d; when adjusted for startIndex %s and maxFeatures %s the count is %d", this.typeName, originalSize, "" + this.query.getStartIndex(), this.query.isMaxFeaturesUnlimited() ? "unlimited" : "" + this.query.getMaxFeatures(), this.objectIds.size()));
            }
            return this.objectIds;
        }
        catch (Exception e) {
            throw new IOException("Error retrieving feature count from ArcGIS: " + e.toString(), e);
        }
    }

    private Map<String, String> createQueryParams() throws FilterToSQLException {
        String where;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("f", "json");
        if (this.query.getFilter() != null) {
            FilterToArcGISSQL visitor = new FilterToArcGISSQL();
            visitor.setFeatureType(this.getFeatureType());
            where = visitor.encodeToString(this.query.getFilter());
            params.putAll(visitor.getSpatialParams());
        } else {
            where = "1 = 1";
        }
        params.put("where", where);
        return params;
    }

    private String getOutFields() {
        if (this.outFields != null) {
            return this.outFields;
        }
        HashSet<String> s = new HashSet<String>();
        if (this.objectIdFieldName != null) {
            s.add(this.objectIdFieldName);
        }
        if (this.query.getPropertyNames() == Query.ALL_NAMES) {
            s.clear();
            s.add("*");
            this.returnGeometry = true;
        } else if (this.query.getPropertyNames().length > 0) {
            s.addAll(Arrays.asList(this.query.getPropertyNames()));
            this.returnGeometry = s.contains(this.getFeatureType().getGeometryDescriptor().getLocalName());
            s.remove("geometry");
        }
        StringBuilder sb = new StringBuilder();
        for (String name : s) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(name);
        }
        this.outFields = sb.toString();
        return this.outFields;
    }

    private void initBeforeRequest() throws IOException {
        if (this.initBeforeRequestDone) {
            return;
        }
        this.featureType = this.getFeatureType();
        this.builder = new SimpleFeatureBuilder(this.featureType);
        this.outFields = this.getOutFields();
        this.initBeforeRequestDone = true;
    }

    protected void getNextBatch() throws IOException {
        this.initBeforeRequest();
        if (this.batch != null) {
            this.batchIndex += this.batch.size();
        }
        int end = Math.min(this.batchIndex + 100, this.objectIds.size());
        this.batch = this.getJSONFeaturesByObjectIds(this.objectIds.subList(this.batchIndex, end));
    }

    private JSONArray getJSONFeaturesByObjectIds(List ids) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("f", "json");
        params.put("outFields", this.getOutFields());
        params.put("returnGeometry", "" + this.returnGeometry);
        StringBuilder sb = new StringBuilder();
        for (Object id : ids) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(id);
        }
        params.put("objectIds", sb.toString());
        JSONObject response = this.fs.getArcGISDataStore().getServerJSONResponse(this.typeName + "/query", params);
        JSONArray features = (JSONArray)response.get((Object)"features");
        if (features == null) {
            throw new IOException("No features returned in ArcGIS server response");
        }
        final String idField = this.objectIdFieldName;
        Collections.sort(features, new Comparator(){

            public int compare(Object o1, Object o2) {
                JSONObject lhs = (JSONObject)o1;
                JSONObject rhs = (JSONObject)o2;
                JSONObject lhsAtts = (JSONObject)lhs.get((Object)"attributes");
                JSONObject rhsAtts = (JSONObject)rhs.get((Object)"attributes");
                return ((Comparable)lhsAtts.get((Object)idField)).compareTo(rhsAtts.get((Object)idField));
            }
        });
        return features;
    }

    private JSONArray getJSONFeaturesDirect() throws IOException {
        this.initBeforeRequest();
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            params.putAll(this.createQueryParams());
        }
        catch (FilterToSQLException ex) {
            throw new IOException(ex);
        }
        params.put("f", "json");
        params.put("outFields", this.getOutFields());
        params.put("returnGeometry", "" + this.returnGeometry);
        try {
            JSONArray subBatch;
            JSONObject response = this.fs.getArcGISDataStore().getServerJSONResponse(this.typeName + "/query", params);
            this.batch = (JSONArray)response.get((Object)"features");
            int originalSize = this.batch.size();
            if (this.query.getStartIndex() != null) {
                subBatch = new JSONArray();
                subBatch.addAll((Collection)this.batch.subList(Math.min(this.query.getStartIndex(), this.batch.size()), this.batch.size()));
                this.batch = subBatch;
            }
            if (this.batch.size() > this.query.getMaxFeatures()) {
                subBatch = new JSONArray();
                subBatch.addAll((Collection)this.batch.subList(0, this.query.getMaxFeatures()));
                this.batch = subBatch;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Features received for layer %s: %d; when adjusted for startIndex %s and maxFeatures %s the count is %d", this.typeName, originalSize, "" + this.query.getStartIndex(), this.query.isMaxFeaturesUnlimited() ? "unlimited" : "" + this.query.getMaxFeatures(), this.batch.size()));
            }
            return this.batch;
        }
        catch (Exception e) {
            throw new IOException("Error retrieving features from ArcGIS: " + e.toString(), e);
        }
    }

    public SimpleFeatureCollection getFeaturesByObjectIds(List ids) throws IOException {
        JSONArray jfeatures = this.getJSONFeaturesByObjectIds(ids);
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        for (Object o : jfeatures) {
            features.add(this.buildFeature((JSONObject)o));
        }
        return DataUtilities.collection(features);
    }

    protected SimpleFeature buildFeature(JSONObject jf) throws IOException {
        Class binding;
        String id = null;
        JSONObject attributes = (JSONObject)jf.get((Object)"attributes");
        for (String attribute : attributes.keySet()) {
            if (this.objectIdFieldName != null && this.objectIdFieldName.equals(attribute)) {
                Object o = attributes.get((Object)this.objectIdFieldName);
                id = o == null ? null : o.toString();
            }
            binding = null;
            try {
                binding = this.featureType.getType(attribute).getBinding();
                if (binding == null) continue;
                this.builder.set(attribute, Converters.convert((Object)attributes.get((Object)attribute), (Class)binding));
            }
            catch (Exception e) {
                throw new IOException(String.format("Error converting field \"%s\" value \"%s\" to type %s: %s", attribute, attributes.get((Object)attribute), binding, e.toString()), e);
            }
        }
        JSONObject jg = (JSONObject)jf.get((Object)"geometry");
        if (jg != null) {
            GeometryDescriptor ad = this.featureType.getGeometryDescriptor();
            binding = ad.getType().getBinding();
            if (binding.isAssignableFrom(Geometry.class)) {
                binding = ArcGISUtils.getGeometryBinding((String)jf.get((Object)"geometryType"));
            }
            Geometry g = ArcGISUtils.convertToJTSGeometry(jg, binding, this.geometryFactory);
            this.builder.set(ad.getName(), (Object)g);
        }
        return this.builder.buildFeature(id);
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (this.fs.getArcGISDataStore().getCurrentMajorVersion() > 9) {
            if (this.batch == null || this.index >= this.batchIndex + this.batch.size()) {
                this.getNextBatch();
            }
        } else if (this.batch == null) {
            this.getJSONFeaturesDirect();
        }
        try {
            return this.buildFeature((JSONObject)this.batch.get(this.index++ - this.batchIndex));
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    public boolean hasNext() throws IOException {
        if (this.fs.getArcGISDataStore().getCurrentMajorVersion() > 9) {
            return this.index < this.getObjectIds().size();
        }
        if (this.batch == null) {
            this.getJSONFeaturesDirect();
        }
        return this.index < this.batch.size();
    }

    public void close() throws IOException {
    }

    public String getObjectIdFieldName() {
        return this.objectIdFieldName;
    }
}

